C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

      SUBROUTINE CHFAC(N, NT, A, IFAIL)
      REAL A
      INTEGER N, NT, IFAIL
      DIMENSION A(NT)
C
C     CHOLESKY DECOMPOSITION LU (U = TRANSPOSE OF L) OF
C     N*N SYMMETRIC POSITIVE DEFINITE MATRIX A. LOWER
C     TRIANGLE OF A STORED BY ROWS IN A, AND OVERWRITTEN
C     BY LOWER TRIANGLE OF L.  NT MUST BE NO SMALLER
C     THAN N*(N + 1)/2. BASED ON THE MARTIN-PETERS-
C     WILKINSON ALGORITHM CHOLDET2.
C
C     NO PROGRAM UNITS CALLED.
C
C     LOCAL VARIABLES -
C
      REAL ONE, X, ZERO
      INTEGER I, IERROR, J, K, P, Q, R

C
C     CONSTANTS -
C
      ZERO = 0.E0
      ONE = 1.0E0
C
      IERROR = 1
      P = 0
      DO 40 I=1,N
         Q = P + 1
         R = 0
         DO 30 J=1,I
            X = A(P+1)
            IF (Q.GT.P) GO TO 20
            DO 10 K=Q,P
               R = R + 1
               X = X - A(K)*A(R)
   10       CONTINUE
   20       R = R + 1
            P = P + 1
            IF (I.EQ.J .AND. X.LE.ZERO) GO TO 50
            IF (I.EQ.J) A(P) = ONE/SQRT(X)
            IF (I.NE.J) A(P) = X*A(R)
   30    CONTINUE
   40 CONTINUE
      IERROR = IERROR - 1
   50 IFAIL = IERROR
      RETURN
      END
