C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

      SUBROUTINE FABNE(X, N, MSTART, MLAST, ICODE, AKCODE,
     * RSCODE, MDIM, V, VC, S, SC, A, M, SSQ, P, OCODE)

      REAL A, S, V, X, SC, VC, SSQ, P
      INTEGER M, N, MDIM, MLAST, MSTART, ICODE, AKCODE,
     * OCODE, RSCODE
      DIMENSION X(N), V(MDIM), VC(MDIM), S(MLAST),
     * SC(MLAST), A(MLAST)
C
C THIS SUBROUTINE FORMS THE FORWARD AND/OR BACKWARD NORMAL
C EQUATIONS FOR AN N-POINT TIME SERIES X, SOLVES THE
C NORMAL EQUATIONS BY CALLS TO SUBROUTINES CHFAC AND
C CHSOL, AND DETERMINES THE 'OPTIMAL' NUMBER OF FILTER
C COEFFICIENTS WITHIN THE RANGE MSTART.LE.M.LE.MLAST BY
C CALLS TO SUBROUTINE AKSTOP. (IF THE REQUIRED NUMBER M OF
C FILTER COEFFICIENTS IS KNOWN BEFOREHAND, MSTART AND
C MLAST SHOULD BOTH BE SET EQUAL TO M.)  THE NORMAL
C EQUATIONS ARE FORMED EFFICIENTLY FOR M=1,2,3,..., AND
C THEY ARE SOLVED FOR M=MSTART,MSTART+1,MSTART+2,... UNTIL
C EITHER M=MLAST OR 'OPTIMALITY' IS ACHIEVED. CALLS ARE
C MADE TO SUBROUTINE ACCSUM WHEN FORMING INNER-PRODUCTS,
C AND SOMETIMES TO SUBROUTINE ACCSSQ WHEN CALCULATING THE
C RESIDUAL SUM OF SQUARES (SEE DESCRIPTION OF PARAMETER
C RSCODE BELOW).
C
C
C FORMAL PARAMETER LIST:
C
C INPUT PARAMETERS
C
C X      A VECTOR REPRESENTING THE TIME SERIES.
C N      THE DIMENSION OF X.
C MSTART THE FIRST VALUE OF M FOR WHICH THE MORMAL
C        EQUATIONS ARE SOLVED (MSTART.GE.1).
C MLAST  THE LARGEST VALUE OF M FOR WHICH THE
C        NORMAL EQUATIONS COULD BE SOLVED (MLAST.GE.
C        MSTART); ALSO USED TO DIMENSION S,SC, AND A.
C ICODE  AN INTEGER INPUT CODE WITH VALUES:
C             -1 - ONLY BACKWARD PREDICTION IS USED,
C              1 - ONLY FORWARD PREDICTION IS USED,
C              0 - BOTH FORWARD AND BACKWARD PREDICTION
C                  IS USED.
C AKCODE AN INTEGER INPUT CODE USED IN SUBROUTINE AKSTOP
C        (SEE SUBROUTINE AKSTOP).
C RSCODE AN INTEGER INPUT CODE WITH VALUES:
C              0 - A 'FAST' CALCULATION OF THE RESIDUAL
C                  SUM OF SQUARES IS USED,
C              1 - A MORE ACCURATE (BUT SLOWER) CALCULATION
C                  OF THE RESIDUAL SUM OF SQUARES IS USED BY
C                  CALLING SUBROUTINE ACCSSQ.
C MDIM   THE DIMENSION OF V AND VC (MDIM.GE.MLAST*
C        (MLAST+1)/2).
C
C WORKSPACE
C
C V      A VECTOR REPRESENTING THE LOWER TRIANGLE OF
C        THE NORMAL EQUATIONS MATRIX, WHICH IS STORED
C        IN V BY ROWS.
C VC     A COPY OF V WHICH IS USED IN THE CHOLESKY
C        FACTORIZATION.
C S      A VECTOR REPRESENTING THE RIGHT HAND SIDE OF
C        THE NORMAL EQUATIONS.
C SC     A COPY OF S WHICH IS USED IN THE CHOLESKY
C        SOLUTION.
C
C OUTPUT PARAMETERS
C
C A      A VECTOR CONTAINING THE OPTIMAL FILTER
C        COEFFICIENTS
C M      THE OPTIMAL NUMBER OF FILTER COEFFICIENTS
C SSQ    THE RESIDUAL SUM OF SQUARES FOR THE OPTIMAL
C        M COEFFICIENT FILTER.
C P      THE MEAN SQUARE RESIDUAL FOR THE OPTIMAL
C        M COEFFICIENT FILTER, GIVEN BY
C
C            P = SSQ / DENOM,
C
C                      2(N-M) IF ICODE.EQ.0
C        WHERE DENOM =
C                      (N-M) IF ICODE.EQ.(1.OR.-1).
C
C OCODE  AN OUTPUT CODE WITH VALUES:
C             0-'OPTIMAL' SOLUTION FOUND (I.E. NORMAL EXIT),
C             1-M.EQ.MLAST, BUT 'OPTIMALITY' WAS NOT
C               ACHIEVED (THE USER MAY WISH TO INCREASE
C               THE VALUE OF MLAST).
C             2-PREMATURE TERMINATION, BECAUSE THE CURRENT
C               NORMAL EQUATIONS MATRIX IS NOT POSITIVE
C               DEFINITE (POSSIBLY DUE TO ROUNDING ERRORS).
C               THE PREVIOUS SOLUTION IS RETURNED IN THE
C               EVENT.
C
C LOCAL VARIABLES
C
      REAL CHSS, SSQL, PL, SUM, YTY, BIG
      INTEGER I, J, K, KD, KPM, KP1, MP1, NMM, NP1, IFAIL,
     * NMMM1, ITEND
C
C THE CONSTANT BIG CAN BE SET TO ANY LARGE REAL NUMBER.
C IT IS USED TO ASSIGN AN INITIAL VALUE TO SSQ AND P
C WHEN MSTART.GT.1.
C
      DATA BIG /1.E20/
C
C FORM AND SOLVE THE NORMAL EQUATIONS FOR M=1.
C
      OCODE = 0
      NP1 = N + 1
      M = 1
      NMM = N - M
      CALL ACCSUM(X, N, NMM, 0, SUM)
      IF (ICODE) 10, 20, 30
C BACKWARD
   10 YTY = SUM
      SUM = SUM - X(1)**2 + X(N)**2
      GO TO 40
C BOTH
   20 SUM = 2.0*SUM - X(1)**2 + X(N)**2
      YTY = SUM
      GO TO 40
C FORWARD
   30 SUM = SUM
      YTY = SUM - X(1)**2 + X(N)**2
   40 V(1) = SUM
      CALL ACCSUM(X, N, NMM, 1, SUM)
      IF (ICODE) 50, 60, 70
C BACKWARD
   50 SUM = SUM
      GO TO 80
C BOTH
   60 SUM = SUM*2.0
      GO TO 80
C FORWARD
   70 SUM = SUM
   80 S(1) = SUM
      A(1) = S(1)/V(1)
      SSQL = YTY - A(1)*S(1)
      IF (RSCODE.EQ.1) CALL ACCSSQ(M, N, X, A, ICODE, SSQL)
      PL = SSQL/(N-M)
      IF (ICODE.EQ.0) PL = SSQL/(2.0*(N-M))
      IF (MLAST.EQ.1) GO TO 310
      IF (MSTART.EQ.1) GO TO 90
      SSQL = BIG
      PL = BIG
   90 GO TO 140
C
C SOLVE TH NEW NORMAL EQUATIONS AND TEST FOR OPTIMALITY.
C
  100 CONTINUE
      KD = M*(M+1)/2
      IF (M.LT.MSTART) GO TO 140
      KD = M*(M+1)/2
      DO 110 K=1,KD
         VC(K) = V(K)
  110 CONTINUE
      DO 120 I=1,M
         SC(I) = S(I)
  120 CONTINUE
      CALL CHFAC(M, MDIM, VC, IFAIL)
      IF (IFAIL.NE.0) GO TO 300
      CALL CHSOL(M, MDIM, VC, SC, CHSS)
      SSQ = YTY - CHSS
      IF (RSCODE.EQ.1) CALL ACCSSQ(M, N, X, SC, ICODE, SSQ)
      P = SSQ/(N-M)
      IF (ICODE.EQ.0) P = SSQ/(2.0*(N-M))
      CALL AKSTOP(P, PL, M, N, AKCODE, ITEND)
      IF (ITEND.EQ.1) GO TO 310
      DO 130 I=1,M
         A(I) = SC(I)
  130 CONTINUE
      IF (M.GE.MLAST) GO TO 320
      SSQL = SSQ
      PL = P
C
C FORM THE NORMAL EQUATIONS FOR SUCCESSIVE VALUES OF M.
C
  140 IF (ICODE) 150, 200, 250
C BACKWARD
  150 MP1 = M + 1
      K = M*(M+1)/2 + 1
      V(K) = S(M) - X(1)*X(MP1)
      KP1 = K + 1
      KPM = K + M
      J = 1
      DO 160 I=KP1,KPM
          J = J + 1
          V(I) = V(I-MP1) - X(J)*X(MP1)
  160 CONTINUE
      K = 0
      DO 180 I=1,M
         DO 170 J=1,I
            K = K + 1
            V(K) = V(K) - X(NMM+I)*X(NMM+J)
  170    CONTINUE
  180 CONTINUE
      DO 190 I=1,M
         S(I) = S(I) - X(NMM)*X(NMM+I)
  190 CONTINUE
      NMMM1 = NMM - 1
      CALL ACCSUM(X, N, NMMM1, MP1, SUM)
      S(MP1) = SUM
      YTY =YTY - X(NMM)**2
      M = MP1
      NMM = N - M
      GO TO 100
C BOTH
  200 MP1 = M + 1
      K = M*(M+1)/2 + 1
      V(K) = S(M) - X(NMM)*X(N) - X(1)*X(MP1)
      KP1 = K + 1
      KPM = K + M
      J = 1
      DO 210 I=KP1,KPM
         J = J + 1
         V(I) = V(I-MP1) - X(NMM)*X(NP1-J) - X(J)*X(MP1)
  210 CONTINUE
      K = 0
      DO 230 I=1,M
         DO 220 J=1,I
            K = K + 1
            V(K) = V(K) - X(MP1-I)*X(MP1-J) -
     *       X(NMM+I)*X(NMM+J)
  220    CONTINUE
  230 CONTINUE
      DO 240 I=1,M
         S(I) = S(I) - X(MP1-I)*X(MP1) - X(NMM)*X(NMM+I)
  240 CONTINUE
      NMMM1 = NMM - 1
      CALL ACCSUM(X, N, NMMM1, MP1, SUM)
      S(MP1) = 2.E0*SUM
      YTY = YTY - X(MP1)**2 - X(NMM)**2
      M = MP1
      NMM = N - M
      GO TO 100
C FORWARD
  250 MP1 = M + 1
      K = M*(M+1)/2 + 1
      V(K) = S(M) - X(NMM) *X(N)
      KP1 = K + 1
      KPM = K + M
      J = 1
      DO 260 I=KP1,KPM
         J = J + 1
         V(I) = V(I-MP1) - X(NMM)*X(NP1-J)
  260 CONTINUE
      K = 0
      DO 280 I=1,M
         DO 270 J=1,I
            K = K + 1
            V(K) = V(K) - X(MP1-I)*X(MP1-J)
  270    CONTINUE
  280 CONTINUE
      DO 290 I=1,M
         S(I) = S(I) - X(MP1-I)*X(MP1)
  290 CONTINUE
      NMMM1 = NMM - 1
      CALL ACCSUM(X, N, NMMM1, MP1, SUM)
      S(MP1) = SUM
      YTY = YTY - X(MP1)**2
      M = MP1
      NMM = N - M
      GO TO 100
C
C PREPARE THE OUTPUT.
C
  300 OCODE = 2
      IF (M.GT.MSTART) GO TO 310
      M = 1
      SSQ = SSQL
      P = PL
      GO TO 320
  310 SSQ = SSQL
      P = PL
      IF (M.EQ.1) GO TO 320
      M = M - 1
  320 IF (ITEND.EQ.0 .AND. OCODE.NE.2) OCODE = 1
      RETURN
      END
