C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fbanal ( tri, nsamp, win1, win2, maxtime, 
     :     r_HdrWrd, r_TzoWrd, c_TzoWrd, max_iterations, nsi, 
     :     tzero, velocity, DstSgn, twin, UnitSc )

c routine to locate first break on trace and return time of same
c in the units of the data

      implicit none

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer nsamp, win1, win2, max_iterations, nsi
      integer maxtime, tzero, DstSgn, twin

      real r_HdrWrd, velocity, r_TzoWrd, UnitSc
      real tri(nsamp)

      character c_TzoWrd*6

c declare local variables

      integer i, win1start, win2start, nwin1, nwin2
      integer counter, minindex, startsample

      real mean, variance, stddev1, stddev2, ratio, minratio
      real t2, Tmute
c      real S1(6000), S2(6000), R(6000)

      logical found
      
c initialize variables

      nwin1 = nint ( float (win1) / float(nsi) )
      nwin2 = nint ( float (win2) / float(nsi) )

      found = .false.
      win1start = 0
      win2start = nwin1 + 1
      counter = 0
      minratio = 1.e32

c calculate start search sample based on user defined parms
c if requested

      if ( c_TzoWrd .ne. ' ' ) then

         if ( velocity .gt. 1.e-32 ) then

            t2 = ( r_TzoWrd * UnitSc )**2
            Tmute = 
     :           sqrt ( t2 + float(DstSgn)**2 / velocity**2 ) / UnitSc
            startsample = nint(Tmute/float(nsi)) + 1

         else

            startsample = nint(r_TzoWrd / float (nsi ) ) + 1

         endif

      elseif ( tzero .ne. 0 .or. velocity .gt. 0.0 ) then
         
         if ( velocity .gt. 1.e-32 ) then

            t2 =  ( float(tzero) * UnitSc )**2
            Tmute = 
     :           sqrt ( t2 + float(DstSgn)**2 / velocity**2 ) / UnitSc
            startsample = nint(Tmute/float(nsi)) + 1

         else

            startsample = nint(float(tzero)/float(nsi)) + 1
            
         endif

      else
         
         startsample = 1

      endif

c use the following arrays for debug if necessary

c      call vclr ( S1,1,6000)
c      call vclr ( S2, 1, 6000)
c      call vclr ( R, 1, 6000)

      DO while ( .not. found )

         counter = counter + 1

c position windows and make sure they stay on the trace

         win1start = win1start + 1
         win2start = win2start + 1

         IF ( (win2start+nwin2-1) .lt. nsamp ) then 

c calculate mean for win1

            mean = 0.

            do i = win1start, win1start+nwin1-1
               mean = mean + tri(i)
            enddo

            mean = mean / float(nwin1)

c calculate variance for win1

            variance = 0.
         
            do i = win1start, win1start+nwin1-1
               variance = variance + (tri(i) - mean)**2
            enddo

            variance = variance / float(nwin1)

c calculate std deviation for win1

            stddev1 = sqrt ( variance )

c calculate mean for win2

            mean = 0.

            do i = win2start, win2start+nwin2-1
               mean = mean + tri(i)
            enddo

            mean = mean / float(nwin2)

c calculate variance for win2

            variance = 0.
         
            do i = win2start, win2start+nwin2-1
               variance = variance + (tri(i) - mean)**2
            enddo

            variance = variance / float(nwin2)

c calculate std deviation for win2

            stddev2 = sqrt ( variance )

c form ratio

            ratio = stddev1 / stddev2

c keep track of minimum ratio and index it occured at

            if ( ratio .lt. minratio .and. 
     :           win2start .ge. startsample ) then
               
               if ( twin .ne. 0 .and.
     :              win2start .le. (startsample+(twin/nsi)) ) then
                  minratio = ratio
                  minindex = win2start
               elseif ( twin .eq. 0 ) then
                  minratio = ratio
                  minindex = win2start
               endif

            endif

c check against detection limits so we do not run off the 
c trace or go beyond the time requested by the user

            if(counter .eq. max_iterations .or.
     :           win2start .gt. maxtime ) then
               r_HdrWrd = float (minindex + 1) * float(nsi)
               return
            endif

c         S1(counter)=stddev1
c         S2(counter)=stddev2
c         R(counter)=ratio


         ELSE

c we are about to walk off the trace so stop and give the
c the first break as the minimum ratio seen so far

            r_HdrWrd = float (minindex + 1) * float(nsi)
            return

         ENDIF

      ENDDO

      write(LERR,*)' '
      write(LERR,*)' Serious flaw in fbpicker logic.'
      write(LERR,*)' The flow should never have reached'
      write(LERR,*)' this point in the fbanal subroutine.'
      write(LERR,*)' Call USP shop for debug services and'
      write(LERR,*)' a mod to the algorithm.  Please have'
      write(LERR,*)' an example dataset handy that caused'
      write(LERR,*)' this condition.'
      write(LERR,*)'FATAL'
      write(LERR,*)' '
      write(LER,*)'FBPICKER: '
      write(LER,*)' Serious flaw in fbpicker logic.'
      write(LER,*)' The flow should never have reached'
      write(LER,*)' this point in the fbanal subroutine.'
      write(LER,*)' Call USP shop for debug services and'
      write(LER,*)' a mod to the algorithm.  Please have'
      write(LER,*)' an example dataset handy that caused'
      write(LER,*)' this condition.'
      write(LER,*)'FATAL'
      write(LER,*)' '
      stop

      end
