C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fbanal_AR ( tri, nsamp, win1, win2, ARwin, 
     :     ARthresh_percent, maxtime, 
     :     r_HdrWrd, r_TzoWrd, c_TzoWrd, max_iterations,  
     :     nsi, tzero, velocity, DstSgn, UnitSc,
     :     Mstart, Mlast, icode, akcode, rscode, mdim,
     :     v, vc, s, sc, a, ocode )

c routine to locate first break on trace and return time of same
c in the units of the data.  Discrimination between noise and onset
c of signal using windowed comparison of AR coefficients.

      implicit none

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c declare variables passed from calling routine

      integer nsamp, win1, win2, max_iterations, nsi
      integer maxtime, tzero, DstSgn
      integer Mstart, Mlast, icode, akcode, rscode, mdim
      integer ocode, ARwin

      real r_HdrWrd, velocity, r_TzoWrd, UnitSc, ARthresh_percent
      real tri(nsamp)

      real v(mdim), vc(mdim), s(mlast), sc(mlast), a(SZLNHD)

      character c_TzoWrd*6

c declare local variables

      integer win1start, win2start, nwin1, nwin2
      integer counter, startsample, endsample, m, mmax, i
      integer narwin

      real t2, Tmute, ssq, p, median, threshold
      real A1(SZLNHD)

c debug
c      real A2(SZLNHD), B1(SZLNHD), B2(SZLNHD), R(SZLNHD)
c debug

      logical found
      
c initialize variables

      narwin = nint ( float(ARwin) / float(nsi) )

      nwin1 = nint ( float (win1) / float(nsi) )
      if ( nwin1 .gt. (nsamp-narwin) ) nwin1= nsamp-narwin

      nwin2 = nint ( float (win2) / float(nsi) )

      found = .false.
      win1start = 0
      win2start = nwin1 + 1
      counter = 0

c calculate start search sample based on user defined parms
c if requested

      if ( c_TzoWrd .ne. ' ' ) then

         if ( velocity .gt. 1.e-32 ) then

            t2 = ( r_TzoWrd * UnitSc )**2
            Tmute = 
     :           sqrt ( t2 + float(DstSgn)**2 / velocity**2 ) / UnitSc
            startsample = nint(Tmute/float(nsi)) + 1

         else

            startsample = nint(r_TzoWrd / float (nsi ) ) + 1

         endif

      elseif ( tzero .ne. 0 .or. velocity .gt. 0.0 ) then
         
         if ( velocity .gt. 1.e-32 ) then

            t2 =  ( float(tzero) * UnitSc )**2
            Tmute = 
     :           sqrt ( t2 + float(DstSgn)**2 / velocity**2 ) / UnitSc
            startsample = nint(Tmute/float(nsi)) + 1

         else

            startsample = nint(float(tzero)/float(nsi)) + 1
            
         endif

      else
         
         startsample = 1

      endif

c use the following arrays for debug if necessary

      call vclr ( a1,1,SZLNHD)
c      call vclr ( a2, 1, SZLNHD)
c      call vclr ( b1,1,SZLNHD)
c      call vclr ( b2, 1, SZLNHD)
c      call vclr ( r, 1, SZLNHD)

c calculate coeffs for first window and find median.
c first window should be from zero for win1 length

c calculate coefs for detection window and watch for threshold
c detection.  detection window goes from start sample for
c win2 length

c coef found for sliding window of narwin length
      
c debug - leave this bit of code in as it is useful in the 
c         debugger in future when the algorithm fails and 
c         a dataset needs to be examined in detail.
c
c      do i = 1,nsamp
c            mmax = narwin / 4
c
c            call fabne(tri(i), narwin, Mstart, mmax, icode,  
c     :           akcode, rscode, mdim, v, vc, s, sc, a, m, 
c     :           ssq, p, ocode )
c
c            b1(i) = a(1)
c            b2(i) = a(2)
c            r(i) = -1*b1(i) / (2 * b2(i) )
c      enddo
c
c debug
      
      
      do i = 1,nwin1

            mmax = narwin / 4

            call fabne(tri(i), narwin, Mstart, mmax, icode,  
     :           akcode, rscode, mdim, v, vc, s, sc, a, m, 
     :           ssq, p, ocode )

            a1(i) = a(1)

c debug
c            a2(i) = a(2)
c debug
                     
      enddo

      call rmdian(nwin1,a1(1), median)
      
      threshold = ARthresh_percent * median

      if ( nwin2 .ne. 0 ) then
         endsample = startsample + nwin2
      else
         endsample = nsamp - startsample + 1
      endif

      if (endsample .gt. (nsamp-narwin) ) endsample = nsamp - narwin

      DO i = startsample, endsample

         call fabne(tri(i), narwin, Mstart, mmax, icode,  
     :        akcode, rscode, mdim, v, vc, s, sc, a, m, 
     :        ssq, p, ocode )

c debug
c         b2(i) = a(1)
c debug

         if ( a(1) .ge. threshold ) then
            r_HdrWrd = float (i + 1) * float(nsi)
            return
         endif
            
      enddo

c no break found so give last sample as detection

      r_HdrWrd = float (nsamp +  1) * float(nsi)

      return
      end
