C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fbanal_freq ( tri, nsamp, win2, maxtime, 
     :     r_HdrWrd, r_TzoWrd, c_TzoWrd, max_iterations, nsi, 
     :     tzero, velocity, DstSgn, UnitSc, fthresh_percent )

c routine to locate first break on freq decomposed trace and return 
c time of same in the units of the data.  First attempt at this will
c be a thresholding routine to watch for first significant rise in 
c power at the decomposed frequency
c
c the thresholding will be applied within the zone defined by
c -vel, -t0, -tmax, -hws  for the startsample and either the end of the
c trace or startsample + nwin2 if defined.

c here  -win2[] gives the extent below the starttime that the threshold
c              will be checked
c      -freq[] is the frequency of interest
c      -fthresh[] is the threshold multiplier
c      -fwin[] is the decomposition window size
c      

c it is impossible to stop the early detection at low thresholds or
c late detection at high thresholds.  There will always be a little
c false detection to deal with.  Looks like the best way out to day
c is to change this routine to be record constant in memory and do a 
c 10 or 11 trace running median smoothing on the picks prior to the
c load back to the output header.

      implicit none

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer nsamp, win2, max_iterations, nsi
      integer maxtime, tzero, DstSgn

      real r_HdrWrd, velocity, r_TzoWrd, UnitSc
      real fthresh_percent
      real tri(nsamp)

      character c_TzoWrd*6

c declare local variables

      integer nwin2
      integer counter, startsample, endsample
      integer sample_at_t0

      real t2, Tmute, threshold,median

      logical found
      
c initialize variables

      nwin2 = nint ( float (win2) / float(nsi) )

      found = .false.
      counter = 0

c set the end of the median extraction window for the trace

      if ( c_TzoWrd .ne. ' ' ) then
         sample_at_t0 = nint ( r_TzoWrd  / float(nsi) ) + 1
      else
         sample_at_t0 = nint ( tzero  / float(nsi) ) + 1
      endif

c calculate start search sample based on user defined parms
c if requested

      if ( c_TzoWrd .ne. ' ' ) then

         if ( velocity .gt. 1.e-32 ) then

            t2 = ( r_TzoWrd * UnitSc )**2
            Tmute = 
     :           sqrt ( t2 + float(DstSgn)**2 / velocity**2 ) / UnitSc
            startsample = nint(Tmute/float(nsi)) + 1

         else

            startsample = nint(r_TzoWrd / float (nsi ) ) + 1

         endif

      elseif ( tzero .ne. 0 .or. velocity .gt. 0.0 ) then
         
         if ( velocity .gt. 1.e-32 ) then

            t2 =  ( float(tzero) * UnitSc )**2
            Tmute = 
     :           sqrt ( t2 + float(DstSgn)**2 / velocity**2 ) / UnitSc
            startsample = nint(Tmute/float(nsi)) + 1

         else

            startsample = nint(float(tzero)/float(nsi)) + 1
            
         endif

      else
         
         startsample = 1

      endif

c calculate median spectal amplitude of win1 samples after startsample

c      call rmdian(nwin1,tri(startsample), median)

c if this works better put a -ftim or something like it on the command 
c line to govern this  window size for t0 might often actually be zero
c which would be bad.  Also note that win1 is no longer used in this 
c subroutine....clean this up.

      call rmdian(sample_at_t0,tri(1), median)

      threshold = fthresh_percent * median

      if ( nwin2 .ne. 0 ) then
         endsample = startsample + nwin2
      else
         endsample = nsamp - startsample + 1
      endif

      if  (endsample .gt. nsamp ) endsample = nsamp

      DO counter = startsample, endsample

c         walk down trace and watch for threshold detection

         if ( tri(counter) .ge. threshold ) then

c compute time in ms of sample at threshold detection
c return
            r_HdrWrd = float (counter + 1) * float(nsi)
            return
         endif

      ENDDO

c no break found so give last sample as detection

      r_HdrWrd = float (nsamp +  1) * float(nsi)
      return

      end
