/***********************************************************************
 *                copyright 2004, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <localsys.h>

#ifdef LINUXSYSTEM
/* #define __USE_XOPEN */
#include <unistd.h>
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/times.h>
#include <time.h>

int main(argc,argv)
int argc;
char **argv;
{
        struct tms child;
	time_t start_time,end_time,elapsed_time;
	pid_t pid;
	int i,c;
	long days=0,hrs=0,mins=0,secs=0;
	long cudays=0,cuhrs=0,cumins=0,cusecs=0;
	long csdays=0,cshrs=0,csmins=0,cssecs=0;
	long child_user_elapsed_time,child_system_elapsed_time;
	int status;
	int exit_status;
	char audit_line[256];
	char audit_cmd[256];
	FILE *info,*mail;
	char OS[8],machine[16],OSREV[8];
	char *sys_time,*date;
	char *cgtime(),*cgdate();
	char *address,*subject;
	char *major_os,*minor_os;
	char *getenv();
	char *GetHostName();
	int  errknt;
        void conv2DHMS(); 

	start_time=time(NULL);
	if (pid = fork(), pid == 0) {     /* child process */
	  execvp(argv[1],&argv[1]);
	  fprintf(stderr,"error in fork/exec\n");
	  }
	else {
	   info = popen("uname -n -s -r","r");
	   if (info == NULL) {
	     strcpy(OS,"unknown");	
	     strcpy(machine,"unknown");	
	     strcpy(OSREV,"unknown");	
	     }
	   else {
	     i = 0;
	     while ((c = fgetc(info)) != EOF) {
		if (c == ' ') break;
		if (i <= 6) OS[i++] = c;
		}
	     OS[i] = '\0';
	     i=0;
	     while ((c = fgetc(info)) != EOF) {
		if (c == ' ') break;
		if (i <= 14) machine[i++] = c;
		}
	     machine[i] = '\0';
	     i=0;
	     while ((c = fgetc(info)) != EOF) {
		if (c == ' ') break;
		if (i <= 6) OSREV[i++] = c;
		}
	     OSREV[i] = '\0';
	     }
	   date = cgdate();
	   sys_time = cgtime();
	   errknt = 0;

	   address = getenv("USP_AUDIT_ADMIN"); 
	   if (address == NULL) {
	     fprintf(stderr,"ERROR(feedback): USP_AUDIT_ADMIN must be set\n");
	     errknt += 1;
	     }
	   subject = getenv("USP_AUDIT_SUBJECT"); 
	   if (subject == NULL) {
	     fprintf(stderr,"ERROR(feedback): USP_AUDIT_SUBJECT must be set\n");
	     errknt += 1;
	     }

	   major_os = getenv("OSARCH_MAJOR_OS_REV");
	   if (major_os == NULL) {
	     fprintf(stderr,"ERROR(feedback): OSARCH_MAJOR_OS_REV must be set\n");
	     errknt += 1;
	     }

	  minor_os = getenv("OSARCH_MINOR_OS_REV");
	   if (minor_os == NULL) {
	     fprintf(stderr,"ERROR(feedback): OSARCH_MINOR_OS_REV must be set\n");
	     errknt += 1;
	     }

	  if (errknt != 0) exit(errknt);

	  while (waitpid(pid,&status,0) != 0) {
	    end_time=time(NULL);
            times(&child);
	    elapsed_time=end_time-start_time;
            conv2DHMS(elapsed_time,&days,&hrs,&mins,&secs); 
            child_user_elapsed_time=(child.tms_cutime-child.tms_utime)/CLK_TCK;
            conv2DHMS(child_user_elapsed_time,&cudays,&cuhrs,&cumins,&cusecs);
            child_system_elapsed_time=(child.tms_cstime-child.tms_stime)/CLK_TCK;
            conv2DHMS(child_system_elapsed_time,&csdays,&cshrs,&csmins,&cssecs);
	    exit_status = WEXITSTATUS(status);
	    sprintf(audit_line,"%s : %12s ( %-24s ) | %8s/%1s.%-4s | %-8s | %s %s | %-72s | %d:%d:%d:%d  %d:%d:%d:%d  %d:%d:%d:%d | %d",
		subject,machine,GetHostName(),OS,major_os,
	        minor_os,getenv("USER"),sys_time,date,
                        argv[1],days,hrs,mins,secs,csdays,cshrs,csmins,cssecs,
                        cudays,cuhrs,cumins,cusecs,exit_status);

/* Try using the /usr/lib/sendmail block for 
 * all architectures - Joe M. Wade 10/31/03
 */

/* #ifdef LINUXSYSTEM */
	    sprintf(audit_cmd,"/usr/lib/sendmail %s",address);
	    mail = popen(audit_cmd,"w");
	    if (mail != NULL) {
		fprintf(mail,"To: %s\n",address);
		fprintf(mail,"From: %s\n",getenv("USER"));
		fprintf(mail,"Subject: %s\n\n",subject);
		fprintf(mail,"\n%s\n",audit_line);
		fprintf(mail,".\n");
/* #else
	    sprintf(audit_cmd,"Mail -s %s %s",subject,address);
	    mail = popen(audit_cmd,"w");
	    if (mail != NULL) {
		fprintf(mail,"%s\n",audit_line);
 #endif */
		fclose(mail);
		}
	    exit(exit_status);
	    }

	   sprintf(audit_line,"%s : %12s ( %-24 ) | %8s/%1s.%-4s | %-6s | %s %s | %-72s | %d:%d:%d:%d  %d:%d:%d:%d  %d:%d:%d:%d",
		subject,machine,GetHostName(),OS,major_os,
	        minor_os,getenv("USER"),sys_time,date,
                argv[1],days,hrs,mins,secs,csdays,cshrs,csmins,cssecs,
                cudays,cuhrs,cumins,cusecs);

/* Try using the /usr/lib/sendmail block for 
 * all architectures - Joe M. Wade 10/31/03
 */
	   
/* #ifdef LINUXSYSTEM */
	    sprintf(audit_cmd,"/usr/lib/sendmail %s",address);
	    mail = popen(audit_cmd,"w");
	    if (mail != NULL) {
		fprintf(mail,"To: %s\n",address);
		fprintf(mail,"Subject: %s\n",subject);
		fprintf(mail,"From: %s\n",getenv("USER"));
		fprintf(mail,"\n%s\n",audit_line);
		fprintf(mail,".\n");
/* #else

	   sprintf(audit_cmd,"Mail -s %s %s",subject,address);
	   mail = popen(audit_cmd,"w");
	   if (mail != NULL) {
		fprintf(mail,"%s\n",audit_line);
  #endif */
		fclose(mail);
		}
	  exit(0);
	  }
}
