/***********************************************************************
 *                copyright 2004, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <string.h>

char *GetHostName(void)
{
    char              Buffer[1024];
    char             *Tokens[256];
    char             *StrPtr;
    int               TokenNdx = 0;
    int               Ndx;
    char             *TmpFile = tempnam("/tmp", "HostName");
    FILE             *File;
    static char       HostName[256];
    int		      status;


    /* Build the command to execute */
    sprintf( Buffer
/*         , "grep `hostname` /etc/hosts | grep -v '^[ \t]*#' > %s" */
           , "grep `hostname` /etc/hosts |  sed 's/[ 	]*[#].*$//' | grep -v '^[ \t]*#' > %s"
           , TmpFile
           );
/* 
 * - added status check to handle case where hostname is not in /etc/hosts
 *						j.m.wade 9/22/2000
 */

    status = system(Buffer);
    if (status != 0) {
        sprintf( Buffer, "rm %s",TmpFile);
        system(Buffer);
	}
    
    /* Load the Buffer with the line from /etc/hosts for this host */
    if (!(File = fopen(TmpFile, "r"))) {
        /* Open error so try again with just `hostname` */
        sprintf(Buffer, "hostname > %s", TmpFile);
        system(Buffer);
        File = fopen(TmpFile, "r");
    }
    if (File) {
        fgets(Buffer, sizeof(Buffer), File);
        fclose(File);
        if (!strlen(Buffer)) strcpy(Buffer, "\n");
    }
    else {
        strcpy(Buffer, "HostName-Unknown\n");
    }
    unlink(TmpFile);

    /* Convert the NewLine into end of string */
    Buffer[strlen(Buffer)-1] = '\0';

    /* Bust the Buffer up into tokens */
    StrPtr = Buffer;
    while (isspace(*StrPtr)) StrPtr++;
    Tokens[TokenNdx] = StrPtr;
    while (*StrPtr) {
        if (isspace(*StrPtr)) {
            *StrPtr = '\0';
            while (isspace(*(++StrPtr)));
            Tokens[++TokenNdx] = StrPtr;
        }
        else StrPtr++;
    }

    /* Set up default HostName */
    strcpy(HostName, Tokens[0]);

    /* Scan tokens for one with a dot and return it */
    for (Ndx = 1; Ndx <= TokenNdx; Ndx++) {
        if (strchr(Tokens[Ndx], '.')) {
            strcpy(HostName, Tokens[Ndx]);
            break;
        }
    }

    /* Return HostName */
    return HostName;
}
