C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ap2xt(uin,uout,xomega,live,
     1                 xomegatr,hbegin,lenhed,lenwin,ntfft,
     2                 ntr,ntrwin,ns,ne,nxfft,ist,iend,maxt,liverec)

      integer hbegin

      real    uout(hbegin:maxt,ntr)       
      real    uin(hbegin:maxt,-nxfft/2:nxfft/2-1)      
c
      complex  xomega(ntfft/2,nxfft)
      complex  xomegatr(nxfft,ntfft/2)
      logical  live(ntr), liverec
c__________________________________________________________________
c     copy trace headers from input data to output data.
c__________________________________________________________________
      itrin=-nxfft/2-1
      do 5000 itr=1,ntr 
       itrin=itrin+1
       call vmov(uin(hbegin,itrin),1,uout(hbegin,itr),1,lenhed)
5000  continue
      if(.not. liverec) then
c___________________________________________________________________
c        dead record. zero the output and return.
c___________________________________________________________________
         do 9000 itr=1,ntr 
          do 8000 j=1,maxt   
           uout(j,itr)=0.
8000      continue
9000     continue
         return
      endif
c___________________________________________________________________
c     remap principle period from (-nxfft/2:nxfft/2-1) to (1:nxfft)
c     flip data from omega up to omega down.                       
c     unpack amplitude and phase components.
c___________________________________________________________________
      do 30000 kxin=-nxfft/2,nxfft/2-1
       if(kxin .lt. 0) then    
          kx=kxin+nxfft+1 
       else
          kx=kxin+1  
       endif
       iamp=ntfft/2+1
       iphase=ntfft+1
       do 20000 iomega=1,ntfft/2
        iamp=iamp-1           
        iphase=iphase-1       
        xomegatr(kx,iomega)=uin(iamp,kxin)*
     1     cmplx(cos(uin(iphase,kxin)),sin(uin(iphase,kxin)))
20000  continue
30000 continue
c___________________________________________________________________
c     transform from kx --> x (in place)              
c___________________________________________________________________
      do 40000 iomega=1,ntfft/2
       call cfft(xomegatr(1,iomega),nxfft,-1) 
40000 continue
c___________________________________________________________________
c     transpose data.                                 
c     lop off right most traces.                
c___________________________________________________________________
      do 60000 iomega=1,ntfft/2
       do 50000 ix=1,ntrwin
        xomega(iomega,ix)=xomegatr(ix,iomega)
50000  continue
60000 continue
c___________________________________________________________________
c     transform from omega --> t (out of place)       
c___________________________________________________________________
      itrin=0     
      do 70000 itr=ns,ne    
       itrin=itrin+1
       call rfftb(xomega(1,itrin),uout(1,itr),ntfft,-1)
70000 continue
c___________________________________________________________________
c     clear out traces that did not fall within the filter window.           
c___________________________________________________________________
      do 75000 itr=1,ns-1
       call vclr(uout(1,itr),1,ntfft)
75000 continue
      do 76000 itr=ne+1,ntr
       call vclr(uout(1,itr),1,ntfft)
76000 continue
c___________________________________________________________________
c     clear out traces that did not fall within the filter window.           
c___________________________________________________________________
      do 79000 itr=1,ntr
       if(.not. live(itr)) then
          call vclr(uout(1,itr),1,ntfft)
       endif
79000 continue
c___________________________________________________________________
c     move data back to its proper position before windowing.                
c___________________________________________________________________
      do 90000 itr=ns,ne    
       do 80000 isamp=iend,ist,-1
        uout(isamp,itr)=uout(isamp+1-ist,itr)
80000  continue
       do 82000 isamp=1,ist-1
        uout(isamp,itr)=0.
82000  continue
       do 83000 isamp=iend+1,ntfft
        uout(isamp,itr)=0.
83000  continue
90000 continue
c
      return
      end
