C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c      PROGRAM fft2da
c 
c Changes:
c
c  Oct 21, 2003: removed mapmem[] logic, replaced with galloc[] to allow
c                for debugging.  Installed implicit none and did declaration
c                on all resulting undefined variables.  Fixed indexing snafu
c                when using -s[] -e[] on the command line.  Now use MnTrSt
c                and MxTrST in the output line header to keep track of that
c                stuff for use  with the inverse transform.  This is a 
c                pretty massive re-write.  Hopefully no new bugs installed
c                in the process.
c  Garossino
c
c  Sept, 97: fixed logic in rdgather to prevent killing traces
c            with stacor > 30000.  Now looks specifically for
c            traces where stacor=30000 or stacor=30001
c  Garossino
c
C
C**********************************************************************C
C
C
C     DECLARE VARIABLES
C

      implicit none

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables

      integer jerr, ns, ne, irs, ire, argis
      integer ist, iend, luin, luout, lbytes
      integer nrec, nsamp, ntrin, nsi

      real UnitSc

      character ntap*256, otap*256, name*6 

      logical verbos

#include <f77/pid.h>

c declare variables used in dynamic memory allocation

      integer errcod, errcheck, alloc_size, abort
      integer l_free, lenu, lenwork

      integer itr, muteend, mutesm

      real uin, uout, xomega, xomegatr
 
      logical live

      pointer ( mem_itr, itr(1) )
      pointer ( mem_muteend, muteend(1) )
      pointer ( mem_mutesm, mutesm(1) )
      pointer ( mem_uin, uin(1) )
      pointer ( mem_uout, uout(1) )
      pointer ( mem_xomega, xomega(1) )
      pointer ( mem_xomegatr, xomegatr(1) )
      pointer ( mem_live, live(1) )


c declare program dependent static variables

      integer hbegin, ordfft, lenhed, nrecwin, ntrwin
      integer ntfft, nxfft, ntr, lenwin, ntrout, nsamporig
      integer nu, maxt, lbyout, lentr2, nbyptr, irec
      integer irecnum, lentr2_out, maxt_out
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer ifmt_MulSkw, l_MulSkw, ln_MulSkw

      real dt

      character*2 domain
c
      logical revers, forward, smooth, eod, liverec
 
c initialize variables


      data name  /'FFT2DA'/    
      data abort /0/

c  get online help if necessary

      if ( argis('-?') .gt .0 .or. 
     :     argis('-help') .gt. 0 .or. 
     :     argis('-h') .gt. 0 )then
           call help ()
           stop
      endif

c  open printout file

#include <f77/open.h>

c  parse program parameters from command line

      call cmdln ( ntap, ist, iend, ns, ne, irs, ire, verbos,
     1     revers, otap, smooth )

      forward = .not. revers

c open input and output data streams

      call getln(luin,ntap,'r',0 )
      call getln(luout,otap,'w',1 )

c allocate buffer for input line header

      alloc_size = SZLNHD * SZSMPD
      errcod = 0
      call galloc(mem_itr,alloc_size,errcod,abort)
      if (errcod .ne. 0) then
	write(LERR,*) 'ERROR: Unable to allocate workspace '
	write(LERR,*) '       ',alloc_size,' bytes requested '
	write(LERR,*) '       FATAL'
	write(LER,*) 'FFT2DA: Unable to allocate workspace '
	write(LER,*) '       ',alloc_size,' bytes requested '
	write(LER,*) 'FATAL'
	stop 100
      else
        write(LERR,*)'Allocating workspace:'
	write(LERR,*) alloc_size,' bytes requested '
      endif

c read input line header
      lbytes = 0
      call rtape ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(lerr,*)'FFT2DA: no header read on unit ',ntap
         write(lerr,*)'Check existence of file & rerun'
         write(lerr,*)'FATAL'
         write(ler,*)'FFT2DA: '
         write(ler,*)' no header read on input', ntap
         write(ler,*)' Check existence of file & rerun'
         write(ler,*)'FATAL'
         stop
      endif

c print hlh to printout file

      call hlhprt(itr,lbytes,name,6,lerr)


c read off relevant arguments from line header

      call saver(itr,'NumRec',nrec,LINHED)
      call saver(itr,'NumSmp',nsamp,LINHED)
      call saver(itr,'NumTrc',ntrin,LINHED)
      call saver(itr,'SmpInt',nsi,LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c generate trace header variables for later use

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('MulSkw',ifmt_MulSkw,l_MulSkw,ln_MulSkw,TRACEHEADER)

      lenhed=ITRWRD
      hbegin=1-lenhed

c ensure that command line values are compatible with data set

      call cmdchk(ns,ne,irs,ire,ntrin,nrec)

c convert sample interval to seconds

      dt = float(nsi) * unitsc

      if(ire .lt. 1) ire=nrec
      nrecwin=ire-irs+1 

      ist=ist/nsi + 1
      iend=iend/nsi + 1

      if(ns .lt. 1) ns=1
      if(ne .lt. 1) ne=ntrin
      ntrwin=ne-ns+1

      if(ist .le. 0) ist=1
c______________________________________________________________________
c     save headers:
c     store original number of traces  under keyword 'IndAdj'
c     store original number of samples under keyword 'OrNSMP'
c     these will get used on the inverse transform to get back to the
c     original size of the input dataset
c______________________________________________________________________

      call savew(itr,'NumRec',nrecwin,LINEHEADER)

      if (revers) then

         ntfft = nsamp
         nxfft = ntrin
c         call saver(itr,'OrNTRC',ntr,LINEHEADER)
c i have changed this to IndAdj to prevent  collision
c with rwindow
c Garossino - I am going to compile and release this on Friday July 8, 1994

         call saver(itr,'IndAdj',ntr  ,LINEHEADER)

c Guto: changed from TmSlIn to OrNSMP to store orig # samps - 5/8/95
c       also see below savew
c        call saver(itr,'TmSlIn',nsamp,LINEHEADER)

         call saver(itr,'OrNSMP',nsamp,LINEHEADER)
         call saver(itr,'MnTrSt',ist,LINEHEADER)
         call saver(itr,'MxTrSt',iend,LINEHEADER)
         call savew(itr,'NumTrc',ntr,LINEHEADER)
         call savew(itr,'NumSmp',nsamp,LINEHEADER)

         domain='xt'
         call savew(itr,'DgTrkS',domain,LINEHEADER)
         

         if(iend .le. 1) iend=nsamp
         lenwin=iend-ist+1
         ntrout = ntr
         nsamporig = nsamp

      else

         nsamporig = nsamp
         if(iend .le. 1) iend=nsamp
         lenwin=iend-ist+1
         nu = ordfft(lenwin)
         ntfft = 2 ** nu
         nu = ordfft(ntrwin)
         nxfft = 2 ** nu

         call savew( itr,'NumRec',nrecwin,LINEHEADER)

c         call savew( itr,'OrNTRC',ntrin,LINEHEADER)
c i have changed this to IndAdj to prevent  collision
c with rwindow
c Garossino

         call savew( itr,'IndAdj',ntrin,LINEHEADER)
         call savew( itr,'OrNSMP',nsamp,LINEHEADER)
         call savew( itr,'NumSmp',ntfft,LINEHEADER)
         call savew( itr,'NumTrc',nxfft,LINEHEADER)
         domain='fk'
         call savew(itr,'DgTrkS',domain,LINEHEADER)
         call savew(itr,'MnTrSt',ist,LINEHEADER)
         call savew(itr,'MxTrSt',iend,LINEHEADER)
         ntrout = nxfft

      endif

      maxt = max(ntfft,iend,nsamp)

c printout 

      write(lerr,*) 
      write(lerr,*) 'files'         
      write(lerr,*) 'ntap : ',ntap    
      write(lerr,*) 'otap : ',otap    
      write(lerr,*)
      write(lerr,*)' Values read from input data set line header'
      write(lerr,*)
      write(lerr,*) ' samples/trace      =  ', nsamp
      write(lerr,*) ' start sample       =  ', ist  
      write(lerr,*) ' end   sample       =  ', iend 
      write(lerr,*) ' samples in window  =  ', lenwin
      write(lerr,*) ' fft length in time =  ', ntfft 
      write(lerr,*) ' trace buffer length=  ', maxt  
      write(lerr,*)
      write(lerr,*) ' Sample Interval    =  ', nsi  
      write(lerr,*) ' Traces per Record  =  ', ntrin
      write(lerr,*) ' Traces in window   =  ', ntrwin
      write(lerr,*) ' fft length in space=  ', nxfft 
      write(lerr,*) ' Records per Line   =  ', nrec
      if(revers) then
         write(lerr,*) ' Output # traces    =  ', ntr
         write(lerr,*) ' start trace        =  ', ns     
         write(lerr,*) ' end   trace        =  ', ne     
         write(lerr,*) ' Output # samples   =  ', nsamp
      else
         write(lerr,*) ' Output # traces    =  ', nxfft
         write(lerr,*) ' Output # samples   =  ', ntfft
      endif
      write(lerr,*) ' Output records     =  ', nrecwin
      write(lerr,*) ' Reverse Transform? =  ', revers
      write(lerr,*) ' smooth early mutes ?         ',smooth

c update hlh

      call savhlh(itr,lbytes,lbyout )

c write output lineheader

      call wrtape(luout,itr,lbyout)

c______________________________________________________________________
c     calculate memory requirements
c     keep data buffered out to fft sizes, even if we don't need them.
c______________________________________________________________________

c      lenu = nxfft*(maxt+lenhed)
c____________________________________________________________________

      l_free=1
      lenu = nxfft * ( SZTRHD + maxt )
      lenwork = ntfft*nxfft 

      errcheck = 0
      errcod = 0
      call galloc ( mem_uin, lenu*SZSMPD, errcod, abort )
      errcheck = errcheck + errcod
      errcod = 0
      call galloc ( mem_uout, lenu*SZSMPD, errcod, abort )
      errcheck = errcheck + errcod
      errcod = 0
      call galloc ( mem_xomega, lenwork*SZSMPD, errcod, abort )
      errcheck = errcheck + errcod
      errcod = 0
      call galloc ( mem_xomegatr, lenwork*SZSMPD, errcod, abort )
      errcheck = errcheck + errcod
      errcod = 0
      call galloc ( mem_live, nxfft*SZSMPD, errcod, abort )
      errcheck = errcheck + errcod
      errcod = 0
      call galloc ( mem_muteend, nxfft*SZSMPD, errcod, abort )
      errcheck = errcheck + errcod
      errcod = 0
      call galloc ( mem_mutesm, nxfft*SZSMPD, errcod, abort )
      errcheck = errcheck + errcod

c      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
c      call mapmem('uin',l_uin,l_free,lenu,lerr)
c      call mapmem('uout',l_uout,l_free,lenu,lerr)
c      call mapmem('xomega',l_xomega,l_free,lenwork,lerr)
c      call mapmem('xomegatr',l_xomegatr,l_free,lenwork,lerr)
c      call mapmem('live',l_live,l_free,nxfft,lerr)
c      call mapmem('muteend',l_muteend,l_free,nxfft,lerr)
c      call mapmem('mutesm',l_mutesm,l_free,nxfft,lerr)
c_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
c      lens=l_free-1
c      write(lerr,'(a20,10x,i10)') 'total vector length',lens
c      call galloc(pntrs,lens*szsmpd,ierrcd,0)

      if ( errcheck .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)
         write(lerr,*)'program FFT2DA aborted'
         write(LER,*)' '
         write(LER,*)'FFT2DA:'
         write(LER,*)' unable to allocate workspace'
         write(LER,*) 2*lenu*SZSMPD,'  bytes requested'
         write(LER,*) 2*lenwork*SZSMPD,'  bytes requested'
         write(LER,*) 3*nxfft*SZSMPD,'  bytes requested'
         write(LER,*)'FATAL '
         write(LER,*)' '
         stop 101
      else
         write(LERR,*)'Allocating workspace:'
         write(LERR,*)2*lenu*SZSMPD,'  bytes requested'
         write(LERR,*)2*lenwork*SZSMPD,'  bytes requested'
         write(LERR,*)3*nxfft*SZSMPD,'  bytes requested'
      endif

c_____________________________________________________________
c     calculate length of trace in integer*2 words.
c     calculate number of bytes in output trace
c     calculate trace header position of key variables.
c_____________________________________________________________
c     lentr2=lntrhd+maxt*i2fact

      lentr2=lenhed+maxt
      if(revers) then
         nbyptr=(nsamp+lenhed)*szsmpd
      else
         nbyptr=(ntfft+lenhed)*szsmpd
      endif

      if(revers) then
c________________________________________________________________
c        clear out all traces.
c        reverse transformed traces will overwrite the window 
c        window (ist:iend,ns:ne)
c________________________________________________________________
c         call clrgather(s(l_uin),hbegin,maxt,ntrin)
         call clrgather(uin,hbegin,maxt,ntrin)
      else
c________________________________________________________________
c        skip over records.  
c________________________________________________________________
c         call recskp(1,irs-1,luin,ntrin,s(l_uin))    
         call recskp(1,irs-1,luin,ntrin,uin)    
      endif

      do 50000 irec=irs,ire
c________________________________________________________________
c      read in seismic gather.
c________________________________________________________________

c       call rdgather(s(l_uin),s(l_uin),s(l_live),hbegin,maxt, 

         call rdgather( uin, uin, live, hbegin,maxt, 
     1        lentr2,ntrin,luin,lerr,eod,itr,irec,
     2        l_StaCor,l_RecNum,l_MulSkw,
     3        ifmt_StaCor,ifmt_RecNum,ifmt_MulSkw,
     4        ln_StaCor,ln_RecNum,ln_MulSkw,
     5        irecnum,forward,liverec,nsamporig)

       if(eod) then       
          write(lerr,*)'error!'  
          write(lerr,*)'read ',itr,' traces from record ',irec,
     1                 ' instead of ',ntrin  
          write(lerr,*)'file unit number = ',luin
          write(lerr,*)'file name = ',ntap   
          go to 99000
       endif
       if(verbos) write(lerr,*) 'process record ',irec,
     1                                ' liverec =',liverec

       if(forward) then
c________________________________________________________________
c         forward fft from (x,t) to (kx,omega)
c________________________________________________________________

c          call xt2ap(s(l_uin),s(l_uout),s(l_xomega),
c     1               s(l_xomegatr),hbegin,lenhed,lenwin,ntfft,

          call xt2ap(uin ,uout , xomega, 
     1         xomegatr,hbegin,lenhed,lenwin,ntfft,
     2         ntrin,ntrwin,ns,ne,nxfft,ist,iend,maxt,liverec)

       else
c________________________________________________________________
c         inverse fft from (kx,omega) to (x,t)
c________________________________________________________________

          call ap2xt(uin,uout,xomega,live,
     1         xomegatr,hbegin,lenhed,lenwin,ntfft,
     2         ntr,ntrwin,ns,ne,nxfft,ist,iend,maxt,liverec)
       endif 
c________________________________________________________________
c      update trace headers
c      output data
c________________________________________________________________
       if(.not. revers) then

c at this point we have transform domain data and need to 
c assign the correct array dimensions based on the size of the
c transform
c     1         l_recnum,l_trcnum,l_stacor,lentr2,

          lentr2_out = lenhed + ntfft

          call hdupdat(uout,nxfft,irecnum,-nxfft/2,
     1         l_recnum,l_trcnum,l_stacor,lentr2_out,
     2         ifmt_RecNum,ifmt_TrcNum,ifmt_StaCor,
     3         ln_RecNum,ln_TrcNum,ln_StaCor)     


c          call wrgather(uout,uout,hbegin,maxt,
c     2         ifmt_MulSkw,lentr2,nxfft,nbyptr,luout,ln_MulSkw,
          maxt_out = ntfft
          call wrgather(uout,uout,hbegin,maxt_out,
     1         mutesm,muteend,forward,smooth,
     2         ifmt_MulSkw,lentr2_out,nxfft,nbyptr,luout,ln_MulSkw,
     3         l_MulSkw)
       else

          call hdupdat(uout,ntrwin,irecnum,1, 
     1         l_recnum,l_trcnum,l_stacor,lentr2,
     2         ifmt_RecNum,ifmt_TrcNum,ifmt_StaCor,
     3         ln_RecNum,ln_TrcNum,ln_StaCor)     


          call wrgather(uout,uout,hbegin,maxt,
     1         mutesm,muteend,forward,smooth,
     2         ifmt_MulSkw,lentr2,ntr,nbyptr,luout,ln_MulSkw,
     3         l_MulSkw)
       endif

50000 continue
99000 continue
c__________________________________________________________________
c     close files
c__________________________________________________________________
      call lbclos(luin)
      call lbclos(luout)
c
      write(lerr,*) 'normal completion of routine fft2da'
      write(LER ,*) 'normal completion of routine fft2da'
      stop
      end

c------------------------------
c  online help section
c------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for fft2da:  2-d fft'
        write(LER,*)' '
        write(LER,*)'-Delimeter[argument]........................(def)' 
        write(LER,*)' '
        write(LER,*)' '
        write(LER,*)'-N[ntap] -- input space/time (x,t) data set'
        write(LER,*)'-O[otap] -- output amplitude/phase (omega,kx)'
     1                         //' data set'
        write(ler,*)
        write(ler,*)' additional command line arguments:'           
        write(ler,*)
        write(LER,*)'-s[ist]    -- start time (ms)         (first samp)'
        write(LER,*)'-e[iend]   -- end time (ms)            (last samp)'
        write(LER,*)'-ns[ns]    -- start trace #                (first)'
        write(LER,*)'-ne[ne]    -- end trace #                   (last)'
        write(LER,*)'-rs[irs]   -- start record                 (first)'
        write(LER,*)'-re[ire]   -- end record                    (last)'
        write(LER,*)'-re[ire]   -- end record                    (last)'
        write(LER,*)'-R         -- inverse transform flag     (.false.)'
        write(ler,*)'-S         -- smooth early mutes on inverse '
     1                           //'(.false.)'
        write(LER,*)'-V         -- verbose output'
        write(LER,*)'Usage:'
        write(LER,*)'        fft2da -N[]-O[] '
        write(ler,*)'               -s[] -e[] -ns[] -ne[]  '
        write(ler,*)'               -rs[] -re[] -[R,S,V]'
        write(LER,*)' '

      return
      end

      subroutine cmdln (ntap,ist,iend,ns,ne,irs,ire,verbos,
     1                  revers,otap,smooth)
#include <f77/iounit.h>
      character*(*) ntap,  otap
      integer    argis,ist,iend,irs,ire,ns,ne
      logical    verbos, revers,smooth

      call argstr('-N',ntap,' ',' ') 
      call argstr('-O',otap,' ',' ') 
      call argi4('-s',ist,1,1)
      call argi4('-e',iend,0,0)
      call argi4('-ns',ns,1,1)
      call argi4('-ne',ne,0,0)
      call argi4('-rs',irs,1,1)
      call argi4('-re',ire,0,0)
      revers=(argis('-R') .gt. 0)
      smooth=(argis('-S') .gt. 0)
      verbos=(argis('-V') .gt. 0)
c
      return
      end
