/***********************************************************************
 *                copyright 2004, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
 this code is used to run a stat on a file and print out whatever information
 is specified on the command line. It is designed to be run by scripts to
 avoid the use of slower user commands. 
						- Joe M. Wade 2/26/01
*/

#include	<stdio.h>
#include	<time.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<signal.h>
#include	<errno.h>
#include	<pwd.h>
#include	<localsys.h>
#include	<cu_defs.h>

void main( argc, argv )

int argc;
char **argv;

{
	int i;
	char *file;
	struct stat	buf;
	int debug;
	int help;
	int option;
	int C_ARGIS();
	char *options[] = {"-size","-mode"};

	help = C_ARGIS("-h",&argc,argv);
	help += C_ARGIS("-?",&argc,argv);
	if (help != 0) {
		fprintf(stderr,"Command line arguments for FILESTAT:\n\n");
		fprintf(stderr,"-size   -- extract size of specified file\n");
		fprintf(stderr,"-mode   -- extract mode of specified file (in octal)\n\n");
		fprintf(stderr,"Usage: usp filestat [-size] [-mode] file\n\n");
		exit(0);
		}

	debug = C_ARGIS("-debug",&argc,argv);

	file = strdup(argv[argc-1]);

	if ( stat( file, &buf ) != 0 ) {
	  fprintf(stderr,"filestat: \"stat of %s failed: errno = %d\" ",file,errno);
	  exit(1);
	  }

	for (i=0;i<sizeof(options)/sizeof(char *);i++) {
	  if (strcmp(options[i],"-size") == 0) {
	    if ( C_ARGIS("-size",&argc,argv) != 0 ) {
	      fprintf(stdout,"%ld",(long)buf.st_size);
	      }
	    }
	  else if (strcmp(options[i],"-mode") == 0) {
	    if ( C_ARGIS("-mode",&argc,argv) != 0 ) {
	      fprintf(stdout,"%03o",(int)buf.st_mode);
	      }
	    }
	  }

}
