C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c     program module fitter
c
c**********************************************************************c
c
c fitter reads seismic trace data from an input file,
c and fits a user specified function to the data
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include     <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      parameter   (mmax = 2500)

      integer     itr ( SZLNHD ), itrhdr
      pointer     (wkitrhdr , itrhdr (1))
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes, lbyout,lbyte
      integer     irs,ire,ns,ne,ist,iend,obytes
#include <f77/pid.h>
      integer     recnum, trcnum, static, poly, iloc, dead
      pointer     (wkdead , dead (1))

      real        tri, work, xtr, sig, time
      pointer     (wktri  , tri  (1))
      pointer     (wkwork , work (1))
      pointer     (wkxtr  , xtr  (1))
      pointer     (wksig  , sig  (1))
      pointer     (wktime , time (1))

      real*8      trace, sample, ampls
      pointer     (wkampls, ampls (1))
      pointer     (wktrace, trace (1))
      pointer     (wksample, sample (1))

      real*8      xx, vv, space
      pointer     (wkxx   , xx   (1))
      pointer     (wkvv   , vv   (1))
      pointer     (wkspace, space(1))
      real*8      sst, delta
      real*8      coef(680), dcoef(120)
      real*8      reg(14), ssr(14), ssd(14), f1(14)
      integer     ndf1(14), ndf2(14), ndf3, itrial(14)
      integer     irtype, limord, ilim, isord

      real        covm (mmax), A(mmax)
      integer     array(mmax)
      character   ntap * 512, otap * 512, name*6
      logical     verbos, query, diff, rob, surf, fill
      integer     argis, itype, iabort, ierr, ierrt, ibye, ibyt

      data lbytes / 0 /, nbytes / 0 /, name/'FITTER'/
      data iabort/0/

c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif

c-----
c     open printout files
c-----
#include <f77/open.h>

      call gcmdln(ntap,otap,ns,ne,irs,ire,verbos,
     1            poly, itype, ist, iend, diff, rob, surf,
     2            ilim, irtype, fill)

      if (poly*poly .gt. mmax) then
         write(LERR,*)'Order of polynomial ',poly,' too high'
         amax = mmax
         imax = sqrt(amax)
         write(LERR,*)'Cannot be greater than ',imax
         stop
      endif
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape   ( luin, itr, lbyte)
      if(lbyte .eq. 0) then
         write(LERR,*)'FITTER: no header read from unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c-----
c     modify line header to reflect actual number of traces output
c-----
      call hlhprt (itr, lbyte, name, 6, LERR)
      nrecc = ire - irs + 1
      jtrc  = ne - ns + 1
      obytes = SZTRHD + nsamp * SZSMPD
      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumTrc', jtrc , LINHED)
      call savhlh(itr,lbyte,lbyout)
      call wrtape ( luout, itr, lbyout                 )


c-----
c     allocate memory
c-----
      ierrt = 0
      ierr  = 0
      ibye  = 0
      ibyt  = 0
      jsz   = SZSMPD
      jsz2  = 2 * jsz
      itemh = (ntrc * ITRWRD)  * jsz
      itemn = ntrc  * jsz
      itemt = nsamp * jsz
      itemx = nsamp * jsz2
      if (surf) then
         ndi = nsamp
         nli = ntrc
         nxy   = nli * ndi
         itemd = nxy * jsz2
         items = (2 * nxy + 680) * jsz2
         itemw = itemd
      else
         ndi = 1
         nli = 1
         items = (29 + 2*nsamp) * jsz2
         itemw = itemt
      endif
      
      call galloc (wkitrhdr, itemh, ierr, iabort)
      ierrt = ierrt + ierr
      ibyt  = ibyt + itemt
      call galloc (wktri, itemt, ierr, iabort)
      ierrt = ierrt + ierr
      ibyt  = ibyt + itemt
      call galloc (wkwork, itemw, ierr, iabort)
      ierrt = ierrt + ierr
      ibyt  = ibyt + itemw
      call galloc (wkxtr, itemt, ierr, iabort)
      ierrt = ierrt + ierr
      ibyt  = ibyt + itemt
      call galloc (wksig, itemt, ierr, iabort)
      ierrt = ierrt + ierr
      ibyt  = ibyt + itemt
      call galloc (wktime, itemt, ierr, iabort)
      ierrt = ierrt + ierr
      ibyt  = ibyt + itemt
      call galloc (wkxx, itemx, ierr, iabort)
      ierrt = ierrt + ierr
      ibyt  = ibyt + itemx
      call galloc (wkvv, itemx, ierr, iabort)
      ierrt = ierrt + ierr
      ibyt  = ibyt + itemx
      call galloc (wkdead, itemn, ierr, iabort)
      ierrt = ierrt + ierr
      ibyt  = ibyt + itemn
      call galloc (wkspace, items, ierr, iabort)
      ierrt = ierrt + ierr
      ibyt  = ibyt + items
      call galloc (wkampls, itemd, ierr, iabort)
      ierrt = ierrt + ierr
      ibyt  = ibyt + itemd
      call galloc (wktrace, itemd, ierr, iabort)
      ierrt = ierrt + ierr
      ibyt  = ibyt + itemd
      call galloc (wksample, itemd, ierr, iabort)
      ierrt = ierrt + ierr
      ibyt  = ibyt + itemd

      if (ierrt .ne. 0) then
         write(LERR,*)'FATAL ERROR in fitter:'
         write(LERR,*)'Unable to allocate ',ibyt,' bytes'
         write(LER ,*)'FATAL ERROR in fitter:'
         write(LER ,*)'Unable to allocate ',ibyt,' bytes'
         go to 911
      else
         write(LERR,*)'Aloocated ',ibyt,' bytes'
      endif

      ist = ist / nsi
      if (ist .le. 1) ist = 1
      iend = iend / nsi
      if (iend .le. 1) iend = nsamp
      if (iend .ge. nsamp) iend = nsamp
      nfit = iend - ist + 1
      ndi  = nfit

      if (nfit .lt. 2*poly) then
         write(LERR,*)'FATAL ERROR in fittern:'
         write(LERR,*)'Number of samples/trc to be fit= ',nfit
         write(LERR,*)'must be > ',2*poly
         write(LER ,*)'FATAL ERROR in fittern:'
         write(LER ,*)'Number of samples/trc to be fit= ',nfit
         write(LER ,*)'must be > ',2*poly
         go to 911
      endif
c-----
c     for 2D generate matrices of trace numbers and samples or
c     for 1D generate vector of 2-way times
c-----
      dt = real (nsi) * unitsc

      if (surf) then

         if (nli .lt. 2*poly) then
            write(LERR,*)'FATAL ERROR in fitter, surf option:'
            write(LERR,*)'Number of traces/rec to be fit= ',nli
            write(LERR,*)'must be > ',2*poly
            write(LER ,*)'FATAL ERROR in fitter, surf option:'
            write(LER ,*)'Number of traces/rec to be fit= ',nli
            write(LER ,*)'must be > ',2*poly
            go to 911
         endif
         ic = 0
         do  j = 1, nli
         do  i = 1, ndi
             ic = ic + 1
             sample (ic) = dble (i)
             trace  (ic) = dble (j)
         enddo
         enddo

         isord  = poly
         limord = 14

      else

         do  i = 1, nsamp
             time (i) = float ( i ) * dt
             xx (i) = dble(time(i))
             sig (i) = 1.0
         enddo
c-----
c     find limits
c-----
         call maxmgv (time, 1, xmax, indx, nsamp)
         call minmgv (time, 1, xmin, indx, nsamp)

c-----
c     generate list of parameters
c-----
         do  11  i = 1, poly
             array (i) = i
11       continue

         if (rob) then
            delta = 1.d-03
            isord = poly - 1
            iloc = isord * (isord+1) / 2
            irtype = 1
            limord = 14
            ilim   = 4
         endif

      endif


      

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,otap,poly,itype, rob,
     2                  xmin,xmax,surf,
     3                  ilim, irtype, fill)
c     endif
c-----
c     BEGIN PROCESSING
c     read trace, do agc, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
c-----
c     process desired trace records
c-----
      DO  1000  JJ = irs, ire

c----------------
c  skip to start
c  of record
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------

c---
c  2D surface fit using robust fitter
c---
         IF ( surf) THEN

            it = 0
            ic = 0
            ip = 0
c---
c  extract working traces out of record (only ones written out)
c---
            do  KK = ns, ne

                  nbytes = 0
                  call rtape ( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  it = it + 1
                  call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
                  ihptr = (it-1) * ITRWRD + 1
                  call vmov (itr, 1, itrhdr(ihptr), 1, ITRWRD)

                  call saver2(itr,ifmt_StaCor,l_StaCor,
     1                        ln_StaCor, static, TRACEHEADER)

c---
c  use only live traces in fit
c---
                  if(static .ne. 30000)then

                     call saver2(itr,ifmt_RecNum,l_RecNum,
     1                           ln_RecNum, recnum, TRACEHEADER)
                     dead (kk) = 0
                     ic = ic + 1
                     if (ic .eq. 1) irec = recnum
                     iptr = (ic-1) * nfit + 1
                     call vmov (tri(ist), 1, work(iptr), 1, nfit)
                     do  ii = 1, nfit
                         ampls (iptr+ii-1) = work (iptr+ii-1)
                     enddo
c---
c  build vectors of samples and traces (basically just seql numbers)
c---
                     do  i = 1, nfit
                         ip = ip + 1
                         sample (ip) = dble (i)
                         trace  (ip) = dble (it)
                     enddo

                  else

                     dead (kk) = 1

                  endif
            enddo

c---
c  keep track of actual live traces along with number of samps in fir window
c---
            jtr = ic
            nlidi = jtr * nfit

c---
c  robust fit on matrix "ampls"
c---
            call rob3sb(Trace,Sample,ampls,nlidi,irtype,limord,
     1                  coef,reg,ssr,ssd,sst,ndf1,ndf2,ndf3,f1,minord,
     2                  if1max,ifumax,ipoly,ilim,delta,ierr,itrial,
     3                  space,isord)

            if (verbos) then
            write(LERR,*)' '
            write(LERR,*)'Fit completed for rec ',irec,' p= ',isord
c           write(LERR,*)'min significant order  = ',minord
c           write(LERR,*)'max significant order  = ',ifumax
c           write(LERR,*)'recommended surf order = ',ipoly
c           write(LERR,*)' '
            endif

c---
c  set number of traces for either no-fill or fill (i.e. fill in dead traces)
c  using the fit coeffs compute the fitted matrix
c  Note that for fill we will have to recompute the XY values
c---
            if (fill) then
               jtro = jtrc
               ic = 0
               do  j = 1, jtrc
               do  i = 1, nfit
                   ic = ic + 1
                   sample (ic) = dble (i)
                   trace  (ic) = dble (j)
               enddo
               enddo
            else
               jtro = jtr
            endif

            do  j = 1, jtro
                iptr = (j-1) * nfit
                do  i = 1, nfit
                    ampls (iptr+i) = 0.0
                enddo
            enddo

            iloc = ipoly*(ipoly+1) * (ipoly +2)/6
            call surfgen (ipoly,coef(iloc),nfit,jtro,ampls,sample,trace)

c---
c  put the fitted matrix (or its diff from input) into output matrix
c---
            do  j = 1, jtro
                iptr = (j-1) * nfit
                if (diff) then
                   do  i = 1, nfit
                       work(iptr+i) = work(iptr+i) - sngl(ampls(iptr+i))
                   enddo
                else
                   do  i = 1, nfit
                       work(iptr+i) = ampls(iptr+i)
                   enddo
                endif
            enddo

c---
c  reattach trc hdrs; extract output matrix (either filled or not) and 
c  write out
c---
            it = 0
            ic = 0
            do  KK = ns, ne

                it = it + 1
                ihptr = (it-1) * ITRWRD + 1
                call vmov (itrhdr(ihptr), 1, itr, 1, ITRWRD)

                call vclr (tri, 1, nsamp)

                if (fill) then
                   call savew2(itr,ifmt_StaCor,l_StaCor,
     1                         ln_StaCor, 0, TRACEHEADER)
                   ic = ic + 1
                   iptr = (ic-1) * nfit + 1
                   call vmov (work(iptr), 1, tri(ist), 1, nfit)
                else
                   if (dead(kk) .eq. 0) then         !  live trace
                      ic = ic + 1
                      iptr = (ic-1) * nfit + 1
                      call vmov (work(iptr), 1, tri(ist), 1, nfit)
                   endif
                endif

                call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
                call wrtape (luout, itr, obytes)
            enddo

         ELSE

c---
c  1D fitter: first work only on selected traces (only ones written out)
c---
            do  KK = ns, ne

                  nbytes = 0
                  call rtape ( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

                  call saver2(itr,ifmt_StaCor,l_StaCor,
     1                        ln_StaCor, static    , TRACEHEADER)
                  call saver2(itr,ifmt_RecNum,l_RecNum,
     1                        ln_RecNum, recnum    , TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum,
     1                        ln_TrcNum, trcnum    , TRACEHEADER)

c---
c  fir live traces only
c---
                  if(static .ne. 30000)then

                        call vmov (tri, 1, work, 1, nsamp)
                        call vclr (xtr, 1, nsamp)
                        if (poly .ne. 0) then

c---
c  robust fit
c---
                          if (rob) then
                             do  ii = 1, nsamp
                                 vv (ii) = dble(work (ii))
                             enddo
                             call rob2ms(xx(ist),vv(ist),nfit,irtype,
     :                                   limord,coef,dcoef,reg,ssr,ssd,
     :                                   sst,ndf1,ndf2,ndf3,f1,minord,
     :                                   if1max,ifumax,ipoly,ilim,delta,
     :                                   ierr,itrial,space,isord)
c---
c  fill or no-fill dimensions; then use coefs to compute fit vector
c---
                             call vclr (work, 1, nsamp)
                             if (fill) then
                                isto  = 1
                                nfito = nsamp
                             else
                                isto  = ist
                                nfito = nfit
                             endif
                             call pxgen (isord, xx(isto), coef(iloc),
     :                                   nfito, work(isto))
c---
c  least squares fit (note: no fill allowed here)
c---
                          else
                            call fitf (time(ist),work(ist),sig,nfit,A,
     1                                 poly, array, poly, covm, poly,
     2                                 chisq, xmin, xmax, itype, mmax)
                          endif

c---
c  for no-fill zero out top and bottom window of output trace
c---
                          if (.not. fill) then
                             if (ist .gt. 1) then
                                do  ii = 1, ist
                                    work (ii) = 0.0
                                enddo
                             endif
                             if (iend .lt. nsamp) then
                                do  ii = iend, nsamp
                                    work (ii) = 0.0
                                enddo
                             endif
                          endif
                          call vmov (work, 1, xtr, 1, nsamp)

                          if (diff) then
                             do  ii = 1, nsamp
                                 xtr (ii) = tri (ii) - xtr (ii)
                             enddo
                          endif
                        endif
                  else
                        call vclr (xtr, 1, nsamp)
                  endif

                  call vmov  (xtr, 1, itr(ITHWP1), 1, nsamp)
                  call wrtape( luout, itr, nbytes)

            enddo

         ENDIF
c----------------
c  skip to end of
c  current record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------


            if(verbos) write(LERR,*)'fitter:  ri ',recnum

 1000 CONTINUE
c-----
c     close data files
c-----
  999 continue
      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'end of fitter, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      stop

911   continue
      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'Abnormal end of fitter'
      write(LER ,*)'Abnormal end of fitter'
      end

      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'execute fitter by typing fitter and a list of program parameters'
      write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
      write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)       : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)       : output data file name'
      write(LER,*)' '
        write(LER,*)
     :' -s[ist]      (default = 0)  : start fitting time (ms)'
        write(LER,*)
     :' -e[iend]     (default = EOT): end fitting time (ms)'
        write(LER,*)
     :' -ns[ns]      (default = first)  : start trace number'
        write(LER,*)
     :' -ne[ne]      (default = last)   : end trace number'
        write(LER,*)
     :' -rs[irs]      (default = first) : start record number'
        write(LER,*)
     :' -ne[ire]      (default = last)  : end record number'
      write(LER,*)' '
        write(LER,*)
     :' -p [poly]    (default = 0)      : fit nth order poly to data'
        write(LER,*)
     :' -f [itype]   (default = 0)      : type of fitting function'
        write(LER,*)
     :'     itype = 0 : polynomial in X (a0 + a1*X a2*X**2 + ...)'
        write(LER,*)
     :'     itype = 1 : exponentials (exp(X), exp(2*X), ...)'
        write(LER,*)
     :'     itype = 2 : gaussians (exp(X**2), exp(2*X**2), ...)'
        write(LER,*)
     :'     itype = 3 : sine (sin[pi*X/xmx], xmx = max X value'
        write(LER,*)
     :'     itype = 4 : cosine (cos[pi*X/xmx], xmx = max X value'
        write(LER,*)
     :'     itype = 5 : sinc (sin[pi*X/X]'
        write(LER,*)
     :'     itype = 6 : natural logs (log(x), log(X)**2), ...'
        write(LER,*)
     :'     itype = 7 : poly in 1/[xmx-X], xmx = max X value'
        write(LER,*)
     :'     itype = 8 : poly in 1/[X-xmn], xmn = min X value'
        write(LER,*)
     :'     itype = 9 : negative exps (exp(-X), exp(-2*X), ...)'
      write(LER,*)' '
        write(LER,*)
     :' -L                     : least squares polynomial fit, else'
        write(LER,*)
     :'                          else robust polynomial fit'
        write(LER,*)
     :' -D                     : difference betw input and fitted curve'
        write(LER,*)
     :' -S                     : 2D surface robust fit of order -p[]'
        write(LER,*)
     :' -F                     : fill in 2D fit dead traces'
        write(LER,*)
     :' -V                     : verbose printout'
      write(LER,*)' '
         write(LER,*)
     :'usage:   fitter -N[ntap] -O[otap] -p[poly] -f[itype]'
         write(LER,*)
     :'               -s[] -e[] -ns[] -ne[] -rs[] -re[] -L -V -D -S -F'
         write(LER,*)
     :'***************************************************************'
      return
      end

      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,verbos,
     1            poly, itype, ist, iend, diff, rob,surf,
     2            ilim, irtype, fill)
c-----
c     get command arguments
c
c     ntap  - c*100     input file name
c     otap  - c*100     output file name
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c     poly    i*4 fit nth order polynomial to gain curve
c     itype   i*4 type of function to fit
c     verbos      - L   verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     ns, ne, irs, ire, ist, iend, poly
      logical     verbos, diff, rob, surf, fill, lsq
      integer     argis, itype, irtype, ilim

            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-s', ist ,   0  ,  0    )
            call argi4 ( '-e', iend ,  0  ,  0    )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4( '-p', poly, 0, 0 )
            call argi4( '-f', itype, 0, 0 )
            call argi4 ('-iter', ilim, 5 , 5 )
            call argi4 ('-ityp', irtype, 1 , 1 )

            surf   = ( argis( '-S' ) .gt. 0 )
            fill   = ( argis( '-F' ) .gt. 0 )
            lsq    = ( argis( '-L' ) .gt. 0 )
            diff   = ( argis( '-D' ) .gt. 0 )
            verbos = ( argis( '-V' ) .gt. 0 )

      rob = .true.
      if (lsq) rob = .false.

      if (surf) then
         rob = .false.
      endif

      if ((.not.surf .AND. .not.rob) .AND. fill) then
         write(LERR,*)'FATAL ERROR in fitter 1D least squares:'
         write(LERR,*)'Can not have -F fill option.'
         write(LERR,*)'For -F use robust fit -rob'
         write(LER ,*)'FATAL ERROR in fitter 1D least squares:'
         write(LER ,*)'Can not have -F fill option.'
         write(LER ,*)'For -F use robust fit -rob'
         call ccexit (666)
      endif

      if (rob .AND. itype .ne. 0) then
         write(LERR,*)'WARNING in fitter 1D:'
         write(LERR,*)'Robust fit option is for itype=0 only.'
         write(LERR,*)'You asked for itype= ',itype,' Will set=0'
         write(LER ,*)'WARNING in fitter 1D:'
         write(LER ,*)'Robust fit option is for itype=0 only.'
         write(LER ,*)'You asked for itype= ',itype,' Will set=0'
         itype = 0
      endif
      if (surf .AND. itype .ne. 0) then
         write(LERR,*)'WARNING in fitter 2D:'
         write(LERR,*)'Robust fit option is for itype=0 only.'
         write(LERR,*)'You asked for itype= ',itype,' Will set=0'
         write(LER ,*)'WARNING in fitter 2D:'
         write(LER ,*)'Robust fit option is for itype=0 only.'
         write(LER ,*)'You asked for itype= ',itype,' Will set=0'
         itype = 0
      endif

      if (surf .AND. diff .AND. fill) then
         write(LERR,*)'FATAL ERROR in fitter 2D surf option:'
         write(LERR,*)'Can not have both -D and -F'
         write(LER ,*)'FATAL ERROR in fitter 2D surf option:'
         write(LER ,*)'Can not have both -D and -F'
         call ccexit (666)
      endif

      return
      end

      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1            ntap,otap,poly,itype, rob,
     2            xmin,xmax,surf,
     2            ilim, irtype, fill)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     poly    i*4 fit nth order polynomial to gain curve
c     itype   i*4 type of function to fit
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c-----
#include <f77/iounit.h>
      integer     nsamp, nsi, ntrc, nrec, iform, poly
      integer     itype,irtype,ilim
      character   ntap*(*), otap*(*)
      logical     rob, surf, fill

            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' Order of polynomial to fit to data= ',poly
            write(LERR,*)' Function type= ', itype
            write(LERR,*)' Minimum time value = ',xmin
            write(LERR,*)' Maximum time value = ',xmax
            if (surf) then
            write(LERR,*)' Surface robust fit:'
            write(LERR,*)' irtype     = ',irtype
            write(LERR,*)' iterations = ',ilim
            if (fill)
     1      write(LERR,*)' Fill in dead traces'
            else
            write(LERR,*)' One dimensional fit'
            endif
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end

