C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine PickInit ( lupick, NumPicks, NumSegs, nbins, PickType )

c routine to count number of segments and total number of picks 
c in pick file.  Expects xsd or oper pick format

#include <f77/iounit.h>

      integer lupick, NumPicks, NumSegs, nrec, nbins
 
      real rec_units, trc_units, samp_units, segs, value

      character junk*1, key*10, PickType*(*), InputLine*200

c initialize variables 

      NumPicks = 0
      NumSegs = 0

c determine type of pickfile being read if the new headeroutput file is 
c being used do appropriate read 

      IF ( PickType .ne. 'header' ) then

c read file header

         read (lupick,'(a150)')InputLine
         call fsscnf(InputLine,'%s %f %f %f %d %d'//char(0), junk, rec_units,
     :      trc_units, samp_units, nrec, nbins)  
c debug
	write(LER,*)'junk = ', junk
         if(junk.ne."U")then
            write(LERR,*)' '
            write(LERR,*)' FATAL ........................'
            write(LERR,*)' Something fishy with pick file'
            write(LERR,*)' first line does not start with Units'
            write(LERR,*)' Fix this and rerun'
            write(LERR,*)' '
            stop
         endif

c check first segment for format

         read(lupick,'(a1)',end=900)junk

         if(junk.ne."S")then

            write(LERR,*)' '
            write(LERR,*)' FATAL ........................'
            write(LERR,*)' Something fishy with pick file'
            write(LERR,*)' second line does not start with Segment'
            write(LERR,*)' Fix this and rerun'
            write(LERR,*)' '
            stop

         endif

         rewind (lupick)
         read ( lupick, '(a1)' ) junk

c determine number of picks

 10      read(lupick,'(a1)',end=910)junk
      
         if(junk.ne."S")then
            NumPicks = NumPicks + 1
         else            
            NumSegs = NumSegs + 1
         endif

         goto 10

      ELSE

c use new pickfile key,value format 

         do while (1.EQ.1)

            read(lupick,'(a10,1x,f17.6)',end=200)key,value
            if (key.EQ.'No_Seg') then
               segs = value
               NumSegs = nint(segs)
            endif

            if (key.EQ.'Max_Pick') then
               NumPicks = nint(segs * value)
            endif
            
            if(segs.gt.0.and.NumPicks.gt.0)goto 200

         enddo

 200     continue

         if(NumPicks.lt.1) then

            write(LERR,*)'FATAL: something fishy in control pickfile'
            write(LERR,*)'       The total number of picks could not'
            write(LERR,*)'       be calculated.  Check that format of'
            write(LERR,*)'       pickfile is consitent with -M option'
            write(LERR,*)'       used on command line or that correct'
            write(LERR,*)'       spelling was used or if the file'
            write(LERR,*)'       exists at all'
            write(LERR,*)'       '
            stop

         else

            goto 910

         endif

      ENDIF

 900     continue

         write(LERR,*)'FATAL .........'
         write(LERR,*)'No entries found in pick file'
         stop
         
 910     continue

         write(LERR,*)' '
         write(LERR,*)'EOF on pick file after ',NumPicks,' picks'
         write(LERR,*)' '
         rewind(lupick)

      return
      end

