C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  gather  n  Data Sets
C
C**********************************************************************C
C
C MERGN READS SEISMIC TRACE DATA FROM N INPUT FILES,
C and either gathers trace-by-trace or record-by-record, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, savhlh, saver, savew
C
C**********************************************************************C
C Changes:
c
c   Gutowski

c   Feb 14, 2003     - upped the trace sample limit to 5*SZLNHD
c                    - changed -believe flag to honor input number of
c                      records on read for -S -s and -D2.
c
c   January 29, 2002 - added logic to get TmMsFS from first dataset on
c                      the gather.  Assumption is that in most gathers
c                      TmMsFS should be constant.  In the case of -T
c                      it should come from the fist dataset in the 
c                      sequence. 
c   Garossino
c
c   August 25, 2001 - added logic to auto figure output NumRec if not
c                     in robot mode and if all NumTrc are equal.  This 
c                     will save a lot of grief for people like Kenny who
c                     do not want to deal with 20000000 records and the
c                     getval logic required to correct for the actual number
c                     of output records.  I also added implicit none and
c                     fixed up all that it entailed.  I also fixed up 
c                     a lot of error statements to echo to ler when the 
c                     program was going to abort.  I also found a couple 
c                     of typos that got caught by implicit none.  Amazing
c                     still that this program functioned.
c   Garossino
c
c - March 26, 2001 - increased max number of files to gather from 1000
c                    to 2000.  Jim Mika was actually gathering up 1006
c                    files and getting a segmentation fault.  Of course
c                    this only works with -D2 and -S options enabled.
c   Garossino
c
c
C - modified to prevent gathering of dataset where sample intervals 
C   are not the same 				- j.m.wade 9/24/98
C
C**********************************************************************C
C
C     DECLARE VARIABLES

      implicit none
 
#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

c declare standard USP variables

      integer     itr ( 5*SZLNHD )
      integer     lhed( 5*SZLNHD ),luin(2000)
      integer     nsamp, nsampo, nsi, ntrc(2000), nrec(2000), iform
      integer     luout, lbytes, nbytes, obytes, jerr, lbyout, JJ, KK
      integer     ist
      integer     argis, pipes(2000)
      integer     ns (2000), ne (2000), irs (2000), ire (2000)
      integer     nreciu, ntrciu

      character   ntap(2000)*512
      character   name * 6, otap * 512, ftap * 512

      logical     verbos

c declare variables used with Dynamic Memory Allocation

      integer itemi, ierr, iabort

      real tri

      pointer ( wktri, tri(2) )

c declare program specific variables

      integer i, iu, ii, LL, it, ks, ke
      integer orntrc(2000), ornrec(2000)
      integer npipes, pipcnt, pmax
      integer nsa, nea, irsa, irea, tdela, rdela
      integer tdel (2000),rdel (2000)
      integer nsm (2000)
      integer nu, nsi1, nroll, lufil, lbytsv, iflag
      integer nrout, nrr, ntrm, ntrcc, nrl, ntr, ntrd, nrc, nrcd
      integer ir, itotrec, irec, itrc
      integer ntrace
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc
      integer ifmt_RecInd, l_RecInd, ln_RecInd
      integer ifmt_DphInd, l_DphInd, ln_DphInd
      integer ifmt_LinInd, l_LinInd, ln_LinInd
      integer ifmt_DstUsg, l_DstUsg, ln_DstUsg
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer ifmt_SGRNum, l_SGRNum, ln_SGRNum
      integer ifmt_StaCor, l_StaCor, ln_StaCor

      real head( 5*SZLNHD )
      real TmMsFS

      logical mpx, nblk, oneblk, wye, back, backh, orig
      logical trace, heap, select, small, robot, totrec, believe

C initialize variables

      equivalence ( itr(  1), lhed(1), head(1) )
      data name/'GATHER'/
      data lbytes / 0 /, nbytes / 0 /
      data obytes / 0 /
      data verbos/.false./,nblk/.false./,oneblk/.false./,mpx/.false./
      data small /.false./
      data totrec /.false./
      data npipes / 0 /

C**********************************************************************C
C     get help if necessary
C**********************************************************************C

      if ( argis('-?') .gt. 0 .or.
     :     argis('-h') .gt. 0 .or.
     :     argis('-help') .gt. 0 ) then
         call help()
         stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C

#include <f77/open.h>

C**********************************************************************C
C     get commandline arguments
C**********************************************************************C
      call cmdln ( ntap, otap, nu, nblk, oneblk, mpx, verbos, wye, back, 
     :     backh, orig, pmax, nroll, trace, ftap, lufil, robot,
     2     nsa, nea, irsa, irea, tdela, rdela, select,
     3     ns, ne, irs, ire, tdel, rdel, believe )

      pipes(1) = 0
      luin(1)  = 0
      do  i = 2, pmax
         pipes(i) = i + 1
      enddo

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----
c    IF NOT ROBOT then we can open all the data sets
c-----

      IF ( .not. robot) THEN

C**********************************************************************C
C     open logical i/o units
C**********************************************************************C
         IF (nu .ne. 0) THEN
            do 1 i = 1, nu
               call getln(luin(i),ntap(i),'r',0)
               if(luin(i) .eq. 0) then
                  write(LERR,*)'Data set cannot be a pipe'
                  write(LERR,*)'check command line args & rerun'
                  stop
               endif
 1          continue
            
         ELSE
            write(LERR,*)'gather: pmax= ',pmax
            nu = pipcnt (pipes,pmax)
c
c - if pmax was unlimited, program printout also got counted
c
            if (pmax .eq. 2000) nu = nu - 1
            write(LERR,*)'Number of pipes found= ',nu
            write(LERR,*)'socket numbers:'
            write(LERR,*)(pipes(i),i=1,nu)
            if (nu .gt. 2000) then
               write(LERR,*)'Cannot have more then 2000 inputs'
               write(LERR,*)'You have  ',nu,'  inputs'
               stop
            endif
            do 2 i = 1, nu
               if ( pipes(i) .eq. 0) then
                  luin(i) = 0
               else
                  call sisfdfit (luin(i), pipes(i))
               endif
               write(LERR,*)'GATHER: got fortran unit number= ',luin(i),
     1              ', socket = ',pipes(i)
 2          continue
            
            small = .true.
            
         ENDIF

         call getln(luout, otap, 'w', 1)
 
C**********************************************************************C
C     read line headers of input data sets
C     get critical values from line header
C**********************************************************************C
c        if ( mpx ) small = .true.

         if ( backh ) then

            lbytes=0
            CALL RTAPE  ( LUIN(1), ITR, LBYTES                  )
            if(lbytes .eq. 0) then
               write(LERR,*)'GATHER: no header read on unit ',luin(1)
               write(LERR,*)'FATAL'
               stop
            endif
            
            call saver(itr, 'NumSmp', nsamp     ,  LINHED)
            call saver(itr, 'SmpInt', nsi       ,  LINHED)
            call saver(itr, 'TmMsFS', TmMsFS    ,  LINHED)
            call saver(itr, 'NumTrc', ntrc(1)   ,  LINHED)
            call saver(itr, 'NumRec', nrec(1)   ,  LINHED)
            call saver(itr, 'Format', iform     ,  LINHED)
            call saver(itr, 'OrNTRC', orntrc(1) ,  LINHED)
            call saver(itr, 'OrNREC', ornrec(1) ,  LINHED)
            
            do  iu = 2, nu
               ntrc (i) = ntrc (1)
               nrec (i) = nrec (1)
            enddo

            do  i = 1, nu
               if (ntrc(1) .eq. 1 .AND. rdel(i) .ne. 1) small =.true.
               if (ntrc(1) .eq. 1 .AND. rdela .ne. 1) small = .true.
               if (tdel(i) .ne. 1) small = .true.
               if (tdela .ne. 1) small = .true.
            enddo

         else

            do 12 i = 1, nu
               lbytes=0
               CALL RTAPE  ( LUIN(i), ITR, LBYTES                  )
               if(lbytes .eq. 0) then
                  if (i .gt. 1) then
                     nu = i - 1
                     lbytes = lbytsv
                     go to 7
                  endif
                  write(LERR,*)'GATHER: no header read on unit ',luin(i)
                  write(LERR,*)'FATAL'
                  stop
               else
                  lbytsv = lbytes
               endif

c need to get the TmMsFS from the first dataset.  In most gathers
c this should not change but in the case of splitting into time chunks
c and gathering back up it needs to come from the top time chunk of the
c sequence which should be the first one in...PGAG

               if ( i .eq. 1 ) call saver(itr, 'TmMsFS', TmMsFS, LINHED)

               call saver(itr, 'NumSmp', nsamp     ,  LINHED)
               call saver(itr, 'NumSmp', nsm (i)   ,  LINHED)
               call saver(itr, 'SmpInt', nsi       ,  LINHED)
               call saver(itr, 'NumTrc', ntrc(i)   ,  LINHED)
               call saver(itr, 'NumRec', nrec(i)   ,  LINHED)
               call saver(itr, 'Format', iform     ,  LINHED)
               call saver(itr, 'OrNTRC', orntrc(i) ,  LINHED)
               call saver(itr, 'OrNREC', ornrec(i) ,  LINHED)
               if (i .eq. 1) then
                  nsi1 = nsi
               else
                  if (nsi .ne. nsi1) then
                     write(LER,*)'GATHER: sample intervals differ',
     :                    ' among datasets'
                     write(LER,*)'FATAL'
                     write(LERR,*)'GATHER: sample intervals differ',
     :                    ' among datasets'
                     write(LERR,*)'FATAL'
                     stop 100
                  endif
               endif
 12         continue

 7          continue

            do  i = 1, nu
               if (ntrc(i) .eq. 1 .AND. rdel(i) .ne. 1) small = .true.
               if (ntrc(i) .eq. 1 .AND. rdela .ne. 1) small = .true.
               if (tdel(i) .ne. 1) small = .true.
               if (tdela .ne. 1) small = .true.
            enddo
            
         endif

c----
c     save certain trc hdr parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
         call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     :        TRACEHEADER)
         call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,
     :        TRACEHEADER)
         call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     :        TRACEHEADER)
         call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,
     :        TRACEHEADER)
         call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,
     :        TRACEHEADER)
         call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     :        TRACEHEADER)
         call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     :        TRACEHEADER)
         call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,
     :        TRACEHEADER)
 
         call savelu('SGRNum',ifmt_SGRNum,l_SGRNum,ln_SGRNum,
     :        TRACEHEADER)


         IF (orig) THEN

            do  i = 2, nu
               if (orntrc(i) .ne. orntrc(1)) then
                  write(LERR,*)'Original # trcs/rec on DSN ',i,
     1                 ' is different.'
                  write(LERR,*)'Check to see if data came from splitr'
                  write(LERR,*)'Cannot restore original # trcs/rec'
                  stop
               endif
               if (ornrec(i) .ne. ornrec(1)) then
                  write(LERR,*)'Original # recs on DSN ',i,
     1                 ' is different.'
                  write(LERR,*)'Check to see if data came from splitr'
                  write(LERR,*)'Cannot restore original # rec'
                  stop
               endif
            enddo
            
         ENDIF
             
         IF (.not. wye) THEN
            iflag=0
            do 13 i=2,nu
               if(ntrc(i) .ne. ntrc(1)) then
                  write(LERR,*)'Input trc/rec not alike for unit= ',i
               endif
               if(nrec(i) .ne. nrec(1)) then
                  write(LERR,*)'Input rec/line not alike for unit= ',i
                  iflag=1
               endif
 13         continue

            write(LERR,*)' '
            if(iflag .eq. 1 .and. oneblk) then
               write(LERR,*)'Input record # or trace # not all alike'
               do  92  i = 1, nu
                  write(LERR,*)'DSN= ',i,' # recs= ',nrec(i),
     1                 ' # trc/rec= ',ntrc(i)
 92            continue
               write(LERR,*)'Last superblock will be a short record'
            endif
            write(LERR,*)' '

         ENDIF

c output stats specified by input dataset 1

         nrout = nrec(1)
         nrr   = nrec(1)
         ntrm  = ntrc(1)

c**************************************************************
c  multiplex option: put ntuple # in 1/2 wd 70 & flag in wd 69

         if (mpx) then

            if (trace) then
               write(LERR,*)'build long traces from input segments'
               do  i = 2, nu
                  if (ntrc(i) .ne. ntrc(i-1) ) then
                     write(LERR,*)'gather: FATAL ERROR'
                     write(LERR,*)'-T option requires each input data'
                     write(LERR,*)'set have the same number of trcs/rec'
                     stop
                  endif
                  if (nrec(i) .ne. nrec(i-1) ) then
                     write(LERR,*)'gather: FATAL ERROR'
                     write(LERR,*)'-T option requires each input data'
                     write(LERR,*)'set have the same number of records'
                     stop
                  endif
               enddo
               ntrcc = ntrc (1)
               nrout = nrec (1)
               nsampo = 0
               write(LERR,*)'nsm:'
               write(LERR,*)(nsm(ii),ii=1,nu)
               do  i = 1, nu
                  nsampo = nsampo + nsm (i)
               enddo
               write(LERR,*)'Output traces ',nsampo,' samps long'
               heap = .true.
               itemi = nsampo * SZSMPD
               call galloc (wktri, itemi, ierr, iabort)
               if (ierr .ne. 0) heap = .false.
               if (.not. heap) then
                  write(LERR,*)' '
                  write(LERR,*)'Unable to allocate workspace:'
                  write(LERR,*) itemi,'  bytes'
                  write(LER ,*)' '
                  write(LER ,*)'Unable to allocate workspace:'
                  write(LER ,*) itemi,'  bytes'
               else
                  write(LERR,*)' '
                  write(LERR,*)'Allocating workspace:'
                  write(LERR,*) itemi,'  bytes'
               endif

            else

c defaults for irsa, irea, nsa, nea

               if ( irsa .eq. 0 ) irsa = 1
               if ( irea .eq. 0 ) irea = nrec(1)
               if ( nsa .eq. 0 ) nsa = 1
               if ( nea .eq. 0 ) nea = ntrc(1)
c               if ( nse .eq. 0 ) nea = ntrc(1)

               write(LERR,*)'multiplex output'
               do  63  i = 1, nu
                  ntrcc = ntrcc + ntrc(i)
 63            continue
               call savew( itr, 'RATTrc',  nu , LINHED)
               call savew( itr, 'RATFld',  0  , LINHED)
               heap = .true.
               itemi =  SZSMPD
               call galloc (wktri, itemi, ierr, iabort)
               
            endif

c-------------------
c  separate blocks back-to-back

         elseif (nblk) then

            write(LERR,*)'blocks back to back'
            ntrcc = ntrm
            nrout = 0
            do  91  i = 1, nu
               nrout = nrout + nrec(i)
 91         continue
            call savew( itr, 'RATTrc',  nu , LINHED)
            call savew( itr, 'RATFld',  1  , LINHED)
            
            call saver( itr, 'ReSpFm', nrl , LINHED)
            if (nroll .eq. 0) then
c     if (nrl .eq. 0) then
c     nroll = 1
c     else
c     nroll = nrl
c     endif
               nroll = 1
            endif

c-------------------
c  input blocks put into 1 super block

         elseif (oneblk) then

            write(LERR,*)'super block'
            ntrcc = 0
            do  14  iu = 1, nu
               ntrcc = ntrcc + ntrc(iu)
 14         continue
            call savew( itr, 'RATTrc',  nu , LINHED)
            call savew( itr, 'RATFld',  2  , LINHED)
            nroll = 1

c-------------------
c  output data sets one after the other

         elseif (wye) then

            write(LERR,*)'wye'

            if (select) then

               write(LERR,*)'Record/Trace select option:'
               nrout = 0
               do  i = 1, nu
                  if (small) then
                     call sislgbuf (luin(i), 'off' )
                  endif
                  if (ns(i)  .le. 0) ns(i)  = 1
                  if (ns(i)  .gt. ntrc(i)) ns(i)  = ntrc(i)
                  if (ne(i)  .eq. 0) ne(i)  = ntrc(i)
                  if (ne(i)  .gt. ntrc(i)) ne(i)  = ntrc(i)
                  if (irs(i) .le. 0) irs(i) = 1
                  if (irs(i) .gt. nrec(i)) irs(i)  = nrec(i)
                  if (ire(i) .eq. 0) ire(i) = nrec(i)
                  if (ire(i) .gt. nrec(i)) ire(i)  = nrec(i)
                  ntr = iabs (ne(i) - ns(i)) + 1
                  if(iabs(tdel(i)) .gt. 1) then
                     ntrd = nint(float(ntr)/float(iabs(tdel(i)))+.49)
                  else
                     ntrd = ntr
                  endif
                  if (i .gt. 1) then
                     if (ns(i) .ne. ns(1)) then
                        write(LERR,*)'GATHER:'
                        write(LERR,*)' For -Y option using trc '
                        write(LERR,*)' selection you must have the same'
                        write(LERR,*)' -ns for  each input data set.'
                        write(LERR,*)'FATAL'
                        write(LER,*)' '
                        write(LER,*)'GATHER:'
                        write(LER,*)' For -Y option using trc '
                        write(LER,*)' selection you must have the same '
                        write(LER,*)' -ns for  each input data set.'
                        write(LER,*)'FATAL'
                        write(LER,*)' '
                        stop 666
                     endif
                  endif

                  if (i .gt. 1) then
                     if (ne(i) .ne. ne(1)) then
                        write(LERR,*)'GATHER:'
                        write(LERR,*)' For -Y option using trc '
                        write(LERR,*)' selection you must have the same'
                        write(LERR,*)'  -ne for each input data set.'
                        write(LERR,*)'FATAL'
                        write(LER,*)' '
                        write(LER,*)'GATHER:'
                        write(LER,*)' For -Y option using trc selection'
                        write(LER,*)' you must have the same -ne for '
                        write(LER,*)' each input data set.'
                        write(LER,*)'FATAL'
                        write(LER,*)' '
                        stop 666
                     endif
                  endif

                  if (i .gt. 1) then
                     if (tdel(i) .ne. tdel(1)) then
                        write(LERR,*)'GATHER:'
                        write(LERR,*)' For -Y option using trc '
                        write(LERR,*)' selection you must have the same'
                        write(LERR,*)' -T0 for each inputdata set.'
                        write(LERR,*)'FATAL'
                        write(LER,*)' '
                        write(LER,*)'GATHER:'
                        write(LER,*)' For -Y option using trc '
                        write(LER,*)' selection you must have the same'
                        write(LER,*)' -T0 for each inputdata set.'
                        write(LER,*)'FATAL'
                        write(LER,*)' '
                        stop 666
                     endif
                  endif

                  ntrcc = ntrd
                  nrc = iabs (ire(i) - irs(i)) + 1

                  if(iabs(rdel(i)) .gt. 1) then
                     nrcd  = nint(float(nrc)/float(iabs(rdel(i)))+.49)
                     nrout = nrout + nrcd
                  else
                     nrout = nrout + nrc
                  endif

                  if (i .eq. 1) then
                     if (irs(i) .ne. irs(1)) then
                        write(LERR,*)'GATHER:'
                        write(LERR,*)' For -Y option using trc '
                        write(LERR,*)' selection you must have the same'
                        write(LERR,*)'  -rs for each input data set.'
                        write(LERR,*)'FATAL'
                        write(LER,*)' '
                        write(LER,*)'GATHER:'
                        write(LER,*)' For -Y option using trc '
                        write(LER,*)' selection you must have the same'
                        write(LER,*)'  -rs for each input data set.'
                        write(LER,*)'FATAL'
                        write(LER,*)' '
                        stop 666
                     endif
                  endif

                  if (i .eq. 1) then
                     if (ire(i) .ne. ire(1)) then
                        write(LERR,*)'GATHER:'
                        write(LERR,*)' For -Y option using trc '
                        write(LERR,*)' selection you must have the same'
                        write(LERR,*)'  -re for each input data set.'
                        write(LERR,*)'FATAL'
                        write(LER,*)' '
                        write(LER,*)'GATHER:'
                        write(LER,*)' For -Y option using trc '
                        write(LER,*)' selection you must have the same'
                        write(LER,*)'  -re for each input data set.'
                        write(LER,*)'FATAL'
                        write(LER,*)' '
                        stop 666
                     endif
                  endif

                  if (i .gt. 1) then
                     if (rdel(i) .ne. rdel(1)) then
                        write(LERR,*)'GATHER:'
                        write(LERR,*)' For -Y option using trc '
                        write(LERR,*)' selection you must have the same'
                        write(LERR,*)' -R0 for each inputdata set.'
                        write(LERR,*)'FATAL'
                        write(LER,*)' '
                        write(LER,*)'GATHER:'
                        write(LER,*)' For -Y option using trc '
                        write(LER,*)' selection you must have the same'
                        write(LER,*)' -R0 for each inputdata set.'
                        write(LER,*)'FATAL'
                        write(LER,*)' '
                        stop 666
                     endif
                  endif

                  write(LERR,*)'ns, ne, tdel= ',ns(i), ne(i), tdel(i)
                  write(LERR,*)'irs, ire, rdel= ',irs(i), ire(i), 
     :                 rdel(i)
                  write(LERR,*)'ntr, ntrd= ',ntr, ntrd
                  write(LERR,*)'nrc, nrcd, nrout= ',nrc, nrcd, nrout
               enddo
               nrout = nrout * ntrcc
               ntrcc = nu

            else

               ir = 0
               do  19  i = 1, nu
                  ir = ir + nrec(i)
 19            continue
               nrout = nrec(1) * ntrc(1)
               ntrcc = nu

            endif

         elseif (back) then

            write(LERR,*)'back'
            if (select) then

               write(LERR,*)'Record/Trace select option:'
               nrout = 0
               do  i = 1, nu
                  if (small) then
                     call sislgbuf (luin(i), 'off' )
                  endif
                  if (ns(i)  .le. 0) ns(i)  = 1
                  if (ns(i)  .gt. ntrc(i)) ns(i)  = ntrc(i)
                  if (ne(i)  .eq. 0) ne(i)  = ntrc(i)
                  if (ne(i)  .gt. ntrc(i)) ne(i)  = ntrc(i)
                  if (irs(i) .le. 0) irs(i) = 1
                  if (irs(i) .gt. nrec(i)) irs(i)  = nrec(i)
                  if (ire(i) .eq. 0) ire(i)  = nrec(i)
                  if (ire(i) .gt. nrec(i)) ire(i)  = nrec(i)
                  ntr = iabs (ne(i) - ns(i)) + 1
                  if(iabs(tdel(i)) .gt. 1) then
                     ntrd  = nint(float(ntr)/float(iabs(tdel(i)))+.49)
                     ntrcc = max (ntrd, ntrcc)
                  else
                     ntrcc = max (ntr, ntrcc)
                  endif
                  nrc = iabs (ire(i) - irs(i)) + 1
                  if(iabs(rdel(i)) .gt. 1) then
                     nrcd  = nint(float(nrc)/float(iabs(rdel(i)))+.49)
                     nrout = nrout + nrcd
                  else
                     nrout = nrout + nrc
                  endif
                  write(LERR,*)'ns, ne, tdel= ',ns(i), ne(i), tdel(i)
                  write(LERR,*)'irs, ire, rdel= ',irs(i), ire(i), 
     :                 rdel(i)
                  write(LERR,*)'ntr, ntrd= ',ntr, ntrd
                  write(LERR,*)'nrc, nrcd, nrout= ',nrc, nrcd, nrout
               enddo

            else

               ir = 0
               do  i = 1, nu
                  ir = ir + nrec(i)
               enddo

c often the line header of the input datasets is lying about the number of records and
c often times the number of traces per record is not the same for all datasets being
c gathered.  In this case we want to read far more data than predicted using the NumTrc
c of the first dataset.  If the user wants to believe the input then he/she can flag
c the command line with -believe otherwise set the NumRec to 2000000000 and let the
c routine read off the end of the dataset.  In this case the number of records actually
c output is recorded in the prinout file and printed to stderr.

               if ( believe ) then
                  nrout = ir
                  write(LERR,*)' '
                  write(LERR,*)' NumRec on output set to ', nrout
                  write(LER,*)' '
                  write(LER,*)'GATHER:'
                  write(LER,*)' NumRec on output set to ', nrout
                  write(LER,*)' NumTrc on output set to ', ntrc(1)
                  write(LER,*)' '
               else
                  nrout = 2000000000
               endif

               ntrcc = ntrc(1)

               if ( believe ) then
                  do i = 2, nu
                     if ( ntrc(i) .ne. ntrc(1) ) then
                        write(LERR,*)' '
                        write(LERR,*)' NumTrc on dataset ',i,' not'
                        write(LERR,*)' equal to NumTrc on dataset 1'
                        write(LERR,*)' output may be messed up'
                        write(LERR,*)'WARNING '
                        write(LER,*)' '
                        write(LER,*)'GATHER:'
                        write(LER,*)' NumTrc on dataset ',i,' not'
                        write(LER,*)' equal to NumTrc on dataset 1'
                        write(LER,*)' output may be messed up'
                        write(LER,*)'WARNING'
                        write(LER,*)' '
                     endif
                  enddo
               endif

            endif

         elseif (backh) then

            write(LERR,*)'backh'
            if (select) then

               write(LERR,*)'Record/Trace select option:'
               do  i = 1, nu
                  if (small) then
                     call sislgbuf (luin(i), 'off' )
                  endif
                  if (ns(i)  .le. 0) ns(i)  = 1
                  if (ns(i)  .gt. ntrc(i)) ns(i)  = ntrc(i)
                  if (ne(i)  .eq. 0) ne(i)  = ntrc(i)
                  if (ne(i)  .gt. ntrc(i)) ne(i)  = ntrc(i)
                  if (irs(i) .le. 0) irs(i) = 1
                  if (irs(i) .gt. nrec(i)) irs(i)  = nrec(i)
                  if (ire(i) .eq. 0) ire(i) = nrec(i)
                  if (ire(i) .gt. nrec(i)) ire(i)  = nrec(i)
                  ntr = iabs (ne(i) - ns(i)) + 1
                  if(iabs(tdel(i)) .gt. 1) then
                     ntrd  = nint(float(ntr)/float(iabs(tdel(i)))+.49)
                     ntrcc = max (ntrd, ntrcc)
                  else
                     ntrcc = max (ntr, ntrcc)
                  endif
                  nrc = iabs (ire(i) - irs(i)) + 1
                  if(iabs(rdel(i)) .gt. 1) then
                     nrcd  = nint(float(nrc)/float(iabs(rdel(i)))+.49)
                     nrout = nrout + nrcd
                  else
                     nrout = nrout + nrc
                  endif
                  write(LERR,*)'ns, ne, tdel= ',ns(i), ne(i), tdel(i)
                  write(LERR,*)'irs, ire, rdel= ',irs(i), ire(i),rdel(i)
                  write(LERR,*)'ntr, ntrd= ',ntr, ntrd
                  write(LERR,*)'nrc, nrcd, nrout= ',nrc, nrcd, nrout
               enddo

            else
               
               nrout = 2000000000
               ntrcc = ntrc (1)

            endif
            
         endif
c**************************************************************
     
         if(nsamp .gt. 5*SZLNHD) nsamp=5*SZLNHD
         if (.not. trace) nsampo = nsamp

         if (orig) then
            call savew( itr, 'NumTrc', orntrc(1) , LINHED)
            call savew( itr, 'NumRec', ornrec(1) , LINHED)
            call savew( itr, 'TmMsFS', TmMsFS , LINHED)
         else
            call savew( itr, 'NumTrc', ntrcc , LINHED)
            call savew( itr, 'NumRec', nrout , LINHED)
            call savew( itr, 'NumSmp', nsampo, LINHED)
            call savew( itr, 'TmMsFS', TmMsFS , LINHED)
         endif
         obytes = SZTRHD + SZSMPD * nsampo
 
C**********************************************************************C
C     write to printout file
C**********************************************************************C
         write(LERR,*)' '
c     if( verbos ) then
         write(LERR,*)
         write(LERR,*)' Values read from input data set line header'
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp
         write(LERR,*) ' Sample Interval    =  ', nsi  
         do 17 i=1,nu
            write(LERR,*) ' Traces per Record = ', ntrc(i),' NTAP= ',
     1           ntap(i),'   Records= ',nrec(i)
            write(LERR,*) ' Orig Traces per Record = ', orntrc(i),
     1           ' NTAP= ',ntap(i),'   Orig Records= ',ornrec(i)
 17      continue

         if(mpx) write(LERR,*)' Multiplex option: ntuples created'
         if(trace) write(LERR,*)' Trace option: long trcs built'
         if(nblk) then
            write(LERR,*)' Input blocks placed back-to-back'
            write(LERR,*)' nroll = ',nroll
         endif
         if(oneblk)write(LERR,*)' Input blocks placed in 1 super block'
         if(wye)write(LERR,*)' Output data sets one after the other'
         if(wye)write(LERR,*)' trace by trace'
         if(back) then
            write(LERR,*)' Output data sets one after the other'
            write(LERR,*)' all of DSN1 followed by all of DSN2...'
         endif
         if (backh) then
            write(LERR,*)' Output data sets one after the other'
            write(LERR,*)' all of DSN1 followed by all of DSN2...'
            write(LERR,*)' Only DSN1 has a line header'
         endif
         write(LERR,*)' New traces/record = ',ntrcc,' OTAP= ',otap
         write(LERR,*)' New samples/trace= ',nsampo
         write(LERR,*)' Output Records per Line   =  ', nrout 
         write(LERR,*)' Output Traces per Rec     =  ', ntrcc
         write(LERR,*)' Format of Data     =  ', iform
c     endif
         write(LERR,*)' '

C**********************************************************************C
C     write to printout file
C**********************************************************************C
         call savhlh ( itr, lbytes, lbyout )
         call wrtape ( luout, itr, lbyout )

C**********************************************************************C
C     READ TRACES,  WRITE TO OUTPUT FILE
C**********************************************************************C

         itotrec = 0
c--------------------------------------------------------------
c      IF mpx (multiplex) is true  read data sets
c--------------------------------------------------------------
         if(mpx) then
            
            if (trace) then

               DO  JJ = 1, nrr
                  DO  KK = 1, ntrm
                     ist = 0
                     call vclr (tri, 1, nsampo)
                     do  iu = 1, nu

                        call rtape  ( luin(iu), itr, nbytes )
                        if(nbytes .eq. 0) then
                           write(LERR,*)'End of file on input:'
                           write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                          ' DSN= ',ntap(iu)
                           go to 999
                        endif
                        if (iu .gt. 1) then
                           ist = ist + nsm (iu-1)
                        endif
                        call vmov (lhed(ITHWP1), 1, tri(ist+1), 1, 
     :                       nsm(iu) )
                        if(verbos) then
                           irec = itr(l_RecNum)
                           itrc = itr(l_TrcNum)
                           write(LERR,*)'LUIN= ',luin(iu),' Rec= ',irec,
     :                          ' Trace= ', itrc
                        endif
                     enddo
                     call vmov (tri, 1, lhed(ITHWP1), 1, nsampo)
                     call wrtape (luout, itr, obytes)
                  ENDDO
               ENDDO


            else

c advance all datasets to start record [can only do this if not robot]
c all datasets have the same number of record and traces

               if ( .not. robot .AND. select ) then
                  do LL = 1, nu
                     call recskp (1, irsa-1, luin(LL),ntrc(LL),itr) 
                  enddo 
               endif  
            
               DO 100 JJ = irsa, irea

c advance all datasets to the correct start trace

                  if ( .not. robot .AND. select ) then
                     do LL = 1, nu
                        call trcskp (JJ, 1, nsa-1,luin(LL),ntrc(LL),itr) 
                     enddo 
                  endif

                  DO 99 KK = nsa, nea
                     do 55 iu = 1, nu
                        nbytes = 0
                        CALL RTAPE  ( LUIN(iu) , ITR, NBYTES  )
                        if(nbytes .eq. 0) then
                           write(LERR,*)'End of file on input:'
                           write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                          ' DSN= ',ntap(iu)
                           go to 999
                        endif
                        if(verbos) then
                           irec = itr(l_RecNum)
                           itrc = itr(l_TrcNum)
                           write(LERR,*)'LUIN= ',luin(iu),' Rec= ',irec,
     :                          ' Trace= ', itrc
                        endif
c--------------------------------------------------------------
c               put ntuple # in header & write to output
c--------------------------------------------------------------
c            call savew( itr, 'SGRNum', iu   , TRCHED)

                        call wrtape(luout,itr,obytes)

 
 55                  continue
 99               continue

c skip to end of current record if required

                  if ( .not. robot .AND. select ) then
                     do LL = 1, nu
                        call trcskp(JJ,KK+1,ntrc(LL),luin(LL),ntrc(LL),
     :                       itr)
                     enddo
                  endif
                  
 100           continue
               
            endif
c--------------------------------------------------------------
c     ELSE IF nblk or oneblk are true  read data sets
c--------------------------------------------------------------
         elseif(nblk .or. oneblk) then

            DO 299 JJ = 1, NRR
               
               do 155 iu = 1, nu
                  
                  ntrace = ntrc(iu)

                  DO     LL = 1, nroll
                     DO 199 KK = 1, ntrace
                        nbytes = 0
                        CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )
                        
                        if(nbytes .eq. 0) then
                           write(LERR,*)'End of file on input:'
                           write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                          ' DSN= ',ntap(iu)
                           go to 999
                        endif
c-------------------------------------------------------------
c            adjust headers
c-------------------------------------------------------------
c            call savew( itr, 'SGRNum', 1    , TRCHED)

                        if(nblk) then
                           irec = nu * (jj-1) + iu
                        endif

                        if(oneblk) then
                           irec = jj
                        endif

                        call wrtape(luout,itr,obytes)

                        if(verbos) then
                           call saver2(lhed, ifmt_TrcNum,l_TrcNum,
     :                          ln_TrcNum, itrc,
     1                          TRACEHEADER)
                           write(LERR,*)'LUIN= ',luin(iu),' Trace= ',
     :                          itrc,' LUOUT= ', luout
                        endif
                        
 199                 CONTINUE
                  ENDDO
 155           continue
 299        continue
c--------------------------------------------------------------
c     ELSE IF nblk or oneblk are true  read data sets
c--------------------------------------------------------------
         elseif(wye) then

            ir = 0

            if (select) then

               do  iu = 1, nu
                  call recskp (1, irs(iu)-1, luin(iu),ntrc(iu),itr)
               enddo

               DO 395 JJ = irsa, irea, rdela
 
c-------------------------------
c  skip to desired trace on each unit
c-------------------------------
                  do  iu = 1, nu
                     call trcskp(jj,1,ns(iu)-1,luin(iu),ntrc(iu),itr)
                  enddo

                  ir = ir + 1
                  it = 0
                  DO 394 KK = nsa, nea, tdela
 
                     it = it + 1
                     do 396 iu = 1, nu
                        nbytes = 0
                        CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )
                        if(nbytes .eq. 0) then
                           write(LERR,*)'End of file on input:'
                           write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                          ' DSN unit= ',iu,luin(iu)
                           go to 999
                        endif
 
                        call wrtape(luout,itr,obytes)
 
                        if(verbos) then
                           call saver2(lhed, ifmt_TrcNum,l_TrcNum,
     :                          ln_TrcNum, itrc, TRACEHEADER)
                           call saver2(lhed, ifmt_RecNum,l_RecNum,
     :                          ln_RecNum, irec, TRACEHEADER)
                           write(LERR,*)'LUIN= ',iu,luin(iu),' Trace= ',
     :                          itrc,' Record= ',irec,' LUOUT= ',luout,
     :                          ' written as rec= ',ir,' trc= ',it
                        endif

c------------------------------------
c  skip every tdel-1 traces
c------------------------------------
                        if (tdel(iu) .gt. 0) then
                           ks = kk
                           ke = kk + tdel(iu) - 1
                           if (ke .gt. ne(iu)) ke = ne(iu)
                           call trcskp(jj,ks+1,ke,luin(iu),ntrc(iu),itr)
                        else
                           ks = kk
                           ke = kk + tdel(iu) - 1
                           if (ke .lt. 0) ke = 0
                           call trcskp(jj,ks-1,ke,luin(iu),ntrc(iu),itr)
                        endif

 
 396                 continue
 
 
 394              CONTINUE

                  do  iu = 1, nu
c--------------------------------------------------
c  skip to the end of current record: trace # ntrc
c--------------------------------------------------
                     call trcskp(jj,ke+1,ntrc(iu),luin(iu),ntrc(iu),itr)
 
c------------------------------------
c  skip every rdel-1 records
c------------------------------------
                     if (rdel(iu) .gt. 0) then
                        call recskp(jj+1,jj+rdel(iu)-1,luin,ntrc,itr)
                     else
                        call recskp(jj+1,jj+rdel(iu),  luin,ntrc,itr)
                     endif

                  enddo

 395           CONTINUE

            else
       
               DO 398 JJ = 1, nrr
                  
                  ir = ir + 1
                  it = 0
                  DO 397 KK = 1, ntrm
                     
                     it = it + 1
                     do 399 iu = 1, nu
                        nbytes = 0
                        CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )
                        if(nbytes .eq. 0) then
                           write(LERR,*)'End of file on input:'
                           write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                          ' DSN unit= ',iu,luin(iu)
                           go to 999
                        endif

                        call wrtape(luout,itr,obytes)

                        if(verbos) then
                           call saver2(lhed, ifmt_TrcNum,l_TrcNum,
     :                          ln_TrcNum, itrc, TRACEHEADER)
                           call saver2(lhed, ifmt_RecNum,l_RecNum,
     :                          ln_RecNum, irec, TRACEHEADER)
                           write(LERR,*)'LUIN= ',iu,luin(iu),' Trace= ',
     :                          itrc, ' Record= ',irec,' LUOUT= ',luout,
     2                          ' written as rec= ',ir,' trc= ',it
                        endif

 399                 continue

 397              CONTINUE
 398           CONTINUE

            endif
c-------------------------------------------------------------
c     all data set1, all data set2, ...
c-------------------------------------------------------------
         elseif(back) then
       
            if (select) then

               DO 491 iu = 1, nu
 
                  call recskp (1, irs(iu)-1, luin(iu),ntrc(iu),itr)

                  DO 492 JJ = irs(iu), ire(iu), rdel(iu)

c-------------------------------
c  skip to desired trace
c-------------------------------
                     call trcskp(jj,1,ns(iu)-1,luin(iu),ntrc(iu),itr)

                     do 493 KK = ns(iu), ne(iu), tdel(iu)

                        nbytes = 0
                        CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )
                        if(nbytes .eq. 0) then
                           write(LERR,*)'End of file on input:'
                           write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                          ' DSN unit= ',iu,luin(iu)
                           if (iu .eq. nu) then
                              go to 999
                           else
                              go to 494
                           endif
                        endif
                        
                        call wrtape(luout,itr,obytes)
    
                        if(verbos) then
                           write(LERR,*)'LUIN= ',iu,luin(iu),' Trace= ',
     1                          KK, ' Record= ',JJ,' LUOUT= ',luout
                        endif
c------------------------------------
c  skip every tdel-1 traces
c------------------------------------
                        if (tdel(iu) .gt. 0) then
                           ks = kk
                           ke = kk + tdel(iu) - 1
                           if (ke .gt. ne(iu)) ke = ne(iu)
                           call trcskp(jj,ks+1,ke,luin(iu),ntrc(iu),itr)
                        else
                           ks = kk
                           ke = kk + tdel(iu) - 1
                           if (ke .lt. 0) ke = 0
                           call trcskp(jj,ks-1,ke,luin(iu),ntrc(iu),itr)
                        endif

 493                 continue
c--------------------------------------------------
c  skip to the end of current record: trace # ntrc
c--------------------------------------------------
                     call trcskp(jj,ke+1,ntrc(iu),luin(iu),ntrc(iu),itr)
 
c------------------------------------
c  skip every rdel-1 records
c------------------------------------
                     if (rdel(iu) .gt. 0) then
                        call recskp(jj+1,jj+rdel(iu)-1,luin,ntrc,itr)
                     else
                        call recskp(jj+1,jj+rdel(iu),  luin,ntrc,itr)
                     endif
                     
 492              CONTINUE
 494              CONTINUE
                  write(LERR,*)'gather: closing unit ',iu
                  write(LER ,*)'gather: closing unit ',iu
                  call lbclos(luin(iu))
 491           CONTINUE

            else

               totrec = .true.
               
               DO 495 iu = 1, nu
                  
                  if (believe) then
                     nreciu = nrec(iu)
                  else
                     nreciu = 2000000000
                  endif

                  DO JJ = 1, nreciu

                     do 497 KK = 1, ntrcc
                        nbytes = 0
                        CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )
                        if(nbytes .eq. 0 .AND. .not.believe) then
                           write(LERR,*)'End of file on input:'
                           write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                          ' DSN unit= ',iu,luin(iu)
                           if (iu .eq. nu) then
                              write(LERR,*)'gather: closing unit ',iu
                              write(LER ,*)'gather: closing unit ',iu
                              call lbclos(luin(iu))
                              go to 999
                           else
                              go to 498
                           endif
                        elseif(nbytes .eq. 0 .AND. believe) then
                           write(LERR,*)'FATAL End of file on input:'
                           write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                          ' DSN unit= ',iu,luin(iu)
                           write(LER ,*)'FATAL End of file on input:'
                           write(LER ,*)'  rec= ',jj,'  trace= ',kk,
     1                          ' DSN unit= ',iu,luin(iu)
                           go to 999
                        endif

                        call wrtape(luout,itr,obytes)

                        if(verbos) then
                           write(LERR,*)'LUIN= ',iu,luin(iu),' Trace= ',
     1                          KK, ' Record= ',JJ,' LUOUT= ',luout
                        endif
 497                 continue

                     itotrec = itotrec + 1

                  ENDDO
 498              CONTINUE
                  write(LERR,*)'gather: closing unit ',iu
                  write(LER ,*)'gather: closing unit ',iu
                  call lbclos(luin(iu))
 495           CONTINUE

            endif

c-------------------------------------------------------------
c     all data set1, all data set2, ...: only DSN1 has line header
c-------------------------------------------------------------
         elseif(backh) then

            if (select) then

               do  iu = 1, nu
                  call recskp (1, irs(iu)-1, luin(iu),ntrc(iu),itr)
               enddo

               iu = 1
               DO 594 JJ = irs(iu), ire(iu), rdel(iu)
 
 595              continue
c-------------------------------
c  skip to desired trace
c-------------------------------
                  call trcskp(jj,1,ns(iu),luin(iu),ntrc(iu),itr)
                  
                  do 596 KK = ns(iu), ne(iu), tdel(iu)
 
                     nbytes = 0
                     CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )
                     if(nbytes .eq. 0) then
                        write(LERR,*)'End of file on input:'
                        write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                       ' DSN unit= ',iu,luin(iu)
                        if (iu .eq. nu) go to 999
                        iu = iu + 1
                        write(LERR,*)'gather: closing unit ',iu
                        write(LER ,*)'gather: closing unit ',iu
                        call lbclos(luin(iu))
                        go to 595
                     endif
                     
                     call wrtape(luout,itr,obytes)
                     
                     if(verbos) then
                        write(LERR,*)'LUIN= ',iu,luin(iu),' Trace= ',KK,
     1                       ' Record= ',JJ,' LUOUT= ',luout
                     endif
c------------------------------------
c  skip every tdel-1 traces
c------------------------------------
                     if (tdel(iu) .gt. 0) then
                        ks = kk
                        ke = kk + tdel(iu) - 1
                        if (ke .gt. ne(iu)) ke = ne(iu)
                        call trcskp(jj,ks+1,ke,luin(iu),ntrc(1),itr)
                     else
                        ks = kk
                        ke = kk + tdel(iu) - 1
                        if (ke .lt. 0) ke = 0
                        call trcskp(jj,ks-1,ke,luin(iu),ntrc(1),itr)
                     endif
 
 596              continue
c--------------------------------------------------
c  skip to the end of current record: trace # ntrc
c--------------------------------------------------
                  call trcskp(jj,ke+1,ntrc(1),luin(iu),ntrc(1),itr)
 
c------------------------------------
c  skip every rdel-1 records
c------------------------------------
                  if (rdel(iu) .gt. 0) then
                     call recskp(jj+1,jj+rdel(iu)-1,luin(iu),ntrc(1),
     :                    itr)
                  else
                     call recskp(jj+1,jj+rdel(iu),  luin(iu),ntrc(1),
     :                    itr)
                  endif
 
 594           CONTINUE

            else

               totrec = .true.
               iu = 1

               if (believe) then
                   nreciu = nrec(iu)
               else
                   nreciu = 2000000000
               endif

               DO JJ = 1, nreciu
 
 598              continue
                  do 599 KK = 1, ntrcc

                     nbytes = 0
                     CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )
                     if(nbytes .eq. 0 .AND. .not.believe) then
                        write(LERR,*)'End of file on input:'
                        write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                       ' DSN unit= ',iu,luin(iu)
                        if (iu .eq. nu) then
                           write(LERR,*)'gather: closing unit ',iu
                           write(LER ,*)'gather: closing unit ',iu
                           call lbclos(luin(i))
                           go to 999
                        endif
                        iu = iu + 1
                        write(LERR,*)'gather: closing unit ',iu
                        write(LER ,*)'gather: closing unit ',iu
                        call lbclos(luin(iu))
                        go to 598
                     elseif(nbytes .eq. 0 .AND. believe) then
                        write(LERR,*)'FATAL End of file on input:'
                        write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                       ' DSN unit= ',iu,luin(iu)
                        write(LER ,*)'FATAL End of file on input:'
                        write(LER ,*)'  rec= ',jj,'  trace= ',kk,
     1                       ' DSN unit= ',iu,luin(iu)
                        go to 999
                     endif
                     
                     call wrtape(luout,itr,obytes)
                     
                     if(verbos) then
                        write(LERR,*)'LUIN= ',iu,luin(iu),' Trace= ',KK,
     1                       ' Record= ',JJ,' LUOUT= ',luout
                     endif
                     
 599              continue
                  itotrec = itotrec + 1
 
 597           ENDDO

            endif

c-------------------------------------------------------------
c     end of mpx/nblk/oneblk/wye/back if
c-------------------------------------------------------------
         endif

 999     continue

c-------------------------------------------------------------
c     close all open units for non -S or -s options
c-------------------------------------------------------------
         if (.not. backh .AND. .not. back) then
            do  i = 1, nu
               if(verbos)write(LERR,*)'Closing unit ',i
               call lbclos(luin(i))
            enddo
         endif

         call lbclos(luout)
         if(verbos)write(LERR,*)'Closing output unit '

c-------------------------------------------------------------
c     D2 ROBOT OPTION
c-------------------------------------------------------------
      ELSE

c-------------------------------------------------------------
c     all data set1, all data set2, ...
c-------------------------------------------------------------
         if (select) then
 
            DO 691 iu = 1, nu
 
               call getln(luin(iu),ntap(iu),'r',0)
               if(luin(iu) .eq. 0) then
                  write(LERR,*)'Data set cannot be a pipe'
                  write(LERR,*)'check command line args & rerun'
                  stop
               endif
               
               lbytes=0
               CALL RTAPE  ( LUIN(iu), ITR, LBYTES )
               if(lbytes .eq. 0) then
                  write(LERR,*)'GATHER: no header read on unit ',
     :                 luin(iu)
                  write(LERR,*)'FATAL'
                  stop
               endif
 
               call saver(itr, 'NumTrc', ntrc(iu)  ,  LINHED)
               call saver(itr, 'NumRec', nrec(iu)  ,  LINHED)
               call saver(itr, 'OrNTRC', orntrc(iu),  LINHED)
               call saver(itr, 'OrNREC', ornrec(iu),  LINHED)
               call saver(itr, 'SmpInt', nsi,         LINHED)
               if (iu .eq. 1) then
                  nsi1 = nsi
                  call saver(itr, 'NumSmp', nsamp     ,  LINHED)
                  call saver(itr, 'Format', iform     ,  LINHED)
                  call savew(itr, 'NumRec', 2000000000,  LINHED)
                  obytes = SZTRHD + SZSMPD * nsamp
                  call getln  (luout, otap, 'w', 1)
                  call savhlh (itr,lbytes,lbyout)
                  call wrtape (itr, itr, lbyout)
               else
                  if (nsi .ne. nsi1) then
                     write(LER,*)'GATHER: sample intervals differ',
     :                    ' among datasets'
                     write(LER,*)'FATAL'
                     write(LERR,*)'GATHER: sample intervals differ',
     :                    ' among datasets'
                     write(LERR,*)'FATAL'
                     stop 100
                  endif
               endif
               
               call recskp (1, irs(iu)-1, luin(iu),ntrc(iu),itr)
               
               DO 692 JJ = irs(iu), ire(iu), rdel(iu)
 
 
c-------------------------------
c  skip to desired trace
c-------------------------------
                  call trcskp(jj,1,ns(iu)-1,luin(iu),ntrc(iu),itr)
 
                  do 693 KK = ns(iu), ne(iu), tdel(iu)
 
                     nbytes = 0
                     CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )
                     if(nbytes .eq. 0) then
                        write(LERR,*)'End of file on input:'
                        write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                       ' DSN unit= ',iu,luin(iu)
                        if (iu .eq. nu) then
                           go to 9999
                        else
                           go to 694
                        endif
                     endif
                     
                     call wrtape(luout,itr,obytes)
                     
                     if(verbos) then
                        write(LERR,*)'LUIN= ',iu,luin(iu),' Trace= ',KK,
     1                       ' Record= ',JJ,' LUOUT= ',luout
                     endif
c------------------------------------
c  skip every tdel-1 traces
c------------------------------------
                     if (tdel(iu) .gt. 0) then
                        ks = kk
                        ke = kk + tdel(iu) - 1
                        if (ke .gt. ne(iu)) ke = ne(iu)
                        call trcskp(jj,ks+1,ke,luin(iu),ntrc(iu),itr)
                     else
                        ks = kk
                        ke = kk + tdel(iu) - 1
                        if (ke .lt. 0) ke = 0
                        call trcskp(jj,ks-1,ke,luin(iu),ntrc(iu),itr)
                     endif
 
 
 693              continue
c--------------------------------------------------
c  skip to the end of current record: trace # ntrc
c--------------------------------------------------
                  call trcskp(jj,ke+1,ntrc(iu),luin(iu),ntrc(iu),itr)
 
c------------------------------------
c  skip every rdel-1 records
c------------------------------------
                  if (rdel(iu) .gt. 0) then
                     call recskp(jj+1,jj+rdel(iu)-1,luin,ntrc,itr)
                  else
                     call recskp(jj+1,jj+rdel(iu),  luin,ntrc,itr)
                  endif
 
 692           CONTINUE
 694           CONTINUE
               write(LERR,*)'gather: closing unit ',iu
               write(LER ,*)'gather: closing unit ',iu
               call lbclos(luin(iu))
 691        CONTINUE
 
         else
 
            totrec = .true.
            
            DO 795 iu = 1, nu
 
               call getln(luin(iu),ntap(iu),'r',0)
               if(luin(iu) .eq. 0) then
                  write(LERR,*)'Data set cannot be a pipe'
                  write(LERR,*)'check command line args & rerun'
                  stop
               endif
               
               lbytes=0
               CALL RTAPE  ( LUIN(iu), ITR, LBYTES )
               if(lbytes .eq. 0) then
                  write(LERR,*)'GATHER: no header read on unit ',
     :                 luin(iu)
                  write(LERR,*)'FATAL'
                  stop
               endif
               
               call saver(itr, 'NumTrc', ntrc(iu)  ,  LINHED)
               call saver(itr, 'NumRec', nrec(iu)  ,  LINHED)
               call saver(itr, 'OrNTRC', orntrc(iu),  LINHED)
               call saver(itr, 'OrNREC', ornrec(iu),  LINHED)
               call saver(itr, 'SmpInt', nsi       ,  LINHED)
               if (iu .eq. 1) then
                  nsi1 = nsi
                  call saver(itr, 'NumSmp', nsamp     ,  LINHED)
                  call saver(itr, 'Format', iform     ,  LINHED)
                  call savew(itr, 'NumRec', 2000000000,  LINHED)
                  obytes = SZTRHD + SZSMPD * nsamp
                  call getln  (luout, otap, 'w', 1)
                  call savhlh (itr,lbytes,lbyout)
                  call wrtape (luout, itr, lbyout)
               else
                  if (nsi .ne. nsi1) then
                     write(LER,*)'GATHER: sample intervals differ',
     :                    ' among datasets'
                     write(LER,*)'FATAL'
                     write(LERR,*)'GATHER: sample intervals differ',
     :                    ' among datasets'
                     write(LERR,*)'FATAL'
                     stop 100
                  endif
               endif
               
               if (believe) then
                   nreciu = nrec(iu)
               else
                   nreciu = 2000000000
               endif

               DO JJ = 1, nreciu
                  
                  do 797 KK = 1, ntrc(iu)
                     nbytes = 0
                     CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )
                     if(nbytes .eq. 0 .AND. .not.believe) then
                        write(LERR,*)'End of file on input:'
                        write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                       ' DSN unit= ',iu,luin(iu)
                        if (iu .eq. nu) then
                           write(LERR,*)'gather: closing unit ',iu
                           write(LER ,*)'gather: closing unit ',iu
                           call lbclos(luin(iu))
                           go to 9999
                        else
                           go to 798
                        endif
                     elseif(nbytes .eq. 0 .AND. believe) then
                        write(LERR,*)'FATAL End of file on input:'
                        write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                          ' DSN unit= ',iu,luin(iu)
                        write(LER ,*)'FATAL End of file on input:'
                        write(LER ,*)'  rec= ',jj,'  trace= ',kk,
     1                          ' DSN unit= ',iu,luin(iu)
                        go to 9999
                     endif
 
                     call wrtape(luout,itr,obytes)
 
                     if(verbos) then
                        write(LERR,*)'LUIN= ',iu,luin(iu),' Trace= ',KK,
     1                       ' Record= ',JJ,' LUOUT= ',luout
                     endif
 797              continue
 
                  itotrec = itotrec + 1

               ENDDO
 798           CONTINUE
               write(LERR,*)'gather: closing unit ',iu
               write(LER ,*)'gather: closing unit ',iu
               call lbclos(luin(iu))
 795        CONTINUE
            
         endif
 
 9999    CONTINUE

         call lbclos (luout)

      ENDIF

c-----
c    END OF D2 ROBOT BLOCK
c-----

      if (totrec) then
         write(LERR,*)' '
         write(LERR,*)'***********************************'
         write(LERR,*)'Total number of input records read= ',itotrec
         write(LERR,*)'***********************************'
         write(LER ,*)' '
         write(LER ,*)'gather: -S, -s, -D2 options'
         write(LER ,*)'Total number of input records read= ',itotrec
         write(LER ,*)' '
      endif

      stop
      END

      subroutine help

      implicit none

#include <f77/iounit.h>
 
c----------------------------------------------------------------------
c       help panel
c----------------------------------------------------------------------
      write(LER,*)' '
      write(LER,*)'Command Line Arguments for gather: merge data sets'
      write(LER,*)' '
      write(LER,*)'Input....................................... (def)'
      write(LER,*)' '
      write(LER,*)'Direct cmd line input of file names...'
      write(LER,*)'-N[ntap]  -- input data set'
      write(LER,*)'-N[ntap]  -- input data set'
      write(LER,*)' ...           ...'
      write(LER,*)'-N[ntap]  -- input data set: max 2000 sets allowed'
      write(LER,*)'... or'
      write(LER,*)'-F[ftap]   -- file of input file names, one per lin
     1e (see man page)'
      write(LER,*)' '
      write(LER,*)'-O[otap]  -- output data set'
      write(LER,*)'-P[num]   -- maximum number of input pipes'
      write(LER,*)'-o        -- output data with original # trcs/rec'
      write(LER,*)'             & recs (all input data from splitr)'
      write(LER,*)'-V        -- verbos printout'
      write(LER,*)' '
      write(LER,*)'-m        -- multiplex input traces,else records '
      write(LER,*)'             go back-to-back'
      write(LER,*)'-T        -- gather trc from DSN1, trc from DSN2,'
      write(LER,*)'             ..., and form 1 long output trace'
      write(LER,*)'-b        -- separate records back-to-back (true)'
      write(LER,*)'-B        -- as above but single output record'
      write(LER,*)'             (mainly for option 3 in splitr)'
      write(LER,*)'-n[nrec]  -- for gathering records: # recs per'
      write(LER,*)'             block of input (def=1). See options'
      write(LER,*)'             1 & 2 for splitr'
      write(LER,*)'-Y        -- output data sets one after the other'
      write(LER,*)'             trace by trace'
      write(LER,*)' '
      write(LER,*)'-S        -- output data sets one after the other'
      write(LER,*)'             (all of DSN1 followed by DSN2, etc'
      write(LER,*)'-s        -- same as -S except all but the first'
      write(LER,*)'             data set have no line headers'
      write(LER,*)'-S or -s or -Y options:'
      write(LER,*)'-D2       -- input data on D2 tape robot'
      write(LER,*)'-e[iend]   -- end time                (last samp)'
      write(LER,*)'-ns[nst]   -- start trace number       (first tr)'
      write(LER,*)'-ne[ned]   -- end trace number          (last tr)'
      write(LER,*)'-T0[tdel]  -- do every tdel trace           ( 1 )'
      write(LER,*)'-rs[nrst]  -- start record            (first rec)'
      write(LER,*)'-re[nred]  -- end record               (last rec)'
      write(LER,*)'-R0[rdel]  -- do every rdel records         ( 1 )'
      write(LER,*)'-believe   -- honour input NumRec for all datasets'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'     gather [ -N[] -N[] ... -N[] ] [ -F[] ] -O[]'
      write(LER,*)'            [ -m -b -B -n[] -Y -T -believe '
      write(LER,*)'              -s -S -ns[] -ne[] -T0[] -rs[] -re[]'
      write(LER,*)'              -R0[] ] [ -D2 -o -P[] -V ]'
      write(LER,*)' '

      return
      end

      subroutine cmdln( ntap, otap, nu, nblk, oneblk, mpx, verbos, wye, 
     :     back, backh, orig, pmax, nroll, trace, ftap, lufil, robot,
     :     nsa, nea, irsa, irea, tdela, rdela, select,
     :     ns, ne, irs, ire, tdel, rdel, believe )

      implicit none

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer ns(*), ne(*), irs(*), ire(*), tdel(*), rdel(*)
      integer nu, argis, pmax, nsa, nea, irsa, irea, tdela, rdela
      integer nroll, lufil

      character*512  ntap(*), otap, ftap
      character*512  card

      logical nblk, oneblk, mpx, wye, back, backh, orig, trace
      logical select, robot, believe, verbos

c declare local variables

      integer  lenthr, i, ierr, j, lc, ifound

      real val

c initialize variables

      nu=0

c  get flags

      believe = ( argis('-believe') .gt. 0)
      oneblk = ( argis('-B') .gt. 0)
      nblk = ( argis('-b') .gt. 0)

      robot  = ( argis('-D2') .gt. 0)

      mpx = ( argis('-m') .gt. 0)

      orig = ( argis('-o') .gt. 0)

      back = ( argis('-S') .gt. 0)
      backh = ( argis('-s') .gt. 0)

      trace  = ( argis('-T') .gt. 0)

      wye = ( argis('-Y') .gt. 0)

      verbos = (argis('-V') .gt. 0)

      if ( .not. nblk .and. .not. oneblk .and. .not. mpx .and. .not. wye
     1     .and. .not. back .and. .not. backh .and. .not. trace ) then
         write(LERR,*)'One of the flags -b, -B, -m, -S, -s, -Y, -T'
         write(LERR,*)'must be set - rerun'
         write(LER ,*)' '
         write(LER ,*)'GATHER: '
         write(LER ,*)' One of the flags -b, -B, -m, -S, -s, -Y, -T'
         write(LER ,*)' must be set - rerun'
         write(LER ,*)'FATAL '
         write(LER ,*)' '
         stop
      endif

      if ( robot .and. .not. back ) then
         write(LERR,*)'For D2 robot option -S must be set'
      endif

      if (trace) mpx = .true.

c  get input data set names

      call argstr ( '-F', ftap, ' ', ' ' )
 
      IF (ftap(1:1) .eq. ' ') THEN
 
         nu=0
         do i = 1, 2000
            call argstr('-N',ntap(i),' ',' ')
            if(ntap(i) .eq. ' ') go to 1
            nu=nu+1
         enddo
 1       continue
         if(nu .eq. 0) then
            write(LERR,*)'Since no input files are explicitly'
            write(LERR,*)'named it is assumed GATHER is running'
            write(LERR,*)'inside the iconic processor - ikp'
         endif
         
         do  i = 1, nu
            ns (i)   = 0
            ne (i)   = 0
            tdel (i) = 1
            rdel (i) = 1
            irs (i)  = 0
            ire (i)  = 0
         enddo
 
      ELSE

         call alloclun (lufil)
         open (unit=lufil, file = ftap, status = 'old', iostat=ierr)
         if(ierr .ne. 0) then
            write(LERR,*)'FATAL ERROR in gather:'
            write(LERR,*)'Could not open file of input names ',ftap
            write(LER ,*)'FATAL ERROR in gather:'
            write(LER ,*)'Could not open file of input names ',ftap
            stop
         endif
         rewind lufil
         i = 1
         do while (1.eq.1)
            
            do  j = 1, 512
               card (j:j) = ' '
            enddo

            read (lufil,'(a512)',end=2,err=666) card
            lc = lenthr(card)
            ntap (i) = card (1:lc)
            
            if (back .OR. backh .OR. wye) then
               call parse ('-ns', card, val, ifound)
               if (ifound .eq. 0) val = 0.0
               write(LERR,*)'ns= ',val
               ns (i)   = val
               call parse ('-ne', card, val, ifound)
               if (ifound .eq. 0) val = 0.0
               write(LERR,*)'ne= ',val
               ne (i)   = val
               call parse ('-T0', card, val, ifound)
               if (ifound .eq. 0) val = 1.0
               write(LERR,*)'-T0= ',val
               tdel (i) = val
               if (tdel(i) .eq. 0) tdel(i) = 1
               call parse ('-rs', card, val, ifound)
               if (ifound .eq. 0) val = 0.0
               write(LERR,*)'-rs= ',val
               irs (i)  = val
               call parse ('-re', card, val, ifound)
               if (ifound .eq. 0) val = 0.0
               write(LERR,*)'-re= ',val
               ire (i)  = val
               call parse ('-R0', card, val, ifound)
               if (ifound .eq. 0) val = 1.0
               write(LERR,*)'-R0= ',val
               rdel (i) = val
               if (rdel(i) .eq. 0) rdel(i) = 1
            endif
            
            i = i + 1

         enddo
 2       continue
         nu = i - 1
         do  i = 1, nu
            if (ntap(i) .eq. ' ') then
               if (i .lt. nu) then
                  write(LERR,*)'FATAL ERROR in gather:'
                  write(LERR,*)'Cannot have blank input name (line '
     1                 ,i,' in file ',ftap,' )'
                  write(LER ,*)' '
                  write(LER ,*)'GATHER:'
                  write(LER ,*)' Cannot have blank input name (line '
     1                 ,i,' in file ',ftap,' )'
                  write(LER ,*)'FATAL '
                  write(LER ,*)' '
                  stop
               endif
               nu = nu - 1
               go to 3
            endif
         enddo
 3       continue

         if(nu .eq. 0) then
            write(LERR,*)'FATAL ERROR in gather:'
            write(LERR,*)'No input file names read in file ',ftap
            write(LER ,*)' '
            write(LER ,*)'GATHER:'
            write(LER ,*)' No input file names read in file ',ftap
            write(LER ,*)'FATAL '
            write(LER ,*)' '
            stop
         endif
 
      ENDIF


      call argi4 ('-ne', nea,  0, 0)
      call argi4 ('-ns', nsa,  0, 0)

      call argstr('-O', otap, ' ',' ')

      call argi4 ('-R0', rdela,  1, 1)
      call argi4 ('-re', irea, 0, 0)
      call argi4 ('-rs', irsa, 0, 0)

      call argi4 ('-T0', tdela,  1, 1)

      if (nsa .ne. 0) then
         do  i = 1, nu
            ns (i) = nsa
         enddo
      endif

      if (nea .ne. 0) then
         do  i = 1, nu
            ne (i) = nea
         enddo
      endif

      if (tdela .ne. 1) then
         do  i = 1, nu
            tdel (i) = tdela
         enddo
      endif

      if (irsa .ne. 0) then
         do  i = 1, nu
            irs (i) = irsa
         enddo
      endif

      if (irea .ne. 0) then
         do  i = 1, nu
            ire (i) = irea
         enddo
      endif

      if (rdela .ne. 1) then
         do  i = 1, nu
            rdel (i) = rdela
         enddo
      endif

      select = .false.

      do  i = 1, nu

         if (ns(i) .ne.0 .OR. ne(i) .ne.0 .OR. tdel(i).ne.1 .OR.
     1        irs(i).ne.0 .OR. ire(i).ne.0 .OR. rdel(i).ne.1 ) then

            select = .true.
         endif
      enddo

      call argi4('-P', pmax, 2000, 2000)
      call argi4 ('-n', nroll, 0, 0)


      if ((.not.back .AND. .not.backh .AND. .not.wye) .AND.
     1     select) then
         write(LERR,*)' '
         write(LERR,*)'WARNING in gather:'
         write(LERR,*)'Cannot use trace/record selection for other'
         write(LERR,*)'option -Y, -S or -s'
         write(LER ,*)' '
         write(LER ,*)'WARNING in gather:'
         write(LER ,*)'Cannot use trace/record selection for other'
         write(LER ,*)'option -Y, -S or -s'
         select = .false.
         do  i = 1, nu
            ns (i) = 0
            ne (i) = 0
            tdel (i) = 1
            irs (i) = 0
            ire (i) = 0
            rdel (i) = 1
         enddo
c     stop 666
      endif

      return

 666  continue
      write(LERR,*)'FATAL ERROR in gather:'
      write(LERR,*)'Error in reading file of input names from file ',
     1     ftap
      write(LER ,*)' '
      write(LER ,*)'GATHER:'
      write(LER ,*)' Error in reading file of input names from file ',
     1     ftap
      write(LER ,*)'FATAL'
      write(LER ,*)' '
      stop 666

      end
