/***********************************************************************
 *                copyright 2004, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*	This subroutine just includes the save.h header file and tries
	to print out the USP line and trace header structures in a readable
	form.
*/
#include <stdio.h>
#include <localsys.h>
#include <save.h>
#include <save_defs.h>

#define MAX(a,b) (a>b ? a : b);

void main(argc,argv)
int argc;
char **argv;
{
	int     line_trace;
	int	sbyte,ebyte;
	int	maxkeylength = 0;
	struct hdr *hd;
        struct hdr *hdrtypes[] = { lhdr,	/* LINEHEADER */
				  thdr,		/* TRACEHEADER */
				  vnlhdr,	/* VANLHEADER */
				  vspn_hdr,	/* VSPNHEADER */
				  segy_lhdr,	/* SEGYLINEHEADER */
				  segy_thdr,	/* SEGYTRACEHEADER */
				  NULL };

        char *type_description[] = {
				"USP Line Header",
				"USP Trace Header",
				"VANL Header",
				"VSPN Header",
				"SEGY Line Header",
				"SEGY Trace Header",
				NULL };

	line_trace = LINEHEADER;
	hd = hdrtypes[LINEHEADER];

	do {
	  maxkeylength = 0;
	  while( hd->pos >= 0 ) {
	    maxkeylength = MAX(maxkeylength,strlen(hd->str));
	    hd++;
	    }
	  hd = hdrtypes[line_trace];
/*	  fprintf(stdout,"\t\t\t\tHeader Type \"%d\"\n",line_trace); */
	  fprintf(stdout,"\t\t\t\t%s\n",type_description[line_trace]);
	  fprintf(stdout,"%*s\tType\t\tByte(s)\tDescription\n\n",
		maxkeylength,"Mnemonic");
	  for(; hd->str != (char *)0;hd++){
	    fprintf(stdout,"%*s\t\t",maxkeylength,hd->str);
	    switch (hd->ind) {
		case SAVE_CHAR_DEF:
		  fprintf(stdout,"character\t");
		  sbyte = hd->pos*sizeof(char);
		  ebyte = sbyte + hd->length*sizeof(char);
		  break;
		case SAVE_SHORT_DEF:
		  fprintf(stdout,"short\t\t");
		  sbyte = hd->pos*sizeof(short);
		  ebyte = sbyte + hd->length*sizeof(short);
		  break;
		case SAVE_LONG_DEF:
		  fprintf(stdout,"integer\t\t");
		  sbyte = hd->pos*sizeof(int);
		  ebyte = sbyte + hd->length*sizeof(int);
		  break;
		case SAVE_FLOAT_DEF:
		  fprintf(stdout,"real\t\t");
		  sbyte = hd->pos*sizeof(float);
		  ebyte = sbyte + hd->length*sizeof(float);
		  break;
		case SAVE_FKFLT_DEF:
		  fprintf(stdout,"fake real\t");
		  sbyte = hd->pos*sizeof(short);
		  ebyte = sbyte + hd->length*sizeof(short);
		  break;
		case SAVE_DUMMY_DEF:
		  fprintf(stdout,"dummy space\t");
		  sbyte = hd->pos*sizeof(short);
		  ebyte = sbyte + hd->length*sizeof(short);
		  break;
		}
	    if ((ebyte - sbyte) == 1)
	      fprintf(stdout,"%d\t%s\n",sbyte+1,hd->comment);
	    else
	      fprintf(stdout,"%d-%d\t%s\n",sbyte+1,ebyte,hd->comment);
	    }
	    fprintf(stdout,"\n\n");
	    hd = hdrtypes[++line_trace];
	  } while (hd != NULL);
	exit(0);
}
