C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine  pikrd ( nblk, nseg, iunit, iseg,nsi,itrs,itre,
     1                    nsmp,recpik,irecz,itrcz,itz,num,lunit,
     2                    unit1,unit2,unit3,off1,off2,off3)
c
c  routine to find number segments in oper pick file
c  and to count numerical entries in each segment
c  and to read the FIRST set of segments
c
c  nblk  -  I     number segments
c  ntrc  -  I     number trace/record in input data
c  nseg  -  I     array containing numerical count in each seg
c  nsi   -  I     sample interval
c  nsmp  -  I     number samples/trc
c  itrcz -  I     array of trace indices
c  irecz -  I     array of record indices
c   itz  -  I     array or corresponding times
c iunit  -  I     time units
c  iseg  -  I     segment to be read for single segment pass
c recpik -  L     are the picks record-by-record
c    num -  L     T = just count # segments & # picks/segment
c    num -  L     F = go to iseg segment & read picks
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      character   junk*1, card * 200, c1 * 5, c2 * 6
      integer     nblk, nent, iunit, nseg(*)
      integer     nsi
      integer     irecz(SZLNHD), itrcz(SZLNHD), itz(SZLNHD)
      integer     itrs, itre, nsmp, iseg
      real        unit, unit1, unit2, unit3, off1,off2,off3, fac
      logical     recpik, num

      IF (num) THEN
         write(LERR,*)'Count horizons only'
         rewind lunit
c------------------------------------------------------
c  count horizons & and count segments in each horizon

c     read(lunit, 101, end = 911) junk,unit1,unit2,unit3,itrs,itre,nsmp,
c    1                            off1,off2,off3
      read(lunit,'(a200)', end = 911)  card
      call fsscnf (card,'%s %f %f %f %d %d %d %s %f %f %f'//char(0),
     1             c1,unit1,unit2,unit3,itrs,itre,nsmp,c2,off1,off2,
     2             off3)

      unit = unit3
      iunit = ifix(unit)
      nblk = 1
      nent = 0
      read(lunit, 100, end = 912) junk
1     read(lunit, 100, end = 910) junk
      if(junk .ne. 'S') then
         nent = nent + 1
         go to 1
      else
         nseg(nblk) = nent
         nblk = nblk + 1
         nent = 0
         go to 1
      endif

101   format(a1,4x,f13.6,f13.6,f13.6,3i6,7x,3f13.6)
100   format(a1)
910   nseg(nblk) = nent
912   continue
      fac = 1.
      do  3  i = 1, nblk
             fac = fac * float(nseg(i))
3     continue
      if(nblk .eq. 1 .and. fac .eq. 0.) then
         write(LERR,*)'Pick file has segment with 0 entries'
         write(LERR,*)'Fix the oper pick file before rerunning'
         stop
      endif
      rewind lunit

c------------------------------------------------------

c------------------------------------------------------
c  read down to first horizon
      read(lunit, 100) junk

c----------------------------------------
c  scan down thru all segments to check
c  whether segments are restricted to
c  records or not

      itest = 1
      do  7  j = 1, nblk
           read(lunit, 100) junk
           do  5  i = 1, nseg(j)
c                 read(lunit,200) rr, tr, tt
                  read (lunit,'(a200)') card
                  call fsscnf (card,'%f %f %f'//char(0), rr, tr, tt)
                  itrcz(i) = ifix(tr)
                  irecz(i) = ifix(rr)
                  if (i .ge. 2) then
                      if (irecz(i) .ne. irecz(i-1)) then
                          itz(j) = 0
                      else
                          itz(j) = 1
                      endif
                  endif
5          continue
4          itest = itest * itz(j)
7     continue
      if (itest .eq. 1) then
          recpik = .true.
          write(LERR,*)'pick segments correspond to record boundaries'
      else
          recpik = .false.
          write(LERR,*)'pick segments cross record boundaries'
      endif
      write(LERR,*)'Found ',nblk,' horizons each having ',
     1 (nseg(ii),ii=1,nblk),' picks'
200   format( f12.6,f13.6,f13.6)
c----------------------------------------

      ELSE

c------------------------------------------------------
c  for one segment pass read down to input segment
      write(LERR,*)'Reading segment ',iseg,' having ',nseg(iseg),
     1' picks'
      rewind lunit
      read(lunit,100) junk
      do  9  j = 1, iseg
             read(lunit,100) junk
             do  10  i = 1, nseg(j)
c                    read(lunit,200) rr, tr, tt
                     read (lunit,'(a200)') card
                     call fsscnf (card,'%f %f %f'//char(0), rr, tr, tt)
                     if (recpik) then
                        itrcz(i) = ifix(tr)
                     else
                        itrcz(i) = ifix(rr)
                     endif
                     itz(i)   = ifix(tt)
10           continue
9     continue
             itrs = itrcz(1)
             itre = itrcz(nseg(iseg))



      ENDIF
      return

911   continue
      write(LERR,*)'Empty oper pick file or,'
      write(LERR,*)'old oper pick file: new one should have 7 entries on
     1 first line'
      write(LERR,*)'First line starts out as...'
      write(LERR,*) junk,unit1,unit2,unit3,itrs,itre,nsmp

      return
      end
