/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  Written by Douglas Horn.
*/

#include <localsys.h>
#include <string.h>
 
#include "ikp_defines.h"
#include "ikp_externs.h"
#include "ikp_remote.h"
#include "globalE.h"

#ifndef NO_RPC_SUPPORT
#include <rpc/rpc.h>
#include <rpcsvc/rstat.h>
#endif


#define MAX_HOSTS 100

char *host_list[MAX_HOSTS];
float host_rating[MAX_HOSTS];
int host_count=0,current_host=0;
int sort_table[MAX_HOSTS];

void save_hostCB();

static Widget text=NULL;

check_load()
{
  FILE *in;
  char host_file[1024],name[80],*colon;
  int load[MAX_HOSTS];
  int n,flag,temp;
  Process statp;
  int rstat_vals[3];

  current_host=0;
				/* Find .ikp_hosts file in HOME directory. */
  strcpy(host_file,getenv("HOME"));
  strcat(host_file,"/.ikp_hosts");
  
  in=fopen(host_file,"r");
  if (in==NULL) {
    ikp_err("Can't open .ikp_hosts file.", NONFATAL);
    return;
  }
  strcpy(buf2,"");
  host_count=0;
  while (fgets(buf1,80,in)!=NULL) {
    host_rating[host_count]=1.0;
    sort_table[host_count]=host_count;
    sscanf(buf1,"%s %f",name,&host_rating[host_count]);
    host_list[host_count]=strdup(name);
    memset(&statp,(int) 0,sizeof(Process));
    statp.prc_host = strdup(name);
    if (rp_loadavg(&statp,rstat_vals) == 0) {
      load[host_count]=(int)rstat_vals[0]+
	(int)(2*rstat_vals[1])+
	(int)(10*rstat_vals[2]);
      if (load[host_count]==0) {
	load[host_count]=-1*host_rating[host_count];
      } else {
	load[host_count]/=host_rating[host_count];
      }
      if (verbose) {
	colon = strchr(name,':');
	if (colon != NULL) *colon = '\0';
	fprintf(stderr,"Host %-30s: ",name);
	fprintf(stderr,"Load avg: %5d %5d %5d : %4.2f : %-d\n",
		rstat_vals[0],
		rstat_vals[1],
		rstat_vals[2],
		host_rating[host_count],load[host_count]);
      }
      host_count++;
      if (host_count>MAX_HOSTS) {
	ikp_err("Too many host in .ikp_host file", NONFATAL);
	return(IKP_FAILURE);
      }
    } else {
      fprintf(stderr,"Warning: can't get load average information from Host: %s\n",
	      name);
      load[host_count]=999;
    }
  }

  host_count--;

  flag=1;
  while (flag) {
    flag=0;
    for (n=1; n<=host_count; n++) {
      if (load[sort_table[n]]<load[sort_table[n-1]]) {
	flag=1;
	temp=sort_table[n];
	sort_table[n]=sort_table[n-1]; 
	sort_table[n-1]=temp;
      }
    }
  }
 if (verbose) {
  fprintf(stderr,"Preferred order:\n");
  for (n=0; n<=host_count; n++) {
	  strcpy(name,host_list[sort_table[n]]);
	  colon = strchr(name,':');
	  if (colon != NULL) *colon = '\0';
	  fprintf(stderr,"Host: %-30s Load: %d\n",
			 name,load[sort_table[n]]);
    }
  }
  
  fclose(in);
}


/*
  This function save the text
  from the text widget.
*/
void save_hostCB(Widget w,
		    XtPointer client_data,
		    XtPointer call_data)
{
  FILE *out,*pin;
  char *str;
  int n;
  char host_file[1024],name[256];

				/* Get text from text widget. */
  XtVaGetValues(text,
		XmNvalue,&str,
		NULL);


                                /* Find .ikp_hosts file in HOME directory. */
  strcpy(host_file,getenv("HOME"));
  strcat(host_file,"/.ikp_hosts");

  out=fopen(host_file,"w");
  if (out==NULL) {
    ikp_err("Can't open .ikp_hosts file.", NONFATAL);
    return;
  }

  strcpy(name,"");
  for (n=0; n<strlen(str); n++) {
    if (str[n]==0x0a) {		/* Line feed. */
      fprintf(out,"%s\n",name);
      strcpy(name,"");
    } else {
      strcpy(buf1,&str[n]);
      buf1[1]=0;
      strcat(name,buf1);
    }
  }
  if (strlen(name)>0) {
    fprintf(out,"%s\n",name);
  }


  fclose(out);

  XtFree(str);
}


/*
  This function create a text widget
  where the user can add hostname.
*/
void host_listCB(Widget w,
		 XtPointer client_data,
		 XtPointer call_data)
{
  static int init=0;
  FILE *in;
  Widget dialog_form;
  Widget button;
  int n;
  float rating;
  char host_file[1024],name[256];


  if (init==0) {
    dialog_form=XmCreateFormDialogVa(w,"form",
				     XmNmarginHeight,10,
				     XmNmarginWidth,10,
				     XmNdeleteResponse,XmDO_NOTHING,
				     XmNdialogTitle,XMstr("Host List"),
				     NULL);

    strcpy(buf1,"gpss53");
    text=XmCreateScrolledTextVa(dialog_form,"host",
				XmNvalue,buf1,
				XmNrows,15,
				XmNcolumns,20,
				XmNeditMode,XmMULTI_LINE_EDIT,
				XmNtopAttachment,XmATTACH_FORM,
				XmNbottomAttachment,XmATTACH_FORM,
				XmNbottomOffset,50,
				XmNleftAttachment,XmATTACH_FORM,
				XmNrightAttachment,XmATTACH_FORM,
				NULL);

    button=XmCreatePushButtonVa(dialog_form," Save ",
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,text,
				XmNtopOffset,10,
				XmNbottomAttachment,XmATTACH_FORM,
				XmNleftAttachment,XmATTACH_FORM,
				XmNactivateCallback,CBl(save_hostCB,0),
				NULL);
    
    button=XmCreatePushButtonVa(dialog_form,"Cancel",
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,text,
				XmNtopOffset,10,
				XmNbottomAttachment,XmATTACH_FORM,
				XmNrightAttachment,XmATTACH_FORM,  
				NULL);
  } else {
    XtManageChild(text);
  }
                                /* Find .ikp_hosts file in HOME directory. */
  strcpy(host_file,getenv("HOME"));
  strcat(host_file,"/.ikp_hosts");

  in=fopen(host_file,"r");
  if (in==NULL) {
    ikp_err("Can't open .ikp_hosts file.", NONFATAL);
    return;
  }
  strcpy(buf2,"");
  while (fgets(buf1,80,in)!=NULL) {
    rating=0.0;
    sscanf(buf1,"%s %f",name,&rating);

    sprintf(buf1,"%s %f\n",name,rating);

    strcat(buf2,buf1);
  }
  fclose(in);

  XtVaSetValues(text,
		XmNvalue,buf2,
		NULL);
  
}
