/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>
#include <localsys.h>
#include <termios.h>
#include <errno.h>
/*
#include <unistd.h>
*/
#include <fcntl.h>
#include <sys/param.h>

#include "ikp_defines.h"
#include "ikp_remote.h"

#if defined( SOLARIS ) || defined( CONVEXSYSTEM )
#include <sys/ioctl.h>
#endif

extern char **environ;

/* extern char *strcpy(), *strcat();*/ 
/*#ifndef SOLARIS*/
/*extern char *calloc();*/
/*#endif*/

char *progname;
int verbose;
char *logfile;
boolean fg, inetd;
struct sockaddr_in client_addr;
int control_pid, proc_pid;
int server, control;
Ioc *iolist;
Diag *diaglist;
char *user_name;
char *remuser_name;
int remuser_id, remgroup_id;
char **proc_argv;
char **proc_envv;
char hostname[MAXHOSTNAMELEN+2];
int mode;
char chld_state;
int sig_type, exit_code;
char diagbuf[DIAGBUFSZ];
char *diagrdptr, *diagwrptr;
int diagbuflen;
int errfd;
FILE *errfp;

#ifdef sun3
char *arch= "sun3";
#endif
#ifdef sun4
char *arch= "sun4";
#endif
#ifdef sun386
char *arch= "sun386";
#endif
#ifdef SOLARIS
char *arch= "sun4cg92";
#endif
#ifdef IBMR2
char *arch= "rs6000";
#endif
#ifdef hpux
char *arch= "HP-UX";		/* char *arch= "HP-PA"; */
#endif
#ifdef __convex__
char *arch= "c2mp";		/* char *arch= "c34"; */
#endif
#ifdef __sgi
char *arch= "IRIX64";
#endif
#ifdef __i686__ 
char *arch= "i686";
#endif
#ifdef __ia64__
char *arch= "ia64";
#endif
#ifdef __ppc__		/* Macintosh PowerPC running OS X */
char *arch= "ppc";
#endif
char home[MAXFILENMSZ+1];

main(argc, argv)
int argc;
char *argv[];
{
	int tty;
	struct sockaddr_in server_addr;
	struct servent *sp;
	struct servent *getservbyname();
	void ikpd_setup(), ikpd_exec();
	void ikpd_monitor(), ikpd_closedown();
	void ikpd_failure();

	progname= *argv;
	iolist= (Ioc *) NULL;
	diaglist= (Diag *) NULL;
	diagrdptr= diagwrptr= diagbuf;
	diagbuflen= 0;
	verbose= 0;
	logfile= (char *) NULL;
	fg= FALSE;
	inetd= TRUE;
	errfd= 2;
	errfp= stderr;

#ifdef __convex__
	argc--;
#endif

	for (argc--, argv++; argc > 0; argc--, argv++) {
		if (!strcmp(*argv, "-v")) {
			argc--, argv++;
			verbose= atoi(*argv);
		}
		else if (!strcmp(*argv, "-l")) {
			argc--, argv++;
			logfile= *argv;
		}
		else if (!strcmp(*argv, "-f"))
			fg= TRUE;
		else if (!strcmp(*argv, "-d"))
			inetd= FALSE;
		else {
			(void) fprintf(errfp, "%s: unrecognized argument\n", progname);
			exit(-1);
		}
	}

	if (fg && inetd) {
		(void) fprintf(errfp, "%s: foreground option requires direct option\n", progname);
		exit(-1);
	}

	if (inetd && (logfile == (char *) NULL) && (verbose > 0)) {
		(void) fprintf(errfp, "%s: verbose mode invalid without logfile option\n", progname);
		exit(-1);
	}

	if (!inetd && !fg && (logfile == (char *) NULL) && (verbose > 0)) {
		(void) fprintf(errfp, "%s: verbose mode invalid without foreground or logfile option\n", progname);
		exit(-1);
	}

	if (logfile != (char *) NULL) {
		if ((errfd= open(logfile, O_WRONLY | O_TRUNC | O_CREAT, 0644)) < 0) {
			(void) fprintf(errfp, "%s: logfile open error\n", progname);
			exit(-1);
		}
		if (dup2(errfd, 30) < 0) {
			(void) fprintf(errfp, "%s: logfile dup2 error\n", progname);
			exit(-1);
		}
		(void) close(errfd);
		errfd= 30;
		if ((errfp= fdopen(errfd, "w")) == (FILE *) NULL) {
			(void) fprintf(errfp, "%s: logfile fdopen error\n", progname);
			exit(-1);
		}
	}

	if ((remuser_id= getuid()) != 0) {
		(void) fprintf(errfp, "%s: must be root to invoke\n", progname);
		exit(-1);
	}

	/* attempt to detach from controlling terminal */
	if (!fg && !inetd) {
		if (fork())
			exit(0);

/* - replaced ioctl call with setsid() to generate a new process group */

		if ((tty = open("/dev/tty", O_RDWR)) >= 0) {
/*
			if (ioctl(tty, TIOCNOTTY, 0) == -1) {
				(void) fprintf(errfp, "%s: cannot detach from /dev/tty\n", progname);
				exit(-1);
			}
			(void) close(tty);
*/
		setsid();
		}
		(void) close(0);
		(void) close(1);
		(void) close(2);
	}

	if (gethostname(hostname, MAXHOSTNAMELEN) < 0) { 
		if (verbose)
			(void) fprintf(errfp, "%s: hostname err %d\n", progname, errno);
		exit(-1);
	}

	/* direct invocation without inetd */
	if (!inetd) {
		if ((sp= getservbyname("ikp", "tcp")) == (struct servent *) NULL) {
			if (verbose)
				(void) fprintf(errfp, "%s: getservbyname error %d\n", progname, errno);
			exit(-1);
		}
		server_addr.sin_port= sp->s_port;
		server_addr.sin_addr.s_addr= INADDR_ANY;

		if ((server= socket(AF_INET, SOCK_STREAM, 0)) == -1) {
			if (verbose)
				(void) fprintf(errfp, "%s: socket error %d\n", progname, errno);
			exit(-1);
		}

		if (bind(server, (struct sockaddr *) &server_addr, sizeof(server_addr)) < 0) {
			if (verbose)
				(void) fprintf(errfp, "%s: bind error %d\n", progname, errno);
			exit(-1);
		}

		if (listen(server, 5) < 0) {
			if (verbose)
				(void) fprintf(errfp, "%s: listen error %d\n", progname, errno);
			exit(-1);
		}

		for (;;) {
			int len= sizeof(client_addr);

			if ((control= accept(server, (struct sockaddr *) &client_addr, &len)) < 0) {
				if (verbose)
					(void) fprintf(errfp, "%s: accept error %d\n", progname, errno);
				exit(-1);
			}

			if ((control_pid= fork()) == -1) {
				if (verbose)
					(void) fprintf(errfp, "%s: fork err %d\n", progname, errno);
				exit(-1);
			}
			if (control_pid == 0) {
				control_pid= getpid();
				if (close(server) < 0)
					ikpd_failure(IKP_CLOSE);
				break;
			}
			else {
				if ((close(control)) < 0) {
					if (verbose)
						(void) fprintf(errfp, "%s: close err %d\n", progname, errno);
					exit(-1);
				}
			}
		}
	}

	/* invoked by inetd */
	else {
		int len= sizeof(client_addr);

		control= 0;
		if (close(1) < 0)
			ikpd_failure(IKP_CLOSE);
		if (getpeername(0, (struct sockaddr *) &client_addr, &len) < 0) {
			if (verbose)
				(void) fprintf(errfp, "%s: accept error %d\n", progname, errno);
			ikpd_failure(IKP_GETSOCKNAME);
		}
		control_pid= getpid();
	}

	ikpd_setup();
	ikpd_exec();
	ikpd_monitor();
	ikpd_closedown();
	exit(0);
}

void
ikpd_setup()
/*
   Performs user authentication, builds child argv and env
   pointers, etc., and makes/accepts client data socket connections
   to/from other remote daemons. Terminates on any internal error
   or reception of an invalid command over the control socket.
   Returns when child setup is complete and an IKPRP_EXEC or an
   IKPRP_RSTAT command is received.
*/
{
	char command;
	int fdrange;
	fd_set readfds;
	Ioc *ioc;
	FILE *fdopen();
	void ikpd_hostname(),ikpd_username(), ikpd_dir();
	void ikpd_argv(), ikpd_envv(), ikpd_lockfd();
	void ikpd_serversock(), ikpd_clientsock();
	void ikpd_fileopen(), ikpd_diag(), ikpd_status();
	void ikpd_success(), ikpd_failure();

	chld_state= IKPRP_SETUP;
	fdrange= getdtablesize();

	for (mode= IKPD_SETUP; mode == IKPD_SETUP; ) {

		FD_ZERO(&readfds);
		FD_SET(control, &readfds);
		for (ioc= iolist; ioc != (Ioc *) NULL; ioc= ioc->ioc_next) {
			if ((ioc->ioc_flags & IOC_SOCKET) && !(ioc->ioc_flags & IOC_CONNECTED))
				FD_SET(ioc->ioc_socket, &readfds);
		}
		if (select(fdrange, &readfds, (fd_set *) NULL, (fd_set *) NULL, (struct timeval *) NULL) < 0)
			ikpd_failure(IKP_SELECT);

		/* process control socket commands */
		if (FD_ISSET(control, &readfds)) {
			if (buf_read(control, &command, 1) != 1)
				ikpd_failure(IKP_READ);

			switch (command) {
			case IKPRP_HOSTNAME:
				ikpd_hostname();
				break;
			case IKPRP_USERNAME:
				ikpd_username();
				break;
			case IKPRP_DIR:
				if (remuser_id == ROOT_UID)
					ikpd_failure(IKP_PERMISSION);
				ikpd_dir();
				break;
			case IKPRP_ARGV:
				ikpd_argv();
				break;
			case IKPRP_ENVV:
				ikpd_envv();
				break;
			case IKPRP_LOCKFD:
				if (remuser_id == ROOT_UID)
					ikpd_failure(IKP_PERMISSION);
				ikpd_lockfd();
				break;
			case IKPRP_SERVERSOCK:
				if (remuser_id == ROOT_UID)
					ikpd_failure(IKP_PERMISSION);
				ikpd_serversock();
				break;
			case IKPRP_CLIENTSOCK:
				if (remuser_id == ROOT_UID)
					ikpd_failure(IKP_PERMISSION);
				ikpd_clientsock();
				break;
			case IKPRP_FILERD:
				if (remuser_id == ROOT_UID)
					ikpd_failure(IKP_PERMISSION);
				ikpd_fileopen(IKPRP_FILERD);
				break;
			case IKPRP_FILEWRTRUNC:
				if (remuser_id == ROOT_UID)
					ikpd_failure(IKP_PERMISSION);
				ikpd_fileopen(IKPRP_FILEWRTRUNC);
				break;
			case IKPRP_FILEWRAPP:
				if (remuser_id == ROOT_UID)
					ikpd_failure(IKP_PERMISSION);
				ikpd_fileopen(IKPRP_FILEWRAPP);
				break;
			case IKPRP_DIAG:
				if (remuser_id == ROOT_UID)
					ikpd_failure(IKP_PERMISSION);
				ikpd_diag();
				break;
			case IKPRP_EXEC:
				if (remuser_id == ROOT_UID)
					ikpd_failure(IKP_PERMISSION);
				mode= IKPD_EXEC;
				break;
			case IKPRP_RSTAT:
				if (verbose)
					(void) fprintf(errfp, "RSTAT ACCEPTED\n");
				ikpd_rstat();
				mode= IKPD_EXITED;
				break;
			case IKPRP_STATUS:
				ikpd_status();
				break;
			case IKPRP_KILL:
				ikpd_success();
				exit(0);
				break;
			case IKPRP_CLOSEDOWN:
				ikpd_success();
				exit(0);
				break;
			default:
				ikpd_failure(IKP_ILLRPCOMM);
				break;
			}
		}

		/* listen for data socket connection requests */
		for (ioc= iolist; ioc != (Ioc *) NULL; ioc= ioc->ioc_next) {

			if (!(ioc->ioc_flags & IOC_SOCKET) || (ioc->ioc_flags & IOC_CONNECTED))
				continue;

			if (FD_ISSET(ioc->ioc_socket, &readfds)) {
				int s;

				if ((s= accept(ioc->ioc_socket, (struct sockaddr *) NULL, (int *) NULL)) < 0)
					ikpd_failure(IKP_ACCEPT);
				ioc->ioc_flags|= IOC_CONNECTED;
				(void) close(ioc->ioc_socket);
				if (control == ioc->ioc_fd) {
					int newcontrol;

					if ((newcontrol= dup(control)) < 0)
						ikpd_failure(IKP_DUP);
					(void) close(control);
					control= newcontrol;
				}
				if (verbose && (errfd == ioc->ioc_fd)) {
					int newerrfd;

					if ((newerrfd= dup(errfd)) < 0)
						ikpd_failure(IKP_DUP);
					(void) fflush(errfp);
					(void) close(errfd);
					errfd= newerrfd;
					if ((errfp= fdopen(errfd, "w")) == (FILE *) NULL)
						ikpd_failure(IKP_OPEN);
				}
				if (s != ioc->ioc_fd) {
					if (dup2(s, ioc->ioc_fd) < 0)
						ikpd_failure(IKP_DUP2);
					(void) close(s);
				}
				if (verbose)
					(void) fprintf(errfp, "CONNECTION ACCEPTED %d\n", ioc->ioc_fd);
			}
		}
	}

	return;
}

void
ikpd_exec()
/*
   Fork child process and transmit
   child pid over control socket.
*/
{
	Ioc *ioc;
	Diag *d;
	char command;
	unsigned long ul;
	void ikpd_failure();

	/* check for unconnected data sockets */
	for (ioc= iolist; ioc != (Ioc *) NULL; ioc= ioc->ioc_next) {
		if ((ioc->ioc_flags & IOC_SOCKET) && !(ioc->ioc_flags & IOC_CONNECTED))
			ikpd_failure(IKP_UNCONNECTED);
	}

	/* fork child */
	if ((proc_pid= fork()) == -1) {
		if (verbose)
			(void) fprintf(errfp, "%s: fork err %d\n", progname, errno);
		ikpd_failure(IKP_FORK);
	}
	if (proc_pid == 0) {

		/* close child copy of control socket */
		if (close(control) < 0)
			exit(-1);

		/* close child copy of diagnostic pipe read descriptors */
		for (d= diaglist; d != (Diag *) NULL; d= d->diag_next) {
			if (close(d->diag_pipe[0]) < 0)
				exit(-1);
		}

		proc_pid = getpid();
/* - commented out 10/11/00 - Joe M. Wade
#ifndef SOLARIS
		setpgrp(0,proc_pid);
#else
		setsid();
#endif
*/
		setpgid(proc_pid,0);

		execvp(proc_argv[0], proc_argv);
		if (verbose)
			(void) fprintf(errfp, "execvp errno %d on %s\n", errno, proc_argv[0]);
		exit(EXECVP_EXITCODE);
	}

	if (verbose)
		(void) fprintf(errfp, "PROCPID %d\n", proc_pid);

	/* close parent copy of all data sockets */
	for (ioc= iolist; ioc != (Ioc *) NULL; ioc= ioc->ioc_next)
		(void) close(ioc->ioc_fd);

	/* close parent copy of child's diag write descriptors,
	   and set the O_NDELAY flag on the read descriptors */
	for (d= diaglist; d != (Diag *) NULL; d= d->diag_next) {
		int flags;

		if (close(d->diag_fd) < 0)
			exit(-1);
		if ((flags= fcntl(d->diag_pipe[0], F_GETFL, 0)) < 0)
			exit(-1);
		if (fcntl(d->diag_pipe[0], F_SETFL, flags | O_NDELAY) < 0)
			exit(-1);
	}

	/* transmit child process id */
	command= IKPRP_PID;
	if (buf_write(control, &command, sizeof(char)) != sizeof(char))
		exit(-1);
	ul= htonl((unsigned long) proc_pid);
	if (buf_write(control, (char *) &ul, sizeof(u_long)) != sizeof(u_long))
		exit(-1);

	mode= IKPD_RUNNING;
	chld_state= IKPRP_RUNNING;
	return;
}

void
ikpd_monitor()
/*
   Monitor child process and handle control socket requests.
   Report child state changes over the control socket when requested.
   Return only when wait3() confirms that the child has terminated.
   Exit (and kill child if necessary) upon receiving IKPRP_CLOSEDOWN
   request.
*/
{
	char command;
	unsigned long ul;
	int fdrange, flag;
	fd_set readfds;
	struct timeval timeout;
	int status;
	int pid;
	Diag *d;
	void ikpd_success(), ikpd_failure();
	void ikpd_rddiag(), ikpd_status();

	flag= IKPD_RUNNING;
	fdrange= getdtablesize();

	while ((mode != IKPD_KILLED) && (mode != IKPD_EXITED)) {

		timeout.tv_sec= 3;
		timeout.tv_usec= 0;
		FD_ZERO(&readfds);
		FD_SET(control, &readfds);
		for (d= diaglist; d != (Diag *) NULL; d= d->diag_next)
			FD_SET(d->diag_pipe[0], &readfds);

		if (select(fdrange, &readfds, (fd_set *) NULL, (fd_set *) NULL, &timeout) < 0)
			ikpd_failure(IKP_SELECT);

/*
		if ((pid= wait3(&status, WNOHANG | WUNTRACED, (struct rusage *) NULL)) < 0)

		if ((pid= waitpid(0, &status, WNOHANG | WUNTRACED)) < 0)
			ikpd_failure(IKP_WAIT3);
*/
		if ((pid= waitpid(-proc_pid, &status, WNOHANG | WUNTRACED)) < 0)
			ikpd_failure(IKP_WAIT3);

		/* child status change */

		if (pid == proc_pid) {

			/* process stopped by a signal sent by controlling daemon */
			if (WIFSTOPPED(status) && (flag == IKPD_STOPPED)) {
				mode= IKPD_STOPPED;
				chld_state= IKPRP_STOPPED;
				sig_type= (status >> 8) & 0377;
			}

			/* process stopped by a signal sent by
			   someone other than the controlling daemon */
			else if (WIFSTOPPED(status)) {
				if (verbose)
					(void) fprintf(errfp, "SIG STOP\n");

				mode= IKPD_STOPPED;
				chld_state= IKPRP_STOPPED;
				sig_type= (status >> 8) & 0377;
			}

			/* process killed by a signal sent by controlling daemon */
			if (WIFSIGNALED(status) && (flag == IKPD_KILLED)) {
				mode= IKPD_KILLED;
				chld_state= IKPRP_KILLED;
				sig_type= status & 0177;
			}

			/* process killed by a signal sent by
			   someone other than the controlling daemon */
			else if (WIFSIGNALED(status)) {
				mode= IKPD_KILLED;
				chld_state= IKPRP_KILLED;
				sig_type= status & 0177;

				if (verbose)
					(void) fprintf(errfp, "SIGNAL %d\n", sig_type);
			}

			/* process exited */
			else if (WIFEXITED(status)) {
				mode= IKPD_EXITED;
				chld_state= IKPRP_EXITED;
				exit_code= status >> 8;

				/* perform sign extension if
				   exit code appears negative */
				if (exit_code & 0x80)
					exit_code|= 0xffffff80;

				if (verbose)
					(void) fprintf(errfp, "EXIT %d\n", exit_code);
			}
/*
   added this to kill all children of a script if one dies
*/
			switch(mode) {
				case IKPD_KILLED:
					if (kill(-proc_pid, SIGKILL) < 0)
						ikpd_failure(IKP_KILL);
					break;
				case IKPD_STOPPED:
					if (kill(-proc_pid, SIGSTOP) < 0)
						ikpd_failure(IKP_KILL);
					break;
				}
		}

		/* store any diagnostics transmitted by child */
		for (d= diaglist; d != (Diag *) NULL; d= d->diag_next) {
			if (FD_ISSET(d->diag_pipe[0], &readfds))
				ikpd_rddiag(d->diag_pipe[0]);
		}

		/* process any control socket command */
		if (FD_ISSET(control, &readfds)) {
			if (buf_read(control, &command, 1) != 1)
				ikpd_failure(IKP_READ);

			switch (command) {

			case IKPRP_STATUS:
				ikpd_status();
				break;

			case IKPRP_STOP:
				if (verbose)
					(void) fprintf(errfp, "CNTL STOP\n");

				switch (mode) {
				case IKPD_EXITED:
					ikpd_failure(IKP_RPEXITED);
					break;
				case IKPD_KILLED:
					ikpd_failure(IKP_RPKILLED);
					break;
				case IKPD_RUNNING:
/* - stop all processes with in process group proc_pid
					if (kill(proc_pid, SIGSTOP) < 0)
						ikpd_failure(IKP_KILL);
*/
					if (kill(-proc_pid, SIGSTOP) < 0)
						ikpd_failure(IKP_KILL);
					flag= IKPD_STOPPED;
					break;
				case IKPD_STOPPED:
					/* report success anyway, since
					   the client certainly doesn't
					   want the process aborted */
					break;
				}

				ikpd_success();
				break;

			case IKPRP_CONT:
				if (verbose)
					(void) fprintf(errfp, "CNTL CONT\n");

				switch (mode) {
				case IKPD_EXITED:
					ikpd_failure(IKP_RPEXITED);
					break;
				case IKPD_KILLED:
					ikpd_failure(IKP_RPKILLED);
					break;
				case IKPD_RUNNING:
					/* report success anyway, since
					   the client certainly doesn't
					   want the process aborted */
					break;
				case IKPD_STOPPED:
/* - send to all processes with in process group proc_pid
					if (kill(proc_pid, SIGCONT) < 0)
						ikpd_failure(IKP_KILL);
*/
					if (kill(-proc_pid, SIGCONT) < 0)
						ikpd_failure(IKP_KILL);
					flag= IKPD_RUNNING;
					mode= IKPD_RUNNING;
					chld_state= IKPRP_RUNNING;
					break;
				}

				ikpd_success();
				break;

			case IKPRP_KILL:
				if (verbose)
					(void) fprintf(errfp, "CNTL KILL\n");

				switch (mode) {
				case IKPD_EXITED:
				case IKPD_KILLED:
					/* report success anyway, since
					   the process is in fact now dead */
					break;
				case IKPD_RUNNING:
				case IKPD_STOPPED:

/* - changed this to kill everything else in the new process group - zjmw36

					if (kill(proc_pid, SIGKILL) < 0)
						ikpd_failure(IKP_KILL);
*/
					if (kill(-proc_pid, SIGKILL) < 0)
						ikpd_failure(IKP_KILL);
					flag= IKPD_KILLED;
					break;
				}

				ikpd_success();
				break;

			case IKPRP_CLOSEDOWN:
				if (verbose)
					(void) fprintf(errfp, "CNTL CLOSEDOWN\n");
				switch (mode) {
				case IKPD_EXITED:
				case IKPD_KILLED:
					break;
				case IKPD_RUNNING:
				case IKPD_STOPPED:
					if (flag != IKPD_KILLED) {
/* - changed this to kill everything else in the new process group - zjmw36

						if (kill(proc_pid, SIGKILL) < 0)
							ikpd_failure(IKP_KILL);
*/
						if (kill(-proc_pid, SIGKILL) < 0)
							ikpd_failure(IKP_KILL);
					}
					break;
				}

				ikpd_success();
				exit(0);
				break;

			default:
				if (verbose)
					(void) fprintf(errfp, "ILLEGAL COMMAND %d\n", (int) command);
				ikpd_failure(IKP_ILLRPCOMM);
				break;
			}
		}
	}
	return;
}

void
ikpd_closedown()
/*
   Listen only for IKPRP_CLOSEDOWN request. The child process
   must be terminated before this routine is called.
*/
{
	char command;
	int fdrange;
	fd_set readfds;
	struct timeval timeout;
	void ikpd_success(), ikpd_failure();
	void ikpd_status();

	fdrange= getdtablesize();

	while (mode != IKPD_CLOSEDOWN) {

		timeout.tv_sec= 3;
		timeout.tv_usec= 0;
		FD_ZERO(&readfds);
		FD_SET(control, &readfds);
		if (select(fdrange, &readfds, (fd_set *) NULL, (fd_set *) NULL, &timeout) < 0)
			ikpd_failure(IKP_SELECT);

		if (FD_ISSET(control, &readfds)) {
			if (buf_read(control, &command, 1) != 1)
				ikpd_failure(IKP_READ);

			switch (command) {

			case IKPRP_STATUS:
				ikpd_status();
				break;

			case IKPRP_CLOSEDOWN:
				if (verbose)
					(void) fprintf(errfp, "CNTL CLOSEDOWN\n");

				ikpd_success();
				mode= IKPD_CLOSEDOWN;
				break;

			default:
				if (verbose)
					(void) fprintf(errfp, "ILLEGAL COMMAND %d\n", (int) command);
				ikpd_failure(IKP_ILLRPCOMM);
				break;
			}
		}
	}
	return;
}
