C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, otap, kfile, ns, ne, irs, ire, dead, 
     :     pickfile, lupick, traces, dismin, dismax, records, inv, Wrd1,
     :      Wrd2, REC, nlive, verbos )

#include <f77/iounit.h>

      integer    ns,ne,irs,ire,argis,lupick, nlive

      character  ntap*(*), otap*(*), kfile*(*), Wrd1*(*), Wrd2*(*)

      logical    verbos, dead,pickfile,traces, records, inv, REC

      inv = .false.
      REC = .false.

      REC      = (argis('-rec') .gt. 0)
      call argi4('-nlive',nlive,1,1)

      call argstr('-hw1',Wrd1,' ',' ') 
      call argstr('-hw2',Wrd2,' ',' ') 

      call argstr('-N',ntap,' ',' ') 
      call argstr('-O',otap,' ',' ') 
      call argstr('-K',kfile,' ',' ') 
      call argr4 ('-dl',dismin, 0., 0.) 
      call argr4 ('-dh',dismax, 0., 0.) 
      if (dismin .eq. 0. .AND. dismax .eq. 0.) then
         dismin =  99999999.
         dismax = -99999999.
      endif
      
      if (kfile(1:1) .eq. ' ') then
         call argi4('-ns',ns,0,0)
         call argi4('-ne',ne,0,0)
         call argi4('-rs',irs,0,0)
         call argi4('-re',ire,0,0)
         traces = .false.
         pickfile = .false.
      else
         records = .false.
         traces  = .false.
         open(unit=lupick, file=kfile, status='old', iostat=ierr)
         if(ierr .ne. 0) then
            write(LERR,*)'Could not open kill pick file'
            write(LERR,*)'Check existence'
            stop
         else
            rewind lupick
         endif
         traces   = (argis('-T') .gt. 0)
         records  = (argis('-R') .gt. 0)
         pickfile = (argis('-pick') .gt. 0)

         if ( .not. traces .and. .not. records .and. 
     :        .not. pickfile ) then
            if ( Wrd1 .ne. ' ' .and. Wrd2 .eq. ' ' .or. 
     :           Wrd2 .ne. ' ' .and. Wrd1 .eq. ' ' ) then
               write(LERR,*)'        '
               write(LERR,*)'KILLTR: you have attached a flat file of '
               write(LERR,*)'        record, trace pairs and referenced'
               write(LERR,*)'        only one of the indices to a trace'
               write(LERR,*)'        header entry.  You need to specify'
               write(LERR,*)'        Either both -hw1 and -hw2 '
               write(LERR,*)'        OR neither for this option.  The '
               write(LERR,*)'        former will kill based on header'
               write(LERR,*)'        index, the latter sequential '
               write(LERR,*)'        record and trace number'
               write(LERR,*)' FATAL'       
               write(LERR,*)'        '
               write(LER,*)'        '
               write(LER,*)'KILLTR: you have attached a flat file of '
               write(LER,*)'        record, trace pairs and referenced'
               write(LER,*)'        only one of the indices to a trace'
               write(LER,*)'        header entry.  You need to specify'
               write(LER,*)'        Either both -hw1 and -hw2 '
               write(LER,*)'        OR neither for this option.  The '
               write(LER,*)'        former will kill based on header'
               write(LER,*)'        index, the latter sequential '
               write(LER,*)'        record and trace number'
               write(LER,*)' FATAL'       
               write(LER,*)'        '
               stop
            endif
         endif    
      endif
      
      inv      = (argis('-I') .gt. 0)
      dead     = (argis('-D') .gt. 0)
      verbos   = (argis('-V') .gt. 0)
      
      return
      end

