C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, kfile, nsamp, nsi, ntrc, nrec,  
     :     iform, dead, pickfile, traces, dismin, dismax, records, 
     :     inv, Wrd1, Wrd2, ns, ne, irs, ire, REC, nlive, verbos )

#include <f77/iounit.h>

c variables passed from calling routine

      integer nsamp, nsi, ntrc, nrec, iform, ns, ne, irs, ire
      integer nlive

      real  dismin, dismax

      character ntap*(*), otap*(*), kfile*(*), Wrd1*6, Wrd2*6

      logical dead, pickfile, traces, records, inv, REC, verbos

c local variables

      integer length


      write(LERR,*)' '
      write(LERR,*)' Input Dataset'
      write(LERR,*)' -------------'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' Filename           =  ', ntap(1:length)
      else
        write(LERR,*) ' Filename           =  stdin'
      endif
      write(LERR,*) ' Samples/Trace      =  ', nsamp
      write(LERR,*) ' Sample Interval    =  ', nsi  
      write(LERR,*) ' Traces per Record  =  ', ntrc 
      write(LERR,*) ' Records per Line   =  ', nrec
      write(LERR,*) ' Format of Data     =  ', iform
      write(LERR,*)' '
      write(LERR,*)' Output Dataset'
      write(LERR,*)' -------------'
      write(LERR,*)' '
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*) ' Filename           =  ', otap(1:length)
      else
        write(LERR,*) ' Filename           =  stdout'
      endif
      write(LERR,*) ' Samples/Trace      =  ', nsamp
      write(LERR,*) ' Sample Interval    =  ', nsi  
      write(LERR,*) ' Traces per Record  =  ', ntrc 
      write(LERR,*) ' Records per Line   =  ', nrec
      write(LERR,*) ' Format of Data     =  ', iform
      write(LERR,*)' '
      write(LERR,*)' Kill / Polarity Reversal Action '
      write(LERR,*)' -------------------------------'
      write(LERR,*)' '

      if ( dead ) then
         write(LERR,*)' the [StaCor=30000] dead trace flag will be set'
      else
         write(LERR,*)' the [StaCor=30000] dead trace flag will NOT be s
     :et'
      endif

      IF ( REC ) THEN

         write(LERR,*) ' Record Mode:'
         write(LERR,*) ' Record will be killed if # live traces <= ',
     1                 nlive

      ELSE

      IF ( irs .ne. 0 .AND. 
     :     ire .eq. 0 .AND. 
     :     ns .ne. 0  .AND. 
     :     ne .eq. 0 ) THEN
         
c kill or invert a single trace in a single record [-ns -rs defined]
              
         write(LERR,*)' operate on single trace in single record'

      ELSEIF (irs .eq. 0 .AND. 
     :        ire .eq. 0 .AND. 
     :        ns .ne. 0  .AND.
     :        ne .eq. 0 ) THEN
            
c kill or invert a given trace in every record based on trace number
c [-ns defined]

         write(LERR,*)' operate on single trace in all records'

      ELSEIF( irs .ne. 0 .AND. 
     :        ire .eq. 0 .AND. 
     :        ns .eq. 0  .AND.
     :        ne .eq. 0 ) THEN
            
c kill or invert all traces of a given record number [-rs defined]

         write(LERR,*)' operate on a single record'

      ELSEIF ( irs .ne. 0 .AND. 
     :        ire .ne. 0 .AND. 
     :        ns .eq. 0 .AND.
     :        ne .eq. 0 ) THEN
            
c kill or invert a contiguous set of  records, [-rs -re defined] 
c the range of records and traces may be given in increasing or decreasing

         write(LERR,*)' operate on a contiguous set of records'

      ELSEIF ( irs .ne. 0 .AND. 
     :        ire .ne. 0 .AND. 
     :        ns .ne. 0 .AND.
     :        ne .ne. 0 ) THEN
                     
c kill or invert a contiguous set of  traces within a 
c contiguous set of  records.  [ -rs -re -ns -ne]

         write(LERR,*)' operate on a contiguous set of traces within a c
     :ontiguous set of records'

      ELSEIF ( irs .eq. 0 .AND. 
     :        ire .eq .0 .AND. 
     :        ns .ne. 0 .AND.
     :        ne .ne. 0 ) THEN

c kill or invert a contiguous set of  traces within all
c records of the dataset.  

         write(LERR,*)' operate on a contiguous set of traces within all
     : records'

      ELSEIF ( irs. ne. 0 .AND. 
     :        ire .eq. 0 .AND. 
     :        ns .gt. 0 .AND.
     :        ne .gt. 0 ) THEN
         
c kill or invert a contiguous set of traces within a single record only

         write(LERR,*)' operate on a contiguous set of traces within a s
     :ingle record'

      ENDIF

      if (inv) then
         write(LERR,*)' trace polarity will be reversed'
      else
         write(LERR,*)' trace amplitude will be set to 0.0'
      endif

      write(LERR,*)' '
      write(LERR,*)' minimum distance to kill = ', dismin
      write(LERR,*)' maximum distance to kill = ', dismax
      write(LERR,*)' '

      if (kfile(1:1) .eq. ' ') then
         write(LERR,*)' NO KILL FILE ATTACHED'
         write(LERR,*) ' ns                 =  ', ns
         write(LERR,*) ' ne                 =  ', ne
         write(LERR,*) ' irs                =  ', irs
         write(LERR,*) ' ire                =  ', ire
         write(LERR,*)' '

      else

         write(LERR,*) ' Kill File Attached'
         length = lenth(kfile)
         write(LERR,*) ' Filename     =  ',kfile(1:length)
         if ( traces ) then 
            write(LERR,*)' flagged to kill traces in all records'
         elseif ( records ) then
            write(LERR,*)' flagged to kill records'
         elseif ( .not. pickfile ) then
            write(LERR,*)' flagged to kill traces in records'
         else
            write(LERR,*)' traces to kill from xsd pick file'
         endif
      endif

      write(LERR,*)' '
      if ( Wrd1 .ne. ' ' )
     :     write(LERR,*)' record index referenced to [',
     :     Wrd1,']'
      if ( Wrd2 .ne. ' ' )
     :     write(LERR,*)' trace index referenced to [',
     :     Wrd2,']'

      ENDIF

      return
      end




         

