/***********************************************************************
 *                copyright 2004, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <math.h>

#ifdef CRAY
#define crvray_ CRVRAY
#define creray_ CRERAY
#endif
#ifdef hpux
#define crvray_ crvray
#define creray_ creray
#endif
void xtop1(),xtop2();
void rms2in();

void crvray_(kdo,thetao,t,x,vrms,vrmsc,sint,nsamp,iflag,vtmax,
 ierr,errp,vsm,vism,vit,xconst)
long int *kdo;
float *thetao, *t, *x, *vrms, *vrmsc, *sint, *vtmax, *errp;
float *vsm, *vism, *vit, *xconst;
long int *nsamp,*iflag, *ierr;
{
    register int i, k;
    double xx, xxs, depth[5000];
    float t1,t2,t3,t4,t5;
    float *pthetao, *th1, *th2;
    float *pt, *pt1, *pvrmss, *pvrmss1;
    float *pvis, *px;
    double *pdepth;


    static float pid2=1.570796326794897;
    float vis[5000],vrmss[5000];
    long int iret;
    double lvi, div;
    float old_vi;

    *ierr = 0; old_vi = vism[0];
    if (*iflag != 2) { 
        pt = t;
        pvrmss = vrmss;
        *pvrmss = vsm[0];
        pvis = vis;
        pdepth = depth;

        *pdepth = *pvis * (*sint);

        *pvis = vism[0];
        *pdepth = *pvis++ * (*sint);
        pvrmss1 = pvrmss++;
        pt1 = pt++;

        for (i=1; i<*nsamp; i++) {

            *pvrmss = vsm[i];
            *pvis = vism[i];
                    
            if (*pvis <= 0) {
               if(*pt <= *vtmax) {
                 *ierr = 1;
                 *errp++ = *pvrmss;
                 *errp++ = *pvrmss1;
                 *errp++ = *pt;
                 *errp++ = *pt1;
                 *errp   = (float)i * (*sint);
                 return;
               }
               else
                *pvis = old_vi;
            }
            old_vi = *pvis;
            xx = (*pdepth++) + *pvis++ * (*sint);
            *pdepth = xx;

            pt1 = pt++;
            pvrmss1 = pvrmss++;
        }
        

        if (*iflag == 0) {
            pthetao = thetao;
            px = x;
            for (k=0; k<*kdo; k++) {
                pdepth = depth;
                for (i=0; i<*nsamp; i++) {
                    if (*pdepth != 0.) {
                        xx = atan( *px / (*pdepth++) );
                        xxs = sin(xx);
                        if (xxs < 1.0 && xxs >= 0.0)
                            *pthetao++ = xx* *xconst;
                        else *pthetao++ = pid2* *xconst;
                    }
                    else {
                        *pthetao++ = 0.;
                        pdepth++;
                    }
                }
                px++;
            }
        }
        else {
            xtop1(kdo,thetao,x,t,vis,vrmss,sint,nsamp,xconst);
        }
    }
    else {
        xtop1(kdo,thetao,x,t,vit,vrms,sint,nsamp,xconst);
    }
}
void xtop1(kdo,thetao,x,t,vi,vrms,dt,n,xconst)
long int *kdo;
float *thetao, *x, *t, *vi, *vrms, *dt,*xconst;
long int *n;
{
    double vrms2;
    double vi2, vi4, vi6;
    double x1,x2,x3,x4,x5,x6,x7,x8;
    double a1,a2,a3,a4,a5;
    double a22,a27,a210,a32;
    double c1,c2,c3,c4,c5,ddt,ax;
    double xx;

    float *pvi, *pp0, *pt, *pvrms;
    float *px, *pthetao;

    register int i,k;

    static float pid2=1.570796326794897;

    ddt = (double)*dt;
    px = x;
    pthetao = thetao;

    for (k=0; k<*kdo; k++) {
        a3 = 0;
        a4 = 0;
        a5 = 0;
        x1 = (double)*px;
        x2 = x1 * x1;
        x3 = x2 * x1;
        x4 = x3 * x1;
        x5 = x4 * x1;
        x6 = x5 * x1;
        x7 = x6 * x1;
        x8 = x7 * x1;

        pvi = vi;

        pt = t;
        pvrms = vrms;

        for (i=0; i<*n; i++) {

            a1 = *pt;
            vrms2 = (*pvrms) * (*pvrms);
            pvrms++;
            a2 = vrms2 * (*pt);

            /* check for time of zero then bump it up to next time */
            if (*pt++ == 0.) a2 = 1.;

            /* a2 squared, a2 to the seventh, a2 to the 10th */

            a22 = a2 * a2;
            a27 = a22 * a22 * a22 * a2;
            a210 = a27 * a22 * a2;

            vi2 = (*pvi) * (*pvi);
            vi4 = vi2 * vi2;
            vi6 = vi4 * vi2;

            a3 += vi4 * ddt;
            a32 = a3 * a3;
            a4 += vi6 * ddt;
            a5 += vi6 * vi2 * ddt;

            c1 = a1 * a1;
            c2 = 1. / vrms2;
            c3 = (a22 - a1*a3) / (4.*(a22*a22));
            c4 = (2.*a1*a32 - a1*a2*a4 - a22*a3) / (8.*a27);

            c5 = (24.*a1*a2*a3*a4 - 24.*a1*(a32*a3)
                - 5.*a1*a22*a5
                + 9.*a22*a32
                - 4.*(a22*a2)*a4) / (64.*a210);

            ax = c1 + 
                c2 * x2 + 
                c3 * x4 + 
                c4 * x6 + 
                c5 * x8;

            if (ax < 0.) xx = 1.;
            else xx = (c2 * x1 + 2. * c3 * x3
                    + 3. * c4 * x5 + 4. * c5 * x7) /
                    sqrt(ax) * (*pvi);

            if (xx < 1.0 && xx >= 0.0) *pthetao++ = asin(xx)* *xconst;
            else *pthetao++ = pid2* *xconst;
            pvi++;
        }
        px++;
    }
}
void rms2in(rms,t,npairs,iret)
float *rms, *t;
long int *npairs, *iret;
{
    int i;
    float *prms, *prms1;
    float *pt, *pt1;
    float temp;

    *iret = 0;

    prms = rms;
    prms1 = prms;
    prms1++;

    pt = t;
    pt1 = t;
    pt1++;

    for (i=0; i<*npairs-1; i++) {
        temp = *pt1 * ((*prms1) * (*prms1)) -
            (*pt) * ((*prms) * (*prms));

        if (temp < 0.) {
            *iret = -1;
            *prms++ = 0.;
        }
        else {
            if ((*pt1) - (*pt) > 0.) *prms++ = sqrt(temp/(*pt1-*pt));
            else *prms++ = 0;
        }

        pt++;
        pt1++;
        prms1++;
    }
    prms1 = prms;
    prms1--;
    *prms = *prms1;
}

void creray_(kdo,thetao,t,x,vrms,vrmsc,sint,nsamp,iflag,vtmax,
   ierr,errp,vsm,vism,vit,xconst)
long int *kdo;
float *thetao, *t, *x, *vrms, *vrmsc, *sint, *vtmax, *errp;
float *vsm, *vism, *vit, *xconst;
long int *nsamp,*iflag, *ierr;
{
    register int i, k;
    double xx, xxs, depth[3000];
    float t1,t2,t3,t4,t5;
    float *pthetao, *th1, *th2;
    float *pt, *pt1, *pvrmss, *pvrmss1;
    float *pvis, *px, *v;
    double *pdepth;


    static float pid2=1.570796326794897;
    float vis[3000],vrmss[3000], vi[3000], ltheta;
    long int iret;
    double lvi, div, parm;
    float old_vi;

    memcpy(vi,vit,(int)(*nsamp*4));
/*    rms2in(vi,t,nsamp,&iret); */

    old_vi = vism[0];
    *ierr = 0;
    if (*iflag != 2) { 
        pt = t;
        pvrmss = vrmss;
        *pvrmss = vsm[0];
        pvis = vis;
        pdepth = depth;

        *pdepth = *pvis * (*sint);

        *pvis = vism[0];
        *pdepth = *pvis++ * (*sint);
        pvrmss1 = pvrmss;  pvrmss ++;
        pt1 = pt; pt ++;

        for (i=1; i<*nsamp; i++) {

            *pvrmss = vsm[i];
            *pvis = vism[i];
                    
             if (*pvis <= 0) {
               if(*pt <= *vtmax) {
                 *ierr = 1;
                 *errp++ = *pvrmss;
                 *errp++ = *pvrmss1;
                 *errp++ = *pt;
                 *errp++ = *pt1;
                 *errp   = (float)i * (*sint);
                 return;
               }
               else
                *pvis = old_vi;
             }
             old_vi = *pvis;
             xx = (*pdepth++) + *pvis++ * (*sint);
             *pdepth = xx;

             pt1 = pt++;
             pvrmss1 = pvrmss++;
        }
        

        if (*iflag == 0) {
            pthetao = thetao;
            v = vi;
            px = x;
            for (k=0; k<*kdo; k++) {
                pdepth = depth;
                for (i=0; i<*nsamp; i++) {
                    if (*pdepth != 0.) {
                        xx = atan( *px / (*pdepth++) );
                        xxs = sin(xx);
                        if (xxs < 1.0 && xxs >= 0.0) {
                             ltheta = xx;
                        }
                        else {
                          ltheta = pid2;
                        }
                    }
                    else {
                        ltheta = 0;
                        pdepth++;
                    }
                    div = (double)ltheta;
                    parm = sin(div)/(*v++);
                    if (parm * (vi[0]) < 1.) {
                      div = parm * vi[0];
                      *pthetao++ = asin(div)* *xconst;
                    }
                    else 
                      *pthetao++ = pid2* *xconst;
                }
                px++;
            }
        }
        else {
            xtop2(kdo,thetao,x,t,vis,vrmss,sint,nsamp,vi,xconst);
        }
    }
    else {
        memcpy(vis,vit,(int)(*nsamp*4));
        xtop2(kdo,thetao,x,t,vis,vrms,sint,nsamp, vi,xconst);
    }
}
void xtop2(kdo,thetao,x,t,vi,vrms,dt,n,vii,xconst)
long int *kdo;
float *thetao, *x, *t, *vi, *vrms, *dt, *vii, *xconst;
long int *n;
{
    double vrms2;
    double vi2, vi4, vi6;
    double x1,x2,x3,x4,x5,x6,x7,x8;
    double a1,a2,a3,a4,a5;
    double a22,a27,a210,a32;
    double c1,c2,c3,c4,c5,ddt,ax;
    double xx, div;

    float *pvi, *pp0, *pt, *pvrms;
    float *px, *pthetao, ltheta, parm, *v;

    register int i,k;

    static float pid2=1.570796326794897;

    ddt = (double)*dt;
    px = x;
    pthetao = thetao;

    for (k=0; k<*kdo; k++) {
        v = vii;
        a3 = 0;
        a4 = 0;
        a5 = 0;
        x1 = (double)*px;
        x2 = x1 * x1;
        x3 = x2 * x1;
        x4 = x3 * x1;
        x5 = x4 * x1;
        x6 = x5 * x1;
        x7 = x6 * x1;
        x8 = x7 * x1;

        pvi = vi;

        pt = t;
        pvrms = vrms;

        for (i=0; i<*n; i++) {

            a1 = *pt;
            vrms2 = (*pvrms) * (*pvrms);
            pvrms++;
            a2 = vrms2 * (*pt);

            /* check for time of zero then bump it up to next time */
            if (*pt++ == 0.) a2 = 1.;

            /* a2 squared, a2 to the seventh, a2 to the 10th */

            a22 = a2 * a2;
            a27 = a22 * a22 * a22 * a2;
            a210 = a27 * a22 * a2;

            vi2 = (*pvi) * (*pvi);
            vi4 = vi2 * vi2;
            vi6 = vi4 * vi2;

            a3 += vi4 * ddt;
            a32 = a3 * a3;
            a4 += vi6 * ddt;
            a5 += vi6 * vi2 * ddt;

            c1 = a1 * a1;
            c2 = 1. / vrms2;
            c3 = (a22 - a1*a3) / (4.*(a22*a22));
            c4 = (2.*a1*a32 - a1*a2*a4 - a22*a3) / (8.*a27);

            c5 = (24.*a1*a2*a3*a4 - 24.*a1*(a32*a3)
                - 5.*a1*a22*a5
                + 9.*a22*a32
                - 4.*(a22*a2)*a4) / (64.*a210);

            ax = c1 + 
                c2 * x2 + 
                c3 * x4 + 
                c4 * x6 + 
                c5 * x8;

            if (ax < 0.) xx = 1.;
            else xx = (c2 * x1 + 2. * c3 * x3
                    + 3. * c4 * x5 + 4. * c5 * x7) /
                    sqrt(ax) * (*pvi);

            if (xx < 1.0 && xx >= 0.0) ltheta = asin(xx);
            else ltheta = pid2;
            pvi++;
            div = (double)ltheta;
            if(*v == 0)fprintf(stderr," vi = 0\n");
            parm = sin(div)/(*v++);
            if (parm * (vii[0]) < 1.) {
             div = parm * vii[0];
             *pthetao++ = asin(div)* *xconst;
            }
            else 
             *pthetao++ = pid2* *xconst;
  
        }
        px++;
    }
}
