C***********************************************************************
C                 copyright 2001,2,3,4  Amoco Production Company       *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

C***************************MODSEL*************************************|
C                                                                 
C     PROGRAM - modsel
C                                                               
C                                                                     
C     ABSTRACT - Fit data to 2nd order polynomial and reconstruct
C                from the coefficients then select reflection mods
c                based on coefficients
C                                                                  
C
C******************************************************************
c      - reference  U.S. Patent #6,263,284, July 17, 2001
c                   Crider, R.L., Thomsen, L.A., Beaudoin, G.J
c
C******************************************************************

      implicit none

#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>

c standard USP variables


      integer LH, TH
      integer pipep, in_ikp


c variables used with dynamic memory allocation

      integer trhd 

      real vel_array, t_array, dx, sumtan, sumsin
      real data, angles, stack, quad
      real sig, vtrms, vsrms, vism, vit,Live
      real b0, b1, b2, envl, d0, d1, d2
      real rsqr

      pointer ( ptrhd, trhd(1) )
      pointer ( pc, vel_array(1) )
      pointer ( ptt, t_array(1) )
      pointer ( pdx, dx(1) )
      pointer ( pstan, sumtan(1) )
      pointer ( psin, sumsin(1) )
      pointer ( pdata, data(1) )
      pointer ( pang, angles(1) )
      pointer ( pstk, stack(1) )
      pointer ( pquad, quad(1) )
      pointer ( psig, sig(1) )
      pointer ( pvtrms, vtrms(1) )
      pointer ( pvsrms, vsrms(1) )
      pointer ( pvism, vism(1) )
      pointer ( pvit, vit(1) )
      pointer ( pLive, Live(1) )
      pointer ( pb0, b0(1) )
      pointer ( pb1, b1(1) )
      pointer ( pb2, b2(1) )
      pointer ( penvl,envl(1) )
      pointer ( pd0, d0(1) )
      pointer ( pd1, d1(1) )
      pointer ( pd2, d2(1) )
      pointer ( prsqr, rsqr(1) )


c local variables

      real coefs(6),errprm(5)
      real timvec(SZLNHD)
      real Ritr(SZLNHD),Vtrc(SZLNHD)
      real angb, ange
C                                                      
      CHARACTER name*6,title(17)*4
      character ntap*100,otap*100
      character vtap*100
C
      logical query,H,ikp,xt,veltape,save_residual,done,verbos,at
      logical robust, sa
c
      integer argis,luv
      integer irs, ire
      integer emerg,ray_mode,reject_mode
      integer itr(SZLNHD),vitr(SZLNHD)

c variables picked off by IMPLICIT NONE, memory allocation and access
c checking

      integer ier, ival, ithw, jerr, luin, nby
      integer ifmt_NumSmp, l_NumSmp, ln_NumSmp
      integer ifmt_SmpInt, l_SmpInt, ln_SmpInt
      integer ifmt_NumTrc, l_NumTrc, ln_NumTrc
      integer ifmt_NumRec, l_NumRec, ln_NumRec
      integer ifmt_Format, l_Format, ln_Format
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer ifmt_DstUsg, l_DstUsg, ln_DstUsg
      integer ifmt_DphInd, l_DphInd, ln_DphInd
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer nsamp, nsr, ntrc, nrec, iform, nsi, i, n4
      integer ntbyt, luout, jnrec, nout, jtbyt
      integer nvsamp, nsrv, ntrcv, nrecv, nsiv, j, nit
      integer ndx, irec, istat, k, ierr, idist, id2, jdx
      integer nv, iopt, np

      real const, th1, th2, rsqm, fact, delt, xy, xq
      real avang, chisq, vtmax, C, anmin, anmax, ang
      real stang2, stang1, a1p, a1n, s1p, s1n, a0p, a0n, s0p, s0n
      real ava0p, ava1p, ava0n, ava1n
      real t1h, t2h, a0l, a0h, a1l, a1h, a0, a1, a2
      real tang, sing, tang2, sing2, tangsing, xr, sgn, xx
      real rp

c dynamic memory allocation

      integer ner, iget

      real vsvpsqr

      pointer ( pvsvpsqr, vsvpsqr(1) )

c set equivalences

      equivalence(itr(1),Ritr(1))
      equivalence(vitr(1),Vtrc(1))

c initialize variables

      DATA name/'MODSEL'/
      DATA IER/0/
      data pipep/3/
      DATA title/6*'    ','AVO ','Reco','stru','ctio','n   ',6*'    '/
      ival = 0
      ithw = ITHWP1-1
      const = .0174533

c +---------------------------------------------------------+
c |     check for help flag.  If found, print help and quit |
c +---------------------------------------------------------+
      h = (argis('-H').gt.0).or.(argis('-h').gt.0)
      query= ((argis ('-?').gt.0).or.h)
      if (query) then
         call help(LER)
         stop
      endif

      ikp = .false.
      if(in_ikp().eq.1)ikp=.true.
#include <f77/open.h>
C               +------------------------------+
C               |       Begin Edit Phase       |
C               +------------------------------+
      xt = .true.
      call gcmdln(ntap,otap,vtap,irs,ire,ray_mode,angb,ange,at,
     :     reject_mode, save_residual,th1,th2, rsqm, verbos,
     :     name,LER,LERR)
 
      sa = .true.
      if(at)then
         xt=.false.
         sa=.false.
      endif
      if(ange.eq.0)ange=45
      if(irs.eq.0)irs=1
      if(ire.eq.0)ire = 999999
C
      fact = .00005
      if(xt.and.ray_mode.eq.-1)then
         ray_mode = 1
*      write(LER,*)' Ray tracing set to curved ray'
*      write(LERR,*)' Ray tracing set to curved ray'
      endif
c +=========================+
c |   print torch and oval  |
c +=========================+
      call gamoco(title,1,lerr) 
c +====================================+
c |   read line header from input data |
c +====================================+

      call getln(luin,ntap,'r',0)
      if(luin.lt.0)then
         write(LERR,*)'Unable to open ', ntap
         stop
      endif
      veltape = .false.
      if(xt)then
         if (ikp .AND. vtap(1:1).eq.' ') then
            call sisfdfit (luv, pipep)
         elseif (vtap(1:1).ne.' ') then
            call getln(luv,vtap,'r',-1)
            veltape = .true.
         else
            luv = -1
         endif
         if(luv.lt.0)then
            write(LERR,*)'Unable to open ', vtap
            write(LER, *)'Unable to open ', vtap
            call lbclos(luin)
            stop
         endif
      endif
      if (luin .eq. 0) call sislgbuf(luin,'off')
      nby = 0 
      call rtape(luin,itr,NBY)     
      if (nby.EQ.0) then         
         write(LERR,*)'No line header found on ntap. Fatal!'
         write(LER,*)'No line header found on ntap. Fatal!'
         call lbclos(luin)
         stop
      endif
C   get processing constants from line header
      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LINEHEADER)
      call savelu('SmpInt',ifmt_SmpInt,l_SmpInt,ln_SmpInt,LINEHEADER)
      call savelu('NumTrc',ifmt_NumTrc,l_NumTrc,ln_NumTrc,LINEHEADER)
      call savelu('NumRec',ifmt_NumRec,l_NumRec,ln_NumRec,LINEHEADER)
      call savelu('Format',ifmt_Format,l_Format,ln_Format,LINEHEADER)

      LH = LINEHEADER
      TH = TRACEHEADER
      call saver2(itr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsamp,LH)
      call saver2(itr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsr,LH)
      call saver2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc,LH)
      call saver2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrec,LH)
      call saver2(itr,ifmt_Format,l_Format,ln_Format,iform,LH)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
C
      if(nsr.gt.32)then
         nsi = nsr/1000
      else
         nsi = nsr
      endif
      delt = float(nsi)/1000.
      do i = 1,  nsamp
         timvec(i) = float(i) * delt
      end do
      n4 = 6
      call hlhprt (itr,NBY,name,n4, LERR)
      ntbyt = nsamp*iszbyt + sztrhd
                           
      call getln(luout,otap,'w',1)
      if(luout.lt.0)then
         write(LERR,*)'  Unable to open ',otap
         call lbclos(luin)
         stop
      endif
      if(ire.lt.999999.and.irs.gt.0)then
         jnrec=ire-irs+1
         call savew2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,jnrec,
     :        LINEHEADER)
      endif

      nout = ntrc
      call savew2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,nout,LINEHEADER)
      call savhlh(itr,nby,jtbyt)
      call wrtape(luout,itr,jtbyt)
c +==================================================+
c | get line header parameters for velocity data set |
c +==================================================+
      if(xt)then
         nby = 0
         call rtape(luv,vitr,nby)
         if(nby.eq.0)then
            write(lerr,*)
     :           'EOF on velocity data set reading header. FATAL'
            call lbclos(luin)
            call lbclos(luout)
            if(veltape)call lbclos(luv)
            stop
         endif
         call saver2(vitr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nvsamp,LH)
         call saver2(vitr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsrv,LH)
         call saver2(vitr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrcv,LH)
         call saver2(vitr,ifmt_NumRec,l_NumRec,ln_NumRec,nrecv,LH)
         if(nsrv.gt.32)then
            nsiv = nsrv/1000
         else
            nsiv = nsrv
         endif
         if((nvsamp.ne.nsamp).or. (nsiv  .ne. nsi))then
            write(LERR,*)
     :           ' Velocity dataset not compatible with input. Must have
     :           same'
            write(LERR,*)
     :           ' number samples and sample interval. FATAL!'
            write(LER,*)
     :           ' Velocity dataset not compatible with input. Must have
     :           same'
            write(LER,*)
     :           ' number samples and sample interval. FATAL!'
            call lbclos(luin)
            call lbclos(luout)
            if(veltape)call lbclos(luv)
            stop
         endif
      endif

C +==================================+
C |   allocate the required memory   |
C +==================================+
      ier = 0
      ner = 0
      iget =nsamp * ntrc * ISZBYT
      call galloc(pdata,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(penvl,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pang, iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pstk  ,iget,ier,0)
      if(ier.ne.0)ner = ner+1

      iget= nsamp*ISZBYT
      call galloc(pquad ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pLive ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pb0   ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(prsqr ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pb1   ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pb2   ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pd0   ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pd1   ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pd2   ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(psig  ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvtrms,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvsrms,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvism ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pvit  ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(pc    ,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(ptt,iget,ier,0)
      if(ier.ne.0)ner=ner+1
      call galloc(pstan ,iget,ier,0)
      if(ier.ne.0)ner = ner+1
      call galloc(psin  ,iget,ier,0)
      if(ier.ne.0)ner=ner+1

c galloc added after memory and access checking

      call galloc(pvsvpsqr  ,iget,ier,0)
      if(ier.ne.0)ner=ner+1

      iget = ITRWRD * ntrc * ISZBYT
      call galloc(ptrhd,iget,ier,0)
      if(ier.ne.0)ner = ner+1

      iget = ntrc*ISZBYT
      call galloc(pdx,iget,ier,0)
      if(ier.ne.0)ner=ner+1

      if(ner.ne.0)then
         write(LERR,*)' Memory allocation failed.  FATAL'
         call lbclos(luin)
         call lbclos(luout)
         stop
      endif

      write(LERR,*)' AGNS Processing Parameters :'
      write(LERR,'(a,i5)')'Start Record ...............',irs
      write(LERR,'(a,i5)')'End Record .................',ire
      if(xt)then
      write(LERR,'(a,i5)')'Mode........................',ray_mode
      write(LERR,'(a   )')'     0 = Straight Ray'
      write(LERR,'(a   )')'     1 = Curved Ray'
      write(LERR,'(a   )')'     2 = Perturbed Curved Ray'
      endif
      write(LERR,'(a,f5.1)')'Start Angle.................',angb
      write(LERR,'(a,f5.1)')'End Angle...................',ange
C               +---------------------------------+
C               |       Begin Process Phase       |
C               +---------------------------------+
c +=================================+
c | Convert limit angles to radians |
c +=================================+
      angb=angb*const
      ange=ange*const
c +=================+
c | go get the data |      
c +=================+
      if(irs.gt.1)then
         do i=1,irs-1
            do j=1,ntrc
               nit = 0
               call rtape(luin,itr,nit)
               if(nit.eq.0)then
                  write(LER,*)'EOF on input trying to find rs. Fatal!'
                  write(LERR,*)' EOF on input trying to find rs. Fatal!'
                  call lbclos(luin)
                  call lbclos(luout)
                  stop
               endif
            end do
            if(nrecv.gt.1.and.xt)then
               nit = 0
               call rtape(luv,vitr,nit)
               if(nit.eq.0)then
                  write(LER,*)'EOF on velocity data set. FATAL!'
                  write(LERR,*)' EOF on velocity data set. FATAL!'
                  call lbclos(luin)
                  call lbclos(luout)
                  if(veltape)call lbclos(luv)
                  stop
               endif
            endif
         end do
      endif
c +==========================+
c | If have only 1 velocity  |
c | record, read it up front |
c +==========================+
      if(nrecv.eq.1.and.xt)then
         nit = 0
         call rtape(luv,vitr,nit)
         if(nit.eq.0)then
            write(LER,*)'EOF on velocity data set. FATAL!'
            write(LERR,*)' EOF on velocity data set. FATAL!'
            call lbclos(luin)
            call lbclos(luout)
            if(veltape)call lbclos(luv)
            stop
         endif
      end if
c +=================+
c |  Process data   |
c +=================+
      do i=1,nsamp
         b0(i)=0.
         b1(i)=0.
         b2(i)=0.
         quad(i)=0.
      end do
      do j=0,ntrc-1
         ndx=j*nsamp
         do i=1,nsamp
            stack(ndx+i)=0.
            angles(ndx+i)=0.
         end do
      end do
      DO WHILE (irs.le.ire)
         do j=1,ntrc
            nby = 0   
            CALL rtape (luin,itr,nby)
            if (nby.eq.0) then
               call lbclos(luin)
               call lbclos(luout)
               if(veltape)call lbclos(luv) 
               stop
            endif
            call saver2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,irec,TH)
            call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,istat,TH)
            ndx = (j-1)*nsamp
            if(istat.ge.30000)then
               do k=1,nsamp
                  data(ndx+k)=0.
                  envl(ndx+k)=0.
               end do
            else
               call hilbertx(Ritr(ithw+1),nsamp,quad,ierr)
               do k=1,nsamp
                  xy = Ritr(ithw+k)
                  xq = quad(k)
                  data(ndx+k)=xy*xy+xq*xq
                  data(ndx+k)=sqrt(data(ndx+k))
                  if(xy.eq.0.0)data(ndx+k)=0.
                  envl(ndx+k)=xy
               end do
            endif
            call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,idist,TH)
            call saver2(itr,ifmt_DstUsg,l_DstUsg,ln_DstUsg,id2,TH)
            if(xt)then
               idist = iabs(idist)
               dx(j) = idist
            else
               avang = (idist+id2)/2.*const
               do k=1,nsamp
                  angles(ndx+k)=avang
               end do
            endif
            jdx = (j-1)*ITRWRD
            do k=1,ITRWRD
               trhd(jdx+k)=itr(k)
            end do
         end do
c +=====================================================+
C | Get the local velocity function if X-T domain input |
c +=====================================================+
         if(xt) then
            if(nrecv.gt.1)then
               nby=0
               call rtape(luv,vitr,nby)
               if(nby.eq.0)then
                  write(lerr,*)' EOF on velocity file. FATAL.'
                  call lbclos(luin)
                  call lbclos(luout)
                  if(veltape)call lbclos(luv)
                  stop
               endif
            endif
            nv=nsamp
            do i=1,nv
               vel_array(i)=Vtrc(ITHWP1+i-1)
               t_array(i)=i*delt
            end do
            do i=1,nsamp
               sig(i)=1.0
            end do
            chisq = 0.
c +======================================================+
c | Resample the input velocity field to something more  |
c | manageable by the lsq routine in fitvel, then call   |
c | fitvel to get the rms, interval, smoothed rms, and   | 
c | smoothed interval velocities (vtrms, vit, vsrms,     |
c | and vism, respectively)                              |
c +======================================================+
            call sloper(t_array, vel_array, nv,fact)
            call fitvel(t_array, vel_array, nv,nsamp, delt, coefs,
     :           sig,chisq,vtrms,vsrms,vism, vit,jerr)
            if(jerr.ne.0)then
               write(lerr,*)' Error allocating memory in getvel. FATAL.'
               write(ler,*)' Error allocating memory in getvel. FATAL.'
               call lbclos(luin)
               call lbclos(luout)
               if(veltape)call lbclos(luv)
               stop
            endif
         endif
c +=======================================+
c | Go compute the angles and do stacking |
c +=======================================+
         if(xt)then
            do i=1,nsamp*ntrc
               angles(i)=0.
            end do
            vtmax = (nsamp-1)*delt
            call GetAngleMatrix(nsamp, coefs, angles, dx,ntrc,delt,
     :           timvec,vtrms,ray_mode,emerg,vtmax,vsrms,vism,vit,ier,
     :           errprm)
            if(ier.ne.0)then
               call lbclos(luin)
               call lbclos(luout)
               if(veltape)call lbclos(luv)
               write(LERR,'(a,i5)')
     :              ' Fatal Error in Velocity Function for Record',irec
               write(LERR,'(a,f8.3,a)')
     :              ' Found imaginary interval velocity at ',errprm(5),
     :              ' seconds.'
               write(LERR,'(a,f10.0,a,f8.3)')
     :              ' V2 = ',errprm(1),' T2 = ',errprm(3)
               write(LERR,'(a,f10.0,a,f8.3)')
     :              ' V1 = ',errprm(2),' T1 = ',errprm(4)
               write(LERR,*)' coefs'
               call writer(coefs,6,1,LERR)
               write(LERR,*)'vsrms '
               call writer(vsrms,nsamp,1,LERR)
               write(LERR,*)'vism '
               call writer(vism,nsamp,1,LERR)
               write(LERR,*)'vit '
               call writer(vit,nsamp,1,LERR)
               stop
            endif
         endif
c +-------------------------------------------------------+
c | create the B0, B1, and B2 attributes, 3-component     |
c +-------------------------------------------------------+
         iopt=4
         robust = .false.
         np = 3
         call solver(nsamp,ntrc, data, vsvpsqr,b0,b1,b2,
     :        angles, angb,ange, np, rsqr, iopt,C,sa,robust,ierr)
c +============================================+
c | Find the integral of sin^2 and tan^2*sin^2 |
c | over the appropriate angle band for each   |
c | time sample.                               |
c | The integral of tan^2*sin^2 is             |
c | -3/2*X + tan(X) +1/4*sin(2X)               |
c | The integral of sin^2 is                   |
c |  -1/2 sin(X)cos(X) + 1/2*X                 |
c +============================================+
         do k=1,nsamp
            anmin = const*90.
            anmax = 0.
            do j=1,ntrc
               ndx=(j-1)*nsamp+k
               ang=angles(ndx)
               xy = envl(ndx)
               if(ang.ge.angb.and.ang.le.ange.and.xy.ne.0.0)then
                  if(ang.le.anmin)anmin=ang
                  if(ang.ge.anmax)anmax=ang
               endif
            end do
            stang2 = -1.5*anmax + tan(anmax)+0.25*sin(2.*anmax)
            stang1 = -1.5*anmin + tan(anmin)+0.25*sin(2.*anmin)
            sumtan(k)=stang2-stang1
            stang2 = -0.5*sin(anmax)*cos(anmax)+0.5*anmax
            stang1 = -0.5*sin(anmin)*cos(anmin)+0.5*anmin
            sumsin(k)=stang2-stang1
         end do
c +=========================+
c | Build predicted data    |
c | and check for rejection |
c | proceedings             |
c +=========================+
         a1p = 0.
         a1n = 0.
         s1p = 0.
         s1n = 0.
         a0p = 0.
         a0n = 0.
         s0p = 0.
         s0n = 0.
c +=================================+
c | get average (+ and -) b0 and b1 |
c +=================================+
         do k=1,nsamp
            if(b1(k).gt.0.)then
               a1p=a1p+b1(k)
               s1p = s1p+1.
            else
               a1n=a1n+b1(k)
               if(b1(k).ne.0.0)s1n=s1n+1.
            endif
            if(b0(k).gt.0.)then
               a0p=a0p+b0(k)
               s0p = s0p+1.
            else
               a0n=a0n+b0(k)
               if(b0(k).ne.0.0)s0n=s0n+1.
            endif
         end do
         if(s1p.ne.0.0)then
            a1p=a1p/s1p
         else
            a1p = 0.
         end if
         if(s1n.ne.0.0)then
            a1n=a1n/s1n
         else
            a1n = 0.
         end if
         if(s0p.ne.0.0)then
            a0p=a0p/s0p
         else
            a0p = 0.
         end if
         if(s0n.ne.0.0)then
            a0n=a0n/s0n
         else
            a0n = 0.
         end if
c +==================================+
c | ava0p is the average positive a0 |
c | ava1p is the average positive a1 |
c | ava0n is the average negative a0 |
c | ava1n is the average negative a1 |
c +==================================+
         ava0p = a0p
         ava1p = a1p
         ava0n = a0n
         ava1n = a1n
         if(verbos)then
            write(LERR,*)' avg positive b0 =',ava0p,
     :           ' avg positive b1 = ',ava1p
            write(LERR,*)' avg negative b0 =',ava0n,
     :           ' avg negative b1 = ',ava1n
         endif
c +=================================================+
c | The reflection rejection process is based on    |
c | the intercept value only, the slope value only, |
c | a combination of both, or the "goodness of fit" |
c | parameter r^2.  If the intercept is             |
c | more than th1 % less than the average a0n or is |
c | greater than th1% more than the average a0p, the|
c | sample is either spatially zero'd or set to the |
c | residual between the fitted value and the       |
c | original value. Same checks for slope and the   |
c | combination, depending on value of reject flag, |
c | except using th2 for slope                      |
c | Otherwise, if the r^2 for this sample is less   |
c | than a specified mean, the sample will be eithe |
c | zero'd or set to residual                       |
c +=================================================+
         t1h = (1. + th1)
         t2h = (1. + th2)
         a0l = ava0n*t1h
         a0h = ava0p*t1h
         a1l = ava1n*t2h
         a1h = ava1p*t2h
         do i=1,nsamp
            a0 = b0(i)
            a1 = b1(i)
            a2 = b2(i)
            do j=1,ntrc
               ndx = (j-1)*nsamp+i
               ang = angles(ndx)
               tang = tan(ang)
               sing = sin(ang)
               rp = 0.
               if(ang.ge.angb.and.ang.le.ange)then
                  tang2 = tang*tang
                  sing2 = sing*sing
                  tangsing=tang2*sing2
                  rp = a0 + a1*sing2 + a2*tangsing
                  xr = data(ndx)
                  if(xr.eq.0.0)rp = 0.
                  if(reject_mode.ne.0)then
                     if(reject_mode.eq.1)then
                        done = .false.
                        if((a0.lt.0.and.a0.lt.a0l).or.
     :                       (a0.gt.0..and.a0.gt.a0h))then
                           if(save_residual)then
                              rp = xr - rp
                           else
                              rp = 0.
                           endif
                        endif
                     endif
c
                     if(reject_mode.eq.2)then
                        done = .false.
                        if((a1.lt.0.and.a1.lt.a1l).or.
     :                       (a1.gt.0..and.a1.gt.a1h))then
                           if(save_residual)then
                              rp = xr - rp
                           else
                              rp = 0.
                           endif
                        endif
                     endif
c
                     if(reject_mode.eq.3)then
                        done = .false.
                        if(((a1.lt.0.and.a1.lt.a1l).or.
     :                       (a1.gt.0..and.a1.gt.a1h)).or.
     :                       ((a0.lt.0.and.a0.lt.a0l).or.
     :                       (a0.gt.0..and.a0.gt.a0h)))then
                           if(save_residual)then
                              rp = xr - rp
                           else
                              rp = 0.
                           endif
                        endif
                     endif
c
                     if(reject_mode.eq.4)then
                        done = .false.
                        if(rsqr(i).lt.rsqm)then
                           if(save_residual)then
                              rp = xr - rp
                           else
                              rp = 0.
                           endif
                        endif
                     endif
                  endif
               endif
               stack(ndx)=rp
            end do
         end do
c +-----------------+
c | Output the data |
c +-----------------+
c +====================================+
c | Note: envl holds the original data |
c +====================================+
         do i = 1,nout
            ndx = (i-1)*nsamp
            do k=1,nsamp
               sgn = sign (1.0, envl(ndx+k))
               xx = stack(ndx+k)*envl(ndx+k)
               Ritr(ithw+k) = sgn * sqrt ( abs(xx) )
            end do
            jdx = (i-1)*ITRWRD
            do k=1,ITRWRD
               itr(k)=trhd(jdx+k)
            end do
            call wrtape(luout,itr,ntbyt)
         end do   
         irs = irs+1
      ENDDO

      call lbclos(luin)                   
      call lbclos(luout)                   
      if(xt.and.veltape)call lbclos(luv)
      stop
      END                                                    

      subroutine gcmdln(ntap,otap,vtap,rs,re,ray_mode,angb,ange,at,
     :reject_mode, save_residual,th1,th2,rsqm, verbos,
     :name,LER,LERR)
      character ntap*(*), otap*(*), vtap*(*),name*(*)
      character mdc*2
      logical at,save_residual,verbos
      integer rs, re,argis,ray_mode,reject_mode
c                                                         
      call argstr ('-N',ntap,' ',' ')          
      call argstr ('-O',otap,' ',' ')            
      vtap = ' '
      call argstr ('-v',vtap,' ',' ')
      call argi4('-rs', rs, 0,0)
      if(rs.eq.0)rs=1
      call argi4('-re', re, 0,0)
      call argstr('-md',mdc,' ',' ')
      if(mdc.eq.'0'.or.mdc.eq.'1'.or.mdc.eq.'2')then
        read(mdc,'(I1)')ray_mode
      else
        ray_mode = -1
      endif
      if(ray_mode.gt.2)ray_mode = 0
      call argr4('-as',angb,0.0,0.0)
      call argr4('-ae',ange,0.0,0.0)
      at = (argis('-at').gt.0)
      save_residual=(argis('-sre').gt.0)
      call argi4('-rj',reject_mode,0,0)
      call argr4('-t1',th1,50.0,50.0)
      call argr4('-t2',th2,50.0,50.0)
      th1 = th1/100.
      th2 = th2/100.
      if (th1.eq.0.)th1=0.50
      if (th2.eq.0.)th2=0.5
      call argr4('-rsqm',rsqm,0.6,0.6)
      verbos = (argis('-V').gt.0)
C **********************************************************************
C ***** check for extraneous arguments and abort if found **************
C ***** (catch all manner of user typo's) ******************************
C **********************************************************************

      call xtrarg (name, LER, .FALSE., .FALSE.)
      call xtrarg (name, LERR, .FALSE., .TRUE.)
      return                                                  
      end

      subroutine help(LER)
          write(LER,*)  
     :'***************************************************************'
         write(LER,*)
     :'Program modsel........................Reflection Mode Selection'
      call describe
      write(LER,*)' '                                             
      write(LER,*)                                               
     :' -N[ntap]    (default = stdin)  : Input data file name'   
      write(LER,*)                                             
     :' -O[otap]    (default = stdout) : Output data file name'
      write(LER,*)                                             
     :' -v[vtap]    (required for XT)  : RMS velocity (Vp) file'   
      write(LER,*)
     :' -rs[irs]  (default = first)    : Starting sequential record'
      write(LER,*)
     :' -re[ire]  (default = last)     : Ending sequential record'
      write(LER,*)
     :' -as[as]      (default = 0)     : Beginning angle for compute'
      write(LER,*)
     :' -ae[ae]      (default = 45)    : Ending angle for compute'
      write(LER,*)
     :' -md[mode] (default = 1 for     : Solution flag for angle comp.'
      write(LER,*)
     :'                                  in XT-domain'
      write(LER,*)
     :'            XT-domain input)      0 = Straight Ray'
      write(LER,*)
     :'                                  1 = Curved Ray'
      write(LER,*)
     :'                                  2 = Perturbed Curved Ray'
      write(LER,*)
     :' -at         (default =  no)    : If present, input data is'
      write(LER,*)
     :'                                  Angle-T domain instead of X-T'
      write(LER,*)                
     :'-t1[]        (default = 0.50)   : Intercept threshold, as'
      write(LER,*)
     :'                                  fraction of temporal average '
      write(LER,*)
     :'                                  intercept value'
      write(LER,*)                
     :'-t2[]        (default = 0.50)   : Slope threshold, as fraction'
      write(LER,*)
     :'                                  of temporal average '
      write(LER,*)
     :'                                  slope value'
      write(LER,*)
     :' -rj         (default =  0)     : Reflectivity selection mode'
      write(LER,*)
     :'                                  0 = All spatially random '
      write(LER,*)
     :'                                      events rejected      '
      write(LER,*)
     :'                                  1 = reject by selection '
      write(LER,*)
     :'                                      according to intercept'
      write(LER,*)
     :'                                      threshold'
      write(LER,*)
     :'                                  2 = reject by selection '
      write(LER,*)
     :'                                      according to slope'
      write(LER,*)
     :'                                      threshold'
      write(LER,*)
     :'                                  3 = reject by selection '
      write(LER,*)
     :'                                      according to BOTH slope'
      write(LER,*)
     :'                                      and intercept threshold'
      write(LER,*)
     :'                                  4 = reject if R^2 is less '
      write(LER,*)
     :'                                      than the min specified '
      write(LER,*)
     :'                                      below (-rsqm)'
      write(LER,*)
     :' -rsqm       (default = 0.6)    : Minimum acceptable R^2 value'
      write(LER,*)
     :' -sre        (default =  0)     : If present, rejected data are'
      write(LER,*)
     :'                                  replaced with residual between'
      write(LER,*)
     :'                                  estimated and original data.'
      write(LER,*)
     :'                                  Otherwise, it is set to 0.'
      write(LER,*)
     :'-V                               : If present, print average '
      write(LER,*)
     :'                                 : b0/b1'
      write(LER,*)' '
      write(LER,*)                                        
     :'Usage:  ',                                         
     :' modsel -N[] -O[] -v[] -rs[] -re[] -as[] -ae[] -md[] -xt '
      write(LER,*)
     :' -rj[] -t1[] -t2[] -sre -V'
      return                                                          
      end                                                            
