C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine realft(data,n,isign)

      integer n,isign

      real data(*)

      real*8 wr,wi,wpr,wpi,wtemp,theta
      theta = 3.141592653589793D0/dble(n)
      c1=0.5

      if(isign.eq.1)then

         c2=-0.5
         call four1(data,n,+1)

      else

         c2=0.5
         theta=-theta

      endif

      wpr=-2.0d0*dsin(0.5d0*theta)**2
      wpi=dsin(theta)
      wr=1.0d0+wpr
      wi=wpi
      n2p3=2*n+3

      do i=2,n/2

         i1=2*i-1
         i2=i1+1
         i3=n2p3-i2
         i4=i3+1
         wrs=sngl(wr)
         wis=sngl(wi)
         h1r=c1*(data(i1)+data(i3))
         h1i=c1*(data(i2)-data(i4))
         h2r=-c2*(data(i2)+data(i4))
         h2i=c2*(data(i1)-data(i3))
         data(i1)=h1r+wrs*h2r-wis*h2i
         data(i2)=h1i+wrs*h2i+wis*h2r
         data(i3)=h1r-wrs*h2r+wis*h2i
         data(i4)=-h1i+wrs*h2i+wis*h2r
         wtemp=wr
         wr=wr*wpr-wi*wpi+wr
         wi=wi*wpr+wtemp*wpi+wi

      enddo

      if(isign.eq.1)then

         h1r=data(1)
         data(1)=h1r+data(2)
         data(2)=h1r-data(2)

      else

         h1r=data(1)
         data(1)=c1*(h1r+data(2))
         data(2)=c1*(h1r-data(2))
         call four1(data,n,-1)

      endif
      
      return
      end
         
