C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  mvstak  n  Data Sets
C
C**********************************************************************C
C
C MVSTAK READS SEISMIC TRACE DATA FROM N INPUT FILES,
C and vertically stacks the traces from each, trace-by-trace, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, savhlh, saver, savew
C
C**********************************************************************C
C
C     DECLARE VARIABLES
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD ),luin(1000)
      INTEGER     SHED( SZLNHD )
      INTEGER     NSAMP(1000), NSI, NTRC(1000), NREC(1000), IFORM
      INTEGER     LUOUT, LBYTES, NBYTES,obytes
      integer     argis, pipes(1000), pipcnt, pmax

      real        xtr (SZLNHD)
      integer     itrhdr
      real        sum
      pointer     (wkadr,    sum(1))
      pointer     (wkadi, itrhdr(1))

#include <f77/pid.h>
      CHARACTER   NAME * 6, otap * 256, ftap * 256
      character   ntap(1000)*256, oper*1000
      logical     verbos, heap, traces, query, first, filein, norm
C
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'MVSTAK'/
      DATA  LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /
      data verbos/.false./
      data first/.false./

C**********************************************************************C
C     get help if necessary
C**********************************************************************C
      query = (argis('-?') .gt. 0)
      if(query) then
        call help()
        stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     get commandline arguments
C**********************************************************************C
      call cmdln(ntap,otap,nu,verbos,traces,oper,pmax,
     1           filein,ftap,norm)

      pipes(1) = 0
      luin(1)  = 0
      do  i = 2, pmax
          pipes(i) = i + 1
      enddo


      write(LER,*)'pmax, nu= ',pmax, nu
C**********************************************************************C
C     open logical i/o units
C**********************************************************************C
      IF (nu .ne. 0) THEN
         do 1 i = 1, nu
            call getln(luin(i),ntap(i),'r',0)
            if(luin(i) .eq. 0) then
               write(LERR,*)'Data set cannot be a pipe'
               write(LERR,*)'check command line args & rerun'
               stop
            endif
1        continue
      ELSE
         nu = pipcnt (pipes,pmax)
c
c - if pmax was unlimited, program printout also got counted
c
         if (pmax .eq. 1000) nu = nu - 1
         write(LER,*)'Number of pipes found= ',nu
         write(LER,*)'socket numbers:'
         write(LER,*)(pipes(i),i=1,nu)

         if (nu .gt. 1000) then
               write(LERR,*)'Cannot have more then 1000 inputs'
               write(LERR,*)'You have  ',nu,'  inputs'
               stop
         endif
         do 2 i = 2, nu
            if ( pipes(i) .eq. 0) then
              luin(i) = 0
            else
              call sisfdfit (luin(i), pipes(i))
            endif
            write(LERR,*)'MVSTAK: got fortran unit number= ',luin(i),
     1          ', socket = ',pipes(i)
2        continue
      ENDIF

      do iu = 1, nu
         write(LERR,*)' '
         write(LERR,*)'Opened input unit = ',luin(iu),' for file= ',
     1   ntap(iu)
      enddo

      loper = lenth (oper)
      if (loper .eq. 1) then
          do  i = 2, nu
              oper (i:i) = oper (1:1)
          enddo
      endif
      do  i = 1, nu-1
          if (norm) then
            if (oper(i:i) .ne. '+') then
            write(LERR,*)'FATAL ERROR in mvstak:'
            write(LERR,*)'Normalization -norm option requires all summa
     1tion, i.e. all +'
            stop
            endif
          endif
      enddo

      call getln(luout, otap, 'w', 1)
 
C**********************************************************************C
C     read line headers of input data sets
C     get critical values from line header
C**********************************************************************C
      do 12 i = 1, nu
          lbytes=0
          CALL RTAPE  ( LUIN(i), ITR, LBYTES                  )
          if(lbytes .eq. 0) then
             write(LERR,*)'MVSTAK: no header read on unit ',luin(i)
             write(LERR,*)'FATAL'
             stop
      endif
      call saver(itr, 'NumSmp', nsamp(i) ,  LINHED)
      call saver(itr, 'SmpInt', nsi      ,  LINHED)
      call saver(itr, 'NumTrc', ntrc(i)  ,  LINHED)
      call saver(itr, 'NumRec', nrec(i)  ,  LINHED)
      call saver(itr, 'Format', iform    ,  LINHED)
      CALL HLHprt ( ITR , LBYTES, NAME, 6, LERR        )
   12 continue

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)


c+++++++++++++++++++++++++++++++++++

      do  20  i = 2, nu

          nr = nsamp(i)/nsamp(1)
          if (nr .ne. 1) then
             write(LERR,*)'FATAL ERROR in mvstak:'
             write(LERR,*)'Input # samples not alike for DSN N',i-1
             write(LERR,*)'Upstream processing needs to be restructured'
             stop
          endif
          nr = ntrc(i)/ntrc(1)
          if (nr .ne. 1) then
             write(LERR,*)'FATAL ERROR in mvstak:'
             write(LERR,*)'Input # traces not alike for DSN N',i-1
             write(LERR,*)'Upstream processing needs to be restructured'
             stop
          endif
          nr = nrec(i)/nrec(1)
          if (nr .ne. 1) then
             write(LERR,*)'FATAL ERROR in mvstak:'
             write(LERR,*)'Input # records not alike for DSN N',i-1
             write(LERR,*)'Upstream processing needs to be restructured'
             stop
          endif
20    continue
      ntrcc  = ntrc(1)
      nrout  = nrec(1)
      nsampo = nsamp(1)
      call savew( itr, 'NumTrc', ntrcc , LINHED)
      call savew( itr, 'NumRec', nrout , LINHED)
      obytes = SZTRHD + SZSMPD * nsampo
 
c---------------------------------------------------
c  malloc only space we're going to use
      heap  = .true.

      if (traces) then
          item  =         nsampo * SZSMPD
          itemi =         ITRWRD * SZSMPD
      else
          item  = (ntrcc + 1) * nsampo * SZSMPD
          itemi = (ntrcc + 1) * ITRWRD * SZSMPD
      endif

c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 1  (allocation succeeded)
c     errcod = 0  (allocation failed)
c--------
 
      call galloc (wkadi, itemi, errcd, abort)
      if (errcd .ne. 0.) heap = .false.

      call galloc (wkadr, item , errcd, abort)
      if (errcd .ne. 0.) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------


      if (norm) then
         scl = 1. / float (nu)
      else
         scl = 1.
      endif

C**********************************************************************C
C     write to printout file
C**********************************************************************C
      write(LERR,*)' '
         write(LERR,*)
         write(LERR,*)' Values read from input data set line header'
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp(1)
         write(LERR,*) ' Sample Interval    =  ', nsi  
         do 17 i=1,nu
            write(LERR,*) ' Traces per Record = ', ntrc(i),' NTAP= ',
     1                 ntap(i),'   Records= ',nrec(i)
   17    continue
         write(LERR,*)' New traces/record = ',ntrcc,' OTAP= ',otap
         write(LERR,*)' New samples/trace= ',nsampo
         write(LERR,*)' Output Records per Line   =  ', nrout 
         write(LERR,*)' Output Traces per Rec     =  ', ntrcc
         write(LERR,*)' Format of Data     =  ', iform
         if (traces) then
         write(LERR,*)' Input trace oriented'
         else
         write(LERR,*)' Input record oriented'
         endif
         write(LERR,*)'Operands:'
         write(LERR,*)(oper(i:i),i=1,nu-1)
      write(LERR,*)' '
c     call flush (LERR)     - jmw - not portable - 4/20/93

C**********************************************************************C
C     write to printout file
C**********************************************************************C
      call savhlh(itr,lbytes,lbyout)
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )

C**********************************************************************C
C     READ TRACES, SUM, WRITE TO OUTPUT FILE
C**********************************************************************C


      IF (traces) THEN

      DO 100 JJ = 1, nrout

         DO 99 KK = 1, ntrcc

            call vclr (sum, 1, nsampo)


            first = .false.
            do 55 iu = 1, nu

               nbytes = 0
               CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                         ' DSN= ',ntap(iu)
                  go to 999
               endif
               call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)
               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istatic, TRACEHEADER)
               if (.not. first .AND. istatic .ne. 30000) then
                  first = .true.
                  call move (1, shed, lhed, nbytes)
               endif

              if(verbos) then
                  call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        irec   , TRACEHEADER)
                  call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        itrc   , TRACEHEADER)

              write(LERR,*)'LUIN= ',luin(iu),' Rec= ',irec,' Trace= ',
     1        itrc
              endif

              iu1 = iu - 1

              IF (iu .eq. 1) THEN

                 do  i = 1, nsampo
                     sum (i) = xtr (i)
                 enddo

              ELSE

                 if     (oper(iu1:iu1) .eq. '*') then
                            do  i = 1, nsampo
                                sum (i) = sum (i) * xtr (i)
                            enddo
                 elseif (oper(iu1:iu1) .eq. '/') then
                            do  i = 1, nsampo
                                xtri = xtr (i)	
                                if (abs(xtri) .gt. 1.e-30)
     1                          sum (i) = sum (i) / xtri
                            enddo
                 elseif (oper(iu1:iu1) .eq. '+') then
                            do  i = 1, nsampo
                                sum (i) = sum (i) + xtr (i)
                            enddo
                 elseif (oper(iu1:iu1) .eq. '-') then
                            do  i = 1, nsampo
                                sum (i) = sum (i) - xtr (i)
                            enddo
                 endif

              ENDIF


55          continue

            if (first) then
               call move (1, lhed, shed, nbytes)
            endif

            call vsmul (sum, 1, scl, lhed(ITHWP1), 1, nsampo)
            call wrtape (luout, itr, obytes)

99       continue


100   CONTINUE

      ELSE

      DO 200 JJ = 1, nrout

         call vclr (sum, 1, nsampo*ntrcc)
         ic = 0

         DO 199 iu = 1, nu

            do 155 kk = 1, ntrc(iu)
               nbytes = 0
               CALL RTAPE  ( LUIN(iu) , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk,
     1                         ' DSN= ',ntap(iu)
                  go to 999
               endif
               call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)

              if(verbos) then
                  call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        irec   , TRACEHEADER)
                  call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        itrc   , TRACEHEADER)

              write(LERR,*)'LUIN= ',luin(iu),' Rec= ',irec,' Trace= ',
     1        itrc,' iu= ',jj,iu,kk
              endif


c---------
c read in input record for each input
c unit, store trc hdrs for unit 1
c---------
              ishdr = (kk-1) * ITRWRD
              istrc = (kk-1) * nsampo

              iu1 = iu - 1

              IF (iu .eq. 1) THEN

                 call vmov (lhed,1, itrhdr(ishdr+1),1,ITRWRD)
                 do  i = 1, nsampo
                     sum (istrc+i) = xtr (i)
                 enddo

              ELSE

                 if     (oper(iu1:iu1) .eq. '*') then
                            do  i = 1, nsampo
                                sum (istrc+i) = sum (istrc+i) * xtr (i)
                            enddo
                 elseif (oper(iu1:iu1) .eq. '/') then
                            do  i = 1, nsampo
                                xtri = xtr (i)
                                if (abs(xtri) .gt. 1.e-30)
     1                          sum (istrc+i) = sum (istrc+i) / xtri
                            enddo
                 elseif (oper(iu1:iu1) .eq. '+') then
                            do  i = 1, nsampo
                                sum (istrc+i) = sum (istrc+i) + xtr (i)
                            enddo
                 elseif (oper(iu1:iu1) .eq. '-') then
                            do  i = 1, nsampo
                                sum (istrc+i) = sum (istrc+i) - xtr (i)
                            enddo
                 endif

              ENDIF

155         continue


199      continue

         do 156 kk = 1, ntrcc

            istrc = (kk-1) * nsampo
            ishdr = (kk-1) * ITRWRD
            call vmov (itrhdr(ishdr+1), 1, lhed, 1, ITRWRD)
            call vmov (sum(istrc+1), 1, xtr, 1, nsampo)
            call dotpr (xtr, 1, xtr, 1, dots, nsampo)
            dots = sqrt (dots / float(nsampo) )
            if (dots .le. 1.e-30) then
               call vclr (xtr, 1, nsampo)
               call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     30000  , TRACEHEADER)
            else
               call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     0      , TRACEHEADER)
            endif

            call vsmul (xtr, 1, scl, lhed(ITHWP1), 1, nsampo)
            call wrtape (luout, itr, obytes)

156      continue

200   CONTINUE

      ENDIF

999   continue

c-------------------------------------------------------------
c     close all open units
c-------------------------------------------------------------
      do 21 i=1,nu
         if(verbos)write(LERR,*)'Closing unit ',i
         call lbclos(luin(i))
   21 continue
        call lbclos(luout)
         if(verbos)write(LERR,*)'Closing output unit '
      END

      subroutine help
#include <f77/iounit.h>
 
c----------------------------------------------------------------------
c       help panel
c----------------------------------------------------------------------
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for mvstak: merg ndata sets'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'Direct cmd line input of file names...'
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-N[ntap]   -- input data set 1'
        write(LER,*)' ...            ... (n of them)'
        write(LER,*)'-N[ntap]   -- input data set n (max 1000 allowed)'
        write(LER,*)'              will be operated on in same order'
        write(LER,*)'              as they appear on cmd line'
        write(LER,*)'... or'
        write(LER,*)'-F[ftap]   -- file of input file names, one per lin
     1e'
        write(LER,*)' '
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)' '
        write(LER,*)'-oper[oper]-- string containing operands (+,-,*,/)'
        write(LER,*)'              should be [n-1] enclosed in double'
        write(LER,*)'              or single quotes, eg  "++-*/*++--+" '
        write(LER,*)'              Default = "+" (applied throughout)'
        write(LER,*)'-P[num]   -- maximum number of output pipes'
        write(LER,*)' '
        write(LER,*)'-norm      -- normalize (if all summation)'
        write(LER,*)'-m         -- input streams trace oritnted, else'
        write(LER,*)'              streams are record oriented'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'       mvstak [ -N[] -N[] ... -N[] ] [ -F[] ]'
        write(LER,*)'              -O[] -oper[] [-norm -m -V]'
        write(LER,*)' '

      return
      end

      subroutine cmdln(ntap,otap,nu,verbos,traces,oper,pmax,
     1                 filein,ftap,norm)
c-----
c     get command arguments 
c
c     ntap  - C*100     vector of strings defining input data sets
c     otap  - C*100     string defining output data set
c  flags:
c   verbos  - L         verbos output flag
c-----
#include <f77/iounit.h>
      character*256  ntap (*), otap, ftap
      character      oper * 1000
      integer        nu, argis, pmax, lufil
      logical        verbos, traces, filein, norm

      do  i = 1, 1000
          oper (i:i) = ' '
      enddo

c                        get input data set names
      call argstr('-F',ftap,' ',' ')

      IF (ftap(1:1) .eq. ' ') THEN

         nu=0
            do  i = 1, 1000
                call argstr('-N',ntap(i),' ',' ')
                if(ntap(i) .eq. ' ') go to 1
                nu=nu+1
            enddo
    1       continue
            if(nu .eq. 0) then
              write(LERR,*)'Since no input files are explicitly'
              write(LERR,*)'named it is assumed MVSTAK is running'
              write(LERR,*)'inside the iconic processor - ikp'
            endif

      ELSE

            call alloclun (lufil)
            open (unit=lufil, file = ftap, status = 'old', iostat=ierr)
            if(ierr .ne. 0) then
            write(LERR,*)'FATAL ERROR in mvstak:'
            write(LERR,*)'Could not open file of input names ',ftap
            write(LER ,*)'FATAL ERROR in mvstak:'
            write(LER ,*)'Could not open file of input names ',ftap
            stop
            endif
            rewind lufil
            i = 1
            do while (1.eq.1)

               read (lufil,'(a80)',end=2,err=666) ntap (i)
               i = i + 1
            enddo
2           continue
            nu = i - 1
            do  i = 1, nu
               if (ntap(i) .eq. ' ') then
                   if (i .lt. nu) then
                      write(LERR,*)'FATAL ERROR in mvstak:'
                      write(LERR,*)'Cannot have blank input name (line '
     1                ,i,' in file ',ftap,' )'
                      write(LER ,*)'FATAL ERROR in mvstak:'
                      write(LER ,*)'Cannot have blank input name (line '
     1                ,i,' in file ',ftap,' )'
                      stop
                   endif
                   nu = nu - 1
                   go to 3
               endif
            enddo
3           continue
            if(nu .eq. 0) then
              write(LERR,*)'FATAL ERROR in mvstak:'
              write(LERR,*)'No input file names read in file ',ftap
              write(LER ,*)'FATAL ERROR in mvstak:'
              write(LER ,*)'No input file names read in file ',ftap
              stop
            endif

      ENDIF

c                       get output data set name
              call argstr('-O', otap, ' ',' ')

              call argstr('-oper', oper, '+','+')

c                       get flags
            verbos = .false.
            traces = (argis('-m') .gt. 0)
            verbos = (argis('-V') .gt. 0)
            norm   = (argis('-norm') .gt. 0)
            call argi4('-P', pmax, 1000, 1000)


      return

666   continue
      write(LERR,*)'FATAL ERROR in mvstak:'
      write(LERR,*)'Error in reading file of input names from file ',
     1              ftap
      write(LER ,*)'FATAL ERROR in mvstak:'
      write(LER ,*)'Error in reading file of input names from file ',
     1              ftap
      stop 666

      end

