C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************C
C
C     PROGRAM MODULE  rotate the phase of seismic data by constant amt
C
C**********************************************************************C
C
C phzrot READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C rotates the phase of the data by a constant amount,
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( 8*SZLNHD )
      INTEGER     ITP ( 8*SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN, LUINP , LUOUT, LBYTES, NBYTES,obytes
      integer     argis, ordfft, npoint, pipe
      real        degrad, radeg, thresh, rot
      REAL        xtr ( 8*SZLNHD ), work (8*SZLNHD )
      REAL        amp ( 8*SZLNHD ), phz  (8*SZLNHD )
      COMPLEX     ctr ( 4*SZLNHD )
      CHARACTER   NAME * 7,  ntap * 512, otap * 512, ptap * 512
#include <f77/pid.h>
      logical     verbos,query,mute,first,time,twopi
      logical     one, record
 
      DATA     NAME /'PHZROT'/
      DATA     LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA     obytes / 0 /
      DATA     verbos /.false./, first/.true./
      DATA     twopi /.false./
      DATA     one /.false./
      DATA     record /.false./
      DATA     radeg/57.29578/
      DATA     degrad/.017453293/
      DATA     npoint/0/
      DATA     pipe/3/


c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?') .gt. 0 .or. argis('-h') .gt. 0)
      if( query ) then
          call help ()
          stop
      endif

c---------------------------------
c  open printout files
c---------------------------------
#include <f77/open.h>

c---------------------------------------------------------------
c  read program parameters from command line
c---------------------------------------------------------------
      call cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,verbos,
     1           rot,mute,time,ptap,npoint)

C**********************************************************************C
C     open logical units
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C

      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'phzrot: no header read on unit ',luin
         write(LERR,*)'for data set name ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'check existence of this file'
         stop
      endif

#include <f77/saveh.h>


c-----
c     read phase line header of input
c     save certain parameters
c-----
      IF (time) THEN
         if (ptap(1:1) .ne. ' ') then
            call getln(luinp, ptap, 'r', 0)
         else
            call sisfdfit (luinp, pipe)
         endif
         if(luinp .lt. 0)   then
            write(lerr,*)'phzrot error: phase file -P not accessible'
         endif
         call rtape  ( luinp, itp, lbytes)
         if(lbytes .eq. 0) then
            write(LER,*)'phzrot: no header read from phase unit ',luinp
            write(LER,*)'FATAL'
            stop 666
         endif

         call saver(itp, 'NumSmp', nsampp, LINHED)
         call saver(itp, 'SmpInt', nsip  , LINHED)
         call saver(itp, 'NumTrc', ntrcp , LINHED)
         call saver(itp, 'NumRec', nrecp , LINHED)
         call saver(itp, 'Format', iformp, LINHED)

         if (nsamp .ne. nsampp) then
           write(LERR,*)'FATAL ERROR in phzrot: time option'
           write(LERR,*)'Number samples/trc in seismic data ',nsamp
           write(LERR,*)'not equal # samps/trc in phase data ',nsampp
           write(LER,*)'FATAL ERROR in phzrot: time option'
           write(LER,*)'Number samples/trc in seismic data ',nsamp
           write(LER,*)'not equal # samps/trc in phase data ',nsampp
           stop 666
         endif
         if (nsi .ne. nsip) then
           write(LERR,*)'FATAL ERROR in phzrot: time option'
           write(LERR,*)'Seismic sample interval ',nsi
           write(LERR,*)'not equal to phase sample interval ',nsip
           write(LER,*)'FATAL ERROR in phzrot: time option'
           write(LER,*)'Seismic sample interval ',nsi
           write(LER,*)'not equal to phase sample interval ',nsip
           stop 666
         endif
         if (ntrcp*nrecp .eq. 1) then
           write(LERR,*)'Warning: time option'
           write(LERR,*)'detected only one trace in phase data set'
           write(LERR,*)'will use this phase trace for all input'
           one = .true.
         elseif (ntrcp*nrecp .eq. nrec) then
           write(LERR,*)'Warning: time option'
           write(LERR,*)'detected one phase trace for each input'
           write(LERR,*)'gather'
           record = .true.
         elseif (ntrc*nrec .ne. ntrcp*nrecp) then
           write(LERR,*)'FATAL ERROR in phzrot: time option'
           write(LERR,*)'Total number of trace in input data ',nrec*ntrc
           write(LERR,*)'not equal to # traces in phase data ',
     1                  nrecp*ntrcp
           write(LER,*)'FATAL ERROR in phzrot: time option'
           write(LER,*)'Total number of trace in input data ',nrec*ntrc
           write(LER,*)'not equal to # traces in phase data ',
     1                  nrecp*ntrcp
           stop 666
         endif
      ENDIF

      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('VPick1',ifmt_VPick1,l_VPick1,ln_VPick1,TRACEHEADER)

      CALL HLHprt ( ITR , LBYTES, NAME, 7, LERR        )

c---------------------------------------
c  check key values for reasonableness
c---------------------------------------
      call cmdchk(nst,ned,nrst,nred,ntrc,nrec)
      if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD
      ntr=ned-nst+1
      nrecc=nred-nrst+1

C**********************************************************************C
C     CHECK CARD DEFAULTS, SET PARAMETERS, and print out values
C**********************************************************************C
      dt = float (nsi) * unitsc

      iend=iend/nsi + .5
      ist0 = ist
      ist=ist/nsi
      if(ist .le. 1) ist=1
      if(iend .eq. 0) iend=nsamp
      if(iend .gt. nsamp) iend=nsamp
      nsampo=iend-ist+1
c------------------------------
c  find power of 2, nsampo

      nu     = ordfft (nsampo)
      n2     = 2 ** nu
      n22    = n2 / 2
      npts   = n2
      npts21 = n22 + 1
      fnyq   = .5 / dt
      fl     = 0.
      fh     = fnyq

      df = fnyq / float(n2/2 - 1)
      ndf = 1000*df

      obytes = SZTRHD + SZSMPD * nsamp
c------------------------------

c     if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' Input Samples/Trace =  ', nsamp
        write(LERR,*) ' # of Samples/Trace  =  ', nsampo
        write(LERR,*) ' power of 2 samples  =  ', n2
        write(LERR,*) ' Sample Interval     =  ', nsi  
        write(LERR,*) ' Input traces/rec    =  ', ntrc
        write(LERR,*) ' Input Records/Line  =  ', nrec
        write(LERR,*) ' Records per Line    =  ', nrecc
        write(LERR,*) ' Format of Data      =  ', iform
        write(LERR,*) ' Output number bytes =  ', obytes
        if (time) then
        write(LERR,*)' Sample-by-sample phase rotation'
        write(LERR,*) ' Phase rotation scaler =  ', rot
        write(LERR,*)' smoothing window length=  ',npoint,' pts'
        else
        write(LERR,*)' Global phase rotation'
        write(LERR,*) ' Phase rotation angle=  ', rot
        endif
        if (mute)
     1  write(LERR,*)' Restore early mute'
c     endif

       call savhlh( itr, lbytes, lbyout)

      CALL WRTAPE ( LUOUT, ITR, LBYout )

C**********************************************************************C
C     get seismoc traces, fft, output complex data
C**********************************************************************C
c------------------------------------------
c  skip to just before desired record
c------------------------------------------
      call recskp(1,nrst-1,luin,ntrc,itr)
c     if (time)
c    :call recskp(1,nrst-1,luinp,ntrc,itr)

      DO 100 JJ = NRST, NRED

c-------------------------------
c  skip to desired trace
c-------------------------------
             call trcskp(jj,1,nst-1,luin,ntrc,itr)
c            if (time)
c    :       call trcskp(jj,1,nst-1,luinp,ntrc,itr)

             DO 99 KK = NST, NED
 
                   nbytes = 0
                   CALL RTAPE  ( LUIN , ITR, NBYTES         )
                   if(nbytes .eq. 0) then
                      write(LERR,*)'End of file on input:'
                      write(LERR,*)'  rec= ',jj,'  trace= ',kk
                      go to 999
                   endif
                   call vmov (itr(ITHWP1), 1, xtr, 1, nsamp)

                   call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                         itrc, TRACEHEADER)
                   call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                         irec, TRACEHEADER)
                   call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                         istatic, TRACEHEADER)

                   IF (time) THEN

                      if (one) then
                         if (first) then
                            CALL RTAPE  ( LUINP, ITP, NBYTES         )
                            if(nbytes .eq. 0) then
                              write(LERR,*)'End of file on input phase:'
                              write(LERR,*)'  rec= ',jj,'  trace= ',kk
                              go to 999
                            endif
                            first = .false.
                         endif
                      elseif (record) then
                         if (KK .eq. NST) then
                            CALL RTAPE  ( LUINP, ITP, NBYTES         )
                            if(nbytes .eq. 0) then
                              write(LERR,*)'End of file on input phase:'
                              write(LERR,*)'  rec= ',jj,'  trace= ',kk
                              go to 999
                            endif
                         endif
                      else
                            CALL RTAPE  ( LUINP, ITP, NBYTES         )
                            if(nbytes .eq. 0) then
                              write(LERR,*)'End of file on input phase:'
                              write(LERR,*)'  rec= ',jj,'  trace= ',kk
                              go to 999
                            endif
                      endif

                      call vmov (itp(ITHWP1), 1, phz, 1, nsamp)

                   ENDIF

                   IF (istatic .ne. 30000) THEN

                        if (mute) then
                           call bd_detmut ( xtr, imtop, nsamp,0)
                           call bd_detmut ( xtr, imbottom, nsamp,1)
                        endif

                        if (time) then
                           call iphase(xtr, nsamp, npts, npts21,
     1                                 npoint, dt, fl, fh, twopi,
     2                                 degrad, radeg, phz, rot)

                        else
                           call bulkrot (nsamp, nsampo, n2, n22, degrad,
     1                                   radeg, xtr, work, amp, phz,
     2                                   ctr, rot)
                        endif

                        if (mute) then
                           call bd_resmut ( xtr, imtop, nsamp,0)
                           call bd_resmut ( xtr, imbottom, nsamp,1)
                        endif
                        call vmov (xtr, 1, itr(ITHWP1), 1, nsamp)

                        call wrtape(luout,itr,obytes)

                   ELSE

                        call wrtape(luout,itr,obytes)

                   ENDIF


   99        CONTINUE

c--------------------------------------------------
c  skip to the end of current record: trace # ntrc
c--------------------------------------------------
             call trcskp(jj,kk+1,ntrc,luin,ntrc,itr)
c            if (time)
c    :       call trcskp(jj,kk+1,ntrc,luinp,ntrc,itr)

  100 CONTINUE
                        if(verbos) then
                           write(LERR,*)'Output Record ',irec
                        endif

  999 continue
        call lbclos(luin)
        call lbclos(luout)
      END

c--------------------------------
c  online help routine
c--------------------------------
      subroutine help
#include <f77/iounit.h>
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for phzrot: '
        write(LER,*)'rotate the phase of seismic data'
        write(LER,*)' '
        write(LER,*)'Input......................................  (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-P[ptap]   -- apply rotation phase trc    (ignore)'
        write(LER,*)'-w[npt]    -- rotation ph trc smooth wind  (0 pts)'
        write(LER,*)'-r[rot]    -- global phase rotation (degrees)  (0)'
        write(LER,*)'-r[rot]       phase scaler for -P[] option   (1.0)'
        write(LER,*)'-M         -- restore top/bottom mutes'
        write(LER,*)'-T         -- apply phase rotation trace'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      phzrot -N[] -O[] [-P[] -w[] -T -r[] -M -V]'
        write(LER,*)' '
      return
      end

      subroutine cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,
     1                  verbos,rot,mute,time,ptap,npoint)
c-----
c     get command arguments
c
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c      ist  - I         start time 
c     iend  - I         end time 
c      nst  - I         start trace
c      ned  - I         end trace
c     nrst  - I         start record
c     nred  - I         end record
c     rot   - R         phase rotation (in degrees)
c     verbos- L         verbose output or not
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*), ptap*(*)
      real      rot
      integer   argis,ist,iend,nst,ned,nrst,nred,npoint
      logical   verbos, mute, time

           call argstr('-N',ntap,' ',' ')
           call argstr('-O',otap,' ',' ')
           call argstr('-P',ptap,' ',' ')
           call argi4('-w',npoint,0,0) 
           call argi4('-s',ist,1,1) 
           call argi4('-e',iend,0,0) 
           call argi4('-ns',nst,0,0)
           call argi4('-ne',ned,0,0)
           call argi4('-rs',nrst,1,1)
           call argi4('-re',nred,0,0)
           call argr4 ('-r',rot, .0, .0)
           mute  = ( argis( '-M' ) .gt. 0 )
           time  = ( argis( '-T' ) .gt. 0 )
           verbos = ( argis( '-V' ) .gt. 0 )

           if (time .AND. rot .eq. 0.0) rot = 1.0
c-----
      return
      end
