C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
Changes:

c   Feb 13/97 ... fixed bug in decon_tv.F where vclr() was
c                 being run using lop instead of lopp resulting
c                 in a core dump on the crays.  Seemed to work
c                 everywhere else as lop= 0 elsewhere....Garossino


C**********************************************************************C
C
C     PROGRAM MODULE  Predictive Deconvolution
C
C**********************************************************************C
C
C PRED READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C does a predictive deconvolution with optional filtering and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, predictive routines
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

      INTEGER     ITR ( 2*SZLNHD )
      INTEGER     LHED( 2*SZLNHD )
      INTEGER     HEAD( 2*SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, luout2
      integer     luin , luout, lbytes, nbytes, obytes, obytes2
      integer     ist, iend, nst, ned, nrst, nred, lslide, argis
      integer     nwin, iovlp

      REAL        xtr ( 2*SZLNHD ), otrace(2*SZLNHD), wtrace(8*SZLNHD)
      real        pf(2*SZLNHD), weight(2*SZLNHD), peo(2*SZLNHD)
      real        decop(2*SZLNHD), acorr(2*SZLNHD), right(2*SZLNHD)
      real        work(2*SZLNHD), winwork(2*SZLNHD), hold1(2*SZLNHD)
      real        sumb(2*SZLNHD), wthold(2*SZLNHD), ytr(2*SZLNHD)
      real        ase, UnitSc
      real        vel1, vel2, pr, ol, prew

      CHARACTER   NAME * 4, ntap * 256, otap * 256, otap2 * 256
      CHARACTER   hdrwrd*6, hdrwdp*6, hdrwdo*6

      logical     verbos, predict, gate, cost, bart, TV
      logical     watbot, sword, flt, hdrp, hdro, filout
 
      EQUIVALENCE ( ITR(  1), LHED(1), HEAD(1) )

      DATA  NAME /'PRED'/
      DATA  LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /
      data  verbos/.false./

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 )then
         call help()
         stop
      endif

C**********************************************************************C
C     open printout files
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     read program parameters from the command line
C**********************************************************************C
      call cmdln( ntap, otap, otap2, ist, iend, nst, ned, nrst, 
     :     nred, vel1, vel2, pr, ol, prew, predict, verbos, gate, cost, 
     :     bart, watbot, sword, hdrwrd, TV, lslide, flt,
     :     hdrwdp, hdrwdo, hdrp, hdro, filout, taper)

C**********************************************************************C
C     open data units
C**********************************************************************C

      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)
      if (filout) call getln(luout2, otap2, 'w', 1)

C**********************************************************************C
C     read lineheader; save key parameters; modify parameters;
C     update header; write out header
C**********************************************************************C

      lbytes = 0

      CALL RTAPE  ( LUIN, ITR, LBYTE        )
      if(lbyte .eq. 0) then
         write(LERR,*)'PRED: no header read on unit ',ntap
         write(LERR,*)'check existence of data file'
         write(LERR,*)'FATAL'
         write(LER,*)'PRED: no header read on unit ',ntap
         write(LER,*)'check existence of data file'
         write(LER,*)'FATAL'
         close(LERR)
         stop
      endif

c------
c     save certain parameters

      call saver(itr, 'NumSmp', nsamp , LINHED)
      call saver(itr, 'SmpInt', nsi   , LINHED)
      call saver(itr, 'NumTrc', ntrc  , LINHED)
      call saver(itr, 'NumRec', nrec  , LINHED)
      call saver(itr, 'Format', iform , LINHED)
      call saver(itr, 'UnitSc', UnitSc, LINHED)
      if (UnitSc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',UnitSc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          UnitSc = .001
          call savew(itr, 'UnitSc', UnitSc, LINHED)
      endif

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('WDepDP',ifmt_WDepDP,l_WDepDP,ln_WDepDP,TRACEHEADER)

      if (sword) then
         call savelu(hdrwrd,ifmt_hdrwrd,l_HdrWrd,ln_hdrwrd,TRACEHEADER)
      endif
      if (hdrp) then
         call savelu(hdrwdp,ifmt_hdrwdp,l_hdrwdp,ln_hdrwdp,TRACEHEADER)
      endif
      if (hdro) then
         call savelu(hdrwdo,ifmt_hdrwdo,l_hdrwdo,ln_hdrwdo,TRACEHEADER)
      endif
      if (watbot .AND. .not. TV) then
         if (vel1 .eq. 9999999.) then
            call saver( itr, 'WatVel', ivel , LINHED)
            vel1 = float (ivel)
            if (vel1 .lt. 100. .or. vel1. gt. 30000.) then
               write(LERR,*)'Line Header water vel entry bad'
               write(LERR,*)'Use utop to put proper value,'
               write(LERR,*)'e.g. 5000 or 1500'
               stop
            endif
         endif
      endif



      if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD
      call cmdchk(nst,ned,nrst,nred,ntrc,nrec)

      ntr   = ntrc
      nrecc = nrec

c     if (nsi .ge. 32) then
c        dtmsec=.001*nsi
c     else
c        dtmsec=nsi                   
c     endif

c------
c  dtmsec = millisecs or microsecs depending on the sample interval units
c  dt     = secs always
c------
         dt     = real (nsi) * UnitSc
         dtmsec = 1000 * dt

      if (TV) then

          lslide = float(lslide) / float(nsi)
          iovlp  = lslide / 2
          ilast = 0
          do while (ilast.lt.nsamp)
             if(ilast.eq.0)then
                 ifirst = 1
                 ilast = lslide + iovlp
                 nwin = 1
             else
                 nmove = lslide+iovlp
                 ifirst = ifirst + iovlp
                 ilast = ifirst + nmove -1
                 nwin = nwin+1
             endif
         end do
         nwin0 = nwin

      endif

         iend  = float(iend)/float(nsi) + .5
         ist   = float(ist)/float(nsi)
         if(ist .le. 1) ist = 1
         ist0 = ist
         if(iend .eq. 0) iend = nsamp
         if(iend .gt. nsamp) iend = nsamp
         iend0 = iend
         veldt1 = vel1 * dt
         veldt2 = vel2 * dt
         iwnd = nsi * (iend - ist + 1)
         if(ol.gt.iwnd/2)then
          write(LER,*)' '
          write(LER,*)'Fatal: time variant option error'
          write(LER,*)'Operator too long.  Max is 1/2 the window length'
          write(LER,*)'Window length is ',iwnd,' op length is ',ol
          write(LER,*)'Fatal'
          call lbclos(luin)
          stop
         endif

      if (pr .ge. 0) then
         lpr = pr/float(nsi)
         if(lpr .eq. 0) lpr = 1
         lpf = ol/float(nsi)
         lf  = lpr + lpf
      else
         lpr = pr
         lpf = ol/float(nsi)
         lf  = lpf
      endif

      nsampo = iend-ist+1

      if (TV) then
         iwnd = nsi * (iend - ist + 1)
         if(ol.gt.iwnd/2)then
          write(LER,*)' '
          write(LER,*)'Fatal: time variant option error'
          write(LER,*)'Operator too long.  Max is 1/2 the window length'
          write(LER,*)'Window length is ',iwnd,' op length is ',ol
          write(LER,*)'Fatal'
          call lbclos(luin)
          stop
         endif
      endif

       call savew( itr, 'NumSmp', nsamp , LINHED)
       call savew( itr, 'NumTrc', ntr  , LINHED)
       call savew( itr, 'NumRec', nrecc, LINHED)

C**********************************************************************C
C     print line header values
C**********************************************************************C
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi   
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Format of Data     =  ', iform

        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval (ms)= ', dtmsec
        write(LERR,*) ' Traces per Record  =  ', ntr 
        write(LERR,*) ' Records per Line   =  ', nrecc 
        write(LERR,*) ' Format of Data     =  ', iform
        if (hdrp) then
        write(LERR,*) 'Prediction distance from hdr wd ',hdrwdp
        else
        write(LERR,*) 'Prediction distance= ',pr,' ms ',lpr,' samples'
        endif
        if (hdro) then
        write(LERR,*)'Operator length from hdr wd ',hdrwdo
        else
        write(LERR,*)'Operator length= ',ol,'  ms ',lpf,' samples'
        endif
        if (.not.hdrp .AND. .not.hdro) then
        write(LERR,*)'Total pred filt length = ',lf,' samples'
        endif
        write(LERR,*)'Prewhitening= ',prew,' %'
        if (TV) then
        write(LERR,*)'Sliding window length    =  ', lslide
        write(LERR,*)'Overlap                  =  ', iovlp
        write(LERR,*)'nwin                     =  ', nwin
        else
        write(LERR,*)'Design window start time =  ',ist0,' samples'
        write(LERR,*)'Design window end time   =  ',iend,' samples'
        write(LERR,*)'Start design velocity (m or ft/s)= ',vel1
        write(LERR,*)'End design velocity (m or ft/s)  = ',vel2
        write(LERR,*)'Cosine weighting of auto-corr  = ',cost
        write(LERR,*)'Bartlett weighting of auto-corr= ',bart
        write(LERR,*)'% design window taper (each end) = ',taper/2
        if (watbot) then
           write(LERR,*)'Key window start time to water depth in trace'
           write(LERR,*)'Water depth trace hdr position= ',l_WDepDP
           if (flt)
     1     write(LERR,*)'Header word is floating point value'
        endif
        if (sword) then
           write(LERR,*)'Start time stored in trc header wrd= ',hdrwrd
           write(LERR,*)'Start time stored in trc header pos= ',l_HdrWrd
           if (flt)
     1     write(LERR,*)'Header word is floating point value'
        endif
        if (gate)
     1  write(LERR,*)'Apply decon only within design window'
        endif
      prew = prew / 100.

      call bldwt (nsampo, taper, cost, bart, weight)

      obytes = SZTRHD + SZSMPD * nsamp
      call savhlh( itr, lbyte, lbyout)
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )


      if ( filout ) then
          lf2 = 2 * lf
          call savew( itr, 'NumSmp',  lf   , LINHED)
          obytes2 = SZTRHD + SZSMPD * lf
          CALL WRTAPE ( LUOUT2, ITR, LBYOUT            )
      endif


C**********************************************************************C
C     main processing loop:
C          read trace; deconvolve; write output
C**********************************************************************C
      DO 100 JJ = 1, nrec

         DO 99 KK = 1, ntrc

            nbytes = 0
            CALL RTAPE  ( LUIN , ITR, NBYTES         )
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp) 

            call vclr (pf, 1, lf2)

            IF (JJ .ge. nrst .and. JJ .le. nred .AND.
     1           KK .ge. nst .and. KK .le. ned) THEN

c-------------------------
c  preserve dead tr flag
c  get other hdr values
               call saver2(lhed,ifmt_StaCor,l_StaCor,ln_StaCor,istatic,
     1              TRACEHEADER)
               call saver2(lhed,ifmt_LinInd,l_LinInd,ln_LinInd,ili,
     1              TRACEHEADER)
               call saver2(lhed,ifmt_DphInd,l_DphInd,ln_DphInd,idi,
     1              TRACEHEADER)


               IF(istatic .ne. 30000) THEN
 
c-----
c    options to get window start times keyed to:

                  ist = ist0
                  iend = iend0
c-----
c       (1) water bottom (need water depth for this cdp
                  if (watbot) then
                     call saver2(lhed,ifmt_WDepDP,l_WDepDP,
     1                    ln_WDepDP, idep, TRACEHEADER)
                     dep  = idep
                     ist  = ist + 2 * dep/veldt1
                     iend = ist + nsampo - 1
                  endif
c-----
c       (2) start time in trace headers (could be I*4, R, I*2)
                  if (sword) then
                     if (flt) then
                        call getfp2(lhed,ifmt_hdrwrd,l_HdrWrd,
     1                       ln_HdrWrd, sst1 , TRACEHEADER)
                        ist = ist + sst1 / float(nsi)
                     else
                        call saver2(lhed,ifmt_hdrwrd,l_HdrWrd,
     1                       ln_HdrWrd, ist1 , TRACEHEADER)
                        ist  = ist + float(ist1) / float(nsi)
                     endif
                     iend = ist + nsampo - 1
                  endif
c-----
c       (3) trace distance / velocity
                  if (vel1 .ne. 9999999.) then
                     call saver2(lhed,ifmt_DstSgn,l_DstSgn,
     1                    ln_DstSgn,idist, TRACEHEADER)
                     dist = abs(float(idist))
                     ist  = ist + dist/veldt1
                     if (vel2 .eq. 9999999.) then
                        iend = ist  + nsampo - 1
                     else
                        iend = iend + dist/veldt2
                     endif
                  endif
c-----
                  if (iend .gt. nsamp) iend = nsamp
 
                  nsampk     = iend - ist + 1
 
                  if (nsampk .le. lf) then
                     write(LERR,*)'Design window time LT filter'
                     write(LERR,*)'length -- FATAL'
                     write(LERR,*)'Increase window start velocity'
                     write(LERR,*)'-v1[], and/or decrease end windw'
                     write(LERR,*)'vel -v2[] & re-run'
                     write(LER ,*)'Design window time LT filter'
                     write(LER ,*)'length -- FATAL'
                     write(LER ,*)'Increase window start velocity'
                     write(LER ,*)'-v1[], and/or decrease end windw'
                     write(LER ,*)'vel -v2[] & re-run'
                     go to 999
                  endif
c----------------
c  option to get
c  pred dist from
c  trc hdr
                  if (hdrp) then
                     call saver2(lhed,ifmt_hdrwdp,l_hdrwdp,ln_hdrwdp,
     1                           ipw, TRACEHEADER)
                     lpr = float(ipw)/float(nsi)
                     if (lpr .le. 1) lpr = 1
                  endif
c----------------
c----------------
c  option to get
c  op length from
c  trc hdr
                  if (hdro) then
                     call saver2(lhed,ifmt_hdrwdo,l_hdrwdo,ln_hdrwdo,
     1                           iow, TRACEHEADER)
                     lpf = float(iow)/float(nsi)
                  endif
c----------------
                  if (lpf .le. 1 .AND. hdro) then
                     write(LERR,*)'FATAL ERROR in pred hdr wd option:'
                     write(LERR,*)'detected bad operator length= ',iow
                     write(LERR,*)'in header wd ',hdrwdo
                     write(LERR,*)'rec/trc/LI,DI= ',jj,kk,ili,idi
                     write(LER ,*)'FATAL ERROR in pred hdr wd option:'
                     write(LER ,*)'detected bad operator length= ',iow
                     write(LER ,*)'in header wd ',hdrwdo
                     write(LER ,*)'rec/trc/LI,DI= ',jj,kk,ili,idi
                     go to 999
                  endif

c                 if (hdro) call bldwt (lpf, cost, bart, weight)
                  call wtapp (xtr(ist), weight, ytr, nsampo, nsampk,
     1                        wthold, taper, cost, bart)
                  lf = lpr + lpf

                  call dotpr (xtr(ist),1,xtr(ist),1,xdot,nsampk)
                  if ( xdot .ne. 0.0 ) then

c++++++++++++++++++++++++++++++++++++++
c  time varying option
                     IF (TV) then
                             
                        do while (ilast.lt.nsampk)
                           if(ilast.eq.0)then
                              ifirst = 1
                              ilast = lslide + iovlp
                              nwin = 1
                           else
                              nmove = lslide+iovlp
                              ifirst = ifirst + iovlp
                              ilast = ifirst + nmove -1
                              nwin = nwin+1
                           endif
                        enddo
                        
                        call vclr ( hold1, 1, nsamp )
                        call vclr ( sumb, 1, nsamp )

                        call decon_tv( xtr(ist), nsamp, lpf, lpr, prew, 
     :                       wtrace, ierr, lslide, nwin, iovlp,
     :                       decop, peo, acorr, right, work, winwork, 
     :                       hold1, sumb )

                        call vmov (wtrace, 1, xtr(ist), 1, nsamp-ist+1)
c++++++++++++++++++++
c  time invariant option
                     ELSE
                              call predik(nsampk,ytr,lpr,lpf,pf,
     1                                     ase,prew,wtrace,peo)
                              lf = lpr + lpf

                     ENDIF
c++++++++++++++++++++++++++++++++++++++

                      endif

c#########################
c  time invariant section
                   IF (.not. TV) THEN

c-------------------
c output the predictable
c part of the data, ie
c basically convolve with
c the prediction coefs
                      if( predict ) then
                          do 51  ii = 2, lf
                                 pf (ii) = - pf (ii)
   51                     continue
                          pf (1) = 0.
                          call fold(lf,pf,nsamp,xtr,nfold,otrace)
                          call vmov(otrace,1,xtr,1,nsamp)
                      else
c--------------------
c apply PEF only within 
c design window, or
                         if (gate) then
                           call fold(lf,pf,nsampk,xtr(ist),nfold,otrace)
                           call vmov(otrace,1,xtr(ist),1,nsampk)
c over whole trace
                         else
                           call fold(lf,pf,nsamp,xtr,nfold,otrace)
                           call vmov(otrace,1,xtr,1,nsamp)
                         endif

                      endif
c--------------------

 
                   ENDIF
c#########################
                      if(verbos) then
                        write(LERR,*)'Record= ',jj,' Trace= ',kk,
     1                               ' Prediction error= ',ase,
     2                               ' Window start sample= ',ist,
     3                               ' end time (samps)= ',iend
                      endif


                   ENDIF

                 ENDIF

                 call vmov (xtr, 1, lhed(ITHWP1), 1, nsamp)
                 call wrtape(luout,itr,obytes)

                 IF ( filout ) THEN

                    if (JJ .ge. nrst .and. JJ .le. nred .AND.
     1                        KK .ge. nst .and. KK .le. ned) then
                       call vclr (xtr,1,lf2)
                       call vmov (pf,1,xtr,1,lf)
                       call vmov (xtr, 1, lhed(ITHWP1), 1, lf)
                       call wrtape (luout2,itr,obytes2)
                    else
                       call vclr (xtr,1,lf2)
                       xtr(1) = 1.
                       call vmov (xtr, 1, lhed(ITHWP1), 1, lf)
                       call wrtape (luout2,itr,obytes2)
                    endif

                 ENDIF

                   
 
   99        CONTINUE


  100 CONTINUE

  999 continue

         call lbclos(luin)
         call lbclos(luout)
         if ( filout ) call lbclos(luout2)

      END

c---------------------------------------
c  online help section
c---------------------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for PRED: predictive decon'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-F[otap2]  -- optional output file name of filter'
        write(LER,*)' '
        write(LER,*)'design window:'
        write(LER,*)'-s[ist]    -- start time                    (0 ms)'
        write(LER,*)'-vs[vel1]  -- start design velocity (m,ft/s)(flat)'
        write(LER,*)'-ve[vel2]  -- end design velocity (m,ft/s)  (flat)'
        write(LER,*)'-e[iend]   -- end time                 (last samp)'
        write(LER,*)'-tp[tp]    -- % design window to taper        (25)'
        write(LER,*)' '
        write(LER,*)'prediction parameters:'
        write(LER,*)'-p[pr]     -- wavelet length (ms, 0-Xing)  (spike)'
        write(LER,*)'Note:         pr <0 refers to zero Xing; pr >=0 ms'
        write(LER,*)'-ol[ol]    -- operator length, ms'
        write(LER,*)'-P[prew]   -- prewhitening (%)               (.01)'
        write(LER,*)'-hwp[hp]   -- grab pred dist (ms) from trc wd (no)'
        write(LER,*)'-hwo[ho]   -- grab op length (ms) from trc wd (no)'
        write(LER,*)'Note: hdr wd options must exist for every live trc'
        write(LER,*)' '
        write(LER,*)'trace/record limitation:'
        write(LER,*)'-ns[nst]   -- start process trc #       (first tr)'
        write(LER,*)'-ne[ned]   -- end process trc #          (last tr)'
        write(LER,*)'-rs[nrst]  -- start process rec #      (first rec)'
        write(LER,*)'-re[nred]  -- end process rec  #        (last rec)'
        write(LER,*)' '
        write(LER,*)'-TV        -- decon time varying:'
        write(LER,*)'-w[lslide] -- sliding window length (ms)     (500)'
        write(LER,*)'Note:         -G, -S options below & -F[otap2]'
        write(LER,*)'              above ignored'
        write(LER,*)' '
        write(LER,*)'-C         -- cosine weighting of auto-corr'
        write(LER,*)'-B         -- bartlett weighting of auto-corr'
        write(LER,*)'           -- default is no weighting of auto-corr'
        write(LER,*)'-G         -- apply decon only within design windw'
        write(LER,*)'-S         -- output predictable part of data'
        write(LER,*)'  default = non-predictable (normal pred)'
        write(LER,*)'-W         -- key start time on water depth in hdr'
        write(LER,*)'-H         -- key start time on trc hdr word'
        write(LER,*)'-hw[hdrwrd]-- trc hdr word with start time (none)'
        write(LER,*)'Note: can have sum of const + dx/v + hdr time + ...
     1'
        write(LER,*)'-flt       -- hdr word time is floating point value
     1'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      pred -N[] -O[] -F[] -s[] -e[] -vs[] -ve[]'
        write(LER,*)'           -P[] -p[] -ol[] -ns[] -ne[] -rs[] -re[]'
        write(LER,*)'           [ -W -H [ -hw[] -F ] [ -hwp[] -hwo[] ]'
        write(LER,*)'            -tp[] -S -G -C -B -TV -V ]'
        write(LER,*)' '
 
      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     otap2 - C*100  output file name of filter
c       s   - I      start time
c       e   - I      stop time
c     nst   - I      start trace
c     ned   - I      stop trace
c    nrst   - I      start record
c    nred   - I      end record
c      pr   - R      prediction distance
c     vel   - R      velocity for design window
c      ol   - R      operator length
c    prew   - R      prewhitening
c   predict - L      output predictable part of data
c    gate   - L      apply only within the design window
c    verbos - L      verbose output or not
c-----
      subroutine cmdln( ntap, otap, otap2, ist, iend, nst, ned, nrst, 
     :     nred, vel1, vel2, pr, ol, prew, predict, verbos, gate, cost, 
     :     bart, watbot, sword, hdrwrd, TV, lslide, flt,
     :     hdrwdp, hdrwdo, hdrp, hdro, filout, taper)

#include <f77/iounit.h>

      integer    ist, iend, nst, ned, nrst, nred, argis, lslide

      real       pr, ol, prew, vel1, vel2, taper

      character  ntap*(*), otap*(*), otap2*(*), hdrwrd*6
      character  hdrwdp*6, hdrwdo*6

      logical    verbos, predict, gate, cost, bart, watbot, sword, TV
      logical    flt, hdrp, hdro, filout

      filout = .false.
      hdrp = .false.
      hdro = .false.
      call argstr('-hwp',hdrwdp,' ',' ')
      call argstr('-hwo',hdrwdo,' ',' ')
      if (hdrwdp(1:1) .ne. ' ') hdrp = .true.
      if (hdrwdo(1:1) .ne. ' ') hdro = .true.

      bart = ( argis( '-B' ) .gt. 0 )

      cost = ( argis( '-C' ) .gt. 0 )

      call argi4('-e',iend,0,0) 

      flt = ( argis( '-flt' ) .gt. 0 )
      call argstr('-F',otap2,' ',' ')

      gate = ( argis( '-G' ) .gt. 0 )

      sword = ( argis( '-H' ) .gt. 0 )

      call argr4('-tp',taper,25.,25.)
      call argi4('-ne',ned,0,0)
      call argi4('-ns',nst,0,0)
      call argstr('-N',ntap,' ',' ')

      call argr4('-ol',ol,0.,0.)
      call argstr('-O',otap,' ',' ')

      call argr4('-P',prew,.01,.01)
      call argr4('-p',pr,0.,0.)

      call argi4('-re',nred,0,0)
      call argi4('-rs',nrst,1,1)

      predict  = ( argis( '-S' ) .gt. 0 )
      call argi4('-s',ist,1,1) 

      TV = ( argis( '-TV' ) .gt. 0 )

      call argr4('-vs',vel1,9999999.,9999999.)
      call argr4('-ve',vel2,9999999.,9999999.)
      if (vel1 .eq. 9999999.)
     1     call argr4('-v', vel1,9999999.,9999999.)
      verbos = ( argis( '-V' ) .gt. 0 )

      watbot = ( argis( '-W' ) .gt. 0 )
      call argi4 ( '-w', lslide, 500, 500 )

c policemen

      if(ol .eq. 0. .AND. .not.hdro) then
         write(LERR,*)' '
         write(LERR,*)'No operator length given -- FATAL'
         write(LER,*)' '
         write(LER,*)'PRED: '
         write(LER,*)'No operator length -ol given'
         write(LER,*)'FATAL'
         close(LERR)
         stop
      endif

      if (predict) gate = .false.

      if (watbot .and. sword) then
         write(LERR,*)'Cannot have both water bottom & header word'
         write(LERR,*)'start time options - choose one & rerun'
         write(LER,*)' '
         write(LER,*)'PRED: '
         write(LER,*)'Cannot have both water bottom & header word'
         write(LER,*)'start time options - choose one & rerun'
         write(LER,*)'FATAL'
         close(LERR)
         stop
      endif

      if (sword) then
         call argstr ('-hw', hdrwrd, ' ', ' ')
         if (hdrwrd(1:1) .eq. ' ') then
            write(LERR,*)'Must enter header word mnemonic'
            write(LERR,*)'Use -hw[] cmd line arg & rerun'
            write(LER,*)' '
            write(LER,*)'PRED: '
            write(LER,*)'Must enter header word mnemonic'
            write(LER,*)'Use -hw[] cmd line arg & rerun'
            write(LER,*)'FATAL'
            close(LERR)
            stop
         endif
      endif

      if (otap2(1:1) .ne. ' ' .AND. TV) then
         write(LERR,*)'Cannot have output decon operator file with'
         write(LERR,*)'time varying option. Will ignore output file'
         write(LER,*)' '
         write(LER,*)'PRED: '
         write(LER ,*)'Cannot have output decon operator file with'
         write(LER ,*)'time varying option. Will ignore output file'
         write(LER,*)'WARNING'
         do i = 1, 256
            otap2(i:i) = ' '
         enddo
         filout = .false.
      elseif (otap2(1:1) .ne. ' ' .AND. .not. TV) then
         if (ol .eq. 0. .AND. hdro) then
            write(LERR,*)'FATAL ERROR in pred:'
            write(LERR,*)'For hdr word option and output filter file'
            write(LERR,*)'you must specify a global max for -ol[]'
            write(LER ,*)'FATAL ERROR in pred:'
            write(LER ,*)'For hdr word option and output filter file'
            write(LER ,*)'you must specify a global max for -ol[]'
            stop
         endif
         filout = .true.
      endif

      return
      end
