C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      program PREPMIG           
C**********************************************************************C
C
C PREPMIG READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C
c     it outputs a flat file containing record number, shotnumber,
c     group index, signed shot-trace distances, shot position.
C**********************************************************************C
      parameter (maxs=2)
      dimension s(maxs)
      pointer   (pntrs,s)
c
      character*(128) file_sg,file_geom,file_topo,file_water
      character*(128) file_cmp
      character*7 name
c
      integer argis
      integer stderr
      integer lineheader(6000)
      dimension cputim(30) , waltim(30)
      logical query
      logical fix_zdatum
      logical xy_indexed
      logical model
      logical stacked,use_dphind,use_SGRDat
      logical wrtopo,wrwater
      logical vsp,wrcmp,verbose
      parameter (undefined=-999999.)   
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>
      data     lugeom/11/,lutopo/12/,luwater/13/,lucmp/14/
      data     name /'PREPMIG'/
c
      stderr=ler
c____________________________________________________________________
c     get online help if necessary
c____________________________________________________________________
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help(ler)
           call exitfu(0)
      endif
      call vclr(cputim,1,30)
      call vclr(waltim,1,30)
c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>

C**********************************************************************C
C     read program parameters from command line argument string
C**********************************************************************C
      call cmdlin(file_sg,file_geom,file_topo,file_water,file_cmp,
     1            dsta,dz,zvo,zdatum,fix_zdatum,verbose,
     2            xy_indexed,model,stacked,minrecind,maxrecind,lerr,
     3            ler,use_dphind,vsp,azim,undefined,tol,use_SGRDat)
C**********************************************************************C 
C     open seismic data tape.         
C**********************************************************************
      call getln(luin,file_sg,'r',0 )
c______________________________________________________________________
c     open output flat files.
c______________________________________________________________________
      if(file_geom .ne. ' ') then
         open(lugeom,file=file_geom,status='UNKNOWN',
     1        form='FORMATTED')
      else
         lugeom = LOT
      endif
c
      if(file_cmp .ne. ' ') then
         open(lucmp,file=file_cmp,status='UNKNOWN',
     1        form='FORMATTED')
         wrcmp=.true.
      else
         wrcmp=.false.
      endif
      if(file_topo .ne. ' ') then
         open(lutopo,file=file_topo,status='UNKNOWN',
     1        form='FORMATTED')
         wrtopo=.true.
      else
         wrtopo=.false.
      endif
c
      if(file_water .ne. ' ') then
         open(luwater,file=file_water,status='UNKNOWN',
     1        form='FORMATTED')
         wrwater=.true.
      else
         wrwater=.false.
      endif
c
      lbytes = 0
      call rtape(luin,lineheader,lbytes)  
      if(lbytes .eq. 0) then
         write(LERR,*)'PREPMIG: no header read on unit ',file_sg
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         close(lerr)
         call exitfu(0)
      endif

      call saver(lineheader,'NumRec',nshot,0)
      call saver(lineheader,'NumTrc',ntrace,0)
      call saver(lineheader,'NumSmp',nsamp ,0)
      call saver(lineheader,'SmpInt',nsi ,0)
      if(nsi .gt. 16) then
         dtmsec=.001*nsi
      else
         dtmsec=nsi
      endif

      nbytes_hdr = ITRWRD * SZSMPD

      ioversion=3
      write(lugeom,'(4a12)') 'nsamp','dtmsec','ntrace','ioversion'
      write(lugeom,'(i12,f12.3,2i12)') nsamp,dtmsec,ntrace,ioversion
c
      write(LERR,*)
      write(LERR,*)' Values read from input data set line header'
      write(LERR,*)
      write(LERR,*) ' Traces per Record        =  ', ntrace
      write(LERR,*) ' Records per Line         =  ', nshot
      write(LERR,*) ' samples per trace        =  ', nsamp
      write(LERR,*) ' sample increment         =  ', nsi   
      write(LERR,*) ' use DphInd to calc SrcLoc?  ', use_dphind
      write(LERR,*) ' irregular (x,y) data?       ', xy_indexed
      if(xy_indexed) then
         write(lerr,'(a40,f12.3)') 'dip direction azimuth',azim
      endif
      write(LERR,*) ' vsp data?                   ', vsp       
      write(LERR,*) ' stacked data?               ', stacked   
      write(LERR,*) ' fixed datum?                ', fix_zdatum
      write(LERR,*) ' datum value              =  ', zdatum     
      write(LERR,*) ' station increment        =  ', dsta       
      write(LERR,*) ' shot smear tolerance     =  ', tol        
      ierror=0
      if(dtmsec .le. 0.) then
         write(lerr,*) 'error in line header'
         write(lerr,*) 'SmpInt nsi = ',nsi
         write(lerr,*) 'dtmsec     = ',dtmsec
         ierror=ierror+1
      endif
      if(nshot .le. 0.) then
         write(lerr,*) 'error in line header'
         write(lerr,*) 'NumRec nshot = ',nshot
         ierror=ierror+1
      endif
      if(ntrace .le. 0.) then
         write(lerr,*) 'error in line header'
         write(lerr,*) 'NumTrc ntrace = ',ntrace
         ierror=ierror+1
      endif
      if(nsamp  .le. 0.) then
         write(lerr,*) 'error in line header'
         write(lerr,*) 'NumSmp nsamp  = ',nsamp 
         ierror=ierror+1
      endif
      if(ierror .gt. 0.) then
         write(lerr,*) 'program aborted due to ',ierror, 
     1                 'input data header errors'
         close(lerr)
         call exitfu(666)
      endif
      maxg=maxrecind-minrecind+1
c________________________________________________________________________
c     calculate memory requirements
c________________________________________________________________________
      WRITE(lerr,'(///,80A1)') ('_',I=1,80)
      WRITE(lerr,'(A)')'STORAGE MAP OF MAJOR ARRAYS'
      WRITE(lerr,'(80A1)') ('_',I=1,80)
      WRITE(lerr,'(A20,3A10)')'VARIABLE NAME','BEGIN','END','LENGTH'
C
      l_FREE=1
      call mapmem('buffer',l_buffer,l_free,ITRWRD+nsamp,lerr) 
      call mapmem('xdistance',l_xdistance,l_free,ntrace,lerr) 
      call mapmem('zdistance',l_zdistance,l_free,ntrace,lerr) 
      call mapmem('group_elevation',l_group_elevation,
     1             l_free,ntrace,lerr) 
      call mapmem('isrcloc',l_isrcloc,l_free,ntrace,lerr) 
      call mapmem('isrptel',l_isrptel,l_free,ntrace,lerr) 
      call mapmem('xstemp',l_xstemp,l_free,ntrace,lerr) 
      call mapmem('ystemp',l_ystemp,l_free,ntrace,lerr) 
c
      call mapmem('xs',l_xs,l_free,nshot,lerr) 
      call mapmem('ys',l_ys,l_free,nshot,lerr) 
      call mapmem('zs',l_zs,l_free,nshot,lerr) 
      call mapmem('soptnm',l_soptnm,l_free,nshot,lerr) 
      call mapmem('srcloc',l_srcloc,l_free,nshot,lerr) 
      call mapmem('nlive',l_nlive,l_free,nshot,lerr) 
      call mapmem('xdistmin',l_xdistmin,l_free,nshot,lerr) 
      call mapmem('xdistmax',l_xdistmax,l_free,nshot,lerr) 
      call mapmem('zdistmin',l_zdistmin,l_free,nshot,lerr) 
      call mapmem('zdistmax',l_zdistmax,l_free,nshot,lerr) 
c
      call mapmem('recind',l_recind,       
     1             l_free,ntrace*nshot,lerr) 
      call mapmem('xr',l_xr,l_free,ntrace*nshot,lerr) 
      call mapmem('yr',l_yr,l_free,ntrace*nshot,lerr) 
      call mapmem('zr',l_zr,l_free,ntrace*nshot,lerr) 
      call mapmem('zwgather',l_zwgather,l_free,ntrace*nshot,lerr) 
      call mapmem('live',l_live,l_free,ntrace*nshot,lerr) 
c
      call mapmem('xtopo',l_xtopo,l_free,maxg,lerr) 
      call mapmem('ytopo',l_ytopo,l_free,maxg,lerr) 
      call mapmem('ztopo',l_ztopo,l_free,maxg,lerr) 
      call mapmem('xg',l_xg,l_free,maxg,lerr) 
      call mapmem('yg',l_yg,l_free,maxg,lerr) 
      call mapmem('zg',l_zg,l_free,maxg,lerr) 
      call mapmem('zw',l_zw,l_free,maxg,lerr) 
      call mapmem('lrecind',l_lrecind,l_free,maxg,lerr) 
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate dynamic memory for PREPMIG: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(stderr,'(//,a)') 'allocate dynamic memory for PREPMIG: '
      write(stderr,*) 1.e-6*lens,' Mwords'
      write(stderr,*) 1.e-6*lens*szsmpd,' Mbytes'
c
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)'program PREPMIG aborted'
         close(lerr)
         call exitfu(101)
      endif
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
c
c kdc - 05/20/93 - Bill May encountered a problem on the Cray-el where
c bogus numbers were printed out.  It turns out that prepmig was depending
c on array s being automatically initialized to 0.  Called vclr to fix it.
      call vclr(s,1,lens)
c
      call prepsub(s(l_buffer),s(l_buffer),s(l_srcloc),s(l_soptnm),
     1             s(l_xs),s(l_ys),s(l_zs),s(l_isrcloc),s(l_isrptel),
     2             s(l_xr),s(l_yr),s(l_zr),s(l_recind),s(l_live),
     3             s(l_xg),s(l_yg),s(l_zg),s(l_zw),s(l_nlive),
     4             s(l_xtopo),s(l_ytopo),s(l_ztopo),s(l_zwgather),
     5             s(l_lrecind),s(l_xstemp),s(l_ystemp),
     6             s(l_xdistmin),s(l_xdistmax),
     7             s(l_zdistmin),s(l_zdistmax),
     8             dsta,zdatum,fix_zdatum,nshot,ntrace,tol,
     9             luin,lugeom,nbytes_hdr,cputim,waltim,
     a             lutopo,luwater,lucmp,wrtopo,wrwater,wrcmp,
     b             zvo,dz,xy_indexed,model,stacked,
     c             minrecind,maxrecind,verbose,
     d             use_dphind,vsp,azim,stderr,lerr,undefined,
     e             use_SGRDat)
c
      call timend(cputim(20),vtot,v2,waltim(20),wtot,w2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'read headers',cputim(1),waltim(1),
     2         'process headers',cputim(2),waltim(2),
     3         'write flat file',cputim(3),waltim(3),
     4         'total',cputim(20),waltim(20)       

      write(lerr,*) 'normal completion of PREPMIG'
      write(stderr,*) 'normal completion of PREPMIG'
      if(wrwater) close(luwater)
      if(wrtopo) close(lutopo)
      if(wrcmp) close(lucmp)
      close(lerr)
      close(lugeom)
c
      call exitfu(0)
      end
c------------------------------
c  online help section
c------------------------------
      subroutine  help(ler)

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for PREPMIG: '
        write(LER,*)'           (trace header preprocessing for MBS)'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[file_sg]  -- input seismic data file '
     1                            //'(stdin)'
        write(LER,*)'-O[file_geom]-- output geometry flat file '
     1                            //'(stdout)'
        write(LER,*)'-T[file_topo]   -- output xsd format topography '
     1                            //'file (optional)'
        write(LER,*)'-W[file_water]  -- output xsd format water bottom '
     1                            //'file (optional)'
        write(LER,*)'-C[file_cmp]  -- output ascii format cmp location '
     1                            //'file for crooked lines (optional)'
        write(LER,*)'-dsta    -- distance between adjacent station'
     1                       //' location (RecInd) in m or ft (GrpInt)'
        write(LER,*)'-zdatum  -- override trace header elevations '
     1                   //' to lie on datum = zdatum  (honor headers)'
        write(LER,*)'-zvo     -- velocity worktape z origin (used for'
     1                   //' output xsd pick files (0.)'                 
        write(LER,*)'-dz      -- velocity worktape z increment (used '
     1                   //' for output xsd pick files (10.)'  
        write(LER,*)'-DphInd - if present,calculate SrcLoc from '     
        write(ler,*)'          SrcLoc=10*(DphInd-RecInd)'                    
        write(LER,*)'-X     -- if present,pull X and Y coord from the'
        write(ler,*)'          seismic trace headers SrPtXc,RcPtXC...'
        write(ler,*)'          (default: assume stations form a regular'
     1                         //' grid)' 
        write(LER,*)'-azim  -- azimuth of dip direction in degrees'
     1                         //' (necessary only if -X option used)'
        write(LER,*)'-S     -- if present,pull geometry of input'
        write(ler,*)'          STACKED data from depth index (DphInd)'
        write(ler,*)'          (dsta then becomes cmp interval!)'
        write(ler,*)'       first RecInd of new x axis is RecInd*dsta'
        write(ler,*)'          (defaulted true if -X option used)'     
        write(LER,*)'-vsp   -- if present, vsp walkaway survey assumed' 
        write(ler,*)'          WDepDP is associated with SrcLoc versus'
     1                         //' DphInd'
        write(LER,*)'-ming    -- minimum station index (RecInd) in data'
     1                           //' (-10000)'
        write(LER,*)'-maxg    -- maximum station index (RecInd) in data'
     1                           //' (+32667)'
        write(LER,*)
        write(LER,*)'usage:'
        write(LER,*)'        prepmig -N[] -O[] -T[] -W[] -C[]'
        write(ler,*)'                -dsta[] -zdatum[] '
        write(ler,*)'                -dz[] -zvo[] -azim[]'        
        write(LER,*)'                -ming[] -maxg[] -[X,DphInd,S]'                   
        write(LER,*)'                -[X,DphInd,S,vsp]'                   
        write(LER,*)' '

      return
      end

C***********************************************************************
      subroutine cmdlin(file_sg,file_geom,file_topo,file_water,file_cmp,
     1                  dsta,dz,zvo,zdatum,fix_zdatum,verbose,
     2                  xy_indexed,model,stacked,minrecind,maxrecind,
     3                  lerr,ler,use_dphind,vsp,azim,undefined,tol,
     4                  use_SGRDat)
c-----
c     get command arguments
c
c__________________________________________________________________
      character*(*)  file_sg,file_geom,file_topo,file_water
      character*(*)  file_cmp
      integer        argis
      logical        fix_zdatum
      logical        xy_indexed
      logical        model
      logical        stacked,use_dphind,use_SGRDat
      logical        vsp,verbose

      ierror=0

      call argstr('-N',file_sg,' ',' ') 
      call argstr('-O',file_geom,' ',' ') 
      call argstr('-T',file_topo,' ',' ') 
      call argstr('-W',file_water,' ',' ') 
      call argstr('-C',file_cmp,' ',' ') 
      call argr4('-zvo',zvo,0.,0.)
      call argr4('-dsta',dsta,0.,0.)
      call argr4('-tol',tol,0.,0.)
      call argr4('-azim',azim,undefined,undefined)
      call argr4('-dz',dz,10.,10.)
      call argi4('-ming',minrecind,-10000,-10000)     
      call argi4('-maxg',maxrecind,+32667,+32667)  
      call argr4('-zdatum',zdatum,-999999.,-999999.)
      xy_indexed=argis('-X').gt.0 
      verbose=argis('-V').gt.0 
      model=argis('-model').gt.0 
      vsp=argis('-vsp').gt.0 
      stacked=argis('-S').gt.0 
      use_SGRDat=argis('-SGRDat').gt.0 
      use_dphind=argis('-DphInd').gt.0 
      if(stacked) use_dphind=.true.
      if(zdatum .eq. undefined) then
         fix_zdatum=.false.
      else
         fix_zdatum=.true. 
      endif
      if(.not. xy_indexed .and. azim .eq. undefined) then
c_______________________________________________________________
c        nominal 2D line. (x=recind*dsta, y=0.)
c_______________________________________________________________
         azim=0.     
      endif
      if(azim .lt. -360. .and. azim .gt. +360.) then
         write(lerr,*) 'command line error!'
         write(lerr,*) 'azim = ',azim,' beyond +/-360 degrees!'
         ierror=ierror+1 
      endif
c
      if(dsta .eq. 0) then
        write(lerr,*) 'cmdlin error'         
        write(lerr,*) 'station/group increment must be explicitly'
        write(lerr,*) 'entered as a nonzero number!'
        ierror=ierror+1
      endif
      if(tol .eq. 0.) then
         tol=dsta/2.
      endif
c
      if(ierror .gt. 0) then 
         write(lerr,*) 'routine PREPMIG aborted'
         write(lerr,*) 
         write(lerr,*) 'usage:'
         write(lerr,*) ' prepmig -N[] -O[] -T[] -W[] -C[]'
         write(lerr,*) '         -dsta[] -zdatum[] -zvo[] -dz[]'
         write(lerr,*) '         -azim[]'
         write(lerr,*) '         -ming[] -maxg[] -[X,S,vsp]'                 
         close(lerr)
         call exitfu(666)
       endif
c
      return
      end
