C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c     PROGRAM MODULE  putsis:
c        chunk a bunch of numbers in a file or stdin into
c        sis trace format (with line header)
c
c**********************************************************************c
c
c READ INPUT NUMBERS, ATTACH LINE & TRACE HEADER, AND
c WRITES THE RESULTS TO AN OUTPUT FILE
c
c SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
c
c**********************************************************************c
c
c Aug 10, 2001 - Joe M. Wade
c   dynamically allocate space for data
c   eliminated references to LHED & HEAD   - Joe M. Wade
c
c Aug 13, 2003 - M. O'Brien, Allied Geophysics
c   added -RA flag to allow .gt. 1 trace to put passed in with 'echo'
c   fixed a number of bugs in the column handling option
c
c**********************************************************************c
c
c     DECLARE VARIABLES
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>

      integer     ilhd(1)
      pointer     (ptr_ilhd,ilhd)

      integer     Trace(1)
      pointer     (ptr_Trace,Trace)

      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin, luout, lbytes,obytes
      integer     argis

      integer     ier1,ier2,ier3,ier4, iab1,iab2,iab3,iab4
      character   name*6, otap*256, ntap*256
      logical     verbos, fill, col, readall

      real        work(1),ami(1)
      pointer     (ptr_work,work)
      pointer     (ptr_ami,ami)
 
      data name /'PUTSIS'/
      data luin /1/, luout /2/, lbytes /0/
      data verbos/.false./

c--------------------------------
c  get online help if necesssary
c--------------------------------
      if(argis('-?').gt.0 .or.
     :   argis('-h').gt.0 .or.
     :   argis('-help').gt.0) then
        call help()
        stop
      endif

c------------------------
c  open printout file
c------------------------
#include <f77/open.h>

c---------------------------------------------------
c     read program parameters from command line
c---------------------------------------------------
      call cmdln(ntap,otap,nsi,nsamp,ntrc,verbos,fill,val,col,readall)

c-----------------
c     open input
c-----------------
      if (.not. fill) then

        if (ntap .ne. ' ') then
          luin = LUCARD
          open (UNIT=luin, FILE=ntap)
          rewind luin
        else
          luin = LIN
        endif

      endif

c------------------------
c     allocate memory
c------------------------
      ier1=0
      ier2=0
      ier3=0
      ier4=0
      iab1=0
      iab2=0
      iab3=0
      iab4=0

      if (fill .or. readall) then
        iget = ntrc*nsamp*SZSMPD
        call galloc(ptr_work, iget,ier1,iab1)
        call vclr (work, 1, ntrc*nsamp)
      else
        iget = nsamp*SZSMPD
        call galloc(ptr_work, iget,ier1,iab1)
        call vclr (work, 1, nsamp)
      endif

      if (col) then
        iget = ntrc*SZSMPD
        call galloc(ptr_ami,iget,ier2,iab2)
      endif

      iget = SZTRHD + nsamp*SZSMPD
      call galloc(ptr_Trace,iget,ier3,iab3)

      iget = SZLNHD
      call galloc(ptr_ilhd,iget,ier4,iab4)

      if(ier1.ne.0 .or. ier2.ne.0 .or. ier3.ne.0 .or. ier4.ne.0)then
        write(LER ,*)'Memory allocation error.  FATAL!'
        stop
      endif

C----------------------------------------------
C     open output data set; build line header
C----------------------------------------------
      call getln( luout, otap, 'w', 1)

      nrec  = 1
      iform = 3
      unitsc = .001

      call savew(ilhd, 'SmpInt', nsi   , LINHED)
      call savew(ilhd, 'UnitSc', unitsc, LINHED)
      call savew(ilhd, 'NumSmp', nsamp , LINHED)
      call savew(ilhd, 'NumTrc', ntrc  , LINHED)
      call savew(ilhd, 'NumRec', nrec  , LINHED)
      call savew(ilhd, 'Format', iform , LINHED)

c-------------------------------------
c  update line header; historical LH
c-------------------------------------
      write(LERR,*)' '
      write(LERR,*)'Number samples      =  ',nsamp
      write(LERR,*)'Number records      =  ',nrec
      write(LERR,*)'Number traces       =  ',ntrc
      write(LERR,*)'Sample interval     =  ',nsi
      write(LERR,*)' '

      lbytes = HSTOFF
      nbyt = 2 * SZHFWD
      call savew(ilhd, 'HlhEnt',  0  , LINHED)
      call savew(ilhd, 'HlhByt', nbyt, LINHED)
      call savhlh(ilhd, lbytes, lbyout)

c--------------------------
c write line hdr to luout
c--------------------------
      call wrtape(luout, ilhd, lbyout)

c-----------------------------
c get trace header info (for stufing trace headers in main loop)
c-----------------------------
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)

c-----------------------------
c set the number of bytes in each output trace
c-----------------------------
      obytes = SZTRHD+SZSMPD*nsamp

c-----------------------------
c stuff the record number now since it won't change
c-----------------------------
      call savew2(Trace,ifmt_RecNum,l_RecNum,ln_RecNum,1,TRACEHEADER)

c------------------------------
c proceed with processing
c------------------------------
      IF (fill) THEN

        do i = 1, nsamp
          work(i) = val
        enddo

        call vmov (work, 1, Trace(ITHWP1), 1, nsamp)
        do itrc = 1,ntrc
          call savew2(Trace,ifmt_TrcNum,l_TrcNum,ln_TrcNum,itrc,
     :                TRACEHEADER)
          call wrtape(luout,Trace,obytes)
        enddo

      ELSE

        if (col) then

          ier1 = 0
          do k = 1, nsamp
            if (ier1.eq.0) then
              read(luin,*,IOSTAT=ier1)(ami(i),i=1,ntrc)
              call vmov(ami,1,work(k),nsamp,ntrc)
              ier2 = k
            endif
          enddo
  100     continue
          if (ier1.gt.0) then
            write(LER,*)name,': ERROR reading input - FATAL'
            write(LERR,*)name,': ERROR reading input - FATAL'
            stop
          endif

          indx = 1 - nsamp
          do itrc = 1, ntrc
            indx = indx + nsamp
            call savew2(itrc_out,ifmt_TrcNum,l_TrcNum,ln_TrcNum,itrc,
     :                  TRACEHEADER)
            call vmov (work(indx), 1, Trace(ITHWP1), 1, nsamp)
            call wrtape(luout,Trace,obytes)
          enddo
          if (ier1.lt.0) then
            write(LERR,*)name,': WARNING'
            write(LERR,*)name,
     :            ':   End of data detected prematurely at sample ',ier2
            write(LERR,*)name,':   You should QC your input and results'
            write(LER,*)name,': WARNING'
            write(LER,*)name,
     :            ':   End of data detected prematurely at sample ',ier2
            write(LER,*)name,':   You should QC your input and results'
          endif

        else

          if (readall) then

            read(luin,*,IOSTAT=ier1)(work(m),m=1,nsamp*ntrc)
            if (ier1.gt.0) then
              write(LER,*)name,': ERROR reading input - FATAL'
              write(LERR,*)name,': ERROR reading input - FATAL'
              stop
            endif
            indx = 1 - nsamp
            do itrc = 1, ntrc
              indx = indx + nsamp
              call savew2(itrc_out,ifmt_TrcNum,l_TrcNum,ln_TrcNum,itrc,
     :                    TRACEHEADER)
              call vmov (work(indx), 1, Trace(ITHWP1), 1, nsamp)
              call wrtape(luout,Trace,obytes)
              if (verbos) then
                write(LERR,*)'Trc= ',i,' Number samples read= ',m-1
                write(LERR,*)(work(i), i=1,m-1)
              endif
            enddo
            if (ier1.lt.0) then
              write(LERR,*)name,': WARNING'
              write(LERR,*)name,':   End of data detected prematurely'
              write(LERR,*)name,':   You should QC the input and output'
              write(LER,*)name,': WARNING'
              write(LER,*)name,':   End of data detected prematurely'
              write(LER,*)name,':   You should QC the input and output'
            endif

          else

            do itrc = 1, ntrc
              read(luin,*,IOSTAT=ier1)(work(m),m=1,nsamp)
              if (ier1.gt.0) then
                write(LER,*)name,': ERROR reading input trace ',itrc
                write(LERR,*)name,': ERROR reading input trace ',itrc
                stop
              endif
              if (ier1.lt.0) then
                write(LERR,*)
     :            name,': WARNING - premature end of input at trace ',itrc
                write(LER,*)
     :            name,': WARNING - premature end of input at trace ',itrc
              endif
              call savew2(itrc_out,ifmt_TrcNum,l_TrcNum,ln_TrcNum,itrc,
     :                    TRACEHEADER)
              call vmov (work, 1, Trace(ITHWP1), 1, nsamp)
              call wrtape(luout,Trace,obytes)
              if (verbos) then
                write(LERR,*)'Trc= ',i,' Number samples read= ',m-1
                write(LERR,*)(work(i), i=1,m-1)
              endif
            enddo

          endif

        endif

      ENDIF

c------------------------

      call lbclos(luout)

      END

c----------------------------
c  online help section
c----------------------------
      subroutine help
#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'Command Line Arguments for putsis: put numbers in'
      write(LER,*)'sis trace format'
      write(LER,*)' '
      write(LER,*)'Input....................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[ntap]   -- input data set name          (stdin)'
      write(LER,*)'-O[otap]   -- output data set name        (stdout)'
      write(LER,*)'-ns[nsamp] -- number input/output samples   (none)'
      write(LER,*)'-nt[ntrc]  -- number input traces              (1)'
      write(LER,*)'-si[nsi]   -- output sample interval, ms       (1)'
      write(LER,*)'-v[val]    -- value to stuff into traces    (none)'
      write(LER,*)'-F         -- fill trace with -val[] value (false)'
      write(LER,*)'-C         -- traces in column format,     (false)'
      write(LER,*)'              else traces one after another'
      write(LER,*)'-RA        -- read all samples at once     (false)'
      write(LER,*)'-V         -- verbos printout              (false)'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'      putsis [ -N[] -F -v[] ] -O[] -ns[] -nt[]'
      write(LER,*)'               -si[] -C -RA -V'
      write(LER,*)' '
      
      return
      end

c-----
c     get command arguments
c-----
      subroutine cmdln(ntap,otap,nsi,nsamp,ntrc,verbos,fill,val,col,
     :                 readall)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      integer    argis, nsi, nsamp, ntrc
      real       val
      logical    verbos, fill, col, readall

      call argstr('-N',ntap,' ',' ')
      call argstr('-O',otap,' ',' ')
      call argi4('-ns',nsamp,0,0)
      call argi4('-nt',ntrc,1,1)
      call argi4('-si',nsi,1,1)
      call argr4('-v',val,0.,0.)
      col    = ( argis( '-C' ) .gt. 0 )
      fill   = ( argis( '-F' ) .gt. 0 )
      readall= ( argis( '-RA') .gt. 0 )
      verbos = ( argis( '-V' ) .gt. 0 )

      if (nsamp .eq. 0) then
         write(LERR,*)'FATAL ERROR in putsis:'
         write(LERR,*)'Must enter number samples -ns[]'
         write(LER ,*)'FATAL ERROR in putsis:'
         write(LER ,*)'Must enter number samples -ns[]'
         stop
      endif

      return
      end
