C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c radonf reads seismic trace data from an input file,
c performs forward tau-p transform in the frequency domain and
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

 
      parameter (maxs=0 000 002)
      parameter (ndiv=10000,adiv=ndiv)
      parameter (lswgt=1000)                   
      dimension s(maxs)
      pointer   (pntrs,s)

      parameter   (pi=3.14159265,twopi=2.*pi)
      parameter   (maxarg=10000)           
      parameter   (maxpat=4)                 
c
      integer     hbegin
      integer     sheader(SZLNHD)
      integer     nsamp, nsi, ntr, nrec, iform
      integer     luin,luout,lbytes,nbyptr         
      real        xmax,white
      real        pmin,pmax
      integer     ist,iend,nfft,ifl,ifh, tpad
      integer     mmin,mmax,nlive,minlive
      logical     tabled(0:maxpat)
      logical     ytransform
      real        cputim(20),waltim(20)
#include <f77/pid.h>
#include <save_defs.h>
c
      character*256  ntap,otap,wgttap
      character*1    moveout
      character*6    name
      character*6    crwnam
      logical        verbose,query 
      logical        ipw,firstrec,time,semblance
      integer        argis
      logical        linear,parabolic,hyperbolic,fourier,eod
      logical        symmetric
      logical        wrtaup,wrwgt,wromega
      logical        alphatrim
      real           alpha
c 
      data           name/'RADONF'/
c_______________________________________________________________
c     initialize timing arrays.
c_______________________________________________________________
      call vclr(cputim,1,20)
      call vclr(waltim,1,20)
      call timstr(vtot,wtot)
      call timstr(v1,w1)
      lastpat=0
      do 10000 ipat=0,maxpat
       tabled(ipat)=.false.
10000 continue
c_______________________________________________________________
c     read program parameters from command line card image file
c_______________________________________________________________
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help(ler)
            call exit(0)
      endif
c_______________________________________________________________
c     open printout files
c_______________________________________________________________
#include <f77/open.h>
c_______________________________________________________________
c     get i/o data set names
c_______________________________________________________________
      call cmdln(ntap,otap,wgttap,verbose,ytransform)
c_______________________________________________________________
c     get logical unit numbers for input and output
c_______________________________________________________________
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      if(wgttap .ne. ' ') then
         call getln(luwgt,wgttap,'w',1)
         wrwgt=.true.
      else
         wrwgt=.false.
      endif
c_______________________________________________________________
c_______________________________________________________________
c     read line header of input
c     save certain parameters
c_______________________________________________________________
      call rtape(luin,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(lerr,*)'RADONF: no header read from unit ',luin
         close(lerr)
         call exit(666)
      endif
c
      call saver(sheader, 'NumSmp',nsamp,LINEHEADER)
      call saver(sheader, 'SmpInt',nsi,LINEHEADER)
      call saver(sheader, 'NumTrc',ntr,LINEHEADER)
      call saver(sheader, 'NumRec',nrec ,LINEHEADER)
      call saver(sheader, 'Format',iform,LINEHEADER)
      call saver(sheader, 'CrwNam',crwnam,LINEHEADER)
      call saver(sheader, 'T_Units',junits,LINEHEADER)
      call saver(sheader, 'UnitSc', unitsc, LINEHEADER)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(sheader, 'UnitSc', unitsc, LINEHEADER)
      endif
      dt = float(nsi) * unitsc
      dtmsec = 1000 * dt

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('MulSkw',ifmt_MulSkw,l_MulSkw,ln_MulSkw,TRACEHEADER)
      call savelu('RedVel',ifmt_RedVel,l_RedVel,ln_RedVel,TRACEHEADER)

      hbegin=1-ITRWRD
      lenhed = ITRWRD

      call hlhprt (sheader,lbytes,name,6,lerr)
c_______________________________________________________________
c     read in remaining parameters from command line
c_______________________________________________________________
      call rdparm(nsamp,nrec,ntr,dtmsec,
     1            ist,iend,f1,f2,f3,f4,mmin,mmax,np,minlive,
     2            xmax,white,wromega,wrtaup,
     3            linear,parabolic,hyperbolic,fourier,zref,
     4            nxtaper, nttaper,lerr,ierror,ipw,pw,time,
     5            szsmpd,amaxmem,semblance,alphatrim,alpha,
     6            sembwt,ltsemb,lxsemb,sigma1,sigma2,
     7            tsemb1,tsemb2,tsemb3,tsemb4,fs,tpad)
      if (ierror .ne. 0) then
         write(lerr,*)'Program abort due to ,',ierror,
     1                ' command line errors'
         go to 99000
      endif
      if(parabolic .or. hyperbolic) then
         symmetric=.false.
      else
         symmetric=.false.
      endif
      maxwords=amaxmem*1.e+06
c_______________________________________________________________
c     initialize parameters
c_______________________________________________________________
      call msize(nsamp,nfft,nfft2,ist,iend,lenwnd,
     1           mmin,mmax,f1,f4,ifl,ifh,flow,df,nf,nfmax,
     2           pmin,pmax,np,dt,dtmsec,domega,
     3           linear,parabolic,hyperbolic,fourier,zref,
     4           xmax,factor,pi,lerr,fs,fstart,tpad)
      if(wromega) then
         nsamp_out=nfft
      else
         nsamp_out=nsamp
      endif
c______________________________________________________________________
c     calculate buffer requirements for nested mixed radix ffts.
c     cray scilib routine rfftmlt runs twice as fast as mathadvantage
c     routine rnfftm.
c
c     buffer   mathadvantage rnfftm        cray scilib rfftmlt
c
c     itab      nfft+34                      2*nfft
c     rtab      3(nfft/2)+13                 2*nfft
c     work      18*ntr                       4*nfft*ntr
c______________________________________________________________________
      maxtrace=max(ntr,np)
      if(szsmpd .eq. 4) then
         lenitab=nfft+34
         lenrtab=3*(nfft/2)+13
         lenwork=18*maxtrace   
      else
         lenitab=max(2*nfft,nfft+34)
         lenrtab=max(2*nfft,3*(nfft/2)+13)
         lenwork=max(4*(maxtrace+1)*nfft,18*maxtrace)
      endif
      maxdist=nint(xmax)
      mindist=-maxdist   
C_______________________________________________________________________
c     output of all pertinent information before
c     memory allocation
C_______________________________________________________________________
      write(lerr,*)' '
      write(lerr,*)' line header values after default check '
      write(lerr,*)' '
      if(linear) then
         write(lerr,*) 'fit data with LINEAR curves'
      elseif(parabolic) then
         write(lerr,*) 'fit data with PARABOLIC curves'
      elseif(hyperbolic) then
         write(lerr,*) 'fit data with HYPERBOLIC curves'
         write(lerr,*) ' reference depth      = ',zref
      elseif(fourier) then
         write(lerr,*) 'fit data with FOURIER sin/cos curves'
         write(lerr,*) ' reference depth      = ',zref
      endif
      write(lerr,'(a40,l8)') 'symmetric?',symmetric
      write(lerr,*)
      write(lerr,*) 'input data set name     = ', ntap
      write(lerr,*) 'output data set name    = ', otap
      write(lerr,'(a40,i8)') 'number of samples/trace',nsamp
      write(lerr,'(a40,i8)') 'analysis window (samps)',lenwnd
      write(lerr,'(a40,i8)') 'starting time   (samps)',ist     
      write(lerr,'(a40,i8)') 'ending   time   (samps)',iend    
      write(lerr,'(a40,f12.3)') 'sample interval (msec)',dt 
      write(lerr,'(a40,i8)') 'traces per record',ntr
      write(lerr,'(a40,i8)') 'taper length in traces',nxtaper
      write(lerr,'(a40,i8)') 'taper length in samples',nttaper
      write(lerr,'(a40,i8)') 'records per line', nrec
      write(lerr,'(a40,f12.3)') 'first (low) frequency (Hz)',f1
      write(lerr,'(a40,f12.3)') 'second frequency (Hz)',f2
      write(lerr,'(a40,f12.3)') 'third frequency (Hz)',f3
      write(lerr,'(a40,f12.3)') 'fourth frequency (Hz)',f4
      write(lerr,'(a40,f12.3)') 'shift frequency (Hz)',fs
      write(lerr,'(a40,i8)') 'low frequency (index)',ifl
      write(lerr,'(a40,i8)') 'hi frequency (index)',ifh
      write(lerr,'(a40,f12.3)') 'low frequency (dimensionless) ',flow 
      write(lerr,'(a40,f12.3)') 'start frequency(dimensionless) ',
     1                             fstart
      write(lerr,'(a40,i8)') 'computation freq', nf
      write(lerr,'(a40,i8)') 'fft freq', nfmax
      write(lerr,'(a40,i8)') 'length of mixed radix fft',nfft
      write(lerr,'(a40,i8)') 'length of power 2 fft',nfft2
      write(lerr,*)' '
      write(lerr,'(a40,f12.3)') 'maximum offset xmax',xmax
      write(lerr,'(a40,i8)') 'minimum moveout mmin (msec)',mmin
      write(lerr,'(a40,i8)') 'minimum moveout mmax (msec)',mmax
      write(lerr,'(a40,f12.3)') ' first ray parameter pmin',pmin
      write(lerr,'(a40,f12.3)') ' last ray parameter pmax',pmax
      write(lerr,'(a40,i8)') 'number of ray parameters np',np
      write(lerr,'(a40,f12.3)') ' prewhitening',white
      write(lerr,'(a40,l8)') 'transform in time domain?',time        
      write(lerr,'(a40,l8)') 'semblance weighting?',semblance   
      if(semblance) then
         write(lerr,'(a40,f12.3)')  'sigma1',sigma1,'sigma2',sigma2
         write(lerr,'(a40,f12.3)')  'sembwt (msec)',sembwt         
         write(lerr,'(a40,i8)')
     1        ' half running semlance height in samples',ltsemb,          
     2        ' half running semblance width in traces',lxsemb
         write(lerr,'(a40,f12.3)')  'tsemb1 (msec)',tsemb1         
         write(lerr,'(a40,f12.3)')  'tsemb2 (msec)',tsemb2         
         write(lerr,'(a40,f12.3)')  'tsemb3 (msec)',tsemb3         
         write(lerr,'(a40,f12.3)')  'tsemb4 (msec)',tsemb4         
      endif
      write(lerr,'(a40,l8)') 'inverse power weighting?',ipw         
      write(lerr,'(a40,f12.3)') 'ipw power weight (pw)',pw
      write(lerr,'(a40,l8)') 'alpha trim mean?',alphatrim       
      write(lerr,'(a40,f12.3)') 'alpha',alpha       
      write(lerr,'(a40,l8)') 'output results in (omega,p)? ',wromega     
      write(lerr,'(a40,l8)') 
     1       'output (tau,p) vs discrete Radon transform?',wrtaup
      write(lerr,'(a40,l8)') 'transform from y to q?',ytransform      
      write(lerr,'(a40,i8)') 'maximum memory (words)', maxwords
      write(lerr,'(a40,f12.3)') 'maximum memory (Mwords)',amaxmem 
      write(lerr,'(a40,l8)') 'verbose output?',verbose              
      write(lerr,*)' '
      if(nf .le. 0) then
         write(lerr,*) 'error in program radonf!'
         write(lerr,*) 'nf = ', nf
         write(lerr,*) 'probable error: bad units!'
         call exitfu(2666)
      endif 
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
      lenbuft=(nsamp+ITRWRD)
      lenbuf=ntr*(nsamp+ITRWRD)
c____________________________________________________________________
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('str',l_str,l_free,lenbuft,lerr)
      call mapmem('tbufin',l_tbufin,l_free,lenbuf,lerr)
      call mapmem('tbufout',l_tbufout,l_free,
     1                               np*(nsamp_out+ITRWRD),lerr)
      call mapmem('theta',l_theta,l_free,ntr,lerr)
      call mapmem('dist',l_dist,l_free,ntr,lerr)
      call mapmem('ioffset',l_ioffset,l_free,
     1               (maxdist-mindist+1),lerr)
      call mapmem('distpat',l_distpat,l_free,ntr*(maxpat+1),lerr)
      call mapmem('muteend',l_muteend,l_free,ntr,lerr)
      call mapmem('live',l_live,l_free,ntr,lerr)
      call mapmem('cincr',l_cincr,l_free,2*np,lerr)
      call mapmem('uin',l_uin,l_free,nfft*ntr,lerr)
      call mapmem('ui',l_ui,l_free,nfft*ntr,lerr)
      call mapmem('ui2',l_ui2,l_free,nfft*ntr,lerr)
      call mapmem('sembwgt',l_sembwgt,l_free,nfft*ntr,lerr)
      call mapmem('unum',l_unum,l_free,nfft*ntr,lerr)
      call mapmem('unum2',l_unum2,l_free,nfft*ntr,lerr)
      call mapmem('unumsum',l_unumsum,l_free,nfft*ntr,lerr)
      call mapmem('udenom',l_udenom,l_free,nfft*ntr,lerr)
      call mapmem('udenomsum',l_udenomsum,l_free,nfft*ntr,lerr)
      call mapmem('uout',l_uout,l_free,nfft*np,lerr)
      call mapmem('rtabf',l_rtabf,l_free,lenrtab,lerr)
      call mapmem('itabf',l_itabf,l_free,lenitab,lerr)
      call mapmem('rtabi',l_rtabi,l_free,lenrtab,lerr)
      call mapmem('itabi',l_itabi,l_free,lenitab,lerr)
      call mapmem('work',l_work,l_free,lenwork,lerr)
      call mapmem('rtrans',l_rtrans,l_free,2*nf*np,lerr)
      call mapmem('utaup',l_utaup,l_free,nfft*np,lerr)
      call mapmem('trcwgt',l_trcwgt,l_free,nfft,lerr)
      call mapmem('taupwgt',l_taupwgt,l_free,nfft*np,lerr)
      call mapmem('trcwgtsum',l_trcwgtsum,l_free,nfft,lerr)
      call mapmem('a',l_a,l_free,2*nf*np*(maxpat+1),lerr)
      call mapmem('u',l_u,l_free,2*nf*np,lerr)
      call mapmem('s',l_s,l_free,2*nf*np,lerr)
      call mapmem('v',l_v,l_free,2*nf,lerr)
      call mapmem('r',l_r,l_free,2*nf,lerr)
      call mapmem('rc',l_rc,l_free,2*nf,lerr)
      call mapmem('e',l_e,l_free,2*nf,lerr)
      call mapmem('ec',l_ec,l_free,2*nf,lerr)
      call mapmem('temp',l_temp,l_free,2*nf,lerr)
      call mapmem('rnorm',l_rnorm,l_free,nf,lerr)
      call mapmem('freq',l_freq,l_free,nf,lerr)
      call mapmem('p',l_p,l_free,np,lerr)
      call mapmem('delt',l_delt,l_free,np,lerr)
      call mapmem('xwgt',l_xwgt,l_free,ntr,lerr)
      call mapmem('twgt',l_twgt,l_free,lenwnd,lerr)
      call mapmem('ncount',l_ncount,l_free,lenwnd,lerr)
      call mapmem('anum',l_anum,l_free,lenwnd,lerr)
      call mapmem('anum2',l_anum2,l_free,lenwnd,lerr)
      call mapmem('adenom',l_adenom,l_free,lenwnd,lerr)
      call mapmem('fwgt',l_fwgt,l_free,nfft/2,lerr)
      call mapmem('tsembwgt',l_tsembwgt,l_free,nfft,lerr)
      call mapmem('rho',l_rho,l_free,nfft/2,lerr)
      call mapmem('w',l_w,l_free,8*(ndiv+1),lerr)
      call mapmem('swgt',l_swgt,l_free,lswgt+1,lerr)
C_______________________________________________________________________
C     calculate 'leftover memory'. use it to store radon transform
c     matrices.
C_______________________________________________________________________
      leftover=maxwords-(l_free-1)
      lenmatrix=2*np*nf
      maxoffset=leftover/lenmatrix-1
c     maxoffset=0
      maxoffset=max(maxoffset,1)
      write(lerr,*) 'maxwords  = ',maxwords 
      write(lerr,*) 'leftover  = ',leftover 
      write(lerr,*) 'lenmatrix = ',lenmatrix
      write(lerr,*) 'maxoffset = ',maxoffset
      lenradon=(maxoffset+1)*lenmatrix
      call mapmem('radon',l_radon,l_free,lenradon,lerr)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)'memory can be decreased by using the -M option'
         write(lerr,*)
         write(lerr,*)'program RADONF aborted'
         close(lerr)
         call exit(101)
      endif
c_______________________________________________________________
c     precompute tabled arrays that will be remain invariant for all
c     seismic gathers.
c_______________________________________________________________
      call gettab(s(l_p),s(l_delt),df,dp,nf,np,s(l_rho),domega,pi,
     1            s(l_fwgt),f1,f2,f3,f4,dt,s(l_twgt),nttaper,lenwnd,
     2            s(l_tsembwgt),tsemb1,tsemb2,tsemb3,tsemb4,
     3            dtmsec,pmin,pmax,nfft,s(l_freq),ifl,ifh,
     4            s(l_swgt),sigma1,sigma2,lswgt,verbose,
     5            s(l_xwgt),nxtaper,ntr,factor,lerr,parabolic)
C_______________________________________________________________________
c     update output line header.
c     steal header words to save values necessary for inverser radon
c     transform.
C_______________________________________________________________________
      if(linear) then
         moveout='L'
      elseif(parabolic) then
         moveout='P'
      elseif(hyperbolic) then
         moveout='H'
      elseif(fourier) then
         moveout='F'
      endif
      izref=nint(zref)
      ixmax=nint(xmax)
c
      call savew(sheader,'NumRec',nrec,LINEHEADER)
      call savew(sheader,'NumTrc',np,LINEHEADER)
      call savew(sheader,'NumSmp',nsamp_out,LINEHEADER)
      if (tpad .gt. 0) then
          call savew(sheader,'VlFnRF',tpad,LINEHEADER)
          call savew(sheader,'Crew06','P',LINEHEADER)
      endif
      if(wromega) then
         call savew(sheader,'Crew01','f',LINEHEADER)
         call savew( sheader,'TmSlIn',nsamp,LINEHEADER)
      else
         call savew(sheader,'Crew01','t',LINEHEADER)
      endif
      if(ytransform) then 
c_______________________________________________________________________
c        transform is from y to q.
c        use line header locations set 2.
c_______________________________________________________________________
         if(crwnam(5:5) .eq. 'q') then
            write(lerr,*) ' lineheader word CrwNam indicates y-->q'
     1           //' transform already completed!'
            write(lerr,*) ' CrwNam = ',crwnam
            write(lerr,*) ' check command line arguments or '
     1           //' modify lineheader using routine utop'
            close(lerr)
            call exit(1201)
         endif
         call savew(sheader,'Crew04','q',LINEHEADER)
         call savew(sheader,'Crew05',moveout,LINEHEADER)
c
         call savew(sheader,'MnShDp',ntr,LINEHEADER)
         call savew(sheader,'MxShDp',nfft,LINEHEADER)
c
         if1=nint(1.e+06*f1)
         if4=nint(1.e+06*f4) 
         idf=nint(1.e+06*df)
c
         call savew(sheader,'TmMsSl',if1,LINEHEADER)
         call savew(sheader,'TmSlIn',if4,LINEHEADER)
         call savew(sheader,'AERcPr',idf,LINEHEADER)
c
         call savew(sheader,'IndAdj',izref,LINEHEADER)
         call savew(sheader,'MnSPEl',mmin,LINEHEADER)
         call savew(sheader,'MxSPEl',mmax,LINEHEADER)
c
         call savew(sheader,'MnTrOf',ixmax,LINEHEADER)
         call savew(sheader,'MnTrSt',ist,LINEHEADER)
      else
C_______________________________________________________________________
c        transform is from x to p.
c        use line header locations set 1.
C_______________________________________________________________________
         if(crwnam(3:3) .eq. 'p') then
            write(lerr,*) ' lineheader word CrwNam indicates x-->p'
     1           //' transform already completed!'
            write(lerr,*) ' CrwNam = ',crwnam
            write(lerr,*) ' check command line arguments or '
     1           //' modify lineheader using routine utop'
            close(lerr)
            call exit(1202)
         endif

         call savew(sheader,'Crew02','p',LINEHEADER)
         call savew(sheader,'Crew03',moveout,LINEHEADER)
c
         call savew(sheader,'MnUHTm',ntr,LINEHEADER)
         call savew(sheader,'MxUHTm',nfft,LINEHEADER)
c
         call savew(sheader,'FreQst',f1,LINEHEADER)
         call savew(sheader,'MutVel',f4,LINEHEADER)
         call savew(sheader,'NmSpMi',df,LINEHEADER)
c
         call savew(sheader,'MxRSEL',izref,LINEHEADER)
         call savew(sheader,'MnGrEl',mmin,LINEHEADER)
         call savew(sheader,'MxGrEl',mmax,LINEHEADER)
c
         call savew(sheader,'MxTrOf',ixmax,LINEHEADER)
         call savew(sheader,'MxTrSt',ist,LINEHEADER)
      endif

      call savhlh(sheader,lbytes,lbyout)
      call wrtape(luout,sheader,lbyout)
      if(wrwgt) then
         call wrtape(luwgt,sheader,lbyout)
      endif
      call timend(cputim(1),v1,v2,waltim(1),w1,w2)
c_____________________________________________________________   
c     get interpolation weights.
c_____________________________________________________________   
      call getw8(s(l_w),ndiv)
c_____________________________________________________________   
c     calculate length of trace in integer*2 words.
c     calculate number of bytes in output trace
c     calculate trace header position of key variables.
c_____________________________________________________________   
      lentr2     = (ITRWRD+nsamp)
      lentr2_out = (ITRWRD+nsamp_out)
      nbyptr=(nsamp_out+ITRWRD)*SZSMPD

c     call savelu('DstSgn',ifmt,l_DstSgn,length,TRACEHEADER)
c     call savelu('DstUsg',ifmt,l_DstUsg,length,TRACEHEADER)
c     call savelu('StaCor',ifmt,l_StaCor,length,TRACEHEADER)
c     call savelu('TrcNum',ifmt,l_TrcNum,length,TRACEHEADER)
c     call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
c     call savelu('RecInd',ifmt,l_RecInd,length,TRACEHEADER)
c     call savelu('SrcLoc',ifmt,l_SrcLoc,length,TRACEHEADER)
c     call savelu('DphInd',ifmt,l_DphInd,length,TRACEHEADER)

      if(ytransform) then
         call savelu('TVPV19',ifmt_disthdr,l_disthdr,ln_disthdr,
     1               TRACEHEADER)
         call savelu('PREPIn',ifmt_mute,l_mute,ln_mute,
     1               TRACEHEADER)
      else
         call savelu('TVPT19',ifmt_disthdr,l_disthdr,ln_disthdr,
     1               TRACEHEADER)
         call savelu('MulSkw',ifmt_mute,l_mute,ln_mute,
     1               TRACEHEADER)
      endif
c_____________________________________________________________   
c     initialize radon transform offset pointer.
c_____________________________________________________________   
      call vfill(0,s(l_ioffset),1,maxdist-mindist+1)
      noffset=0
      initfftf=1
      initffti=1
      ndiscard=0
      ndeadrec=0
c_____________________________________________________________   
c     loop over all records.
c_____________________________________________________________   
      firstrec=.true.
      do 20000 irec = 1, nrec
       call rdgather(s(l_tbufin),s(l_tbufin),s(l_tbufout),
     1               hbegin,nsamp,lentr2,ntr,np,luin,lerr,eod,irec,           
     2               lntrhd,l_DstSgn,l_StaCor,l_TrcNum,s(l_xwgt),
     3               s(l_live),s(l_theta),s(l_dist),zref,xmax,  
     4               l_mute,hyperbolic,parabolic,linear,
     5               fourier,nlive,l_disthdr,ler,lentr2_out,
     6               ifmt_StaCor,ln_StaCor,ifmt_TrcNum,ln_TrcNum,
     7               ifmt_DstSgn,ln_DstSgn,ifmt_disthdr,ln_disthdr,
     8               ifmt_mute,ln_mute,ITRWRD,tpad,s(l_str))
       if(eod) go to 99000
c_____________________________________________________________
c      initialize trace headers.
c_____________________________________________________________
       call hdinit(s(l_tbufout),s(l_p),s(l_delt),lentr2_out,ITRWRD,
     1             np,irec,l_TrcNum,l_DstUsg,l_RecNum,l_StaCor,
     2             dt,ytransform,ifmt_StaCor,ln_StaCor,
     3             ifmt_TrcNum,ln_TrcNum,ifmt_DstUsg,ln_DstUsg,
     4             ifmt_RecNum,ln_RecNum,
     5             l_RedVel,ifmt_RecVel,ln_RecVel)


       if(nlive .lt. minlive) then
c_____________________________________________________________   
c         zero out record.
c_____________________________________________________________   
          call clrgather(s(l_tbufout),s(l_tbufout),
     1                   lentr2_out,l_StaCor,hbegin,nsamp_out,ntr,
     2                   ifmt_StaCor,ln_StaCor)
       else
c_____________________________________________________________   
c         go take forward radon transform.
c_____________________________________________________________   
          call fwdt(s(l_tbufin),s(l_tbufout),hbegin,nsamp,nsamp_out,
     1     s(l_utaup),s(l_ui),s(l_ui2),s(l_w),ndiv,adiv,s(l_sembwgt),
     2     s(l_unumsum),s(l_udenomsum),s(l_unum),s(l_unum2),
     3     s(l_udenom),nfft,nfft2,s(l_theta),s(l_uout),
     3     s(l_dist),noffset,maxoffset,s(l_ioffset), 
     4     mindist,maxdist,nbyptr,wromega,s(l_swgt),lswgt,
     5     s(l_live),np,ifl,ifh,irec,ITRWRD,SZSMPD,
     6     s(l_a),s(l_rtrans),s(l_u),s(l_rnorm),luout,
     7     s(l_v),s(l_r),s(l_e),s(l_ec),s(l_temp),s(l_rc),
     8     s(l_s),s(l_freq),fstart,s(l_p),s(l_uin),s(l_rho),
     9     s(l_radon),s(l_cincr),white,df,
     a     ist,lenwnd,ntr,symmetric,
     b     s(l_rtabf),s(l_itabf),initfftf,s(l_work),
     c     s(l_rtabi),s(l_itabi),initffti,tabled,lastpat,
     d     lenrtab,lenitab,lenwork,s(l_distpat),maxpat,
     e     s(l_fwgt),s(l_twgt),nlive,ipw,firstrec,time,
     f     s(l_trcwgt),s(l_trcwgtsum),s(l_taupwgt),s(l_ncount),
     g     s(l_muteend),lerr,cputim,waltim,verbose,
     h     l_TrcNum,l_DstSgn,l_RecNum,pw,wrwgt,luwgt,s(l_tsembwgt),
     i     semblance,wrtaup,ltsemb,lxsemb,alphatrim,alpha,fourier)
       endif
c_____________________________________________________________   
c      write out data.         
c_____________________________________________________________   
       call timstr(v1,w1)
       call wrgather(s(l_tbufout),hbegin,nsamp_out,
     1                  np,luout,nbyptr)
       call timend(cputim(9),v1,v2,waltim(9),w1,w2)
20000 continue
      write(lerr,*) 'noffset = ',noffset
99000 continue
c_____________________________________________________________   
c     write out timing statistics.
c_____________________________________________________________   
      call timend(cputim(20),vtot,V2,waltim(20),wtot,W2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'setup',cputim(1),waltim(1),
     2         'taup transform',cputim(11),waltim(11),
     2         'forward fft',cputim(2),waltim(2),
     3         'calculate radon',cputim(3),waltim(3),
     4         'forward radon',cputim(4),waltim(4),
     5         'form normal eqns',cputim(10),waltim(10),
     6         'invert normal eqns',cputim(5),waltim(5),
     9         'inverse fft',cputim(7),waltim(7),
     a         'write output',cputim(9),waltim(9),
     b         'time interpolate',cputim(17),waltim(17),
     b         'semblance',cputim(18),waltim(18),
     b         'alpha trim mean',cputim(19),waltim(19),
     c         'total',cputim(20),waltim(20)
c_____________________________________________________________   
c     close data files
c_____________________________________________________________   
      call lbclos(luin)
      call lbclos(luout)
      if(wrwgt) call lbclos(luwgt) 

      write(ler,*) 'Normal completetion. routine RADONF'
      write(lerr,*)'end of radon, processed',nrec,' record(s)',
     :            ' with ',ntr, ' traces'
      write(lerr,*)'end of radon, processed',nrec,' record(s)',
     :            ' with ',ntr, ' traces'
      close(lerr)
      call exit(0)
      end
 
C***********************************************************************
 

      subroutine cmdln( ntap,otap,wgttap,verbose,ytransform)

      character*(*)  ntap,otap,wgttap
      integer    argis
      logical    verbose
      logical    ytransform

      call argstr('-N',ntap,' ',' ')
      call argstr('-O',otap,' ',' ')
      call argstr('-wgt',wgttap,' ',' ')
      verbose=(argis('-V') .gt. 0)
      ytransform=(argis('-Y') .gt. 0)

      return
      end

      subroutine help(ler)

         write(ler,*)
     1'***************************************************************'
       write(ler,*)' '
        write(ler,*)
     1'execute radonf by typing radonf and list of program parameters.'
        write(ler,*)
     1'note that each parameter is proceeded by -a where "a" is '
        write(ler,*)
     1'a character(s) corresponding to some parameter.'
        write(ler,*)
     1'users enter the following parameters, or use the default values'
       write(ler,*)' '
        write(ler,*)
     1' -N [ntap]  (stdin)   : input data file name'
        write(ler,*)
     1' -O [otap]  (stdout)  : output data file name'
        write(ler,*)
     1' -wgt[wgttap] (optional) :'
     2                 //' output weight applied to tau-p transform'
        write(ler,*)
     1' -s[ist]    (1st samp) :  start of processing window (ms)'
        write(ler,*)
     1' -e[iend]   (last samp):  end of processing window (ms)'
        write(ler,*)
     1' -f1[f1]   (5.)      :  begin roll in taper (Hz)' 
        write(ler,*)
     1' -f2[f2]   (f1)      :  end roll in taper (Hz)'
        write(ler,*)
     1' -f3[f3]   (f4)      :  begin roll off taper (Hz)'
        write(ler,*)
     1' -f4[f4]   (temporal Nyquist) :  end roll off freqency (Hz)'
        write(ler,*)
     1' -xmax[xmax](none)   :  max absolute distance (ft,m) to be'
     2                                //'modeled'
        write(ler,*)
     1' -mmin[mmin]   (0)   :  minimum moveout to be modeled (ms)'
        write(ler,*)
     1' -mmax[mmax]   (none):  maximum moveout to be modeled (ms)'
        write(ler,*)
     1' -np[np]       (ntrace) :  number of parameters/curves '
        write(ler,*)
     1'                           used to span modeled space'   
        write(ler,*)
     1' -prew[white]   (5.0) :  % prewhitening for inverse'
        write(ler,*)
     1' -tpad[tpad] (0) : time to pad top of record'
        write(ler,*)
     1' -nttaper[nttaper] (100) : length (ms) of temporal taper'
        write(ler,*)
     1' -nxtaper[nxtaper] (5)   : length (traces) of spatial tapers' 
        write(ler,*)
     1' -live[nlive]   (3)  :  minimum # live traces required'
        write(ler,*)
     1' -sigma1[sigma1] (.1)    : if present apply semblance weighting'
     2                       //' with weight=0. if semblance < sigma1'
        write(ler,*)
     1' -sigma2[sigma2] (.2)    : if present apply semblance weighting'
     2                       //' with weight=1. if semblance > sigma2'       
        write(ler,*)
     1' -sembwt[sembwt] (5 samps): half time window for running'// 
     2                           ' semblance calculation' 
        write(ler,*)
     1' -sembwx[sembwx] (0)      : half trace window for running '//
     1                               'window semblance calculation' 
      write(ler,*)
     1' -tsemb1[tsemb1] (first samp) : begin roll in of semblance '
     2                         //' weighting (msec)'
      write(ler,*)
     1' -tsemb2[tsemb2] (tsemb1)     : end  roll in of semblance '
     2                         //' weighting (msec)'
      write(ler,*)
     1' -tsemb3[tsemb3] (tsemb4)     : begin roll out of semblance '
     2                         //' weighting (msec)'
      write(ler,*)
     1' -tsemb4[tsemb4] (last samp)  : end roll out of semblance '
     2                         //' weighting (msec)'
        write(ler,*)
     1' -alpha[alpha] (1.0) : if entered, perform alpha-trim mean'
     2                         //' alpha = 0.0 implies median filter'
        write(ler,*)
     1' -ipw[pw](.1)        : if entered, perform inverse power'
     2                         //' weighting  using a minimum weight'
        write(ler,*)
     1'                           of pw*squared energy in each record'
         write(ler,*)
     1' -M[amaxmem]         : maximum memory in megawords'
         write(ler,*)
     1'                       (default 4 on sparc, 16 on cray)'

        write(ler,*)
     1' -nyquist            : set value of np to be 2 points '//
     2                       ' period at farthest offset'
        write(ler,*)
     1' -taup :             : if present, output conventional (tau,p)'
     2                      //' versus discrete Radon transform'
        write(ler,*)
     1' -L                  : fit data with linear curves'  
        write(ler,*)
     1' -P         (default): fit data with parabolic curves'  
        write(ler,*)
     1' -K                  : fit data with Fourier sin/cos functions' 
     2                      //' (least square (omega,k) transform)'
        write(ler,*)
     1' -H                  : fit data with hyperbolic curves'  
        write(ler,*)
     1' -zref      (xmax)   : reference depth for hyperbolae'   
        write(ler,*)
     1' -Y                  : if present, transform from (tau,y,p) to'
     2                      //' (tau,q,p)'   
        write(ler,*)
     1' -omega              : if present, output data in (omega,p) '//
     2                          ' Default is (tau,p)'
        write(ler,*)
     1'                                          or from (t,y,x) to'
     2                      //' (tau,q,x) domain'
        write(ler,*)
     1' -V                  :  if present, verbose printout'
       write(ler,*)' '
       write(ler,*)'usage:'
       write(ler,*)
       write(ler,*)'radonf -N[ntap] -O[otap] '
       write(ler,*)'       -s[] -e[] -f1[] -f2[] -f3[] -f4[]'
       write(ler,*)'       -mmin[] -mmax[] -np[] -tpad[]'
       write(ler,*)'       -xmax[] -zref[] -ipw[] -alpha[]'   
       write(ler,*)'       -prew[] -live[] -nxtaper[] -nttaper[] -M[]'
       write(ler,*)'       -sigma1[] -sigma2[] -sembwt[] -sembwx[]'        
       write(ler,*)'       -tsemb1[] -tsemb2[] -tsemb3[] -tsemb4[]'        
       write(ler,*)'       -[L,P,H,K,Y,omega,taup,time,nyquist,V] '
       write(ler,*)' '
       write(ler,*)

      return
      end
 

