C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gettab(p,fl,df,np,ifl,ifh,pmin,pmax,
     1                  radon,cincr,noffset,pwgt,nptaper,
     3                  xmin,xmax,dx,lerr,cputim,waltim)
c_______________________________________________________________
c     routine to precompute/table relevant matrices and arrays for
c     efficient calculations.
c_______________________________________________________________
c     radon transform matrix
c_______________________________________________________________
      complex    radon(ifl:ifh,np,0:noffset)
      complex    cincr(np)                         
c_______________________________________________________________
c     other tabled arrays.
c_______________________________________________________________
      real    p(np)
      real    pwgt(np)
      real    cputim(*),waltim(*)
c_____________________________________________________________
c     precompute p array
c_____________________________________________________________
      write(lerr,'(/,a15,4a15,/)') 'curve number','p','delt'
      dp=(pmax-pmin)/float(np-1)
      do 40000 jp=1,np
       p(jp)=pmin+(jp-1)*dp
       write(lerr,'(i15,e15.5)') jp,p(jp)
40000 continue
c_____________________________________________________________________
c     calculate spatial tapers to minimize edge effects.
c_____________________________________________________________________
      p1=1
      p2=1+nptaper
      p3=np-nptaper
      p4=np
      dtrace=1.
      call gttapr(pwgt,p1,p2,p3,p4,dtrace,1,np)

      return
      end

