C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c radonr reads radon transformed data from an input file,
c performs an inverse generalized omega-p transform,                
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

 
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)

      parameter   (pi=3.14159265,twopi=2.*pi)
      parameter   (maxarg=10000)           
      parameter   (maxpat=6)                 
c
      integer     hbegin
      integer     sheader(SZLNHD)
      logical     tabled(0:maxpat)
      real        cputim(20),waltim(20)
#include <f77/pid.h>
c     parameter (i2fact=8/szsmpd,lenhed=lntrhd/i2fact,hbegin=1-lenhed)
c
      character*256  ntap,otap
      character*6    name
      character*6    crwnam
      character*1    moveout,domain_in,domain_out,t_or_f,cpad
      integer     tpad
      logical     smooth,restore_mute
      logical     verbose, query  
      integer     argis
      logical     ytransform
      logical     linear,parabolic,hyperbolic,fourier,eod
      logical     rdomega                                   
      logical     regularize,interpolate                         

      common /thdr/ ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1              ifmt_RecNum,l_RecNum,ln_RecNum,
     2              ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     3              ifmt_RecInd,l_RecInd,ln_RecInd,
     4              ifmt_DphInd,l_DphInd,ln_DphInd,
     5              ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     6              ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     7              ifmt_StaCor,l_StaCor,ln_StaCor,
     8              ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm

 
      data        name/'RADONR'/
c_______________________________________________________________
c     initialize timing arrays.
c_______________________________________________________________
      call vclr(cputim,1,20)
      call vclr(waltim,1,20)
      call timstr(vtot,wtot)
      call timstr(v1,w1)
      lastpat=0
      do 10000 ipat=0,maxpat
       tabled(ipat)=.false.
10000 continue
c_______________________________________________________________
c     read program parameters from command line card image file
c_______________________________________________________________
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            call exit(0)
      endif
c_______________________________________________________________
c     open printout files
c_______________________________________________________________
#include <f77/open.h>
c_______________________________________________________________
c     get i/o data set names
c_______________________________________________________________
      call cmdln(ntap,otap,verbose,ytransform)
c_______________________________________________________________
c     get logical unit numbers for input and output
c_______________________________________________________________
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
c_______________________________________________________________
c     read line header of input
c     save certain parameters
c_______________________________________________________________
      call rtape(luin,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(lerr,*)'RADONR: no header read from unit ',luin
         call exit(0)
      endif
c
C_______________________________________________________________________
c     pull relevent values from line header.
C_______________________________________________________________________
      call saver(sheader,'NumSmp',nsamp_in,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader,'NumRec',nrec,LINEHEADER)
      call saver(sheader,'NumTrc',np,LINEHEADER)
      call saver(sheader,'CrwNam',crwnam,LINEHEADER)
      call saver(sheader,'Crew01',t_or_f,LINEHEADER)
      call saver(sheader,'Crew06',cpad,LINEHEADER)
      call saver(sheader, 'T_Units',junits,LINEHEADER)
      call saver(sheader, 'UnitSc', unitsc, LINEHEADER)
      tpad = 0
      if (cpad .eq. 'P') then
         call saver(sheader, 'VlFnRF',tpad,LINEHEADER)
         call savew(sheader,'TmMsSl', 0  ,LINEHEADER)
         call savew(sheader,'Crew06',' ',LINEHEADER)
      endif
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(sheader, 'UnitSc', unitsc, LINEHEADER)
      endif
      dt = float(nsi) * unitsc
      dtmsec = 1000 * dt

      if(t_or_f .eq. 'f') then
         rdomega=.true.
         call saver( sheader,'TmSlIn',nsamp_out,LINEHEADER)
         call savew(sheader,'NumSmp',nsamp_out,LINEHEADER)
      else
         rdomega=.false.
         nsamp_out=nsamp_in
      endif
      if (tpad .gt. 0) nsampo = nsamp_out - tpad

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('MulSkw',ifmt_MulSkw,l_MulSkw,ln_MulSkw,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
 
      lenhed=ITRWRD
      hbegin=1-lenhed

      if(ytransform) then
c_______________________________________________________________________
c        transform is from q to y.
c        use line header locations set 2.
c_______________________________________________________________________
         call saver(sheader,'Crew04',domain_in,LINEHEADER)
         call saver(sheader,'Crew05',moveout,LINEHEADER)
c
         call saver(sheader,'MnShDp',ntrin,LINEHEADER)
         call saver(sheader,'MxShDp',nfft,LINEHEADER)
c
         call saver(sheader,'TmMsSl',ifl,LINEHEADER)
         call saver(sheader,'TmSlIn',ifh,LINEHEADER)
         call saver(sheader,'AERcPr',idf,LINEHEADER)
c
         fl=1.e-6*ifl
         fh=1.e-6*ifh
         df=1.e-6*idf
c
         call saver(sheader,'IndAdj',izref,LINEHEADER)
         call saver(sheader,'MnSPEl',mmin,LINEHEADER)
         call saver(sheader,'MxSPEl',mmax,LINEHEADER)
c
         call saver(sheader,'MnTrOf',ixmax,LINEHEADER)
         call saver(sheader,'MnTrSt',ist,LINEHEADER)
c
         domain_out='y'
         call savew(sheader,'Crew04',domain_out,LINEHEADER)
         call savew(sheader,'Crew05',' ',LINEHEADER)
      else
C_______________________________________________________________________
c        transform is from p to x.
c        use line header locations set 1.
C_______________________________________________________________________
         call saver(sheader,'Crew02',domain_in,LINEHEADER)
         call saver(sheader,'Crew03',moveout,LINEHEADER)
c
         call saver(sheader,'MnUHTm',ntrin,LINEHEADER)
         call saver(sheader,'MxUHTm',nfft,LINEHEADER)
c
         call saver(sheader,'FreQst',fl,LINEHEADER)
         call saver(sheader,'MutVel',fh,LINEHEADER)
         call saver(sheader,'NmSpMi',df,LINEHEADER)
c
         call saver(sheader,'MxRSEL',izref,LINEHEADER)
         call saver(sheader,'MnGrEl',mmin,LINEHEADER)
         call saver(sheader,'MxGrEl',mmax,LINEHEADER)
c
         call saver(sheader,'MxTrOf',ixmax,LINEHEADER)
         call saver(sheader,'MxTrSt',ist,LINEHEADER)
c
         domain_out='x'
         call savew(sheader,'Crew02',domain_out,LINEHEADER)
         call savew(sheader,'Crew03',' ',LINEHEADER)

      endif

      write(lerr,*) 'crwnam = ',"'"//crwnam//"'"
      if(moveout .eq. 'L') then
         linear=.true.
         parabolic=.false.
         hyperbolic=.false.
         fourier=.false.
      elseif(moveout .eq. 'P') then
         linear=.false.
         parabolic=.true. 
         hyperbolic=.false.
         fourier=.false.
      elseif(moveout .eq. 'H') then
         linear=.false.
         parabolic=.false.
         hyperbolic=.true. 
         fourier=.false.
      elseif(moveout .eq. 'F') then
         linear=.false.
         parabolic=.false.
         hyperbolic=.false.
         fourier=.true. 
      else
         write(lerr,*) 'error in routine radonr'
         write(lerr,*) 'moveout keyword in line header word CrwNam',
     1              ' crwnam character 3 or 5 = ',"'"//moveout//"'"
         write(lerr,*) 'domain_in keyword in line header word CrwNam',
     1               ' crwnam character 2 or 4 = ',"'"//domain_in//"'"
         write(lerr,*) 'crwnam = ',"'"//crwnam//"'"
         write(lerr,*) 'needs to be either L, P, H or F'    
         call exit(10004)
      endif
      zref=izref           
      xmax=ixmax
c     if(junits .eq. 1) then
c___________________________________________________________________
c        sample units are in microseconds.
c___________________________________________________________________
c        dtmsec=.001*nsi
c     else
c___________________________________________________________________
c        sample units are in milliseconds.
c___________________________________________________________________
c        dtmsec=nsi
c     endif
c     dt=.001*dtmsec

      if(fourier) then
c______________________________________________________________________
c        fit multiple/noise trains with Fourier sin/cos functions.
c        sample maximum moveout at Nyquist at fh
c______________________________________________________________________
         smin=.001*mmin/xmax
         smax=.001*mmax/xmax
         pmin=2.*pi*fh*smin
         pmax=2.*pi*fh*smax
      else
         if(linear) then
c______________________________________________________________________
c           fit multiple/noise trains with linear curves.
c______________________________________________________________________
            factor=dtmsec*xmax
         elseif(parabolic) then
c______________________________________________________________________
c           fit multiple/noise trains with parabolic curves.
c______________________________________________________________________
            factor=dtmsec*xmax**2
         elseif(hyperbolic) then
c______________________________________________________________________
c           fit multiple/noise trains with hyperbolic curves.
c______________________________________________________________________
            factor=dtmsec*(sqrt(xmax**2+zref**2)-zref)
         endif
         pmin=float(mmin)/factor
         pmax=float(mmax)/factor
c  this almost gets the full circle xform kinematically right but there is
c  a troubling phase change...
c        pmin = .985*pmin
c        pmax = .985*pmax
      endif
      write(lerr,*) 'mmin ',mmin,' pmin',pmin
      write(lerr,*) 'mmax ',mmax,' pmax',pmax

c
      call hlhprt (sheader,lbytes,name,6,lerr)
c_______________________________________________________________
c     read in remaining parameters from command line
c_______________________________________________________________
      call rdparm(dmin,dmax,dx,verbose,amaxmem,nptaper,szsmpd,
     1            lerr,ierror,regularize,interpolate,smooth,
     2            lensmooth,restore_mute)
      if (ierror .ne. 0) then
         write(lerr,*)'Program abort due to ,',ierror,
     1                ' command line errors'
         go to 99000
      endif
      maxwords=amaxmem*1.e+06
      if(regularize) then
         ntrout=iabs (nint((dmax-dmin)/dx) )+1
      else
         ntrout=ntrin
      endif
c
      call argr4('-fs',fs,0.,0.)
      flow=2.*pi*dt*fl
      fstart=2*pi*dt*(fl+fs)
      fhigh=2.*pi*dt*fh
      ifl=nint(flow/df)
      ifh=nint(fhigh/df)
      nf=ifh-ifl+1
      xfh=fhigh/df
c______________________________________________________________________
c     calculate buffer requirements for nested mixed radix ffts.
c     cray scilib routine rfftmlt runs twice as fast as mathadvantage
c     routine rnfftm.
c
c     buffer   mathadvantage rnfftm        cray scilib rfftmlt
c
c     itab      nfft+34                      2*nfft
c     rtab      3(nfft/2)+13                 2*nfft
c     work      18*ntrout                    4*nfft*ntrout
c______________________________________________________________________
      maxtrace=max(ntrout,np)
      if(szsmpd .eq. 4) then
         lenitab=nfft+34
         lenrtab=3*(nfft/2)+13
         lenwork=18*maxtrace   
      else
         lenitab=max(2*nfft,nfft+34)
         lenrtab=max(2*nfft,3*(nfft/2)+13)
         lenwork=max(4*(maxtrace+1)*nfft,18*maxtrace)
      endif
      maxdist=nint(xmax)
      mindist=-maxdist
C_______________________________________________________________________
c     output of all pertinent information before
c     memory allocation
C_______________________________________________________________________
      write(lerr,*)' '
      write(lerr,*)' line header values after default check '
      write(lerr,*)' '
      if(linear) then
         write(lerr,*) 'fit data with LINEAR curves'
      elseif(parabolic) then
         write(lerr,*) 'fit data with PARABOLIC curves'
      elseif(hyperbolic) then
         write(lerr,*) 'fit data with HYPERBOLIC curves'
         write(lerr,*) ' reference depth      = ',zref
      elseif(fourier) then
         write(lerr,*) 'fit data with Fourier sin/cos functions'
      endif
      write(lerr,*)
      write(lerr,*) ' input data set name   = ', ntap
      write(lerr,*) ' output data set name  = ', otap
      write(lerr,*) ' # of input samples    =  ', nsamp_in
      write(lerr,*) ' # of output samples   =  ', nsamp_out
      write(lerr,*) ' length of FFT         =  ', nfft
      write(lerr,*) ' first sample in window=  ', ist
      write(lerr,*) ' sample interval (msec)=  ', dtmsec
      write(lerr,*) ' dt (sec)              =  ', dt 
      write(lerr,*) ' traces per output record =  ', ntrout
      write(lerr,*) ' records per line      =  ', nrec
      write(lerr,*) ' number of frequencies =  ', nf  
      write(lerr,*) ' fl (Hz)               =  ', fl  
      write(lerr,*) ' fh (Hz)               =  ', fh  
      write(lerr,*) ' fs (Hz)               =  ', fs  
      write(lerr,*) ' flow (dimensionless)  =  ', flow
      write(lerr,*) ' fhigh (dimensionless) =  ', fhigh   
      write(lerr,*) ' fstart (dimensionless) =  ', fstart
      write(lerr,*) ' df (dimensionless)    =  ', df      
      write(lerr,*) ' number of param       =  ', np
      write(lerr,*) ' number of param to taper = ',nptaper
      write(lerr,*) ' dmin                  =  ', dmin
      write(lerr,*) ' dmax                  =  ', dmax
      write(lerr,*) ' dx                    =  ', dx
      write(lerr,*) ' number of output traces = ',ntrout
      write(lerr,*) ' xmax                  =  ', xmax
      write(lerr,*) ' number of tabled offsets = ',noffset
c
      write(lerr,*) ' restore early mutes ?     ',restore_mute
      write(lerr,*) ' smooth early mutes ?      ',smooth 
      write(lerr,*) ' length of smoother       =   ',lensmooth
      write(lerr,*) ' regularize output data ?     ',regularize
      write(lerr,*) ' linear moveout ?             ',linear    
      write(lerr,*) ' parabolic moveout ?          ',parabolic 
      write(lerr,*) ' hyperbolic moveout ?         ',hyperbolic
      write(lerr,*) ' Fourier sin/cos transform?   ',fourier   
      write(lerr,*) ' read in amplitude/phase?     ',rdomega   
      write(lerr,*) ' transform from q to y?       ',ytransform
      write(lerr,*) ' verbose  output ?            ',verbose     
      write(lerr,*)' '
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
c____________________________________________________________________
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('tbufout',l_tbufout,l_free,
     1                               ntrout*(nsamp_out+lenhed),lerr)
      call mapmem('tbufin',l_tbufin,l_free,
     1                               np*(nsamp_in+lenhed),lerr)
      call mapmem('uout',l_uout,l_free,nfft*ntrout,lerr)
      call mapmem('uin',l_uin,l_free,nfft*np,lerr)
      call mapmem('theta',l_theta,l_free,ntrout,lerr)
      call mapmem('dist',l_dist,l_free,ntrout,lerr)
      call mapmem('ioffset',l_ioffset,l_free,
     1               (maxdist-mindist+1),lerr)
      call mapmem('distpat',l_distpat,l_free,ntrout*(maxpat+1),lerr)
      call mapmem('live',l_live,l_free,ntrout,lerr)
      call mapmem('cincr',l_cincr,l_free,2*np,lerr)
      call mapmem('rtabf',l_rtabf,l_free,lenrtab,lerr)
      call mapmem('itabf',l_itabf,l_free,lenitab,lerr)
      call mapmem('rtabi',l_rtabi,l_free,lenrtab,lerr)
      call mapmem('itabi',l_itabi,l_free,lenitab,lerr)
      call mapmem('work',l_work,l_free,lenwork,lerr)
      call mapmem('p',l_p,l_free,np,lerr)
      call mapmem('pwgt',l_pwgt,l_free,np,lerr)
      call mapmem('wgt',l_wgt,l_free,ntrin,lerr)
      call mapmem('muteend',l_muteend,l_free,ntrout,lerr)
      call mapmem('mutesm',l_mutesm,l_free,ntrout,lerr)
      call mapmem('jwork',l_jwork,l_free,lensmooth,lerr)
C_______________________________________________________________________
C     calculate 'leftover memory'. use it to store radon transform
c     matrices.
C_______________________________________________________________________
      leftover=maxwords-(l_free-1)
      lenmatrix=2*np*nf
      maxoffset=leftover/lenmatrix-1
      maxoffset=max(maxoffset,1)
      write(lerr,*) 'maxwords  = ',maxwords
      write(lerr,*) 'leftover  = ',leftover
      write(lerr,*) 'lenmatrix = ',lenmatrix
      write(lerr,*) 'maxoffset = ',maxoffset
      lenradon=(maxoffset+1)*lenmatrix
      call mapmem('radon',l_radon,l_free,lenradon,lerr)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)'memory can be decreased by using the -M option'
         write(lerr,*)
         write(lerr,*)'program RADONR aborted'
         call exit(101)
      endif
C_______________________________________________________________________
c     modify line header to reflect actual number of traces output
C_______________________________________________________________________
      call savew(sheader,'NumRec',nrec,LINEHEADER)
      call savew(sheader,'NumTrc',ntrout,LINEHEADER)
      if (tpad .gt. 0)
     1    call savew(sheader,'NumSmp', nsamp_out-tpad,LINEHEADER)
      call savhlh(sheader,lbytes,lbyout)
      call wrtape(luout,sheader,lbyout)
      call timend(cputim(1),v1,v2,waltim(1),w1,w2)
c_______________________________________________________________
c     precompute tabled arrays that will be remain invariant for all
c     seismic gathers.
c_______________________________________________________________
      call gettab(s(l_p),fl,df,np,ifl,ifh,pmin,pmax,
     1            s(l_radon),s(l_cincr),noffset,s(l_pwgt),nptaper,
     2            dmin,xmax,dx,lerr,cputim,waltim)
c_____________________________________________________________   
c     calculate length of trace in integer*2 words.
c     calculate number of bytes in output trace
c     calculate trace header position of key variables.
c_____________________________________________________________   
      lentr2_in  =(lenhed+nsamp_in )
      lentr2_out =(lenhed+nsamp_out)
c     lentr2_in=lntrhd+nsamp_in*i2fact
c     lentr2_out=lntrhd+nsamp_out*i2fact
      nbyptr=(nsamp_out-tpad+lenhed)*szsmpd
c     call savelu('DstSgn',ifmt,l_DstSgn,length,TRACEHEADER)
c     call savelu('DstUsg',ifmt,l_DstUsg,length,TRACEHEADER)
c     call savelu('StaCor',ifmt,l_StaCor,length,TRACEHEADER)
c     call savelu('TrcNum',ifmt,l_TrcNum,length,TRACEHEADER)
c     call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
c     call savelu('RecInd',ifmt,l_RecInd,length,TRACEHEADER)
c     call savelu('SrcLoc',ifmt,l_SrcLoc,length,TRACEHEADER)
c     call savelu('DphInd',ifmt,l_DphInd,length,TRACEHEADER)
c     call savelu('SoPtNm',ifmt,l_SoPtNm,length,TRACEHEADER)
      if(ytransform) then
         call savelu('TVPV19',ifmt_disthdr,l_disthdr,ln_disthdr,
     1               TRACEHEADER)
         call savelu('PREPIn',ifmt_mute,l_mute,ln_mute,
     1               TRACEHEADER)
c        call savelu('TVPV19',ifmt,l_disthdr,length,TRACEHEADER)
c        call savelu('PREPIn',ifmt,l_mute,length,TRACEHEADER)
      else
         call savelu('TVPT19',ifmt_disthdr,l_disthdr,ln_disthdr,
     1               TRACEHEADER)
         call savelu('MulSkw',ifmt_mute,l_mute,ln_mute,
     1               TRACEHEADER)
c        call savelu('TVPT19',ifmt,l_disthdr,length,TRACEHEADER)
c        call savelu('MulSkw',ifmt,l_mute,length,TRACEHEADER)
      endif
c_____________________________________________________________
c     initialize radon transform offset pointer.
c_____________________________________________________________
      call vfill(0,s(l_ioffset),1,maxdist-mindist+1)
      noffset=0
c
      initfftf=1
      initffti=1
      ndiscard=0
      ndeadrec=0
c_____________________________________________________________   
c     loop over all records.
c_____________________________________________________________   
      do 20000 irec = 1, nrec
       call rdgather(s(l_tbufin),s(l_tbufin),s(l_tbufout),
     1               hbegin,nsamp_in,nsamp_out,lentr2_in,lentr2_out,
     1               lenhed,ntrout,np,luin,lerr,eod,irec,
     2               ifmt_disthdr,l_disthdr,ln_disthdr,
     3               ifmt_mute,l_mute,ln_mute,
     4               s(l_p),dmin,dx,s(l_theta),s(l_dist),zref,
     5               hyperbolic,parabolic,linear,fourier,s(l_live),
     6               regularize,interpolate,verbose,dt)
       if(eod) go to 99000
c_____________________________________________________________   
c      go take inverse radon transform.
c_____________________________________________________________   
       call rev(s(l_tbufout),s(l_tbufin),hbegin,nsamp_in,nsamp_out,
     1          s(l_uout),nfft,s(l_theta),
     2          s(l_dist),dmin,dx,noffset,maxoffset,
     3          np,ifl,ifh,fstart,irec,lenhed,
     4          s(l_ioffset),mindist,maxdist,
     4          s(l_p),s(l_uin),s(l_pwgt),ntrin,
     5          s(l_radon),s(l_cincr),df,ntrout,s(l_live),
     6          s(l_rtabf),s(l_itabf),initfftf,s(l_work),
     7          s(l_rtabi),s(l_itabi),initffti,tabled,lastpat,
     8          lenrtab,lenitab,lenwork,s(l_distpat),maxpat,
     9          s(l_muteend),restore_mute,lerr,cputim,waltim,verbose,
     b          ist,fourier,rdomegao,tpad)
c_____________________________________________________________   
c      write out data.         
c_____________________________________________________________   
       call timstr(v1,w1)
       call wrgather(s(l_tbufout),s(l_tbufout),
     1               s(l_muteend),s(l_mutesm),lentr2_out,smooth,
     2               hbegin,nsamp_out,ntrout,luout,nbyptr,l_mute,  
     3               regularize,s(l_jwork),lensmooth,restore_mute,
     4               ifmt_mute,ln_mute,ifmt_dstsgn,ln_dstsgn,
     5               l_dstsgn,s(l_dist),tpad)

       call timend(cputim(9),v1,v2,waltim(9),w1,w2)
20000 continue
      write(lerr,*) 'noffset = ',noffset
99000 continue
c_____________________________________________________________   
c     write out timing statistics.
c_____________________________________________________________   
      call timend(cputim(20),vtot,V2,waltim(20),wtot,W2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'setup',cputim(1),waltim(1),
     2         'forward fft',cputim(2),waltim(2),
     3         'calculate radon',cputim(3),waltim(3),
     7         'inverse radon',cputim(6),waltim(6),
     9         'inverse fft',cputim(7),waltim(7),
     b         'write output',cputim(9),waltim(9),
     c         'total',cputim(20),waltim(20)
c_____________________________________________________________   
c     close data files
c_____________________________________________________________   
      call lbclos ( luin )
      call lbclos ( luout )

      write(ler,*)'normal completetion. routine RADONR'           
      write(lerr,*)'normal completetion. routine RADONR'           
      close(lerr)
      call exit(0)
      end
 
C***********************************************************************
 

      subroutine cmdln( ntap,otap,verbose,ytransform)

      character*(*)  ntap,otap
      integer    argis
      logical    verbose,ytransform

      call argstr('-N',ntap, ' ', ' ')
      call argstr('-O',otap, ' ', ' ')
      ytransform=(argis('-Y') .gt. 0)
      verbose=(argis('-V') .gt. 0)

      return
      end

      subroutine help
#include <f77/iounit.h>

         write(ler,*)
     1'***************************************************************'
       write(ler,*)' '
        write(ler,*)
     1'execute radonr by typing radonr and list of program parameters.'
        write(ler,*)
     1'note that each parameter is proceeded by -a where "a" is '
        write(ler,*)
     1'a character(s) corresponding to some parameter.'
        write(ler,*)
     1'users enter the following parameters, or use the default values'
       write(ler,*)' '
        write(ler,*)
     1' -N [ntap]  (stdin)   : input tau-p domain data file name'
        write(ler,*)
     1' -O [otap]  (stdout)  : output x-t domain data file name'
        write(ler,*)' '
        write(ler,*)
     1' -nptaper[nptaper](10): taper in traces on ends in p-domain'
        write(ler,*)
     1' -S[lensmooth]        : length of median filter on early'
     2                      //'  mutes (0)'
         write(ler,*)
     1' -M[amaxmem]             : maximum memory in megawords'
         write(ler,*)
     1'                          (default 4 on sparc, 16 on cray)'
        write(ler,*)
     1' -I                    : if present, interpolate dead traces'
     2                       //' at original signed trace distances'
        write(ler,*)
     1' -R                    : if present, regularize output data'
        write(ler,*)
     1' -Y                  : if present, transform from (tau,q,p) to'
     2                      //' (tau,y,p)'
        write(ler,*)
     1' -nomute               : if present, do not restore early mute'
        write(ler,*)
     1' -V                    : if present, verbose printout'
        write(ler,*)
     1'_____________________________________________________________'    
        write(ler,*)
     1' the following parameters must be supplied to reconstruct'
     2  //' regularized data'
        write(ler,*)
     1'_____________________________________________________________'    
        write(ler,*)
     1' -dmin[dmin](0.0)      :  min signed distance (ft,m) of'
     2                                //' regularized data'
        write(ler,*)
     1' -dmax[dmax](none)     :  max signed distance (ft,m) of'
     2                                //' regularized data'
        write(ler,*)
     1' -dx[dx]  (none)       :  trace spacing (ft,m) of '
     2                                //' regularized data'
       write(ler,*)' '
       write(ler,*)'usage:'
       write(ler,*)
       write(ler,*)'radonr -N[ntap] -O[otap]  nptaper[]'
       write(ler,*)'       -dmin[] -dmax[] -dx[] -S[] -M[]'
       write(ler,*)'       [ -R,-I,-Y -nomute -V ]'
       write(ler,*)' '
       write(ler,*)

      return
      end
 

