C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine rev(tbufout,tbufin,hbegin,nsamp_in,nsamp_out,
     1                uout,nfft,theta,
     2                dist,xmin,dx,noffset,maxoffset,
     3                np,ifl,ifh,fstart,irec,lenhed, 
     4                ioffset,mindist,maxdist,
     4                p,uin,pwgt,ntrin,
     5                radon,cincr,df,ntrout,live,  
     6                rtabf,itabf,initfftf,work,
     7                rtabi,itabi,initffti,tabled,lastpat,
     8                lenrtab,lenitab,lenwork,distpat,maxpat,
     9                muteend,mute,lerr,cputim,waltim,verbose,
     b                ist,fourier,rdomega,tpad)
      integer   hbegin
c_________________________________________________________________________
c     tau-p input data.
c_________________________________________________________________________
      real   tbufin(hbegin:nsamp_in,np)    
c_________________________________________________________________________
c     x-t output data.                                
c_________________________________________________________________________
      real   tbufout(hbegin:nsamp_out,ntrout)    
c_________________________________________________________________________
c     moveout function theta(x)    
c     trace distances  dist(x)     
c_________________________________________________________________________
      real       theta(ntrout)     
      real       dist(ntrout)     
      real       distpat(ntrout,0:maxpat)     
      integer    ioffset(mindist:maxdist)
      integer    tpad
      real       pwgt(np)                      
c_______________________________________________________________
c     input data (in both tau-p and tau-omega domains)                          
c_______________________________________________________________
      complex    uin(nfft/2,np)           
c_________________________________________________________________________
c     output data (in both x-omega and x-t domains)
c_________________________________________________________________________
      real       uout(nfft,ntrout)         
c_______________________________________________________________
c     fourier transform table and work arrays.                       
c_______________________________________________________________
      real       rtabf(lenrtab)        
      integer    itabf(lenitab)
      real       rtabi(lenrtab)        
      integer    itabi(lenitab)
      real       work(lenwork)
c_______________________________________________________________
c     radon transform matrix
c_______________________________________________________________
      complex    radon(ifl:ifh,np,0:maxoffset)               
c_______________________________________________________________
c     tabled arrays.
c_______________________________________________________________
      real       p(np)
      complex    cincr(np)                           
c_______________________________________________________________
c     mute preservation array
c_______________________________________________________________
      integer    muteend(ntrout)
c_______________________________________________________________
c     timing arrays.
c_______________________________________________________________
      real       cputim(*),waltim(*)
c_______________________________________________________________
c     logical control directives.
c_______________________________________________________________
      logical    forward       
      logical    tabled(0:maxpat)
      logical    verbose             
      logical    mute
      logical    live(ntrout)
      logical    fourier,rdomega

      common /thdr/ ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1              ifmt_RecNum,l_RecNum,ln_RecNum,
     2              ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     3              ifmt_RecInd,l_RecInd,ln_RecInd,
     4              ifmt_DphInd,l_DphInd,ln_DphInd,
     5              ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     6              ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     7              ifmt_StaCor,l_StaCor,ln_StaCor,
     8              ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm

c___________________________________________________________________
c     build the model.         
c___________________________________________________________________
c___________________________________________________________________
c     clear transform space
c     any dead traces have been zeroed out in calling program.
c___________________________________________________________________

      ibegin_copy=ist
      iend_copy=min(nsamp_in,ist-1+nfft)
      iend_fft=ist-1+nfft
       if(rdomega) then
c___________________________________________________________________
c         data already in (omega,p) domain.
c         convert amplitude and phase into real and imaginary parts.
c         flip data from omega up to omega down.
c         taper in p domain if desired.
c___________________________________________________________________
          do 35500 ip=1,np     
           iamp=nfft/2+1
           iphase=nfft+1
           do 35200 ifreq=1,nfft/2 
            iamp=iamp-1
            iphase=iphase-1
            uin(ifreq,ip)=tbufin(iamp,ip)*
     1         cmplx(cos(tbufin(iphase,ip)),sin(tbufin(iphase,ip)))
35200      continue
35500     continue
       else
c___________________________________________________________________
c         zero pad, then transform from (tau,p) to (omega,p).
c___________________________________________________________________
          do 40000 ip=1,np           
c___________________________________________________________________
c          copy window of trace data into work array uin.
c___________________________________________________________________
           call vclr(uin(1,ip),1,nfft)
           call vmov(tbufin(ibegin_copy,ip),1,
     1               uin(1,ip),1,iend_copy-ibegin_copy+1)
40000    continue
c
         forward=.true.
         call timstr(v1,w1)
         call rmmfft(uin(1,1),work,itabf,rtabf,forward,
     1               nfft,lenwork,lenitab,lenrtab,
     2               nfft,np,initfftf,lerr)
665   format(5i10)
666   format(5f10.4)
         initfftf=0
         call timend(cputim(2),v1,v2,waltim(2),w1,w2)
c______________________________________________________________________
c        taper in p domain if desired.
c______________________________________________________________________
         do 41000 ip=1,np
          do 40500 ifreq=1,nfft/2
           uin(ifreq,ip)=pwgt(ip)*uin(ifreq,ip)
40500     continue
41000    continue
      endif
c______________________________________________________________________
c     determine which gather distance pattern we are working with.
c______________________________________________________________________
      call getpat(dist,distpat,ntrout,1,ntrout,lastpat,maxpat,ipat)
      if(verbose) write(lerr,*) 'ipat = ',ipat
c___________________________________________________________________
c     compute modeled data. 
c___________________________________________________________________
      call timstr(v1,w1)
      do 70000 itr=1,ntrout  
       call vclr(uout(1,itr),1,nfft)         
       if(live(itr)) then
          idist=dist(itr)
          if(ioffset(idist) .eq. 0) then
             if(noffset .lt. maxoffset) then
                noffset=noffset+1
                ioffset(idist)=noffset
                if(verbose)  then
                   write(lerr,*) 'store dist(itr),ioffset(idist) ',
     1                  dist(itr),ioffset(idist)
                endif
             endif
             call timstr(v1,w1)
c___________________________________________________________________
c            calculate Radon coefficient matrix.
c___________________________________________________________________
             call getradon(radon(ifl,1,ioffset(idist)),p,ifl,ifh,
     1                  df,np,fstart,theta(itr),cincr,fourier)
             call timend(cputim(3),v1,v2,waltim(3),w1,w2)
          endif
c___________________________________________________________________
c         take inverse Radon transform 
c___________________________________________________________________
          call timstr(v1,w1)
          call radinv(uin(1,1),uout(1,itr),
     1                radon(ifl,1,ioffset(idist)),ifl,ifh,np,nfft)           
         call timend(cputim(6),v1,v2,waltim(6),w1,w2)
       endif
70000 continue
c_____________________________________________________________________
c     transform back to time
c_____________________________________________________________________
      call timstr(v1,w1)
      forward=.false.
      call rmmfft(uout(1,1),work,itabi,rtabi,forward,
     1            nfft,lenwork,lenitab,lenrtab,
     2            nfft,ntrout,initffti,lerr)
      initffti=0
      call timend(cputim(7),v1,v2,waltim(7),w1,w2)
      call timstr(v1,w1)
c___________________________________________________________________
c     copy analysis window back into trace buffers.
c___________________________________________________________________
      do 80000 itr=1,ntrout
       do 79100 isamp=1,ibegin_copy-1
        tbufout(isamp,itr)=0.
79100  continue
       k=0
       do 79200 isamp=max(ibegin_copy-1,1),
     1                min(iend_copy,nsamp_out-tpad)
        k=k+1
        tbufout(isamp,itr)=uout(k+tpad,itr)
79200  continue
       do 79300 isamp=iend_copy+1,nsamp_out
        tbufout(isamp,itr)=0.
79300  continue
80000 continue
c
      call timend(cputim(8),v1,v2,waltim(8),w1,w2)
c
      return
      end

