C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ganma (j,X, g, offset, NS, sr, Y, work, R,
     1                  SZSMPD)
************************************************************************
*                                                                      *
*    SUBROUTINE TO PERFORM gamma MOVEOUT CORRECTION on angle gathers   *
*      INPUTS ARE:                                                     *
*           X = DATA TO BE CORRECTED                                   *
*           V = gamma (z) array
*      OFFSET = OFFSET FOR X                                           *
*          NS = NUMBER SAMPLES PER TRACE                               *
*          sr = SAMPLE INTERVAL IN SEC                                 *
*           Y = CORRECTED DATA                                         *
*                                                                      *
************************************************************************
#include <f77/iounit.h>

      real    X(ns), Y(ns), g(ns)
      real    work (ns)
      real    v
      pointer (wkv, v(1))
      integer ierr, iabort, SZSMPD
      logical R
      data iabort/0/

      call galloc (wkv, ns*SZSMPD, ierr, iabort)
      if (ierr .ne. 0) then
       write(LERR,*)'FATAL ERROR in gammaa option:'
       write(LERR,*)'Unable to allocate ',ns*SZSMPD,' bytes'
       call ccexit (666)
      endif

      pi = 3.14159265
      call vclr (work, 1, ns)

      call vmov (x, 1, work(2), 1, ns)
      call vmov (g, 1, v, 1, ns)

      do  i = 1, ns
          v(i) = (v(i) * v(i) - 1.0)
      enddo

      work (ns+2) = 0
      dist  = tan ( pi * abs ( real (offset) ) / 180. )
      dist2 = dist * dist
      call vclr (work(ns+2), 1, 2)

      IF (.not.R) THEN


       DO  i = 1, ns

           z0 = float(i-1) * sr
           gi = v (i)
           shfts = z0 / sqrt (1.0 - gi * dist2)

           IF (shfts .ge. 0.0) THEN

              shft  = shfts / sr + 1.0
              if (shft .le. ns-2) then

                if (shft .gt. 0) then

                    zj = shft
                    it = int(zj)
                    if (it .eq. 0) it = 1
                     f  = zj - aint(zj)
                     fs = f * f
                     c1 = fs - f
                     c2 = 2.0 - 2.0 * fs
                     c3 = fs + f
                     y(i)=0.5 * (
     :                   work(it)   * c1 +
     :                   work(it+1) * c2 +
     :                   work(it+2) * c3
     :                          )
                else
                     y(i) = work(i)
                endif

              else
                y(i) = 0
              endif

           ENDIF

       ENDDO

      ELSE

       call vclr (y, 1, ns)

       DO  i = 2, ns

           z0 = float(i-1) * sr
           gi = v (i)
           shfts = z0 / sqrt (1.0 - gi * dist2)


           IF (shfts .ge. 0.0) THEN
 
              shft  = shfts / sr + 1.0

              if (shft .le. ns-2) then

                if (shft .gt. 0) then

                    zj = shft
                    it = int(zj)

                    if (it .eq. 0) it = 1
                    f  = zj - aint(zj)
                    fs = f * f
                    c1 = fs - f
                    c2 = 2.0 - 2.0 * fs
                    c3 = fs + f
                    y(it) = 0.5 *   (
     :                     work(i)   * c3 +
     :                     work(i+1) * c2 +
     :                     work(i+2) * c1
     :                              )
                else
                     y(i) = work(i)
                endif

              else
                y(i) = 0

              endif

           ENDIF

       ENDDO

      ENDIF

      call gfree (wkv)
      RETURN
      END
