#include <stdio.h>
#include <stdlib.h>
#include <localsys.h>
#include <size_defs.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#ifdef FTN_TO_C_UPPERCASE
#define F_FILESIZECHK FILESIZE
#else
#ifdef FTN_TO_C_UNDERSCORE_SUFFIX
#define F_FILESIZECHK filesizechk_
#else
#define F_FILESIZECHK filesizechk
#endif
#endif

#ifdef CRAYSYSTEM
#include <fortran.h>

int F_FILESIZECHK(filename,c_fn_len,esize,asize)
_fcd *filename;
int *c_fn_len;
off_t *asize,*esize;
{
unsigned filename_lng = _fcdlen(filename);
#else
int F_FILESIZECHK(filename,c_fn_len,esize,asize,filename_lng)
char *filename;
int *c_fn_len;
unsigned filename_lng;
off_t *asize,*esize;
{
#endif
	int i;
	struct stat buf;
	char *c_filename;
	unsigned long size;
	int retcode;

	c_filename = (char *)malloc((filename_lng+1)*sizeof(char));
	strncpy(c_filename, filename, filename_lng);
	for (i=filename_lng-1; i>=0; i--) {
	  if (*(c_filename+i) != ' ') {
	    *c_fn_len = i+1;
	    *(c_filename+*c_fn_len) = '\0';
	    break;
	    }
	  }

	if (stat(c_filename,&buf) == 0) {
	  *asize = buf.st_size;
	  if (buf.st_size == *esize)
	    retcode = 0;
	  else
	    retcode = 1;
	  }
	else {
	  fprintf(stderr,"unable to stat %s\n",c_filename);
	  retcode = 1;
	  }

        return(retcode);
}
