C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine hsort1 (n, x)
C ******************************************************************** C
C *  Subroutine to sort array X of length N into ascending           * C
C *  numerical order using the Heapsort algorithm.                   * C
C *                                                                  * C
C ******************************************************************** C

      implicit none
      integer n, n2, ni, i, j
      real x(*)
      real xx

      if (n .le. 1) return

      n2 = n/2+1
      ni = n

1     continue

       if (n2 .gt. 1) then

         n2 = n2-1
         xx = x(n2)

       else

         xx = x(ni)
         x(ni) = x(1)
         ni = ni-1

         if (ni .eq. 1) then
           x(1) = xx
           return
         endif

       endif

       i = n2
       j = 2*n2

2      continue

       if (j .le. ni) then

         if (j .lt. ni) then
           if (x(j) .lt. x(j+1)) j = j+1
         endif

         if (xx .lt. x(j)) then
           x(i) = x(j)
           i = j
           j = 2*j
         else
           j = ni+1
         endif

         go to 2

       endif

       x(i) = xx

       go to 1

      end
