C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ******************************************************************** C
C |                                                                    |
C |  Module to perform a dip-dependent slant stack (tau-p-like radon   |
C |  transform) and optionally apply deconvolution.  The program can   |
C |  be used as a dip filtering program by simply setting the dip      |
C |  transform range to exclude the undesirable dips, or by specifying |
C |  a range of dips to "kill" with the -dk1 and -dk2 parameters.      |
C |  Forward transform only is supported.                              |
C |  Input data may be stacked or unstacked.                           |
C |                                                                    |
C |  Author:   R. Crider  12/92                                        |
C |                                                                    |
C ******************************************************************** C
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>
      integer nerrflg
      parameter (nerrflg = 15)
      integer luin,luout,j,i
      integer jerr,ovlp
      integer np,mbytes,nrecc,iby,noutr,jabort,ierror,ner,iget
      integer lbytes,nsamp,nsr,ntrc,nrcd,nbytes
      integer nx,istat,ndx,kdx
      integer ns,iws,iwe,jp,ndo,iout
      integer itr(SZLNHD), itrhd(1)
      integer argis,zero(1)
      integer ol,pred,aper
      integer th4(SZLNHD),trlen
      integer   th2(SZLNHD)
C
      real    Ritr(SZLNHD),hoff(1)
      real    dipm,dipx,delp,pmax,pmin,sr
      real    h1,h2,tp(550), xoff(1),temp(1),live(1)
      real    hold(1),Dhold(1),prew,decond(1),data(1),hdata(1)
      real    orig(1),env_in(1),env_de(1),ramp(386)
C
      character parr*43,name*4,title(66)*1,ntap*256, otap*256
C
      logical open, there,errflg(nerrflg),time_variant,is_offset
      logical forward,do_decon,scale,arho,stak,eof
C
      POINTER       (phold, hold), (pdhold, dhold)
      POINTER       (plive, Live),(ptemp,temp)
      POINTER       (pth,itrhd),(pdecon,decond)
      POINTER       (pdata,data)
      POINTER       (po,orig),(pz,zero)
      POINTER       (phdata,hdata),(poff,xoff)
      POINTER       (pen1,env_in),(pen2,env_de)
      POINTER       (phoff,hoff)
C
      data name/'SLDK'/,open/.FALSE./
      data parr/'Dip-Dependent Deconvolution in Radon Domain'/
      data TITLE/66*' '/
C
      equivalence (itr(1),th2(1),th4(1),Ritr(1))

C +=========================+
* | Check for the HELP flag |
C +=========================+
      if (argis ('-?').gt.0 .OR. (argis('-H').gt.0)) then
         call help(LER)
         stop
      endif
      J=11
      DO I=1,43
         J=J+1
         TITLE(J)=parr(I:I)
      END DO
#include <f77/open.h>
      forward = .false.
C +===============================+
* | Get the processing parameters |
C +===============================+
      call gcmdln(ntap,otap, np,dipm,dipx,ist,iend,lslide,
     :ol,pred,prew,forward,scale,arho,stak,aper,dk1,dk2,ovlp,tk1,tk2,
     :is_offset)
      if(stak.and.aper.eq.0)then
       write(LER,*)' For stacked or common offset data, -ap parameter ',
     :'required'
       stop
      endif
      if(np.eq.0)then
       write(LER,*)' Number of dips must be specified - Fatal.'
       stop
      endif
      if(dipm.eq.dipx)then
       write(LER,*)' Input min and max dips cannot be equal - Fatal.'
       stop
      endif
      if(ntap.ne.' ')then
       there = .false.
       inquire(file = ntap, exist = there)
       if(.not.there) then
        write(LER,*)'Requested input data set does not exist.',
     &'  Try again.'
        stop
       endif
      endif
      call gamoco(title,1,LERR)
C +====================+
C |Open input data set |
C +====================+
      ierror = 0
      call openr(luin,itr,lbytes,nsamp,nsr,ntrc,nrcd,ntap,
     :ierror,unitsc)
      trlen = nsamp+ITRWRD
      ifour=4
      call hlhprt(itr,lbytes,name,ifour,LERR)
      if(ierror.eq.1)then
       write(LERR,*)'No header read on input data set. Fatal.'
       call lbclos(luin)
       stop 100
      endif
C
C   Removed check on nsamp - 10/10/96 - jev
C
C     if(ierror.eq.2)then
C      write(LERR,175)nsamp
C 175 format('The number of samples per trace (',I5,') > 3000.',
C    :'Fatal.')
C      call lbclos(luin)
C      stop 100
C     endif

      sr = float(nsr) * unitsc

      if(ist.ne.0)then
       xst=float(ist)*unitsc
       jst=xst/sr
      else
       jst=1
      endif
      tk1 = tk1*unitsc
      tk1 = tk1/sr
      tk2 = tk2*unitsc
      tk2 = tk2/sr
      dtk = (tk2-tk1)/nrcd
      if(iend.ne.0)then
       xend=float(iend)*unitsc
       jend=xend/sr
      else
       jend=nsamp
      endif
      if(jend.gt.nsamp)then
        write(LERR,*)'Design end time exceeds trace length. It is',
     :' reset to trace length'
       jend=nsamp
      endif
      if(lslide.eq.0)then
        time_variant = .false.
      else
        xslide=float(lslide)*unitsc
        jslide=xslide/sr
        iovlp=jslide/2
        nwin=1+(nsamp-iovlp)/jslide
        if(nwin*jslide.eq.nsamp)then
         nwin=2*(nwin-1)
        else
         nwin=2*(nwin-1)+1
        endif
        time_variant = .true.
      endif
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
C +=================================================+
* | Print the processing parameters in sysout file. |
C +=================================================+
      if(iend.eq.0)iend=nsamp*nsr
      if(ol.ne.0)do_decon=.true.
      call prparm(np,dipm,dipx,ntap,otap,ist,iend,lslide,
     :do_decon,ol,pred,prew,forward,arho,stak,scale,LERR)
C +============================================+
C | In the next several steps                  | 
C |  - convert prewhitening to fraction        |
C |  - compute the taper ramp                  |
C |  - convert the dip parameters to samples   |
C |  - compute the shift vector                |
C |  - set the dip traces to be zero'd if any  |
C +============================================+
      prew=prew*.01
      lramp=.048/sr
      limit=nsamp-lramp
      do i=1,lramp
       ramp(i)=float(i-1)/float(lramp)
      end do
      dipm=dipm * unitsc
      dipx=dipx * unitsc
      pmin = dipm/sr
      pmax = dipx/sr
      dk1=dk1 * unitsc
      dk2=dk2 * unitsc
      dk1 = dk1/sr
      dk2 = dk2/sr
      if(dk1.ne.0.0.and.dk2.ne.0.0)then
       if(dk2.lt.dk1)then
         write(lerr,*)' Second reject dip must be greater than first'
         write(lerr,*)' Fatal'
         call lbclos(luin)
         stop
        endif
      endif
      delp = abs((pmax-pmin)/float(np-1))
      do i=1,np
        tp(i)=pmin+float(i-1)*delp
      end do
      k1=0
      k2=0
      if(dk1.ne.0.)then
      if(dk1.lt.0.)then
      do i=2,np
        tt=abs(tp(i))
        tt1=abs(tp(i-1))
        dd=abs(dk1)
        if(tt.le.dd.and.tt1.ge.dd)k1=i
      end do
      else
      do i=2,np
        tt=abs(tp(i))
        tt1=abs(tp(i-1))
        dd=abs(dk1)
        if(tt.ge.dd.and.tt1.le.dd)k1=i
      end do
      endif
      endif
      if(dk2.ne.0.)then
      if(dk2.lt.0.0)then
      do i=2,np
        tt=abs(tp(i))
        tt1=abs(tp(i-1))
        dd=abs(dk2)
        if(tt.le.dd.and.tt1.ge.dd)k2=i
      end do
      else
      do i=2,np
        tt=abs(tp(i))
        tt1=abs(tp(i-1))
        dd=abs(dk2)
        if(tt.ge.dd.and.tt1.le.dd)k2=i
      end do
      endif
      endif
      itrcs = ntrc*nrcd
      if(ierror.ne.0)then
       call lbclos(luin)
       stop
      endif
      if(.not.stak)aper=ntrc
      if(pred.ge.nsr)then
        fpred=float(pred) * unitsc
        pred=fpred/sr
      else
        if(pred.eq.0)pred=1
      endif
      if(ol.ne.0)then
        fol=float(ol) * unitsc
        ol=fol/sr
        do_decon=.true.
      else
        write(LERR,*)'Operator length is zero. No decon performed.'
        do_decon=.false.
      endif
C
C +=================================+
* | Compute the output trace length |
C +=================================+
      mbytes = nsamp + itrwrd
      mbytes = mbytes*ISZBYT
      nrecc = nrcd
C +=======================================+
* | Update the hlh, compute number of     |
* | output records and traces per record. |
C +=======================================+
      iby = lbytes
      call savhlh(itr,iby,lbytes)
      if(forward)then
       noutr = np
       if(stak)then
        nrecc=(itrcs-1)/aper+1
       else
        nrecc=nrcd
       endif
      else
       noutr = ntrc
       nrecc=nrcd
      endif
C +===========================================+
* | Open the output and write the line header |
C +===========================================+
      call openw(luout,ITR,LBYTES,NRECC,noutr,open,otap)
      if(.not.open)then
         write(LERR,*)'Error opening output data set'
         call lbclos(luin)
         stop
      endif
C +==============================+
* | Allocate the required memory |
C +==============================+
      if(stak)then
        if(ovlp.gt.aper/2)ovlp=aper/2
        jbias=ovlp
      else
        ovlp=0
        jbias=0
      end if
      do i=1,nerrflg
       errflg(i)=.false.
      end do
      jabort = 0
      ierror =0
      ner=0
      iget=nsamp*ISZBYT*2
      call galloc(ptemp,iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      iget=nsamp*ISZBYT
      call galloc(plive,iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      iget=(ovlp+aper)*nsamp*ISZBYT
      call galloc(pdhold,iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      call galloc(pen1,iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      call galloc(pen2, iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      call galloc(po    , iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      call galloc(phdata, iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      if(forward)iget=np*nsamp*ISZBYT
      call galloc(pdata,iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      iget = np*nsamp*ISZBYT
      call galloc(phold, iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      call galloc(pdecon, iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      iget=(ovlp+aper)*ITRWRD*ISZBYT
      call galloc(pth,iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      iget=(ovlp+aper)*ISZBYT
      call galloc(poff ,iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      call galloc(pz   ,iget,ierror,jabort)
      ner=ner+1
      if(ierror.ne.0)errflg(ner)=.true.
      if(is_offset)then
       iget=ntrc*trlen*ISZBYT
       call galloc(phoff,iget,ierror,jabort)
       if(ierror.ne.0)errflg(ner)=.true.
      endif
      do i=1,nerrflg
       if(errflg(i))then 
        write(LERR,*)' Unable to allocate memory.  Reduce data set',
     :       ' size and try again.'
        call lbclos(luin)
        call lbclos(luout)
        stop
       endif
      end do
C +===============================+
C | Find the data to be processed |
C +===============================+
  305 continue
      iout=1
      istart=1
      nread=aper+ovlp
      eof=.false.
      ipass=0
      ndo = 0	
      ioffknt=0
      if(is_offset)then
       do i=1,ntrc
        ndx=(i-1)*trlen+1
        nit=0
        call rtape(luin,hoff(ndx),nit)
        if(nit.eq.0)then
         call lbclos(luin)
         call lbclos(luout)
         stop
        endif
       end do
      end if
  306 continue
      if(eof)then
        call lbclos(luin)
        call lbclos(luout)
        stop
      endif
      do 101 nx = istart,nread
       if(is_offset)then
        ioffknt=ioffknt+1
        if(ioffknt.le.ntrc)then
         ndx=(ioffknt-1)*trlen+1
         call vmov(hoff(ndx),1,itr(1),1,trlen)
        else
         eof = .true.
         go to 102
        endif
       else
        nbytes = 0
        call rtape(luin,itr,nbytes)
        if(nbytes .eq. 0) then
         eof=.true.
         if(nx.eq.1)then
          call lbclos(luin)
          call lbclos(luout)
          stop
         else
          go to 102
         endif
        endif
       endif
c      istat=th2(l_StaCor)
       call saver2(th2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1             istat, TRACEHEADER)
       ndo=ndo+1
       i=ithwp1
       j=1
       zero(nx)=0
       do while(itr(i).eq.0.and.j.le.nsamp)
        zero(nx)=j
        j=j+1
        i=i+1
       end do
        xoff(nx)=nx-1
C +====================+
C | Save trace headers |
C +====================+
        ndx = (nx-1)*ITRWRD + 1
        call vmov(itr,1,itrhd(ndx),1,ITRWRD)
C +================+
C | Save the data  |
C +================+
        ndx = (nx-1)*nsamp
        k=ITHWP1-1
        if(istat .eq. 30000)then
         do i=1,nsamp
          Dhold(ndx+i)=0.
         end do
        else 
         do i=1,nsamp
          Dhold(ndx+i)=Ritr(k+i)
         end do
        endif
  101 continue
  102 continue
C +======================+
C | Do forward transform |
C +======================+
      call taupf(dhold,nsamp,ndo,tp,np,temp,live,xoff,sr,hold,arho,
     :do_decon)
C +=================================+
C | If dip deletion parameters are  |
C | non-zero, clear the appropriate |
C | radon traces.                   |
C +=================================+
      if(k1.ne.0.and.k2.eq.0)then
        ndx=(k1-1)*nsamp+1+tk1
        lclr = nsamp
        if(tk2.gt.0)lclr=(tk2-tk1)+1
        call vclr(hold(ndx),1,lclr)
      end if
      if(k2.ne.0.and.k1.eq.0)then
       ndx=(k2-1)*nsamp+1+tk1
       lclr = nsamp
       if(tk2.gt.0)lclr=(tk2-tk1)+1
       call vclr(hold(ndx),1,lclr)
      end if
      if(k1.ne.0.and.k2.ne.0)then
       lclr = nsamp
       if(tk2.gt.0)lclr=(tk2-tk1)+1
       do i=k1,k2
        ndx=(i-1)*nsamp+1+tk1
        call vclr(hold(ndx),1,lclr)
       end do
      endif
C +============================+
C | Process the data, applying |
C | decon if requested.          |
C +============================+
      ns = nsamp
      iws = jst
      iwe = jend
      if(do_decon)then
       do i=1,np
        ndx=(i-1)*nsamp+1
        if(.not.time_variant)then
        call decon(hold(ndx),ns,iws,iwe,ol,pred,prew,
     :             decond(ndx),ierror)
        else
          call decon_tv(hold(ndx),ns,ol,pred,prew,decond(ndx),ierror,
     :                  jslide,nwin,iovlp)
        endif
        if(forward)then
          ndx=ndx-1
          do j=1,nsamp
           data(ndx+j)=decond(ndx+j)
          end do
        endif
        if(ierror.ne.0)call vclr(decond(ndx),1,ns)
       end do
      else
       if(.not.forward)then
        do i=1,np
         ndx=(i-1)*nsamp
         do j=1,nsamp
          decond(ndx+j)=hold(ndx+j)
         end do
        end do
       else
        do i=1,np
         ndx=(i-1)*nsamp
         do j=1,nsamp
          data(ndx+j)=hold(ndx+j)
         end do
        end do
       endif
      endif
C +=======================+
C | Get inverse transform |
C +=======================+
      if(.not.forward)then
       call taupr(decond,nsamp,ndo,tp,np,temp,live,xoff,sr,data,
     : arho,do_decon)
       if(do_decon)then
        call taupr(hold,nsamp,ndo,tp,np,temp,live,xoff,sr,orig,
     : arho,do_decon)
       endif
      endif
      if(.not.scale)go to 1000
      if(.not.forward)then
C    +=================================+
C    | Get envelopes of the input data |
C    +=================================+
       do i=1,ndo
        kdx=(i-1)*nsamp
        call hilbertx(dhold(kdx+1),nsamp,temp,ierror)
        do j=1,nsamp
         h1=dhold(kdx+j)
         h2=temp(j)
         env_in(kdx+j) = sqrt(h1*h1+h2*h2)
        end do
       end do
C    +=====================================================+
C    | If not doing decon, data holds the inverse xform of |
C    | the original data. Otherwise, it holds the inverse  |
C    | of the deconvolved data.  Want scaling to use the   |
C    | original data, not the deconvolved data. Therefore, |
C    | if not doing decon, get the envelopes of data to us |
C    | in the scaling.  Otherwise, get the envelopes of    |
C    | orig, which holds the inverse xform of th original  |
C    | data.
C    +=====================================================+
       if(.not.do_decon)then
        do i=1,ndo
         kdx=(i-1)*nsamp
         call hilbertx(data(kdx+1),nsamp,temp,ierror)
         do j=1,nsamp
          h1=data(kdx+j)
          h2=temp(j)
          env_de(kdx+j) = sqrt(h1*h1+h2*h2)
         end do
        end do
       else
        do i=1,ndo
         kdx=(i-1)*nsamp
         call hilbertx(orig(kdx+1),nsamp,temp,ierror)
         do j=1,nsamp
          h1=orig(kdx+j)
          h2=temp(j)
          env_de(kdx+j) = sqrt(h1*h1+h2*h2)
         end do
        end do
       endif
C    +=====================================================+
C    | Now compute and do the scaling.                     |
C    | The scaling divides out the envelope of the inverse |
C    | transformed data and replaces it with the envelope  |
C    | of the original data.  This way, the envelope of    |
C    | output should be same as that of input while the    |
C    | frequency modulation portion of the output comes    |
C    | from the inverse transform data.  This operation    |
C    | preserves energy and properly scales the ouput.     |
C    +=====================================================+
       if(forward)then
         nout=np
       else
         nout=ndo
       endif
       do i=1,nout
        kdx=(i-1)*nsamp
        do j=1,nsamp
c - modified 10/13/04 to prevent div by zero - j.m.wade
c        if(env_in(kdx+j).ne.0.0)then
         if ((env_in(kdx+j).ne.0.0) .and.
     1       (env_de(kdx+j).ne.0.0)) then
          data(kdx+j)=env_in(kdx+j)/env_de(kdx+j)*data(kdx+j)
         else
          data(kdx+j)=0.
         endif
        end do
       end do
      endif
C +=================+
C | Output the data |
C +=================+
 1000 continue
      if(forward)then
       nout=np
      else
       nout=aper
       if(eof)nout=ndo
      end if
C +=======================================================+
C | if not at end of input file, save the overlap portion |
C | of the data matrix into the hold area.                |
C +=======================================================+
      if(ovlp.ne.0)then
       if(ipass.gt.0)then
        do i=1,mhold
          xmul=float(i-1)/float(mhold-1)
          ymul=1.0-xmul
          kdx=(i-1)*nsamp
          do j=1,nsamp
           data(kdx+j)=data(kdx+j)*xmul+hdata(kdx+j)*ymul
          end do
        end do
       end if
      if(.not.eof)then
       iget=nread-ovlp+1
       mhold=0
       do i=iget,nread
         jdx=mhold*nsamp
         kdx=(i-1)*nsamp
         do j=1,nsamp
          hdata(jdx+j)= data(kdx+j)
          Dhold(jdx+j)=Dhold(kdx+j)
         end do
         mhold=mhold+1
       end do
      endif
      endif
      do 204 jp=1,nout
        kdx=(jp-1)*nsamp
        jdx=(jp-1)*ITRWRD+1
        if(forward)then
         jdx=1
        endif
        call vmov(itrhd(jdx),1,itr,1,ITRWRD)
c       istat = th2(l_StaCor)
        call saver2(th2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1              istat, TRACEHEADER)
        if(forward)then
c         th2(l_StaCor)=0
c         th2(l_TrcNum)=jp
          call savew2(th2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                0    , TRACEHEADER)
          call savew2(th2,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                jp   , TRACEHEADER)
c         idip=tp(jp)*1000.*float(nsr)
          idip=tp(jp)*float(nsr)/unitsc
          if(idip.gt.32767)idip=32767
c         th2(l_DstSgn)=idip
          call savew2(th2,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                idip , TRACEHEADER)
          k=ITHWP1-1
          do i=1,nsamp
           Ritr(k+i)=data(kdx+i)
          end do
          call vmov(data(kdx+1),1,itr(ITHWP1),1,nsamp)
          if(stak)then
c           th2(l_RecNum)=iout
            call savew2(th2,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                  iout , TRACEHEADER)
          endif
        else
         if(istat .ne. 30000)then
          k=ITHWP1-1
          do i=1,nsamp
           Ritr(k+i)=data(kdx+i)
          end do
          if(zero(jp).ne.0.and.zero(jp).lt.limit)then
            izro = zero(jp)
            il = ITHWP1+izro
            call vclr(itr(ITHWP1),1,izro)
            call vmul(itr(il),1,ramp,1,itr(il),1,lramp)
          endif
         else
          k=ITHWP1-1
          do i=1,nsamp
           Ritr(k+i)=0.
          end do
         endif
        endif
        call wrtape(luout,itr,mbytes)
  204 CONTINUE
      if(.not.stak)then
       ndo=0
       goto 306
      else
       if(ovlp.ne.0)then
        m=0
        do i=iget,nread
         jdx=m*ITRWRD+1
         kdx=(i-1)*ITRWRD+1
         call vmov(itrhd(kdx),1,itrhd(jdx),1,ITRWRD)
         m=m+1
         zero(m)=zero(i)
        end do
       endif
       istart=ovlp+1
       ndo=ovlp
       jbias=0
       ipass=ipass+1
       iout=iout+1
       if(.not.eof)then
        goto 306
       else
        go to 305
       endif
      endif
      stop
      END
C***********************************************************************
      subroutine prparm(np,pmin,pmax,ntap,otap,ist,iend,lslide,
     :do_decon,ol,pred,prew,forward,arho,stak,scale,LERR)
      INTEGER     np,ol,pred
      real pmax,pmin,prew
C
      logical do_decon,forward,arho,stak,scale
C
      character ntap*100, otap*100
C
      write(LERR,'(10X,A     )')' '
      write(LERR,'(10X,A     )')'  Input Processing Parameters'
      if(ntap.ne.' ')then
      write(LERR,'(10X,2A)')    'Input data set...................',
     :ntap(1:25)
      else
      write(LERR,'(10x,3a)')    'Input data set...................',
     :'pipe'
      endif
      if(otap.ne.' ')then
      write(LERR,'(10X,2a)')    'Output data set..................',
     :otap(1:25)
      else
      write(LERR,'(10x,3a)')    'Output data set..................',
     :'pipe'
      endif
      if(stak)then
      write(lerr,'(10x,a     )')'Input is stacked data      '
      endif
      write(LERR,'(10X,A,f6.2)')'Minimum dip......................',pmin
      write(LERR,'(10X,A,f6.2)')'Maximum dip......................',pmax
      write(LERR,'(10X,A,I6  )')'Number of dips...................',np
      if(forward)then
      write(lerr,'(10x,a     )')'Forward transform only     '
      return
      endif
      if(do_decon)then
      if(lslide.eq.0)then
      write(LERR,'(10x,a   )')'Time-Invariant Deconvolution parameters'
      else
      write(LERR,'(10x,a   )')'Time-Variant Deconvolution parameters'
      endif
      write(LERR,'(10X,A,I6  )')'Operator length (ms).............',ol
      write(LERR,'(10X,A,I6  )')'Prediction length................',pred
      write(LERR,'(10X,A,f6.2)')'Prewhitening.....................',prew
      if(lslide.eq.0)then
      write(LERR,'(10X,A,I6  )')'Design window start..............',ist
      write(LERR,'(10X,A,I6  )')'Design window end................',iend
      else
      jend=lslide
      write(LERR,'(10X,A,I6  )')'Sliding window length(ms)........',jend
      endif
      endif
      if(arho)then
      write(LERR,'(10X,A     )')'Rho filter to be applied'
      endif
      if(scale)then
      write(LERR,'(10X,A     )')'Amplitude scaling to be applied'
      endif
      RETURN
      END
C
      subroutine openr(luin,itr,lbytes,nsamp,nsr,ntrc,nrcd,ntap,
     :ierr,unitsc)
* ******************************************************************** *
*                                                                      *
*  Subroutine to open the input data set and extract necessary         *
*  header information.                                                 *
*                                                                      *
*  Parameters                                                          *
*    luin  - I*4  -  Logical unit for input - returned by lbopen       *
*    itr   - I*4  -  Input buffer for line header                      *
*   nsamp  - I*4  -  Number of samples per trace                       *
*    nsr   - I*4  -  Sample interval of data. If > 64, assume microsec *
*    ntrc  - I*4  -  Number of traces per record input                 *
*    nrcd  - I*4  -  Number of records in data set                     *
*    ntap  - C*   -  Input data set name.  Blank = pipe                *
*    ierr  - I*4  -  Returned error:                                   *
*                    1 - No line header found.                         *
*                    1 - Too many samples per trace                    *
*                                                                      *
* ******************************************************************** *
      integer  itr(*),luin,lbytes
      integer nsamp,nsr,nrcd,ntrc,ierr
      character ntap*(*)
       if(ntap.ne.' ')then
           call lbopen(luin, ntap, 'r')
       else
           luin = 0
       endif
C +----------------------------------------+
C | Get line header, check to see if empty |
C +----------------------------------------+
      lbytes = 0
      call rtape(luin, itr, lbytes)
      if(lbytes .eq. 0) THEN
       ierr=1
       return
      endif
      call saver(itr, 'NumSmp', nsamp, 0)
      call saver(itr, 'SmpInt', nsr  , 0)
      call saver(itr, 'NumRec', nrcd , 0)
      call saver(itr, 'NumTrc', ntrc,  0)
      call saver(itr, 'UnitSc', unitsc, 0)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, 0)
      endif
C
C Removed check on nsamp - 10/10/96 - jev
C
C     if (nsamp.gt.3000) then
C        ierr = 2
C     endif
      return
      end
      subroutine openw(luout,itr,lbytes,nrecc,np,open,otap)
* ******************************************************************** *
*                                                                      *
*  Subroutine to open the output data set and write the line header.   *
*  Parameters:                                                         *
*   luout  - I*4  -  Logical unit for output. Returned by lbopen.      *
*    itr   - I*4  -  Line header buffer.                               *
*   lbytes - I*4  -  Line header length in bytes.                      *
*    nrecc - I*4  -  Number of records to output.                      *
*    np    - I*4  -  Number of traces per output record.               *
*    open  - L*4  -  Flag to signify data set opened successfully.     *
*    otap  - C*   -  Output data set name.                             *
*                                                                      *
* ******************************************************************** *

      integer   itr(*),luout,lbytes,nrecc,np
      character otap*(*)
      logical open

      if(otap.ne.' ')then
        call lbopen(luout,otap, 'w')
      else
        luout = 1
      endif
      if(luout.gt.0)then
       open=.true.
      else
       open=.false.
       return
      endif
      call savew(itr, 'NumTrc', np, 0)
      call savew(itr,'NumRec',nrecc,0)
      call wrtape(luout, itr, lbytes)
      return
      end
      subroutine gcmdln(ntap,otap, np,pmin,pmax,ist,iend,lslide,
     :ol,pred,prew,forward,scale,arho,stak,aper,dk1,dk2,ovlp,tk1,tk2,
     :is_offset)

      integer ol,pred,argis,np,aper,ovlp
      real pmin,pmax,prew

      character ntap*(*), otap*(*),cpw*8

      logical forward,scale,arho,stak,brho,is_offset

	  ntap = ' '
      otap = ' '
      call argstr ('-N',ntap,' ',' ')          
      call argstr ('-O',otap,' ',' ')            
      call argr4('-am',pmin,0.,0.)
      call argr4('-ax',pmax,0.,0.)
      call argi4('-na',np,0,0)
      call argi4('-p',pred,0,0)
      call argi4('-ol',ol,0,0)
      cpw=' '
      call argstr('-P',cpw,' ',' ')
      if(cpw.eq.' ')prew=0.01
      forward = (argis('-F').gt.0)
      scale = (argis('-S').gt.0)
      arho=.true.
      brho = (argis('-R').gt.0)
      if(brho)arho=.false.
      stak = (argis('-X').gt.0)
      is_offset = (argis('-Y').gt.0)
      if(is_offset)stak=.true.
      call argi4('-ap',aper,0,0 )
      call argr4('-dk1',dk1,0.,0.)
      call argr4('-dk2',dk2,0.,0.)
      call argr4('-tk1',tk1,0.,0.)
      call argr4('-tk2',tk2,0.,0.)
      call argi4('-ovlp',ovlp,0,0)
      call argi4('-s',ist,0,0)
      call argi4('-e',iend,0,0)
      call argi4('-l',lslide,0,0)
      return                                                  
      end
      subroutine help(LER)

      integer ler
      write(LER,*)  
     :'****************************************************************'
      write(LER,*)'Program SLDK.....................Dip-Dependent Slant'
      write(LER,*)'                             Stack and Deconvolution'
      write(LER,*)' '                                             
      write(LER,*)                                               
     :' -N [ntap]      (may be pipe)     : Input data file name'   
      write(LER,*)                                             
     :' -O [otap]      (may be pipe)     : Output data file name'
      write(LER,*)                                           
     :' -am [dmin]   (default = 0)       : Minimum dip (ms/tr)'
      write(LER,*)                                           
     :'                                    May use decimal & negative'
      write(LER,*)                                           
     :' -ax [dmax]   (no default)        : Maximum dip (ms/tr)'
      write(LER,*)                                           
     :'                                    May use decimal & negative'
      write(LER,*)                                           
     :' -na [na]    (no default)         : Number of dips in transform'
      write(LER,*)                                           
     :' -ol [ol]     (default=no decon)  : Operator length (ms)'
      write(LER,*)                                           
     :' -p [pred]   (default = 1 sample) : Prediction length in ms if'
      write(LER,*)                                           
     :'                                    positive'
      write(LER,*)                                           
     :'                                    Prediction length in zero' 
      write(LER,*)                                           
     :'                                    crossings if negative'
      write(LER,*)                                           
     :' -P [prew]    (default = 0.01)    : Prewhitening (%)'
      write(LER,*)                                        
     :' -s [ist]   (default = 0)         : Design window start time',
     :' (ms)'
      write(LER,*)
     :'                                    Ignored for time-variant '
      write(LER,*)
     :'                                    deconvolution'
      write(LER,*)                                             
     :' -e [iend] (default = last samp)  : Design window end time',
     :' (ms)'
      write(LER,*)
     :'                                    Ignored for time-variant '
      write(LER,*)
     :'                                    deconvolution'
      write(LER,*)
     :' -l [lslide] (Default = time-invar.): Sliding window length (ms)'
      write(LER,*)
     :'                                     for time-variant decon'
      write(LER,*)                                           
     :' -F [forward] (default=No)        : If present, output forward'
      write(LER,*)                                           
     :'                                    Tau-P transform only'
      write(LER,*)                                           
     :' -S [scale]   (default=No)        : If present, apply scaling'
      write(LER,*)                                           
     :'                                    to balance the output'
      write(LER,*)                                           
     :'                                    amplitudes relative to input'
      write(LER,*)                                           
     :' -R [rho]     (default=Yes)       : If present, DO NOT apply rho'
      write(LER,*)                                           
     :'                                    filter'
      write(LER,*)                                           
     :' -X [stacked] (default=No)        : If present, process stacked'
      write(LER,*)                                           
     :'                                    data (-ap required)'
      write(LER,*)                                           
     :' -Y [cos]     (default=No)        : If present, process common'
      write(LER,*)                                           
     :'                                    offset data (-ap required)'
      write(LER,*)                                           
     :' -ap [ap]     (default=none)      : Processing aperature for'
      write(LER,*)                                           
     :'                                    stacked data (traces)'
      write(LER,*)                                           
     :' -ovlp [ovlp] (default=none)      : Overlap between partitions'
      write(LER,*)                                           
     :'                                    for stacked data (traces)'
      write(LER,*)                                           
     :' -dk1 [dk1]   (default=no reject) : Minimum reject dip (ms/tr)'
      write(LER,*)                                           
     :'                                    May use decimal & negative'
      write(LER,*)                                           
     :' -dk2 [dk2]   (default=no reject) : Maximum reject dip (ms/tr)'
      write(LER,*)                                           
     :'                                    May use decimal & negative'
      write(LER,*)                                           
     :' -tk1 [tk1]   (default=0)         : Time for application of'
      write(LER,*)                                           
     :'                                    minimum reject dip (ms)'
      write(LER,*)                                           
     :' -tk2 [tk2]   (default=no reject) : Time for application of'
      write(LER,*)                                           
     :'                                    maximum reject dip (ms/tr)'
      write(LER,*)  
     :'***************************************************************'
      write(LER,*)'Usage: ',
     :'Usage: ',                                         
     :'sldk -N[] -O[] -am[] -ax[] -na[] -p[] -ol[] -P[] -s[] -e[]',
     :' -F -S -R -X -Y -ap[] -ovlp[] -dk1[] -dk2[] -tk1[] -tk2[]'
      write(LER,*)                                     
     :'***************************************************************'
      return                                                          
      end                                                            
      subroutine vmov(x,ix,y,iy,n)
      real x(*), y(*)
      iix = 1
      iiy = 1
      do i=1,n
       y(iiy)=x(iix)
       iix=iix+ix
       iiy=iiy+iy
      end do
      return
      end
