C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c Program spec to perform a continuous Fourier Transform
c and output either amplitude or phase.  This code take
c advantange of faster computers and clever analogs.
c
c  James M. Gridley
c  USP Team
c  November 1995
c with lots of help from lots of people
c Guto set me straight on phase and help
c with optimization techniques.	
c
c     Changes:
c
c Aug 22, 2001: Did runtime memory and access checking on Ganyuans upgrades
c               for energy normalization and live sample normalization.  
c               Also upgraded man page and pattern files for new 
c               -energy, -live options.
c
c Apr 24, 2000: Added -ssam option to report ongoing status for impatient
c               users.
c Garossino
c
c Oct 11, 1999: Added capability to output freq and spectral amplitude at
c               first spectral maxima.  This information allows the user
c               to define the highest frequency at which relative thickness
c               measure is a posibility.  On a time slice the lowest value
c               would be the highest such frequency.
c Garossino
c
c Jun 29, 1999: Finally got around to moving the table calculations out
c               of the inner loop.  Also added Tables and Decompose 
c               subroutines making spec now compatible completely with 
c               rwspec and also much much faster.  I really do not know
c               what to make of the -opbias operation.  I can see no 
c               theoretical reason to do this.  It seems like bullshit
c               to me.  The -trbias I can see as one would like the 
c               single realisation to be zero mean for the transform.
c               I am leaning toward taking the -opbias right out of the
c               routine altogether.  Maybe next time.
c Garossino
c
c 
c Jun 28, 1999: found sign error in sin table bias calculation as well
c               as multiple application of trace bias removal. both fixed.
c Garossino
c
c 
c Jun 23, 1999: Found major differences between output of rwspec and spec.
c               These were due to differences is bias treatment.  I have
c               made the default bias treatment to be NO bias removal of
c               either the trace or operator.  I added command line options
c               -trbias -opbias to activate either if wanted.
c Garossino
c
c 
c     May 17/99: fixed hardwired logical unit assignment to scaling
c                parameters file to use call alloclun(). Added policeman
c                to capture failure to open scaling parameters file.
c     Garossino
c
c     Maximum Entropy Option added August 1996 by James Gridley
c     New Command line parameters should not alter the usage
c     of this module to date.
c     Note, when running MEM there will  be an additional sample
c     at the end of each trace defining the polynomial order which
c     best fits the spectra.
c     This method was developed and subrountines provided by
c     Paul Gutowski (see mesa).
c  
      
c     get machine dependent parameters 
      
      implicit none
      
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>

c     dimension standard USP variables 
      
      integer itr ( SZLNHD )
      
      integer nsamp, nsi, ntrc, ntrco, nrec, nreco, iform
      integer luin, luout, lbytes, nbytes, lbyout, obytes
      integer ist, iend, irs, ire, ns, ne, argis, jerr
      integer JJ, KK 
      
      real tri ( SZLNHD )
      real UnitSc, dt

      character   ntap*255, otap*255, name*4
      
      logical     verbos
      
c Program Specific _ dynamic memory variables
      
      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6, abort
      integer TableSize, MaxEntSize
      
      real    Ctable, amprms, ampmax, freq, MaxEnt_freq, dead_trace
      
      pointer ( mem_Ctable, Ctable(2) )
      pointer ( mem_amprms, amprms(2) )
      pointer ( mem_ampmax, ampmax(2) )
      pointer ( mem_freq, freq(2) )
      pointer ( mem_MaxEnt_freq, MaxEnt_freq(2) )
      pointer ( mem_dead_trace, dead_trace(2) )
      
c Program Specific _ static memory variables
      
      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer luscale, lufreq, length, mstart, mlast
      integer itw, k, icode, akcode, rscode, ocode
      integer nfreq, ifint, freqbytes
      integer lenth, iwind, ihalf, mdim, lwin, i, nlive
      integer m_mem

      real fmin, fmax, fint, pie, df, radeg
      real freq_at_max, amp_at_max, avg, ssq_mem, pwr
      real t(SZLNHD)
      real v_mem(SZLNHD),vc_mem(SZLNHD)
      real s_mem(SZLNHD),sc_mem(SZLNHD)
      real a_mem(SZLNHD),freqs(SZLNHD)
      real counter(SZLNHD)
    
      character   scale_file*255, freq_file*255

      logical trbias, opbias, phase, wrap, gaus, entropy, ssam
      logical normal_energy, normal_live
      
c Initialize variables
      
      data abort/1/
      data name/"SPEC"/

      pie= 4.0 * atan(1.0) 
      radeg = 57.29578

c     give command line help if requested
      
      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif
      
c     open printout file
      
#include <f77/open.h>
      
c     get command line input parameters
      
      call cmdln (ntap,otap,scale_file, freq_file, ns,ne,irs,ire, ist, 
     :     iend, name, verbos, fmin, fmax, fint, itw, phase,
     :     normal_energy, normal_live, wrap, gaus, entropy, mstart, 
     :     mlast, trbias, opbias, ssam )

c     if entropy then fint must equal 1
      if (entropy) then
         if(fint .ne. 1) then
            write(LERR,*)' '
            write(LERR,*) 'Warning: -fint[] must equal 1'
            write(LERR,*) 'Program Override of -fint1 Enabled '
            write(LERR,*)' '  
            write(LER,*)' '
            write(LER,*) 'Warning: -fint[] must equal 1'
            write(LER,*) 'Program Override of -fint1  Enabled '
            write(LER,*)' '
            fint = 1
         endif
      endif
   
c     open input and output files
      
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c open scale file

      call alloclun (luscale)
      length = lenth(scale_file)
      open(luscale,file=scale_file(1:length),status='UNKNOWN', err=900)

c open frequency at 1st spectral max file

      if ( freq_file .ne. ' ') then
         call getln(lufreq,freq_file,'w',1)
      endif
      
c     read input line header and save certain parameters
      
      lbytes = 0
      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'SPEC: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif
      
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', UnitSc, LINHED)

      if (UnitSc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',UnitSc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          UnitSc = .001
          call savew(itr, 'UnitSc', 1.0 , LINHED)
      endif

c     define pointers to header words required by your routine
      
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      
c check the default on the max limits of frequency and set
c to nyquist if zero
 
      dt = real (nsi) * UnitSc
      if (fmax .le. 0. ) fmax = (1./ ( 2.* dt) )
      nfreq = ( (fmax-fmin) / fint ) + 1
 
      if ( iend .le. 0 .or. iend .gt. nsamp*nsi ) then
	 iend = nsamp
      else
         iend = iend / nsi + 1
      endif
 
      if (ist .le. 1) then
         ist = 1
      else
         ist = ist/nsi + 1	
      endif
      
      iwind = iend - ist + 1
      ihalf = iwind / 2

c     check user supplied boundary conditions and set defaults
      
      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec
      
      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

c     print HLH to printout file 

      call hlhprt (itr, lbytes, name, 4, LERR)
      
c     number output bytes
      

      if (entropy) then
         obytes = SZTRHD + (SZSMPD * (nfreq +1))
      else
         obytes = SZTRHD + SZSMPD * nfreq 
      endif

      freqbytes = SZTRHD + SZSMPD * 2

c     save out hlh and line header
      
      ifint = int(fint)

      if (entropy) then
         call savew(itr,'NumSmp', nfreq+1, LINHED)
         call savew(itr,'SmpInt', ifint, LINHED)
      else
         call savew(itr,'NumSmp', nfreq, LINHED)
         call savew(itr,'SmpInt', ifint, LINHED)
      endif

      call savew ( itr, 'SmpFlt', fint , LINHED)
      call savew ( itr, 'FreQst', fmin , LINHED)
      call savew ( itr, 'FreQnd', fmax , LINHED)
      call savew ( itr, 'NumRec', nreco, LINHED)
      call savew ( itr, 'NumTrc', ntrco  , LINHED)
      
      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c write line header to frequency at 1st spectral maximum file, if requested

      if ( freq_file .ne. ' ' ) then
         call savew ( itr, 'NumSmp', 2, LINHED )
         call wrtape ( lufreq, itr, lbyout )
      endif
      
c     verbose output of all pertinent information before processing begins
      
      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, ns, ne, verbos, fmin, fmax, fint, itw, phase,
     :     normal_energy, normal_live, wrap, gaus, entropy, mstart, 
     :     mlast, scale_file,freq_file,trbias, opbias )
      
c     dynamic memory allocation:  
      
      TableSize = nfreq * ( iwind + 2 ) * 2
      MaxEntSize = nfreq + 1
      
      call galloc (mem_Ctable, TableSize * SZSMPD, errcd1, abort)
      call galloc (mem_amprms, nfreq * SZSMPD, errcd2, abort)
      call galloc (mem_ampmax, nfreq * SZSMPD, errcd3, abort)
      call galloc (mem_freq, nfreq * SZSMPD, errcd4, abort)
      call galloc (mem_MaxEnt_freq, MaxEntSize * SZSMPD, errcd5, abort)
      call galloc (mem_dead_trace, nfreq * SZSMPD, errcd6, abort)
      
      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) TableSize * SZSMPD, '  bytes'
         write(LERR,*) MaxEntSize * SZSMPD, '  bytes'
         write(LERR,*) 4 * nfreq * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) TableSize * SZSMPD, '  bytes'
         write(LER,*) MaxEntSize * SZSMPD, '  bytes'
         write(LER,*) 4 * nfreq * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) TableSize * SZSMPD, '  bytes'
         write(LERR,*) MaxEntSize * SZSMPD, '  bytes'
         write(LERR,*) 4 * nfreq * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif
      
c     initialize memory
      
      call vclr ( Ctable, 1, TableSize )
      call vclr ( amprms, 1, nfreq )
      call vclr ( ampmax, 1, nfreq )
      call vclr ( freq, 1, nfreq )
      call vclr ( dead_trace, 1, nfreq )

c=======================================================================  
c Maximum Entropy method
      
      IF (entropy) then
         icode=0
         akcode = 0
         rscode = 1
         mdim = int(mlast*(mlast+1)/2)
         lwin = nsamp
         dt = nsi/1000.

         do i = 1, mlast
            counter(i) = 0.
         enddo 

         ifint=int(fint)

         do i = fmin, fmax, fint
            freqs(i-int(fmin)+1) = float(i)   
         enddo

      ENDIF

c=======================================================================
c     call this subroutine to set up transform tables

      call Tables ( Ctable, iwind, nfreq, opbias, gaus, t, itw, 
     :     ihalf, pie, fmin, fmax, fint, dt )

c____________________________________________________________
c     initialize factors used for scaling.
c____________________________________________________________
      nlive = 0

c=======================================================================
        
c     BEGIN PROCESSING 
        
c     skip unwanted input records
        
      call recskp ( 1, irs-1, luin, ntrc, itr )
      
      DO JJ = irs, ire
         
c     skip to start trace
         
         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         if ( ssam ) write(LER,*)' (spec) start, current, end',irs, JJ, 
     :        ire
         
         DO KK = ns, ne
            
            nbytes = 0
            call rtape( luin, itr, nbytes)
            
c     if end of data encountered (nbytes=0) then bail out
            
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif
            
c     get required trace header information
            
            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )
            
c     process only live traces
            
            IF ( StaCor .ne. 30000) then

               nlive=nlive+1
               
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )

               IF (entropy) then

c Maximum Entropy Method
               
                  
                  if ( trbias ) then

c do not remove bias unless the user has specifically asked to
                     
                     avg = 0.
                     do i = 1, nsamp
                        avg = avg + tri(i)
                     enddo
                  
                     avg = avg / nsamp
                     do i = 1 , nsamp
                        tri(i) = tri(i) - avg
                     enddo

                  endif

                  call fabne (tri, nsamp, mstart, mlast, icode,
     1                 akcode, rscode, mdim, v_mem, vc_mem, s_mem,
     2                 sc_mem, a_mem, m_mem, ssq_mem, pwr, ocode)

                  do i = 1, nfreq + 1
                     MaxEnt_freq(i) =0.
                  enddo   
                
                  
                  call power ( MaxEnt_freq, a_mem, m_mem, freqs,
     :                 nfreq , dt, pwr)

                  counter(int(m_mem)) =  counter(int(m_mem)) +1
                 
                  MaxEnt_freq (nfreq+1) = m_mem
                 
                  call vmov ( MaxEnt_freq, 1, itr(ITHWP1), 1, nfreq+1 )

               ELSE

                  call Decompose ( tri, nsamp, ist, iend, trbias, 
     :                 nfreq, iwind, ihalf, Ctable, t, freq, radeg, 
     :                 phase, normal_energy, normal_live, ampmax, 
     :                 amprms )

                  if (phase .and. .not. wrap) call drum (nfreq, freq)
                  
                  call vmov ( freq, 1, itr(ITHWP1), 1, nfreq )
                  
                  if ( freq_file .ne. ' ' .and. .not. phase ) 
     :                 call FirstSpectralMaxima ( freq, nfreq, 
     :                 fmin, fint, freq_at_max, amp_at_max)

               ENDIF

            ELSE

c dead trace
               
               call vmov ( dead_trace, 1, itr(ITHWP1), 1, nfreq )

            ENDIF

c write output data
            
            call wrtape ( luout, itr, obytes)

c write freq output data if requested

            if ( freq_file .ne. ' ' ) then

               call vclr(tri, 1, nsamp)
               tri(1) = freq_at_max
               tri(2) = amp_at_max
               call vmov ( tri, 1, itr(ITHWP1), 1, 2 )
               call wrtape ( lufreq, itr, freqbytes )

            endif
            
         ENDDO
         
c     skip to end of record
         
         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )
         
      ENDDO
c------------------------------------------------------------
c     write out factors used for scaling.
c------------------------------------------------------------
      write(luscale,'(i15,t20,a)') nfreq,'number of frequencies'
      write(luscale,'(3a15)') 'frequency','max amplitude',
     1                          'rms amplitude'
      do k = 1,nfreq
         df=(k-1)*fint+fmin
         if(nlive .gt. 0) then
            amprms(k)=sqrt(amprms(k))/real(nlive)
         else
            amprms(k)=0.
         endif
         write(luscale,'(f15.3,e15.5,e15.5)')
     1        df, ampmax(k), amprms(k)
      enddo
      
      if(entropy) then
         write(LERR,*) ' '
         write(LERR,*) ' '
         write(LERR,*) ' '
         write(LERR,*)'Order of Polynomial, Number of Occurrences'
         write(LERR,*) ' '
         do i = 1, mlast
            write(LERR,*)i,counter(i)
         enddo
         write(LERR,*) ' '
      endif

c close data files 

      close(luscale)
      call lbclos ( luin )
      call lbclos ( luout )
      if ( freq_file .ne. ' ' ) call lbclos ( lufreq )
      write(LERR,*)'SPEC: Normal Termination'
      write(LER,*)'SPEC: Normal Termination'
      stop

 900  continue

      write(LERR,*)' Error opening Scaling File ',scale_file(1:length)
      write(LERR,*)' check permissions and try again'
      write(LERR,*)'FATAL '
      write(LERR,*)' '
      write(LER,*)'SPEC: '
      write(LER,*)' Error opening Scaling File ',scale_file(1:length)
      write(LER,*)' check permissions and try again'
      write(LER,*)'FATAL '
      write(LER,*)' '
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      if ( freq_file .ne. ' ' ) call lbclos ( lufreq )
      write(LERR,*)'SPEC: Abnormal Termination'
      write(LER,*)'SPEC: Abnormal Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for SPEC'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-F[]   -- freq and amp at 1st '
      write(LER,*)'          spectral maxima file         (not used)'
      write(LER,*)'-S[]   -- output data used for scaling '
     1                          //' (spec_scale_file)'
      write(LER,*)'-s[]   -- process start time (ms)             (1)'
      write(LER,*)'-e[]   -- process end time (ms)     (last sample)'
      write(LER,*)'-ns[]  -- start trace number                  (1)'
      write(LER,*)'-ne[]  -- end trace number           (last trace)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)'-fmin[]  -- minimum frequency              (1 hz)'
      write(LER,*)'            value put in output LH word FreQst'
      write(LER,*)'-fmax[]  -- maximum frequency  (0 yields Nyquist)'
      write(LER,*)'-fint[]  -- frequency interval             (1 hz)'
      write(LER,*)'            value put in LH word SmpFlt & SmpInt'
      write(LER,*)'-taper[]  -- percent taper (100=total taper, 10%)'
      write(LER,*)'-phase  -- Calculate and output phase'
      write(LER,*)'-opbias -- remove operator bias'
      write(LER,*)'-trbias -- remove trace bias'
      write(LER,*)'-energy  -- Apply energy normalization'
      write(LER,*)'-live  -- Apply normalization by live samples'
      write(LER,*)'-G  -- Apply a Gaussian Taper (-taper not used)'
      write(LER,*)'-W  -- Leave phase wrapped'
      write(LER,*)' '
      write(LER,*)'Maximum Entropy Method'
      write(LER,*)'-MEM -- Use Maximum Entropy Method'
      write(LER,*)'-min[] -- Minimum  order of polynomial        (2)'
      write(LER,*)'-max[] -- Maximum order of polynomial         (2)'
      write(LER,*)' '
      write(LER,*)'Printout'
      write(LER,*)'-ssam  -- print ongoing status to stderr     (not)'
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'     spec -N[] -O[] -S[] -F[] -s[] -e[] -ns[] -ne[]'
      write(LER,*)'          -rs[] -re[] -fmin[], -fmax[], -fint[],'
      write(LER,*)'          -taper[], -phase, -G, -W, -energy, -live, '
      write(LER,*)'          -MEM -min[] -max[]  -opbias -trbias -ssam'
      write(LER,*)'          -V'
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 
      subroutine cmdln(ntap,otap,scale_file, freq_file,ns,ne,irs,ire,
     :     ist, iend, name, verbos, fmin, fmax, fint, itw, phase,
     :     normal_energy, normal_live, wrap, gaus, entropy, mstart, 
     :     mlast, trbias, opbias, ssam )


#include <f77/iounit.h>

      integer    ist, iend, ns, ne, irs, ire, argis
      integer    itw,mstart,mlast

      character  ntap*(*), otap*(*), name*(*)
      character  scale_file*(*), freq_file*(*)

      real     fmin, fmax, fint

      logical verbos, phase, wrap, gaus, entropy, trbias, opbias
      logical normal_energy, normal_live
      logical ssam

      normal_energy = (argis('-energy') .gt. 0)
      call argi4 ( '-e', iend, 0, 0 )

      call argr4( '-fint', fint,1.,1.)
      call argr4( '-fmax', fmax,0.,0.)
      call argr4( '-fmin', fmin,1.,1.)
      call argstr ( '-F', freq_file, ' ', ' ' ) 

      gaus = (argis('-G') .gt. 0)

      normal_live = (argis('-live') .gt. 0)

      call argi4( '-max', mlast,2,2)

      entropy = (argis('-MEM') .gt. 0)
          
      call argi4( '-min', mstart,2,2)

      call argi4 ( '-ne', ne, 0, 0 )
      call argi4 ( '-ns', ns, 0, 0 )
      call argstr ( '-N', ntap, ' ', ' ' ) 

      opbias = (argis('-opbias') .gt. 0)
      call argstr ( '-O', otap, ' ', ' ' ) 

      ssam = (argis('-ssam') .gt. 0)
      call argstr ( '-S',scale_file,'spec_scale_file',
     1     'spec_scale_file' ) 

      phase = (argis('-phase') .gt. 0)
      
      call argi4 ( '-re', ire, 0, 0 )
      call argi4 ( '-rs', irs, 0, 0 )
      
      call argi4 ( '-s', ist, 1, 1 )
      
      trbias = (argis('-trbias') .gt. 0)
      call argi4 ( '-taper', itw, 10, 10 )
      
      verbos = (argis('-V') .gt. 0)
      
      wrap = (argis('-W') .gt. 0)


c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, ns, ne, verbos, fmin, fmax, fint, itw,
     :     phase,normal_energy, normal_live,wrap, gaus, entropy, 
     :     mstart, mlast, scale_file, freq_file, trbias, opbias )
      
#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs
      integer    ire, ns, ne, nsi
      integer    itw, mstart, mlast

      character  ntap*(*), otap*(*), scale_file*(*)

      real fmin, fmax, fint	

      logical verbos, phase, wrap, gaus, entropy, normal_energy
      logical trbias, opbias, normal_live

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*) ' Min Freq.             =  ', fmin
      write(LERR,*) ' Max Freq.             =  ', fmax
      write(LERR,*) ' Freq. Interval        =  ', fint
	if (gaus) then
      write(LERR,*) ' Using Gaussian Taper'
	else	
      write(LERR,*) ' Percent Cosine Taper  =  ', itw
	endif
      write(LERR,*)' '
      write(LERR,*)' '
	if (phase) then
      write(LERR,*)' '
      write(LERR,*) ' Calculating Phase'
      write(LERR,*)' '
	endif
      write(LERR,*)' '
	if (.not. wrap) then
      write(LERR,*)' '
      write(LERR,*) ' Leaving Phase Wrapped'
      write(LERR,*)' '
	endif
	if (normal_energy) then
      write(LERR,*)' '
      write(LERR,*) ' Normalize energy level'
      write(LERR,*)' '
	endif
	if (normal_live) then
      write(LERR,*)' '
      write(LERR,*) ' Normalize by number of live samples'
      write(LERR,*)' '
	endif
        
        if (entropy) then
           write(LERR,*)' '
      write(LERR,*)' Using Maximum Entropy Method'
      write(LERR,*)' Minimum polynomial order = ', mstart
      write(LERR,*)' Maximum polynomial order = ', mlast
      write(LERR,*)' '
      endif
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' output scale file name = ', scale_file
      write(LERR,*) ' start record          =  ', irs 
      write(LERR,*) ' end record            =  ', irs 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      if ( trbias )  write(LERR,*) ' trace bias removed'
      if ( opbias )  write(LERR,*) ' operator bias removed'
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
	end
 
      subroutine drum (lphz, ph)
      real      ph(*)
      integer   lphz,ii
      pi = 180.
 
      pj = 0.
      do  40 ii = 2, lphz
 
          if (abs(ph(ii)+pj-ph(ii-1))-pi) 40,40,10
 
10        if (ph(ii)+pj-ph(ii-1)) 20,40,30
 
20        pj = pj +  2*pi
          go to 40
 
30        pj = pj -  2*pi
 
40        ph(ii) = ph(ii) + pj
 
      return
	end
