C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ttdparse( ndomain, odomain, func, ierr )

      implicit none

      character*3 ndomain, odomain, func
      character*1 i1, i2, i3, o1, o2, o3
      integer     ierr
      
      ierr = 0
      func = '?'

      i1 = ndomain(1:1)
      i2 = ndomain(2:2)
      i3 = ndomain(3:3)
      o1 = odomain(1:1)
      o2 = odomain(2:2)
      o3 = odomain(3:3)

c===  check for uniqueness of symbols and first two characters non-blank

      if( i1.eq.i2  .or. i1.eq.i3  .or. i2.eq.i3 .or.
     &    o1.eq.o2  .or. o1.eq.o3  .or. o2.eq.o3 .or.
     &    i1.eq.' ' .or. i2.eq.' ' .or. o1.eq.' ' .or. o2.eq. ' ' ) then
         ierr = 1
         return
      end if

c===  check for txy -> xyw

      if( ( i1.eq.'t' .or. i1.eq.'T' ) .and. ( o3.eq.'w' .or. o3.eq.'W')
     &    .and. o1.eq.i2 .and. o2.eq.i3 ) then
         func = '23w'
         return
      endif

c===  check for xyw -> txy

      if( ( i3.eq.'w' .or. i3.eq.'W' ) .and. ( o1.eq.'t' .or. o1.eq.'T')
     &    .and. o2.eq.i1 .and. o3.eq.i2 ) then
         func = 't12'
         return
      endif

c===  check for arbitrary permutation

      if     ( o1.eq.i1 .and. o2.eq.i2 .and. o3.eq.i3 ) then
         func = '123'
      else if( o1.eq.i1 .and. o2.eq.i3 .and. o3.eq.i2 ) then
         func = '132'
      else if( o1.eq.i2 .and. o2.eq.i1 .and. o3.eq.i3 ) then
         func = '213'
      else if( o1.eq.i2 .and. o2.eq.i3 .and. o3.eq.i1 ) then
         func = '231'
      else if( o1.eq.i3 .and. o2.eq.i1 .and. o3.eq.i2 ) then
         func = '312'
      else if( o1.eq.i3 .and. o2.eq.i2 .and. o3.eq.i1 ) then
         func = '321'
      else
         ierr = 2
      endif

      return
      end
