C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C*********************************************************************
C NAME: TTDS3D  TTDS3D HEADER FILE              REV 2.10    APR 95   *
C*********************************************************************
C
C  PURPOSE:
C     DEFINES SYMBOLIC CONSTANTS FOR TTDS3D.
C
C  HISTORY:
C       JAN 92          REV 1.0         R.D. COLEMAN, CETech
C       MAY 93          REV 1.1         Mary Ann Thornton
C             Change version number.
C       JUN 93          REV 1.2         R.D. COLEMAN, CETech
C             Change version number.
C       DEC 93          REV 2.0         R.D. COLEMAN, CETech
C             Change version number.
C       JUN 94          REV 2.1         R.D. COLEMAN, CETech
C             Change version number.
C       JUL 94          REV 2.2         R.D. COLEMAN, CETech
C             Change version number.
C       AUG 94          REV 2.3         Mary Ann Thornton     
C             Changes: version number
C                      Changed default memory size for Suns to 16MB
C                      Changed the order of picking up the command line
C                              arguments to avoid collisions of flags: 
C                              -ND -N, -OD -O, -MF -M, -fc -f, -FC -F
C       SEPT 94         REV 2.4         Mary Ann Thornton     
C             Changes: version number
C                      changed 4 calls to argi4 (see ttparm.F)
C                      changed the Open statments in the conversion 
C                      routines to remove the "SCRATCH" access when
C                      "FILE" is specified. This fails on the HP.
C       Jan 95          REV 2.5         Mary Ann Thornton     
C             Changes: version number
C                      Changed ttparm to include call to savhlh which
C                      will save command line arguments in historical
C                      part of the line header
C       Jan 95          REV 2.6         Mary Ann Thornton     
C             Changes: version number
C                      Moved dw and w0 calculations
C       Feb 95          REV 2.7         Mary Ann Thornton     
c                      Recompile to pickup the new libut (putfp)
C       Feb 24, 1995    REV 2.8         Mary Ann Thornton     
c                      Write dw, w0 to printout when not in verbose mode
C   Revised:  Mary Ann Thornton                        REV 2.9  04/21/95
C             Changed ttinit and ttparm so all of the command line args
C             beginning with an 'N' would be selected before the input
C             tape.  Program was failing inside IKP because of this.
C   Revised:  R.D.Coleman, CETech                      REV 2.10 04/27/95
C             Changed version number in this file (see ttmain.F for
C             other changes).
C   Revised:  R.D.Coleman, CETech                      REV 2.11 05/17/95
C             Changed version number in this file (see ttmain.F for
C             other changes).
C   Revised:  Mary Ann Thornton                        REV 2.12 01/04/96
C             changed error messages in the conversion routines for
C             clarity of meaning
C-----------------------------------------------------------------------
C
      integer maxwm
#ifdef SUNSYSTEM
      parameter ( maxwm = 4194304 )
#else
      parameter ( maxwm = 8388608 )
#endif
C
C  LOGICAL UNIT NUMBERS
C
      integer lutrm, lutmp, lusur
      parameter( lutrm = 0, lutmp = 25, lusur = 27 )
C
C  STRING CONSTANTS
C
      integer lppnam
      parameter ( lppnam = 6 )
      character ppname*6, version*4, title*66
      parameter( ppname = 'TTDS3D', version = '2.12' )
      parameter( title =                                               '
     &                  Transform & Transpose Data Set
     &' )
C
C  MISCELLANEOUS CONSTANTS
C
      real pi, halfpi, twopi, deg2rad, rad2deg
      parameter( pi = 3.141592653589793 )
      parameter( halfpi = 0.5 * pi, twopi = 2.0 * pi,
     &           deg2rad = pi / 180.0, rad2deg = 180.0 / pi )
C
