C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: TTINIT      TTDS3D INITIALIZE                                  *
C***********************************************************************
C
C  PURPOSE:
C      TTINIT INITIALIZES THE PROGRAM INCLUDING OPENING ALL REQUIRED
C      FILES.
C
C-----------------------------------------------------------------------
C
      subroutine ttinit( verbos, memmax, ifiltr, ndomain, odomain,ierr )
C
      implicit none
C
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
cinclude <f77/hp.h>
#include <ttds3d.h>
C
C  SUBROUTINE ARGUMENTS
C
      logical   verbos
      integer   memmax, ierr
      logical   ifiltr
      character ndomain*3, odomain*3
C
C  LOCAL VARIABLES
C
      integer       argis, nlines, mbytes
C
C-----------------------------------------------------------------------
C
      verbos = argis( '-V' ) .gt. 0
C
C  IF HELP, WRITE INSTRUCTIONS TO SCREEN
C
      if ( argis( '-h' ) .gt. 0 .or. 
     :     argis( '-?' ) .gt. 0 .or. 
     :     argis( '-help' ) .gt. 0 ) then
         write (ler, 901)
  901 format(/
     &' =============================================================='/
     &' Command Line Arguments for TTDS3D: time to depth slice 3D'/ 
     &' '/
     &' For a more detailed description of these parameters'/
     &' see the online man page using uman, xman or xuspman'/
     &' '/
     &' Input................................................... (def)'/
     &' '/
     &'  -N[]         - input data set                         (stdin)'/
     &'  -O[]         - output data set                       (stdout)'/
     &' '/
     &'  -T[]         - temporary file  (default is system generated '/
     &'                                  name in current directory)'/
     &' '/
     &'  -ND[]        - Input Domain                (default = "txy")'/
     &'  -OD[]        - Output Domain               (default = "txy")'/
     &'  -BR[]        - Beginning Record            (default = 1'/
     &'  -ER[]        - ENDING RECORD               (default = NumRec)'/
     &'  -PR[]        - PAD RECORD                  (default = 0)'/
     &'  -IR[]        - RECORD INCREMENT            (default = 1)'/
     &'  -BT[]        - BEGINNING TRACE             (default = 1)'/
     &'  -ET[]        - ENDING TRACE                (default = NumTrc)'/
     &'  -PT[]        - PAD TRACE                   (default = 0)'/
     &'  -BS[]        - BEGINNING SAMPLE            (default = 1)')

#ifdef SUNSYSTEM

            write( ler, 9012)
 9012 format(/
     &'  -M[]         - MAXIMUM MEMORY IN MBYTES    (default = 16)')

#else

            write( ler, 9011)
 9011 format(/
     &'  -M[]         - MAXIMUM MEMORY IN MBYTES    (default = 64)')

#endif

         write (ler, 902)
  902 format(
     &'  -ES[]        - ENDING SAMPLE               (default = NumSmp)'/
     &'  -PS[]        - PAD SAMPLE                  (default = 0)'/
     &'  -OS[]        - OFFSET SAMPLES              (default = 0)'/
     &'  -DT[]        - DELTA TIME                  (default = SmpInt)'/
     &'  -V           - VERBOSE PRINTOUT'/
     &' '/
     &' THE NEXT 4 ARGUMENTS ARE FOR txy -> xyw AND xyw -> txy ONLY:'/
     &' '/
     &'  -f[]         - LOW CUTOFF FREQUENCY IN HZ  (default = 0)'/
     &'  -fc[]        - LOW CORNER FREQUENCY IN HZ  (default = f)'/
     &'  -FC[]        - HI  CORNER FREQUENCY IN HZ  (default = F)'/
     &'  -F[]         - HI  CUTOFF FREQUENCY IN HZ  (default = nyq-dw)'/
     &' '/
     &' THE NEXT 6 ARGUMENTS ARE FOR xyw -> txy ONLY:'/
     &' '/
     &'  -DW[]        - DELTA OMEGA                 (default none)'/
     &'  -W0[]        - OMEGA ORIGIN                (default = 0.0)'/
     &'  -NT[]        - NUMBER OF T-s = FFT Length(default = smallest)'/
     &'                     FFT number >= twice the highest frequency)'/
     &' '/
     &'  -IT[]        - INDEX OF FIRST T TO OUTPUT  (default = 1)'/
     &'  -NTOUT[]     - NUMBER OF T-s TO OUTPUT    (default =nt-it1+1)'/
     &'  -MF          - MULTIPLY BY TRAPIZOIDAL FILTER'/)

         write (ler, 903)
  903 format(
     &'  Note: The arguments -IR and -OS are ignored for xyw -> txy'/)


	 if( verbos ) then
            write (ler, 904)
  904 format(
     &'  INPUT DOMAIN is a sequence of any two or three symbols'//
     &'  OUTPUT DOMAIN is a sequence of any two or three symbols that'/
     &'  comform to the following rules:'//
     &'    1. No transform - The symbols used for output domain must'/
     &'       be the same as those used for the input domain, however,'/
     &'       they may be in any arbitrary order.  Examples:'/
     &'          a. -NDabc -ODcab'/
     &'          b. -ND123 -OD132'/
     &'          c. -NDtx  -ODxt'//
     &'    2. Forward FFT - The first symbol of the input domain must'/
     &'       be either "t" or "T" and the last symbol of the output'/
     &'       must be either "w" or "W".  In addition, the first and'/
     &'       second symbols of the output domain must equal the'/
     &'       second and third symbols of the input domain,'/
     &'       respectively.  Examples:'/
     &'          a. -NDtxy -ODxyw'/
     &'          b. -NDTab -ODabW'/)

            write (ler, 905)
  905 format(
     &'    3. Inverse FFT - The first symbol of the output domain must'/
     &'       be either "t" or "T" and the last symbol of the input'/
     &'       must be either "w" or "W".  In addition, the first and'/
     &'       second symbols of the input domain must equal the'/
     &'       second and third symbols of the output domain,'/
     &'       respectively.  Examples:'/
     &'          a. -NDxyw -ODtxy'/
     &'          b. -NDabW -ODTab'/)
	 endif

         write (ler, 909)
  909 format(
     &' **************************************************************'/
     &)
         stop
      endif
C
C  CREATE UNIQUE PRINT FILE NAME FROM THE PROCESS ID & OPEN PRINT FILE
C
      call openpr (lusur, luprt, ppname, ierr)
      if (ierr .ne. 0) then
         ierr = 2100 + iabs( ierr )
         return
      endif
C
      if (verbos) write (luprt, *) ' ENTER SUBROUTINE TTINIT'
C
c#include <f77/mbsdate.h>
C
      nlines = 1
      call gamoco (title, nlines, luprt)
C
C  GET REMAINING COMMAND LINE ARGUMENTS
C
      ifiltr = argis( '-MF' ) .le. 0
      call argstr('-ND', ndomain, 'txy', 'txy' )
      call argstr('-OD', odomain, 'txy', 'txy' )
      call argi4 ('-M' , mbytes , 0, 0)

C
      if( mbytes .eq. 0 ) then
         memmax = maxwm
      else
         memmax = 1048576 * mbytes / iszbyt
      endif
C
      ierr = 0
C
C-----------------------------------------------------------------------
C
      return
      end
