C***********************************************************************
C                                                                      *
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C NAME: TTDS3D    TRANSFORM & TRANSPOSE DATASET        REV 2.10 APR 95 *
C***********************************************************************
C
C   Original: R.D. Coleman, CETech                     REV 1.0  JAN 92
C   Revised:  Mary Ann Thornton                        REV 1.1  MAY 93
C             Recompiled to utilize the new gtfltr.f routine in the
C             libmbs library.
C             Change line header size to SZLNHD
C             Add include file for logical unit for hp and change writes
C             to lutrm to writes to ler.
C   Revised:  R.D. Coleman, CETech                     REV 1.2  JUN 93
C             Replaced calls to RDREC and WRREC with calls to RDRECNH
C             and WRRECNH.  Also, replaced PRNAME with PPNAME.
C   Revised:  R.D. Coleman, CETech                     REV 2.0  DEC 93
C             Complete rewrite.  Data is chunked to minimize I/O to
C             temporary file.  Added xyw -> txy and all possible
C             permutations without transforms.  Added a record
C             increment parameter.
C   Revised:  R.D. Coleman, CETech                     REV 2.1  JUN 94
C             Fixed bug in calculation of number of output records when
C             increc > 1.
C   Revised:  R.D. Coleman, CETech                     REV 2.2  JUL 94
C             Write w0 and dw to output line header.
C   Revised:  Mary Ann Thornton (See ttds3d.h)         REV 2.3  JAN 95
C   Revised:  Mary Ann Thornton (See ttds3d.h)         REV 2.4  JAN 95
C   Revised:  Mary Ann Thornton (See ttds3d.h)         REV 2.5  JAN 95
C             Add a call to savhlh to save the command line arguments
C             in the historical part of the line header (see ttparm.F)
C   Revised:  Mary Ann Thornton (See ttds3d.h)         REV 2.6  JAN 95
C             Moved w0 and dw calculation in txy2xyw portion of code
C   Revised:  Mary Ann Thornton (See ttds3d.h)         REV 2.7  FEB 95
C             Recompile to pick up the new libut (putfp)
C   Revised:  Mary Ann Thornton (See ttds3d.h)         REV 2.8  02/24/95
C             Write dw, w0 to printout when not in verbose mode
C   Revised:  Mary Ann Thornton (See ttds3d.h)         REV 2.9  04/21/95
C             Changed ttinit and ttparm so all of the command line args
C             beginning with an 'N' would be selected before the input
C             tape.  Program was failing inside IKP because of this.
C   Revised:  Ron Coleman, CETech                      REV 2.10 04/27/95
C             Added call to sigign for Cray's only so that scratch files
C             will be cleaned up when the output pipe gets broken.
C   Revised:  Ron Coleman, CETech                      REV 2.11 05/17/95
C             Add check for SGISYSTEM and calculate "recl" for the scratch
C             file in 4 byte words (temp until we get verification from SGI)
C-----------------------------------------------------------------------
C
c   Routine moved to USP support structure January 15, 2004
c
c   Changes:
c
c   January 15, 2004:  Made many stylistic changes to make the routine
c                      more understandable from a USP coding viewpoint.
c                      Got rid of dt check against 32 ms and installed
c                      UnitSc dependency.  There is still one section
c                      that does some of this crap but it looks inoccuous
c   Garossino
c

      program ttds3d
c
      implicit none
C
#include     <save_defs.h>
#include     <f77/iounit.h>
#include     <f77/lhdrsz.h>
#include     <f77/sisdef.h>
#include     <ttds3d.h>
cinclude <f77/hp.h>
C
      integer ierr, increc, irec1, irec2, ismp1, ismp2, itrc1, itrc2,
     &        iw1, luinp, luout, memmax, nrec1, nrec2, nsmp1, nsmp2, 
     &        nsoff, nt, ntrc1, ntrc2, nw, nx, ny

      character func*3,    tfile*128
      character ndomain*3, odomain*3
C
      real    wm(1)

      pointer ( pwm, wm )
C
      logical verbos, flip, ifiltr
C
c initialize data
c
      data luinp, luout / -1, -1 /
C
C-----------------------------------------------------------------------
C
#ifdef CRAY
call sigign(13)
#endif
C
C===  INITIALIZE, OPEN FILES, ETC.
C
      call ttinit( verbos, memmax, ifiltr, ndomain, odomain, ierr )
      if( ierr .ne. 0 ) go to 800
C
      call galloc( pwm, memmax*iszbyt, ierr, 'ABORT' )
C
C===  READ LINE HEADER & JOB PARAMETERS, WRITE OUTPUT LINE HEADER
C
      call ttparm( luinp, luout, verbos, func,
     &             nrec1, irec1, irec2, increc,
     &             ntrc1, itrc1, itrc2,
     &             nsmp1, ismp1, ismp2, nsoff,
     &             nt, nw, iw1, nx, ny, nrec2, ntrc2, nsmp2,
     &             tfile, wm, ifiltr, ndomain, odomain, ierr )
      if( ierr .ne. 0 ) go to 800
C
      flip = func.eq.'213' .or. func.eq.'321' .or. func.eq.'132'
C
      if     ( func .eq. '123' .or. func .eq. '213' ) then
         call txy2txy( luinp, luout, verbos, flip,
     &                 nrec1, irec1, irec2, increc,
     &                 ntrc1, itrc1, itrc2,
     &                 nsmp1, ismp1, ismp2, nsoff,
     &                 nt, nx, ny, nrec2, ntrc2, nsmp2,
     &                 tfile, wm, memmax, ierr )
      else if( func .eq. '231' .or. func .eq. '321' ) then
         call txy2xyt( luinp, luout, verbos, flip,
     &                 nrec1, irec1, irec2, increc,
     &                 ntrc1, itrc1, itrc2,
     &                 nsmp1, ismp1, ismp2, nsoff,
     &                 nt, nx, ny, nrec2, ntrc2, nsmp2,
     &                 tfile, wm, memmax, ierr )
      else if( func .eq. '312' .or. func .eq. '132' ) then
         call xyt2txy( luinp, luout, verbos, flip,
     &                 nrec1, irec1, irec2, increc,
     &                 ntrc1, itrc1, itrc2, 
     &                 nsmp1, ismp1, ismp2, nsoff,
     &                 nt, nx, ny, nrec2, ntrc2, nsmp2,
     &                 tfile, wm, memmax, ierr )
      else if( func .eq. '23w' ) then
         call txy2xyw( luinp, luout, verbos,
     &                 nrec1, irec1, irec2, increc,
     &                 ntrc1, itrc1, itrc2,
     &                 nsmp1, ismp1, ismp2, nsoff,
     &                 nt, nw, iw1, nx, ny, nrec2, ntrc2, nsmp2,
     &                 tfile, wm, memmax, ierr )
      else if( func .eq. 't12' ) then
         call xyw2txy( luinp, luout, verbos,
     &                 nrec1, irec1, irec2,
     &                 ntrc1, itrc1, itrc2,
     &                 nsmp1, ismp1, ismp2,
     &                 nt, nsoff, nw, iw1, nx, ny, nrec2, ntrc2, nsmp2,
     &                 tfile, wm, memmax, ierr )
      else
         print *, 'Execution should never reach this statement'
         print *, 'Subroutine TTPARM should have flagged an error'
      endif
C
C===  CLOSE FILES, CLEAN-UP, & EXIT
C

      if ( ierr .ne. 0 ) goto 800

      call lbclos(luinp)
      call lbclos(luout)
      write(luprt,*) ' Normal Completion'
      write(lprt,*) ' ttds3d: Normal Completion'
      close(luprt)
      stop

  800 continue
      call lbclos(luinp)
      call lbclos(luout)
      write(luprt,*) ' Abnormal Completion'
      write(lprt,*) ' ttds3d: Abnormal Completion'
      close(luprt)
      stop
c      call mexit( ierr, luprt, luinp, luout )
C
      end
