C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: TTPARM      TTDS3D GET PARAMETERS                              *
C***********************************************************************
C
C  PURPOSE:
C      TTPARM READS THE INPUT LINE HEADER, JOB PARAMETERS, AND WRITES
C      THE OUTPUT LINE HEADER.  IN ADDITION, TTPARM CALCULATES SOME JOB
C      PARAMETERS.
C
C-----------------------------------------------------------------------
C
      subroutine ttparm( luinp, luout, verbos, func,
     &                   nrec1, irec1, irec2, increc,
     &                   ntrc1, itrc1, itrc2,
     &                   nsmp1, ismp1, ismp2, nsoff,
     &                   nt, nw, iw1, nx, ny, nrec2, ntrc2, nsmp2,
     &                   tfile, filtr, ifiltr, ndomain, odomain, ierr )
C
      implicit none
C
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
C
#include <ttds3d.h>
C
      real eps
      parameter( eps = 1.0e-6 )
C
C  SUBROUTINE ARGUMENTS
C
      integer   luinp, luout, nrec1, irec1, irec2, increc,
     &          ntrc1, itrc1, itrc2, nsmp1, ismp1, ismp2, nsoff,
     &          nt, nw, iw1, nx, ny, nrec2, ntrc2, nsmp2, ierr

      real      filtr(*)

      character func*3,    tfile*128
      character ndomain*3, odomain*3

      logical   verbos, ifiltr
C
C  LOCAL VARIABLES
C
      integer   idt, idt0, it1, jw, linhed, nbytes, nrpad, ntpad
      integer   nspad, ntout, maxnw, ihead(szlnhd), nrfft5, lbyout

      real      dt, dw, err, f1, f2, f3, f4, w, w0, w1, w2, w3, w4
      real      fmin, fmax, wmax, wmin, df, fnyq, UnitSc

      character*255 ntape, otape
C
C-----------------------------------------------------------------------
C
  900 format (/' ', ' INPUT DATASET  = ' / a255,
     &        /' ', ' OUTPUT DATASET = ' / a255)

  901 format( /' ', 'INPUT LINE HEADER PARAMETERS:' )
  902 format( /' ', 'OUTPUT LINE HEADER PARAMETERS:' )
  903 format(  ' ', '   NUMBER OF SEISMIC RECORDS IN THIS JOB =', i5,
     2        /' ', '   NUMBER OF TRACES PER SEISMIC RECORD   =', i5,
     3        /' ', '   NUMBER OF DATA SAMPLES PER TRACE      =', i5,
     4        /' ', '   SAMPLE INTERVAL (MILLISECONDS)        =', i5 )
  910 format(
     1        /' ', '   NDOMAIN  = ', a3,
     2        /' ', '   ODOMAIN  = ', a3,
     3        /' ', '   FUNCTION = ', a3)
  911 format(
     1        /' ', '   NREC1    = ', i6,
     2        /' ', '   IREC1    = ', i6,
     3        /' ', '   IREC2    = ', i6,
     4        /' ', '   INCREC   = ', i6,
     5        /' ', '   NRPAD    = ', i6)
  912 format(
     1         ' ', '   NTRC1    = ', i6,
     2        /' ', '   ITRC1    = ', i6,
     3        /' ', '   ITRC2    = ', i6,
     4        /' ', '   NTPAD    = ', i6)
  913 format(
     1         ' ', '   NSMP1    = ', i6,
     2        /' ', '   ISMP1    = ', i6,
     3        /' ', '   ISMP2    = ', i6,
     4        /' ', '   NSOFF    = ', i6,
     5        /' ', '   NSPAD    = ', i6)
  914 format(
     1        /' ', '   N', a1, '       = ', i6,
     2        /' ', '   N', a1, '       = ', i6,
     3        /' ', '   N', a1, '       = ', i6)
  917 format(
     1         ' ', '   DT       = ', f13.6)
  918 format(
     1         ' ', '   F1       = ', f8.1,
     2        /' ', '   F2       = ', f8.1,
     3        /' ', '   F3       = ', f8.1,
     4        /' ', '   F4       = ', f8.1,
     5        /' ', '   NW       = ', i6,
     6        /' ', '   IW1      = ', i6,
     7        /' ', '   W0       = ', f13.6,
     8        /' ', '   DW       = ', f13.6)
  971 format( /
     &' **** WARNING - record increment must be 1 for 12w -> t12 ****'/)
  981 format( /' ', '***** ERROR REPORTED BY GTFLTR =', i2, ' *****'/ )
  990 format( /' ', '***** ERROR - LINE HEADER READ ERROR *****'/ )
  991 format( /' ', '***** ERROR - INVALID RECORD PARAMETER *****'/ )
  992 format( /' ', '***** ERROR - INVALID TRACE PARAMETER *****'/ )
  993 format( /' ', '***** ERROR - INVALID SAMPLE PARAMETER *****'/ )
  994 format( /' ', '***** ERROR - INVALID DT VALUE *****'/ )
  995 format( /' ', '***** ERROR - DW MUST BE SPECIFIED *****'/ )
  996 format( /' ', '***** ERROR - W0 IS NOT A MULTIPLE OF DW *****'/ )
  997 format( /' ', '***** ERROR - INVALID FILTER PARAMETERS *****'/ )
  998 format( /' ', '***** ERROR - INVALID FUNCTION *****'/ )
C
C-----------------------------------------------------------------------
C
      if( verbos ) write( luprt, * ) ' ENTER SUBROUTINE TTPARM'
C
C=======================================================================
C                 READ PARAMETERS FROM COMMAND LINE
C=======================================================================
C
      call argi4 ( '-NTOUT', ntout  ,     0,     0 )
      call argi4 ( '-NT'   , nt     ,     0,     0 )
      call argstr('-N' , ntape  , ' ', ' ')
      call argstr('-O' , otape  , ' ', ' ')
C=======================================================================
C                       PROCESS LINE HEADER
C=======================================================================
C
C
C  DEFAULT FOR PIPES
C
      luinp = 0
      luout = 1
C
C  OPEN I/O FILES
C
      if (ntape .ne. ' ') call lbopen (luinp, ntape, 'r')
      if (otape .ne. ' ') call lbopen (luout, otape, 'w')
C
      write (luprt, 900) ntape, otape

      nbytes = 0
      call rtape( luinp, ihead, nbytes )
      if( nbytes .eq. 0 ) then
         write( luprt, 990 )
         ierr = 3000
         return
      endif
C
C  GET PARAMETERS FROM LINE HEADER
C
      linhed = 0
      call saver( ihead, 'SmpInt', idt0 , linhed )
      call saver( ihead, 'NumSmp', nsmp1, linhed )
      call saver( ihead, 'NumTrc', ntrc1, linhed )
      call saver( ihead, 'NumRec', nrec1, linhed )
      call saver( ihead, 'UnitSc', UnitSc, linhed )

c POLICEMAN: check header for units scaling.  Using UnitSc, remember
c that UnitSc default is milliseconds [i.e. 0.001] and UnitSc
c is a floating point variable.  A UnitSc entry of 1.0 would
c mean units are in seconds.  A UnitSc entry of 0 indicates that
c the unit was not defined.  In this case milliseconds are 
c assumed and loaded to the header for further processing.

      if ( UnitSc .eq. 0.0 ) then
         write(LUPRT,*)'********************************************'
         write(LUPRT,*)'WARNING: sample unit scaler in LH = ',UnitSc
         write(LUPRT,*)'         will set to .001 (millisec default)'
         write(LUPRT,*)'********************************************'
         UnitSc = 0.001
         call savew ( ihead, 'UnitSc', UnitSc, LINHED)
      endif


C
C=======================================================================
C                 READ PARAMETERS FROM COMMAND LINE
C=======================================================================
      call argstr( '-T'    , tfile  , ' '  , ' '   )
      call argi4 ( '-BR'   , irec1  ,     1,     1 )
      call argi4 ( '-ER'   , irec2  ,     0,     0 )
      call argi4 ( '-PR'   , nrpad  ,     0,     0 )
      call argi4 ( '-IR'   , increc ,     1,     1 )
      call argi4 ( '-BT'   , itrc1  ,     1,     1 )
      call argi4 ( '-ET'   , itrc2  ,     0,     0 )
      call argi4 ( '-PT'   , ntpad  ,     0,     0 )
      call argi4 ( '-BS'   , ismp1  ,     1,     1 )
      call argi4 ( '-ES'   , ismp2  ,     0,     0 )
      call argi4 ( '-PS'   , nspad  ,     0,     0 )
      call argi4 ( '-OS'   , nsoff  ,     0,     0 )
      call argi4 ( '-DT'   , idt    ,     0,      0)
      call argr4 ( '-fc'   , f2     ,   0.0,   0.0 )
      call argr4 ( '-f'    , f1     ,   0.0,   0.0 )
      call argr4 ( '-FC'   , f3     ,   0.0,   0.0 )
      call argr4 ( '-F'    , f4     ,   0.0,   0.0 )
      call argr4 ( '-DW'   , dw     ,   0.0,   0.0 )
      call argr4 ( '-W0'   , w0     ,   0.0,   0.0 )
      call argi4 ( '-IT'   , it1    ,     0,     0 )
cmat
      if(irec2.le.0)irec2 = nrec1
      if(itrc2.le.0)itrc2 = ntrc1
      if(ismp2.le.0)ismp2 = nsmp1
      if(idt  .le.0)idt   = idt0
cmat
C
      nx    = 0
      ny    = 0
      nw    = 0
      iw1   = 0
C
      if( verbos ) then
         write( luprt, 901 )
         write( luprt, 903 ) nrec1, ntrc1, nsmp1, idt0
      endif
C
      call ttdparse( ndomain, odomain, func, ierr )
      if( verbos ) write( luprt, 910) ndomain, odomain, func
      if( ierr .ne. 0 ) then
         write( luprt, 998 )
         ierr = 3008
         return
      endif
C
      if( func .eq. 't12' .and. increc .gt. 1 ) then
         increc = 1
         write( luprt, 971 )
      endif
C
      if( verbos ) write( luprt, 911) nrec1, irec1, irec2, increc, nrpad
      if( irec1.le.0 .or. irec1.gt.irec2 .or. irec2.gt.nrec1
     &    .or. increc.lt.1 .or. nrpad.lt.0 ) then
         write( luprt, 991 )
         ierr = 3001
         return
      endif
C
      if( verbos ) write( luprt, 912) ntrc1, itrc1, itrc2, ntpad
      if( itrc1.le.0 .or. itrc1.gt.itrc2 .or. itrc2.gt.ntrc1
     &   .or. ntpad.lt.0 ) then
         write( luprt, 992 )
         ierr = 3002
         return
      endif
C
      if( verbos ) write( luprt, 913) nsmp1, ismp1, ismp2, nsoff, nspad
      if( ismp1.le.0 .or. ismp1.gt.ismp2 .or. ismp2.gt.nsmp1
     &   .or. nsoff.lt.0 .or. nspad.lt.0 ) then
         write( luprt, 993 )
         ierr = 3003
         return
      endif
C
C=======================================================================
C                    PROCESS PARAMETERS FOR txy2txy
C=======================================================================
C
      if( func .eq. '123' ) then

         nt = ismp2 - ismp1 + 1 + nspad + nsoff
         nx = itrc2 - itrc1 + 1 + ntpad
         ny = ( irec2 - irec1 + increc ) / increc + nrpad

         if( verbos ) write( luprt, 914) ndomain(1:1), nt,
     &                                   ndomain(2:2), nx,
     &                                   ndomain(3:3), ny

         nsmp2 = nt
         ntrc2 = nx
         nrec2 = ny
C
C=======================================================================
C                    PROCESS PARAMETERS FOR xyt2xty
C=======================================================================
C
      else if( func .eq. '132' ) then

         nx = ismp2 - ismp1 + 1 + nspad + nsoff
         ny = itrc2 - itrc1 + 1 + ntpad
         nt = ( irec2 - irec1 + increc ) / increc + nrpad

         if( verbos ) write( luprt, 914) ndomain(1:1), nt,
     &                                   ndomain(2:2), nx,
     &                                   ndomain(3:3), ny

         nsmp2 = nx
         ntrc2 = nt
         nrec2 = ny
C
C=======================================================================
C                    PROCESS PARAMETERS FOR txy2xty
C=======================================================================
C
      else if( func .eq. '213' ) then

         nt = ismp2 - ismp1 + 1 + nspad + nsoff
         nx = itrc2 - itrc1 + 1 + ntpad
         ny = ( irec2 - irec1 + increc ) / increc + nrpad

         if( verbos ) write( luprt, 914) ndomain(1:1), nt,
     &                                   ndomain(2:2), nx,
     &                                   ndomain(3:3), ny

         nsmp2 = nx
         ntrc2 = nt
         nrec2 = ny
C
C=======================================================================
C                    PROCESS PARAMETERS FOR txy2xyt
C=======================================================================
C
      else if( func .eq. '231' ) then

         nt = ismp2 - ismp1 + 1 + nspad + nsoff
         nx = itrc2 - itrc1 + 1 + ntpad
         ny = ( irec2 - irec1 + increc ) / increc + nrpad

         if( verbos ) write( luprt, 914) ndomain(1:1), nt,
     &                                   ndomain(2:2), nx,
     &                                   ndomain(3:3), ny

         nsmp2 = nx
         ntrc2 = ny
         nrec2 = nt
C
C=======================================================================
C                    PROCESS PARAMETERS FOR xyt2txy
C=======================================================================
C
      else if( func .eq. '312' ) then

         nx = ismp2 - ismp1 + 1 + nspad + nsoff
         ny = itrc2 - itrc1 + 1 + ntpad
         nt = ( irec2 - irec1 + increc ) / increc + nrpad

         if( verbos ) write( luprt, 914) ndomain(1:1), nx,
     &                                   ndomain(2:2), ny,
     &                                   ndomain(3:3), nt

         nsmp2 = nt
         ntrc2 = nx
         nrec2 = ny
C
C=======================================================================
C                    PROCESS PARAMETERS FOR txy2yxt
C=======================================================================
C
      else if( func .eq. '321' ) then

         nt = ismp2 - ismp1 + 1 + nspad + nsoff
         nx = itrc2 - itrc1 + 1 + ntpad
         ny = ( irec2 - irec1 + increc ) / increc + nrpad

         if( verbos ) write( luprt, 914) ndomain(1:1), nt,
     &                                   ndomain(2:2), nx,
     &                                   ndomain(3:3), ny

         nsmp2 = ny
         ntrc2 = nx
         nrec2 = nt
C
C=======================================================================
C                    PROCESS PARAMETERS FOR txy2xyw
C=======================================================================
C
      else if( func .eq. '23w' ) then

         nt = nrfft5( ismp2 - ismp1 + 1 + nspad + nsoff )
         nx = itrc2 - itrc1 + 1 + ntpad
         ny = ( irec2 - irec1 + increc ) / increc + nrpad

         if( verbos ) write( luprt, 914) ndomain(1:1), nt,
     &                                   ndomain(2:2), nx,
     &                                   ndomain(3:3), ny

c         if( idt .le. 32 ) then
c            dt = 0.001 * float( idt )
            dt = UnitSc * float( idt )
c         else
c            dt = 0.000001 * float( idt )
c         endif
C
         if( verbos ) write( luprt, 917) dt
         if( dt .le. 0.0 ) then
            write( luprt, 994 )
            ierr = 3004
            return
         endif
C
C  PROCESS FILTER PARAMETERS
C
         fmin = 0.0
         fmax = float( nt/2 - 1 ) / ( float( nt ) * dt )
         if( f1 .le. fmin .or. f1 .gt. fmax ) f1 = fmin
         if( f4 .le. f1   .or. f4 .gt. fmax ) f4 = fmax
         if( f2 .le. f1   .or. f2 .gt. f4   ) f2 = f1
         if( f3 .le. f2   .or. f3 .gt. f4   ) f3 = f4
C
C  GENERATE FILTER
C
         maxnw = nt / 2
         call gtfltr( f1, f2, f3, f4, nt, dt, maxnw,
     &                nw, iw1, filtr(1+maxnw), filtr, ierr )
C
         w0 = filtr(1+maxnw)
         dw = filtr(2+maxnw) - filtr(1+maxnw)
         write( luprt, 918) f1, f2, f3, f4, nw, iw1, w0, dw

         if (ierr .ne. 0) then
            write( luprt, 981 ) ierr
            ierr = 3100 + abs( ierr )
            return
         endif
C
         nsmp2 = nx
         ntrc2 = ny * 2
         nrec2 = nw
C
C=======================================================================
C                    PROCESS PARAMETERS FOR xyw2txy
C=======================================================================
C
      else if( func .eq. 't12' ) then
C
C  INSURE THAT DW WAS SPECIFIED
C
         if( dw .le. 0.0 ) then
            write( luprt, 995 )
            ierr = 3005
            return
         endif
C
C  INSURE THAT W0 IS AN INTEGER MULTIPLE OF DW
C
         if( w0 .lt. 0.0 ) w0 = 0.0
         w0  = w0 + dw * ( irec1 - 1 )
         iw1 = nint( w0 / dw ) + 1
         err = abs( w0 - (iw1-1)*dw ) / dw
         if( err .gt. 0.01 ) then
            write( luprt, 996 )
            ierr = 3006
            return
         endif

         nw = irec2 - irec1 + 1
         nt = nrfft5( max0( nt, 2*(nw+iw1-1+nrpad) ) )
         nx = ismp2 - ismp1 + 1 + nspad
         ny = ( itrc2 - itrc1 + 1 + ntpad ) / 2

         if( it1 .le. 0 .or. it1 .gt. nt ) then
            nsoff = 0
         else
            nsoff = it1 - 1
         endif

         if( verbos ) write( luprt, 914) ndomain(1:1), nx,
     &                                   ndomain(2:2), ny,
     &                                   ndomain(3:3), nw

         dt  = twopi / ( nt * dw )
         idt = nint( 1000.0 * dt )
         err = abs( dt - 0.001*idt ) / dt
         if( err.gt.0.01 .and. dt.lt.0.032 ) idt = nint( 1000000.* dt )

         if( verbos ) write( luprt, 917) dt
C
C  PROCESS FILTER PARAMETERS
C
         df   = 1.0 / ( nt * dt )
         fnyq = 0.5 / dt
         fmax = fnyq - df * ( 1.0 - eps )
         fmin = 0.0
         if( f1 .le. fmin .or. f1 .gt. fmax ) f1 = fmin
         if( f4 .le. f1   .or. f4 .gt. fmax ) f4 = fmax
         if( f2 .le. f1   .or. f2 .gt. f4   ) f2 = f1
         if( f3 .le. f2   .or. f3 .gt. f4   ) f3 = f4

         write( luprt, 918) f1, f2, f3, f4, nw, iw1, w0, dw

         wmin = twopi * fmin
         wmax = twopi * fmax
         w1   = twopi * f1
         w2   = twopi * f2
         w3   = twopi * f3
         w4   = twopi * f4
C
C  GENERATE FORWARD TRAPIZOIDAL FILTER
C
         do jw = 1, nw
            w = w0 + dw * ( jw - 1 )
            if     ( w .lt. w1-eps ) then
               filtr(jw) = 0.0
            else if( w .gt. w4+eps ) then
               filtr(jw) = 0.0
            else if( w .lt. w2-eps ) then
               filtr(jw) = ( w - w1 ) / ( w2 - w1 )
            else if( w .gt. w3+eps ) then
               filtr(jw) = ( w4 - w ) / ( w4 - w3 )
            else
               filtr(jw) = 1.0
            endif
         end do

C
C  IF IFILTR, THEN GENERATE INVERSE FILTER INSTEAD
C
         if( ifiltr ) then
            do jw = 1, nw
               if( filtr(jw) .eq. 0.0 ) then
                  write( luprt, 997 )
                  ierr = 3007
                  return
               endif
               filtr(jw) = 1.0 / filtr(jw)
            end do
         endif

         if( ntout .le. 0 ) then
            nsmp2 = nt - nsoff
         else
            nsmp2 = min0( ntout, nt-nsoff )
         endif

         ntrc2 = nx
         nrec2 = ny

      endif
C
C=======================================================================
C                    UPDATE AND OUTPUT LINE HEADER
C=======================================================================
C
      if( func .ne. '23w' ) then
         w0 = 0.0
         dw = 0.0
      endif
C
      call hlhprt( ihead, nbytes, ppname, lppnam, luprt )
C
      call savew( ihead, 'SmpInt', idt  , linhed )
      call savew( ihead, 'NumSmp', nsmp2, linhed )
      call savew( ihead, 'NumTrc', ntrc2, linhed )
      call savew( ihead, 'NumRec', nrec2, linhed )
      call putfp( ihead, 'ReSpFm', w0   , linhed )
      call putfp( ihead, 'RATTrc', dw   , linhed )
cmat
c     add a call to savhlh to store command line arguments in historical L.H.
c  
      call savhlh( ihead, nbytes, lbyout )
      call wrtape( luout, ihead, lbyout )
C
      if( verbos ) then
         write( luprt, 902 )
         write( luprt, 903 ) nrec2, ntrc2, nsmp2, idt
      endif
C
      ierr = 0
      return
      end

