C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: TXY2TXY     TXY -> TXY                                         *
C***********************************************************************
C
      subroutine txy2txy( luinp, luout, verbos, flip,
     &                    nrec1, irec1, irec2, increc,
     &                    ntrc1, itrc1, itrc2,
     &                    nsmp1, ismp1, ismp2, nsoff,
     &                    nt, nx, ny, nrec2, ntrc2, nsmp2,
     &                    tfile, wm, memmax, ierr )
C
      implicit none
C
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
C
#include <ttds3d.h>
C
      logical verbos, flip
      integer ibuf, ierr, increc, incsmp, inctrc, irec1, irec2,
     &        ismp1, ismp2, itrc, itrc1, itrc2, jrec, jy, lbuf,
     &        ltrc, luinp, luout, lt, memmax,
     &        next, nsoff, nrec1, nrec2, nsmp1, nsmp2,
     &        ntrc1, ntrc2, nx, ny, nt
      real    wm(*)
      character tfile*128
C
C-----------------------------------------------------------------------
C
  901 format( /' ', 'MEMORY ALLOCATION:',
     1        /' ', '   MEMMAX   =', i10,
     2        /' ', '   LTRC     =', i10,
     3        /' ', '   LBUF     =', i10 )
  911 format( /' ', '***** ERROR: INSUFFICIENT MEMORY SPACE ',/,
     &        ' ***** Please ask for more memory using -M flag *****'/ )
C
C-----------------------------------------------------------------------
C
C  ALLOCATE WORK SPACE
C
      lt   = nt + 1 - mod( nt, 2 )
      ltrc = max0( itrwrd+nsmp1, itrwrd+nsmp2 )
      lbuf = lt * nx
C
      itrc = 1
      ibuf = itrc  + ltrc
C
      if( verbos ) write( luprt, 901 ) memmax, ltrc, lbuf
C
      if( ibuf+lbuf .gt. memmax ) then
         write( luprt, 911 )
         ierr = 1003
         return
      endif
C
      if( flip ) then
         incsmp = lt
         inctrc = 1
      else
         incsmp = 1
         inctrc = lt
      endif

      jrec = irec1 - increc
      next = 1

c===  loop over y-planes; i.e., input records

      do jy = 1, ny
         jrec = jrec + increc
         if( jrec .le. irec2 ) then
            if( jrec .ne. next )
     &         call sisseek( luinp, 1+(jrec-1)*ntrc1 )
            next = jrec + 1

            call rdrecnh( luinp, luprt, jrec, ntrc1, itrc1, itrc2,
     &                    nsmp1, ismp1, ismp2, nsoff, nt, 1, nx, lt,
     &                    wm(itrc), wm(ibuf), ierr )
            if( ierr .ne. 0 ) then
               ierr = 1500 + iabs( ierr )
               return
            endif
         else
            call vclr( wm(ibuf), 1, lt*nx )
         endif

         call wrrecnh( luout, luprt, jy, nsmp2, incsmp,
     &                 ntrc2, inctrc, wm(itrc), wm(ibuf), ierr)
         if( ierr .ne. 0 ) then
            ierr = 1600 + iabs( ierr )
            return
         end if
      end do

c======  end of loop over y-planes

      ierr = 0
      return
C
      end
