C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: TXY2XYT     TXY -> XYT                                         *
C***********************************************************************
C
      subroutine txy2xyt( luinp, luout, verbos, flip,
     &                    nrec1, irec1, irec2, increc,
     &                    ntrc1, itrc1, itrc2,
     &                    nsmp1, ismp1, ismp2, nsoff,
     &                    nt, nx, ny, nrec2, ntrc2, nsmp2,
     &                    tfile, wm, memmax, ierr )
C
      implicit none
C
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
C
#include <ttds3d.h>
C
      logical verbos, flip
      integer ibuf, ichnk, ierr, increc, irec1, irec2, ismp1, ismp2,
     &        itrc, itrc1, itrc2, lbuf, lchnk,
     &        ltrc, luinp, luout, lt, memmax, nbrec,
     &        nrec1, nrec2, nsmp1, nsmp2,
     &        ntrc1, ntrc2, nx, ny, nysl, nyslices, nt, nsoff, ntsl,
     &        ntslices
      real    wm(*)
      character tfile*128
C
C-----------------------------------------------------------------------
C
  901 format( /' ', 'MEMORY ALLOCATION:',
     1        /' ', '   MEMMAX   =', i10,
     2        /' ', '   LTRC     =', i10,
     3        /' ', '   LCHNK    =', i10,
     4        /' ', '   LBUF     =', i10 )
  902 format( /' ', 'MORE COMPUTED PARAMETERS:',
     1        /' ', '   NYSL     =', i10,
     2        /' ', '   NYSLICES =', i10,
     3        /' ', '   NTSL     =', i10,
     4        /' ', '   NTSLICES =', i10,
     5        /' ', '   NBREC    =', i10 )
  911 format( /' ', '***** ERROR: INSUFFICIENT MEMORY SPACE ',/,
     &        ' ***** Please ask for more memory using -M flag *****'/ )
C
C-----------------------------------------------------------------------
C
C  ALLOCATE WORK SPACE
C
      ltrc = max0( itrwrd+nsmp1, itrwrd+nsmp2 )
      lt   = nt + 1 - mod( nt, 2 )

      call txy2xyt0( nx, ny, nt, lt, memmax-ltrc, nysl,
     &               nyslices, ntsl, ntslices, ierr )

      if( ierr .ne. 0 ) then
         write( luprt, 911 )
         ierr = 1003
         return
      endif
C
      lchnk = nx * nysl * ntsl
      lbuf  = max0( nx*ny*ntsl, lt*nx*nysl )
C
      itrc  = 1
      ichnk = itrc  + ltrc
      ibuf  = ichnk + lchnk

c - with f90, allocation changes to bytes
c#ifdef SGISYSTEM
c     nbrec = lchnk
c#else
      nbrec = ISZBYT * lchnk
c#endif
C
      if( verbos ) write( luprt, 901 ) memmax, ltrc, lchnk, lbuf
      if( verbos ) write( luprt, 902 ) nysl, nyslices, ntsl, ntslices,
     &                                 nbrec
C
      if( tfile .eq. ' ' ) then
         open( unit=lutmp, access='DIRECT', form='UNFORMATTED',
     &         recl=nbrec, status = 'SCRATCH' )
      else
         open( unit=lutmp, file=tfile, access='DIRECT',
     &         form='UNFORMATTED', recl=nbrec )
      endif
C
      call txy2xyt1( luinp, lutmp, luprt, lt, nt, nx, ny,
     &               nysl, nyslices, ntsl, ntslices,
     &               nrec1, irec1, irec2, increc,
     &               ntrc1, itrc1, itrc2,
     &               nsmp1, ismp1, ismp2, nsoff,
     &               wm(itrc), wm(ichnk), wm(ibuf), ierr )
      if( ierr .ne. 0 )  go to 800
C
      call txy2xyt2( luout, lutmp, luprt, flip, nt, nx, ny,
     &               nysl, nyslices, ntsl, ntslices,
     &               nrec2, ntrc2, nsmp2,
     &               wm(itrc), wm(ichnk), wm(ibuf), ierr )
C
  800 continue
      close( lutmp )
      return
C
      end
C
C=======================================================================
C
      subroutine txy2xyt0( nx, ny, nt, lt, mfree,
     &                     nysl, nyslices, ntsl, ntslices, ierr )

      implicit none

      real p
      parameter ( p = 0.143 )

      integer nx, ny, nt, lt, mfree, nysl, nyslices, ntsl, ntslices,
     &        ierr, mysl, mtsl, memreq, mreqy, mreqt
      real    r, y, t

c-----------------------------------------------------------------------

      r    = float( ny ) / float( nt )
      t    = sqrt( p * mfree / ( r * nx ) )
      y    = r * t
      ntsl = nint( t )
      nysl = nint( y )

  110 continue
      if( nysl .le. 0 .or. ntsl .le. 0 ) then
         memreq = max0( nx*ny, lt*nx ) + nx
         if( memreq .le. mfree ) then
            nysl = 1
            ntsl = 1
         else
            ierr = 1
            return
         endif
      else
         memreq = max0( nx*ny*ntsl, lt*nx*nysl ) + nx*nysl*ntsl
         if( memreq .gt. mfree ) then
            ntsl = ntsl - 1
            nysl = nint( r * ntsl )
            go to 110
         endif
      endif

      if( nysl .gt. ny ) nysl = ny
      if( ntsl .gt. nt ) ntsl = nt

      nyslices = ( ny + nysl - 1 ) / nysl
      ntslices = ( nt + ntsl - 1 ) / ntsl

  120 continue
      if( nyslices .gt. 1 .and. ntslices .gt. 1 ) then
         nyslices = nyslices - 1
         ntslices = ntslices - 1
         nysl = ( ny + nyslices - 1 ) / nyslices
         ntsl = ( nt + ntslices - 1 ) / ntslices
         memreq = max0( nx*ny*ntsl, lt*nx*nysl ) + nx*nysl*ntsl
         if( memreq .le. mfree ) then
            go to 120
         else
            nyslices = nyslices + 1
            ntslices = ntslices + 1
         endif
      endif

  130 continue
      nysl  = ( ny + nyslices - 1 ) / nyslices
      ntsl  = ( nt + ntslices - 1 ) / ntslices

      if( nyslices .gt. 1 ) then
         mysl  = ( ny + nyslices - 2 ) / ( nyslices - 1 )
         mreqy = max0( nx*ny*ntsl, lt*nx*mysl ) + nx*mysl*ntsl
      else
         mreqy = mfree + 1
      endif

      if( ntslices .gt. 1 ) then
         mtsl  = ( nt + ntslices - 2 ) / ( ntslices - 1 )
         mreqt = max0( nx*ny*mtsl, lt*nx*nysl ) + nx*nysl*mtsl
      else
         mreqt = mfree + 1
      endif

      if( mreqy .le. mfree ) then
         if( mreqt .le. mfree ) then
            if( mreqy .ge. mreqt ) then
               nyslices = nyslices - 1
               go to 130
            else
               ntslices = ntslices - 1
               go to 130
            endif
         else
            nyslices = nyslices - 1
            go to 130
         endif
      else
         if( mreqt .le. mfree ) then
            ntslices = ntslices - 1
            go to 130
         endif
      endif

      nysl = ( ny + nyslices - 1 ) / nyslices
      ntsl = ( nt + ntslices - 1 ) / ntslices

      ierr = 0
      return
      end
C
C=======================================================================
C
      subroutine txy2xyt1( luinp, lutmp, luerr, lt, nt, nx, ny,
     &                     nysl, nyslices, ntsl, ntslices,
     &                     nrec1, irec1, irec2, increc,
     &                     ntrc1, itrc1, itrc2,
     &                     nsmp1, ismp1, ismp2, nsoff,
     &                     trace, chunk, buf, ierr )

      implicit none

c  arguments:

      integer luinp, lutmp, luerr, lt, nt, nx, ny, nysl, nyslices,
     &        ntsl, ntslices, nrec1, irec1, irec2, increc,
     &        ntrc1, itrc1, itrc2, nsmp1, ismp1, ismp2, nsoff, ierr
      real    trace(*), chunk(nx,nysl,ntsl), buf(lt,nx,nysl)

c  local variables:

      integer it, jrec, jx, jy, jyslice, jt, jt1, jt2, jtslice, kt, loc,
     &        next

c-----------------------------------------------------------------------

      loc  = 0
      jrec = irec1 - increc
      next = 1

c===  loop over y-slices

      do jyslice = 1, nyslices

c======  fill buf with a y-slice of data
c======  loop over y-planes; i.e., input records

         do jy = 1, nysl
            jrec = jrec + increc
            if( jrec .le. irec2 ) then
               if( jrec .ne. next )
     &            call sisseek( luinp, 1+(jrec-1)*ntrc1 )
               next = jrec + 1

               call rdrecnh( luinp, luerr, jrec, ntrc1, itrc1, itrc2,
     &                       nsmp1, ismp1, ismp2, nsoff, nt, 1, nx, lt,
     &                       trace, buf(1,1,jy), ierr )
               if( ierr .ne. 0 ) then
                  ierr = 1500 + iabs( ierr )
                  return
               endif
            else
               call vclr( buf(1,1,jy), 1, lt*nx )
            endif
         end do

c======  end of loop over y-planes

c======  get chunks of data from buf and write them to the temp file
c======  loop over t-slices

         jt2 = 0
         do jtslice = 1, ntslices
            jt1 = jt2 + 1
            jt2 = jt2 + ntsl
            if( jt2 .gt. nt ) jt2 = nt
            kt  = jt2 - jt1 + 1

            if( kt .lt. ntsl ) call vclr( chunk, 1, nx*nysl*ntsl )

c=========  transpose a chunk from buf to chunk

            do jt = jt1, jt2
               it = jt - jt1 + 1
               do jy = 1, nysl
                  do jx = 1, nx
                     chunk(jx,jy,it) = buf(jt,jx,jy)
                  end do
               end do
            end do

c=========  write the chunk to the temp file

            loc = loc + 1
            write( lutmp, rec=loc ) chunk

         end do

c======  end of loop over t-slices

      end do

c===  end of loop over y-slices

      ierr = 0
      return
      end
C
C=======================================================================
C
      subroutine txy2xyt2( luout, lutmp, luerr, flip, nt, nx, ny,
     &                     nysl, nyslices, ntsl, ntslices,
     &                     nrec2, ntrc2, nsmp2,
     &                     trace, chunk, buf, ierr )

      implicit none

c  arguments:

      integer luout, lutmp, luerr, nx, ny, nt,
     &        nysl, nyslices, ntsl, ntslices, nrec2, ntrc2, nsmp2, ierr
      logical flip
      real    trace(*), chunk(nx,nysl,ntsl), buf(nx,ny,ntsl)

c  local variables:

      integer incsmp, inctrc, jy1, jy2, jyslice, jt, jt1, jt2, jtslice,
     &        ky, loc

c-----------------------------------------------------------------------

      if( flip ) then
         incsmp = nx
         inctrc = 1
      else
         incsmp = 1
         inctrc = nx
      endif

c===  loop over t-slices

      jt2 = 0
      do jtslice = 1, ntslices
         jt1 = jt2 + 1
         jt2 = jt2 + ntsl
         if( jt2 .gt. nt ) jt2 = nt

c======  read a chunk of data from temp file and transpose it into buf
c======  loop over y-slices

         jy2 = 0
         do jyslice = 1, nyslices
            jy1 = jy2 + 1
            jy2 = jy2 + nysl
            if( jy2 .gt. ny ) jy2 = ny

            ky = jy2 - jy1 + 1

            loc = ( jyslice - 1 ) * ntslices + jtslice
            read( lutmp, rec=loc ) chunk

c=========  move chunk into buf

            do jt = 1, ntsl
               call vmov( chunk(1,1,jt), 1, buf(1,jy1,jt), 1, nx*ky )
            end do

         end do

c======  end of loop over y-slices

c======  write output records
c======  loop over t-planes

         do jt = jt1, jt2
            call wrrecnh( luout, luerr, jt, nsmp2, incsmp,
     &                    ntrc2, inctrc, trace, buf(1,1,jt-jt1+1), ierr)
            if( ierr .ne. 0 ) then
               ierr = 1600 + iabs( ierr )
               return
            end if
         end do

c======  end of loop over t-planes

      end do

c===  end of loop over t-slices

      ierr = 0
      return
      end
