C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE TVDAFD
C
C**********************************************************************C
C
C TVDAFD READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C boosts the amplitude spectra down a time varying window, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
 

#include     <save_defs.h>
#include     <f77/iounit.h>
#include     <f77/lhdrsz.h>
#include     <f77/sisdef.h>

      INTEGER     ITR ( 2 * SZLNHD)
      INTEGER     LHED( 2 * SZLNHD ), LUIN, LUOUT, NBYTES, LBYTES
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM, obytes, ovlp
      INTEGER     fun , ordfft
      REAL        gain, amp, phz, work, xtr, ytr, otime, ftime
      REAL        hold1, sumb, wgt
      pointer     (wkotime, otime (10000000))
      pointer     (wkftime, ftime (10000000))
      pointer     (wkwgt  , wgt   (10000000))
      pointer     (wkhold1, hold1 (10000000))
      pointer     (wksumb , sumb  (10000000))
      pointer     (wkgain , gain  (10000000))
      pointer     (wkamp  , amp   (10000000))
      pointer     (wkphz  , phz   (10000000))
      pointer     (wkwork , work  (10000000))
      pointer     (wkxtr  , xtr   (10000000))
      pointer     (wkytr  , ytr   (10000000))
      complex     workc
      pointer     (wkworkc, workc (10000000))

      REAL        SAMP, coefs(2,32), wrk1(3), wrk2(96)
      CHARACTER   NAME * 6, junk * 80
      character   ntap * 256, otap * 256, ttap * 256
#include     <f77/pid.h>
      logical     verbos,query,mute,first,heap
      integer     argis
 
      EQUIVALENCE ( ITR(  1), LHED(1) )
      data name/'TVDAFD'/
      data first/.true./
      DATA     NBYTES , LBYTES  /
     :           0    ,   0     /

c-------------------------------------
c  get online help if necessary
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
          call help()
          stop
      endif
c-------------------------------------

c-------------------------------
c  open printout file
#include  <f77/open.h>
c-------------------------------

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE
C**********************************************************************C
      call cmdln (ntap,otap,ttap,ns,ne,lslide,fl,fh,ovlp,
     &                irs,ire,norder,verbos,mute,fun)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )

      lbytes = 0
      CALL RTAPE ( LUIN, ITR, LBYTES )
      if(lbytes .eq. 0) then
         write(LERR,*)'TVDAFD: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt( ITR , LBYTES, NAME, 6, LERR)

#include  <f77/saveh.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)


      samp = float (nsi) * unitsc
      dtms = float (nsi)
      fnyq = .5 / samp

      if (fh .eq. 0.0) fh = .5 * fnyq

      dt     = SAMP
      lslide = lslide / nsi
      ovlp   = ovlp / nsi
      if (ovlp .eq. 0) ovlp = lslide / 2

      nu  = ordfft (lslide+ovlp)
      N   = 2 ** nu
      N22 = N/2
      N21 = N/2 + 1
      df  = fnyq / float(N21-1)
      ifl = fl / df + 1.0
      ifh = fh / df

      call bwcoef ( fl, fh, dt, coefs, xnorm, norder, ift)
c------------------------------
c  check defaults
      call cmdchk (ns,ne,irs,ire,ntrc,nrec)
c------------------------------
       nrecc  = ire - irs + 1
       jtr    = ne - ns + 1
       obytes = SZTRHD + SZSMPD * nsamp

c---------------------------------------------------
c  adjust line header & write header
       call savew( itr, 'NumTrc', jtr    , LINHED)
       call savew( itr, 'NumRec', nrecc  , LINHED)
       call savew( itr, 'NumSmp', nsamp  , LINHED)
       call savhlh ( itr, lbytes, lbyout )
       CALL WRTAPE ( LUOUT, ITR, LBYOUT )
c---------------------------------------------------

c----------------------------
c   printout
       write(LERR,*) ' Values read from command line '
       write(LERR,*) 'Input data set =  ',ntap
       write(LERR,*) 'Output data set = ',otap
       write(LERR,*) ' nr =  ', nr
       write(LERR,*) ' Output samples = ',nsamp
       write(LERR,*) ' Butterworth order = ', norder
       write(LERR,*) ' Traces per record = ',ntrc
       write(LERR,*) ' Records per line =',nrec
       write(LERR,*) ' Nyquist frequency= ',fnyq
       write(LERR,*) ' Starting freq index = ',ifl
       write(LERR,*) ' Ending freq index   = ',ifh
       write(LERR,*)' '
       write(LERR,*) 'Values read from input data set line header'
       write(LERR,*) ' # of Samples/Trace =  ', nsamp
       write(LERR,*) ' Sample Interval    =  ', nsi,' (input)'
       write(LERR,*) ' Traces per Record  =  ', ntrc
       write(LERR,*) ' Records per Line   =  ', nrec
       write(LERR,*) ' Format of Data     =  ', iform
       write(LERR,*) ' Do not restore early mute =  ', mute

c-----------------------------------
c  skip to start record
      call recskp(1,irs-1,luin,ntrc,itr)
c-----------------------------------

C**********************************************************************C
C
C     COMPUTE DESIRED FILTER
C
C**********************************************************************C
c100   continue

      nf = 0
      ic = 0
      nwin = 0

        ilast = 0
        do while (ilast.lt.nsamp)
            if(ilast.eq.0)then
                ifirst = 1
                ilast = lslide + ovlp
                nwin = 1
            else
                nmove = lslide+ ovlp
                ifirst = ifirst + ovlp
                ilast = ifirst + nmove -1
                nwin = nwin+1
            endif
        end do
        nwin0 = nwin
        write(LERR,*)'Number sliding windows = ',nwin
        write(LERR,*)'Number samps in window = ',lslide
        write(LERR,*)'Window overlap (samps) = ',ovlp
        if (nwin .gt. 200) then
           write(LERR,*)'FATAL ERROR in tvdafd:'
           write(LERR,*)'Update window too short. Must be larger'
           write(LERR,*)'than ',nsi*nsamp/200
           write(LER ,*)'FATAL ERROR in tvdafd:'
           write(LER ,*)'Update window too short. Must be larger'
           write(LER ,*)'than ',nsi*nsamp/200
           stop
         endif

         rewind fun
         nf = 0
         do while (1.eq.1)
            read(fun,'(a80)',end=111,err=998) junk
            nf = nf + 1
         enddo
         go to 111
998      continue
         write(LERR,*)'FATAL ERROR in tvdafd:'
         write(LERR,*)'Error reading time varying filter file. File'
         write(LERR,*)'must contain time(ms) locut(Hz) hicut(Hz)'
         write(LER ,*)'FATAL ERROR in tvdafd:'
         write(LER ,*)'Error reading time varying filter file. File'
         write(LER ,*)'must contain time(ms) locut(Hz) hicut(Hz)'
         stop
111      continue
         rewind fun

         heap = .true.
         item  = max (nf+2,nwin+2)
         itemd = nsamp
         itemf = N
         itemg = N21 * (nwin+1)

         ierr = 0
         call galloc (wkotime, item  * SZSMPD, ierr, iab)
         if (ierr .ne. 0) heap = .false.
         call galloc (wkftime, item  * SZSMPD, ierr, iab)
         if (ierr .ne. 0) heap = .false.
         call galloc (wkhold1, itemf * SZSMPD, ierr, iab)
         if (ierr .ne. 0) heap = .false.
         call galloc (wksumb , itemd * SZSMPD, ierr, iab)
         if (ierr .ne. 0) heap = .false.
         call galloc (wkgain , itemg * SZSMPD, ierr, iab)
         if (ierr .ne. 0) heap = .false.
         call galloc (wkamp  , itemf * SZSMPD, ierr, iab)
         if (ierr .ne. 0) heap = .false.
         call galloc (wkwgt  , itemf * SZSMPD, ierr, iab)
         if (ierr .ne. 0) heap = .false.
         call galloc (wkphz  , itemf * SZSMPD, ierr, iab)
         if (ierr .ne. 0) heap = .false.
         call galloc (wkwork , itemd * SZSMPD, ierr, iab)
         if (ierr .ne. 0) heap = .false.
         call galloc (wkxtr  , itemd * SZSMPD, ierr, iab)
         if (ierr .ne. 0) heap = .false.
         call galloc (wkytr  , itemd * SZSMPD, ierr, iab)
         if (ierr .ne. 0) heap = .false.
         call galloc (wkworkc, itemf * SZSMPD, ierr, iab)
         if (ierr .ne. 0) heap = .false.


         if (.not. heap) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*)' '
            write(LER ,*)' '
            write(LER ,*)'Unable to allocate workspace:'
            write(LER ,*)' '
            go to 999
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*)' '
         endif

         ic = 0

c-----
c  time varying gain funtion
c-----
         do  j = 1, nf
             ic = ic + 1
             read(fun,'(a80)') junk
             call fsscnf (junk,'%f %f'//char(0),tmp1,tmp2)
             if (j .eq. 1. .AND. tmp1 .gt. float(nsi)) then
                ftime (ic) = nsi
                work  (ic) = tmp2
                ic = ic + 1
                ftime (ic) = tmp1
                work  (ic) = tmp2
             else
                if (tmp1 .le. float(nsi)) tmp1 = nsi
                ftime (ic) = tmp1
                work  (ic) = tmp2
             endif
         enddo
         nf = ic

         if (tmp1 .ne. float(nsamp*nsi)) then
             nf = nf + 1
             ftime (nf) = nsamp*nsi
             work  (nf) = tmp2
         endif

         write(LERR,*)' '
         write(LERR,*)'Time Varying Frequency Boost (time, exponent)'
         write(LERR,*)(ftime(i),i=1,nf)
         write(LERR,*)' '
         write(LERR,*)(work (i),i=1,nf)
         write(LERR,*)' '

         dtmin = 999999.
         do  j = 2, nf
             dtt = abs (ftime (j) - ftime (j-1)) / float(nsi)
             if (dtt .le. dtmin) dtmin = dtt
         enddo
         idtmin = nint (dtmin)

         nwin1 = nwin + 1
         do  j = 2, nwin1
             otime (j) = dtms * float( j - 1 ) * ovlp
         enddo
         otime (1) = nsi

         call flint (ftime, work , nf, otime, xtr, nwin1)
         call vmov  (xtr, 1, work, 1, nwin1)

         write(LERR,*)' '
         write(LERR,*)'Time'
         write(LERR,*)(otime(i),i=1,nwin1)
         write(LERR,*)' '
         write(LERR,*)'Boost Exponents'
         write(LERR,*)(work (i),i=1,nwin1)
         write(LERR,*)' '

         call vfill (1.0, wgt, 1, N21)

         do  i = 1, ifl
             wgt (i) = float (i-1) / float(ifl)
         enddo
         do  i = ifh, N21
             wgt (i) = float (N21 - i) / float(N21-ifl+1)
         enddo

         do  j = 1, nwin

             tim = otime (j)
             slp = work  (j)
             write(LERR,*)'Window ',j,': time, exponent= ',tim,slp
             istrc = (j-1) * N21
             do  i = 1, N21
c                gain (istrc+i) = 1.0 + float(i-1) * slp
                 gain (istrc+i) = wgt (i) * (dt * float(i)) ** slp
             enddo
         enddo

C**********************************************************************C
C
C     READ TRACE, FILTER, WRITE TO OUTPUT FILE
C
C**********************************************************************C

      init = 1

      DO 5001 JJ = IRS, IRE

c-------------------------------------------------
c  skip to start trace of this record
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c-------------------------------------------------

           DO 5002 KK = NS, NE

               nbytes = 0
               CALL RTAPE  ( LUIN, ITR, NBYTES           )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)

               call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     irec   , TRACEHEADER)
               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istatic, TRACEHEADER)

               IF(istatic .ne. 30000) THEN
c------------------
c  detect mute zone
                    if (.not. mute)
     1              call detmut ( xtr, im, nsamp)
c------------------
c  determine trace
c  level; check for
c  dead trc
                    call dotpr (xtr, 1, xtr, 1, xmax, nsamp)
                    if (xmax .ne. 0.0) then
                       xmax = sqrt (xmax/float(nsamp))
                       call vsdiv (xtr, 1, xmax, xtr, 1, nsamp)
                    endif


                    call tvboost (nsamp, N, N21, lslide, nwin, ovlp,
     1                            xtr, ytr, amp, phz, workc, gain,
     2                            work, hold1, sumb, first)

                    call vclr (wrk1, 1, 3)
                    call vclr (wrk2, 1, 96)
 
                    call bwfilt ( ytr, ytr, wrk1, wrk2, coefs,
     1                            xnorm, norder, nsamp, init, 0)
                    init = 0
                    call vrvrs (ytr,  1, nsamp)
                    call bwfilt ( ytr, ytr, wrk1, wrk2, coefs,
     1                            xnorm, norder, nsamp, init, 0)
                    call vrvrs (ytr,  1, nsamp)

c------------------
c  restore trace
c  level
                    call dotpr (ytr, 1, ytr, 1, xnew, nsamp)
                    xnew = xmax / sqrt (xnew/float(nsamp))
                    call vsmul  (ytr, 1, xnew, ytr, 1, nsamp)

c------------------
c  reapply zone
                    if (.not. mute)
     1              call resmut (ytr, im, nsamp)

               ELSE

                    call vclr (ytr, 1, nsamp)

               ENDIF
               call vmov (ytr, 1, lhed(ITHWP1), 1, nsamp)

               CALL WRTAPE ( LUOUT, ITR, OBYTES          )
 5002      CONTINUE

c-------------------------------------------------
c  skip to end trace of this record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c-------------------------------------------------
           if( verbos ) write(LERR,*)'Filtered record ',irec

 5001 CONTINUE

  999 continue
      call lbclos ( luin )
      call lbclos ( luout)
      END

c---------------------------------
c  online help section
c---------------------------------
      subroutine  help
#include  <f77/iounit.h>

      write(LER,*)
     :'**************************************************************'
      write(LER,*)
     :'tvdafd:  time varying bandpass filtering'
      write(LER,*)
     :'Run this program by typing tvdafd and the following arguments'
      write(LER,*)
     :' -N[ntap]     (default stdin)  : Input data file'
      write(LER,*)
     :' -O[otap]     (default stdout) : Output data file'
      write(LER,*)
     :' -B[ffile]    (default = none) : file of time(ms) gain slope'
      write(LER,*)
     :'                                  (2 entries per line)'
      write(LER,*)' '
      write(LER,*)'-fl[fl]    -- min lo-cut freq (Hz)           ( 5 )'
      write(LER,*)'-fh[fh]    -- max hi-cut freq (Hz)    (.7 Nyquist)'

      write(LER,*)
     :' -ns[ns]      (default = first): start trace number'
      write(LER,*)
     :' -ne[ne]      (default = last) : end trace number'
      write(LER,*)
     :' -rs[irs]     (default = first): start record number'
      write(LER,*)
     :' -re[ire]     (default = last) : end record number'
      write(LER,*)' '
      write(LER,*)
     :' -lw[lwind]    (default = 500) : filter update time'
      write(LER,*)
     :' -ov[ovlp]     (def = lwind/2) : window overlap (ms)'
      write(LER,*)
     :' -nor[norder] (default = 2)    : filter order'
      write(LER,*)
     :' -M                     Do not restore early mute'
      write(LER,*)
     :'                                        (time varying option)'
      write(LER,*)
     :' -lw[lside]   (default = 500ms) : length sliding window'
      write(LER,*)' '
      write(LER,*)
     :'Usage:'
      write(LER,*)
     :' tvdafd -N[] -O[] -ns[] -ne[] -rs[] -re[] -B[] -lw[] -ov[]'
      write(LER,*)
     :'        -fl[] -fh[] [ -nor[] -M -V ]'

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c    tmul   - R      time multiplier
c    fl,h   - R      corner frqs
c     ns    - I      start trace
c     ne    - I      stop end trace
c    irs    - I      start record
c    ire    - I      stop end record
c  norder   - I      butterworth order
c    deci   - I      decimation factor
c   zerop   - L      causal/acausal
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,ttap,ns,ne,lslide,fl,fh,ovlp,
     &                irs,ire,norder,verbos,mute,fun)
#include    <f77/iounit.h>
      character  ntap*(*), otap*(*), ttap*(*)
      integer    argis,ns,ne,irs,ire,norder,lslide,fun,ovlp
      logical    verbos, mute

      call alloclun (fun)

          call argstr( '-N', ntap, ' ', ' ' )
          call argstr( '-O', otap, ' ', ' ' )
          call argstr( '-B', ttap, ' ', ' ' )
          call argi4 ( '-lw', lslide , 500  ,500    )
          call argi4 ( '-ov', ovlp   ,   0  ,  0    )
          call argr4('-fl',fl,5.,5.)
          call argr4('-fh',fh,0.,0.)
          call argi4 ( '-ns', ns ,   0  ,  0    )
          call argi4 ( '-ne', ne ,   0  ,  0    )
          call argi4 ( '-rs', irs ,   0  ,  0    )
          call argi4 ( '-re', ire ,   0  ,  0    )
          call argi4 ( '-nor', norder, 2 , 2 )

          if (ttap(1:1) .ne. ' ') then
             open (unit=fun,file=ttap,status='old',iostat=ierr)
             if (ierr .ne. 0) then
                write(LERR,*)'Could not open time-freq file ',ttap
                write(LERR,*)'Check existence'
                stop
             endif
          else
             write(LERR,*)'Fatal Error in tvdafd:'
             write(LERR,*)'Must supply file of ampl. gain boosts'
             write(LERR,*)'using -B[] on the cmd line'
             write(LER ,*)'Fatal Error in tvdafd:'
             write(LER ,*)'Must supply file of ampl. gain boosts'
             write(LER ,*)'using -B[] on the cmd line'
             stop
          endif

          if (norder .gt. 8) then
             write(LERR,*)'Filter order cannot exceed 8: resetting'
             write(LERR,*)'order to 8'
             norder = 8
          elseif (norder .lt. 2) then
             write(LERR,*)'Filter order cannot be less than 2:'
             write(LERR,*)'resetting order to 2'
             norder = 2
          endif

          mute   = ( argis( '-M' ) .gt. 0   )
          verbos = ( argis( '-V' ) .gt. 0   )

      return
      end
