C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE TVFILT
C
C**********************************************************************C
C
C FILT READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C APPLIES A USER-SPECIFIED time varying BUTTERWORTH FILTER, AND
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE, butt, filco
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
 

#include     <save_defs.h>
#include     <f77/iounit.h>
#include     <f77/lhdrsz.h>
#include     <f77/sisdef.h>

      INTEGER     ITR ( 2 * SZLNHD)
      INTEGER     LHED( 2 * SZLNHD ), LUIN, LUOUT, NBYTES, LBYTES
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM, obytes, ovlp
      INTEGER     fun 
      REAL        ftime(200), otime(200), lo(200), hi(200)
      REAL        f1(200), f2(200), f3(200), f4(200)
      REAL        SAMP, coefs(2,32), wrk1(3), wrk2(96)
      REAL        tcoefs(200,2,32), tnorm(200)
      real        fwt(SZLNHD), amp(SZLNHD), phz(SZLNHD)
      complex     workc(SZLNHD)
      REAL        TRI  ( 2 * SZLNHD )
      REAL        work ( 2 * SZLNHD )
      CHARACTER   NAME * 6, junk * 80
      character   ntap * 256, otap * 256, ttap * 256
#include     <f77/pid.h>
      logical     verbos,query,zerop,mute,TV,orms,first
      integer     argis
 
c     EQUIVALENCE ( ITR(129), TRI (1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      data name/'TVFILT'/
      data first/.true./
      DATA     NBYTES , LBYTES  /
     :           0    ,   0     /

c-------------------------------------
c  get online help if necessary
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
          call help()
          stop
      endif
c-------------------------------------

c-------------------------------
c  open printout file
#include  <f77/open.h>
c-------------------------------

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE
C**********************************************************************C
      call cmdln (ntap,otap,ns,ne,TV,ttap,fun,lslide,orms,
     &                irs,ire,norder,zerop,verbos,mute)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )

      lbytes = 0
      CALL RTAPE ( LUIN, ITR, LBYTES )
      if(lbytes .eq. 0) then
         write(LERR,*)'TVFILT: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt( ITR , LBYTES, NAME, 6, LERR)

#include  <f77/saveh.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)


      samp = float (nsi) * unitsc
      dtms = float (nsi)
      fnyq = .5 / samp

      dt     = SAMP
      lslide = lslide / nsi

c------------------------------
c  check defaults
      call cmdchk (ns,ne,irs,ire,ntrc,nrec)
c------------------------------
       nrecc  = ire - irs + 1
       jtr    = ne - ns + 1
       obytes = SZTRHD + SZSMPD * nsamp

c---------------------------------------------------
c  adjust line header & write header
       call savew( itr, 'NumTrc', jtr    , LINHED)
       call savew( itr, 'NumRec', nrecc  , LINHED)
       call savew( itr, 'NumSmp', nsamp  , LINHED)
       call savhlh ( itr, lbytes, lbyout )
       CALL WRTAPE ( LUOUT, ITR, LBYOUT )
c---------------------------------------------------

c----------------------------
c   printout
       write(LERR,*) ' Values read from command line '
       write(LERR,*) 'Input data set =  ',ntap
       write(LERR,*) 'Output data set = ',otap
       write(LERR,*) ' nr =  ', nr
       write(LERR,*) ' Output samples = ',nsamp
       if (orms) then
       write(LERR,*) ' Time varying trapezoidal filter'
       else
       write(LERR,*) ' BWF order = ', norder
       endif
       write(LERR,*) ' Traces per record = ',ntrc
       write(LERR,*) ' Records per line =',nrec
       write(LERR,*) ' Nyquist frequency= ',fnyq
       write(LERR,*)' '
       write(LERR,*) 'Values read from input data set line header'
       write(LERR,*) ' # of Samples/Trace =  ', nsamp
       write(LERR,*) ' Sample Interval    =  ', nsi,' (input)'
       write(LERR,*) ' Traces per Record  =  ', ntrc
       write(LERR,*) ' Records per Line   =  ', nrec
       write(LERR,*) ' Format of Data     =  ', iform
       write(LERR,*) ' Do not restore early mute =  ', mute

c-----------------------------------
c  skip to start record
      call recskp(1,irs-1,luin,ntrc,itr)
c-----------------------------------

C**********************************************************************C
C
C     COMPUTE DESIRED FILTER
C
C**********************************************************************C
c100   continue

      nf = 0
      ic = 0
      nwin = 0

         ovlp  = lslide / 2
         ilast = 0
         do while (ilast.lt.nsamp)
            if(ilast.eq.0)then
                ifirst = 1
                ilast = lslide + ovlp
                nwin = 1
            else
                nmove = lslide+ ovlp
                ifirst = ifirst + ovlp
                ilast = ifirst + nmove -1
                nwin = nwin+1
            endif
        end do
        nwin0 = nwin
        write(LERR,*)'Number sliding windows = ',nwin
        write(LERR,*)'Number samps in window = ',lslide
        write(LERR,*)'Window overlap (samps) = ',ovlp
        if (nwin .gt. 200) then
           write(LERR,*)'FATAL ERROR in tvfilt:'
           write(LERR,*)'Update window too short. Must be larger'
           write(LERR,*)'than ',nsi*nsamp/200
           write(LER ,*)'FATAL ERROR in tvfilt:'
           write(LER ,*)'Update window too short. Must be larger'
           write(LER ,*)'than ',nsi*nsamp/200
           stop
         endif

         rewind fun
         nf = 0
         do while (1.eq.1)
            read(fun,'(a80)',end=111,err=998) junk
            nf = nf + 1
         enddo
         go to 111
998      continue
         write(LERR,*)'FATAL ERROR in tvfilt:'
         write(LERR,*)'Error reading time varying filter file. File'
         write(LERR,*)'must contain time(ms) locut(Hz) hicut(Hz)'
         write(LER ,*)'FATAL ERROR in tvfilt:'
         write(LER ,*)'Error reading time varying filter file. File'
         write(LER ,*)'must contain time(ms) locut(Hz) hicut(Hz)'
         stop
111      continue
         rewind fun

         ic = 0

c-----
c  time varying trapezoidal filter
c-----
         IF (orms) THEN

         do  j = 1, nf
             ic = ic + 1
             read(fun,'(a80)') junk
             call fsscnf (junk,'%f %f %f %f %f'//char(0),
     1			tmp,tmp1,tmp2,tmp3,tmp4)

             if (tmp1.gt.tmp2 .OR. tmp2.gt.tmp3 .OR. tmp3.gt.tmp4) then
                write(LERR,*)'FATAL ERROR in tvfilt:'
                write(LERR,*)'lo-cut freq must be < hi-cut freq'
                write(LER ,*)'FATAL ERROR in tvfilt:'
                write(LER ,*)'lo-cut freq must be < hi-cut freq'
                stop
             endif
             if (j .eq. 1. .AND. tmp .gt. float(nsi)) then
                ftime (ic) = nsi
                f1    (ic) = tmp1
                f2    (ic) = tmp2
                f3    (ic) = tmp3
                f4    (ic) = tmp4
                ic = ic + 1
                ftime (ic) = tmp
                f1    (ic) = tmp1
                f2    (ic) = tmp2
                f3    (ic) = tmp3
                f4    (ic) = tmp4
             else
                if (tmp .le. float(nsi)) tmp = nsi
                ftime (ic) = tmp
                f1    (ic) = tmp1
                f2    (ic) = tmp2
                f3    (ic) = tmp3
                f4    (ic) = tmp4
             endif
         enddo
         nf = ic

         if (tmp .ne. float(nsamp*nsi)) then
             nf = nf + 1
             ftime (nf) = nsamp*nsi
             f1    (nf) = tmp1
             f2    (nf) = tmp2
             f3    (nf) = tmp3
             f4    (nf) = tmp4
         endif

         write(LERR,*)' '
         write(LERR,*)'Time Varying Filter Params (T, f1,f2,f3,f4):'
         write(LERR,*)(ftime(i),i=1,nf)
         write(LERR,*)' '
         write(LERR,*)(f1(i),i=1,nf)
         write(LERR,*)' '
         write(LERR,*)(f2(i),i=1,nf)
         write(LERR,*)' '
         write(LERR,*)(f3(i),i=1,nf)
         write(LERR,*)' '
         write(LERR,*)(f4(i),i=1,nf)
         write(LERR,*)' '

         dtmin = 999999.
         do  j = 2, nf
             dtt = abs (ftime (j) - ftime (j-1)) / float(nsi)
             if (dtt .le. dtmin) dtmin = dtt
         enddo
         idtmin = nint (dtmin)

c        if (idtmin .lt. ovlp) then
c           lslide = 2 * idtmin
c           write(LERR,*)'Changing update window to ',lslide,
c    1                   ' samples'
c           go to 100
c        endif

         nwin1 = nwin + 1
         do  j = 2, nwin1
             otime (j) = dtms * float( j - 1 ) * ovlp
         enddo
         otime (1) = nsi

         call flint (ftime, f1 , nf, otime, work, nwin1)
         call vmov (work, 1, f1, 1, nwin1)

         call flint (ftime, f2 , nf, otime, work, nwin1)
         call vmov (work, 1, f2, 1, nwin1)

         call flint (ftime, f3 , nf, otime, work, nwin1)
         call vmov (work, 1, f3, 1, nwin1)

         call flint (ftime, f4 , nf, otime, work, nwin1)
         call vmov (work, 1, f4, 1, nwin1)

         write(LERR,*)' '
         write(LERR,*)'Time, f1,f2,f3,f4 interpolated'
         write(LERR,*)(otime(i),i=1,nwin1)
         write(LERR,*)' '
         write(LERR,*)(f1(i),i=1,nwin1)
         write(LERR,*)' '
         write(LERR,*)(f2(i),i=1,nwin1)
         write(LERR,*)' '
         write(LERR,*)(f3(i),i=1,nwin1)
         write(LERR,*)' '
         write(LERR,*)(f4(i),i=1,nwin1)
         write(LERR,*)' '


c-----
c  time varying butterworth filter (default)
c-----
         ELSE

         do  j = 1, nf
             ic = ic + 1
             read(fun,'(a80)') junk
             call fsscnf (junk,'%f %f %f'//char(0),tmp1,tmp2,tmp3)
             if (tmp2 .ge. tmp3) then
                write(LERR,*)'FATAL ERROR in tvfilt:'
                write(LERR,*)'lo-cut freq must be < hi-cut freq'
                write(LER ,*)'FATAL ERROR in tvfilt:'
                write(LER ,*)'lo-cut freq must be < hi-cut freq'
                stop
             endif
             if (tmp3 .gt. .9*fnyq) then
                write(LERR,*)'WARNING from tvfilt:'
                write(LERR,*)'Hi-cut too close to nyquist.'
                write(LERR,*)'Reducing by 10%'
                tmp3 = .9 * tmp3
             endif
             if (j .eq. 1. .AND. tmp1 .gt. float(nsi)) then
                ftime (ic) = nsi
                lo    (ic) = tmp2
                hi    (ic) = tmp3
                ic = ic + 1
                ftime (ic) = tmp1
                lo    (ic) = tmp2
                hi    (ic) = tmp3
             else
                if (tmp1 .le. float(nsi)) tmp1 = nsi
                ftime (ic) = tmp1
                lo    (ic) = tmp2
                hi    (ic) = tmp3
             endif
         enddo
         nf = ic

         if (tmp1 .ne. float(nsamp*nsi)) then
             nf = nf + 1
             ftime (nf) = nsamp*nsi
             lo    (nf) = tmp2
             hi    (nf) = tmp3
         endif

         write(LERR,*)' '
         write(LERR,*)'Time Varying Filter Params (T, FL, FH)'
         write(LERR,*)(ftime(i),i=1,nf)
         write(LERR,*)' '
         write(LERR,*)(lo(i),i=1,nf)
         write(LERR,*)' '
         write(LERR,*)(hi(i),i=1,nf)
         write(LERR,*)' '

         dtmin = 999999.
         do  j = 2, nf
             dtt = abs (ftime (j) - ftime (j-1)) / float(nsi)
             if (dtt .le. dtmin) dtmin = dtt
         enddo
         idtmin = nint (dtmin)

c        if (idtmin .lt. ovlp) then
c           lslide = 2 * idtmin
c           write(LERR,*)'Changing update window to ',lslide,
c    1                   ' samples'
c           go to 100
c        endif

         nwin1 = nwin + 1
         do  j = 2, nwin1
             otime (j) = dtms * float( j - 1 ) * ovlp
         enddo
         otime (1) = nsi

         call flint (ftime, lo , nf, otime, work, nwin1)
         call vmov (work, 1, lo, 1, nwin1)

         call flint (ftime, hi , nf, otime, work, nwin1)
         call vmov (work, 1, hi, 1, nwin1)

         write(LERR,*)' '
         write(LERR,*)'Time, locut, hicut interpolated'
         write(LERR,*)(otime(i),i=1,nwin1)
         write(LERR,*)' '
         write(LERR,*)(lo(i),i=1,nwin1)
         write(LERR,*)' '
         write(LERR,*)(hi(i),i=1,nwin1)
         write(LERR,*)' '

         do  j = 1, nwin1

             fl = lo (j)
             fh = hi (j)
             write(LERR,*)'Window ',j,': fl, fh= ',fl,fh
             call bwcoef ( fl, fh, dt, coefs, tnorm(j), norder, ift)
             do  jj = 1, 2
                 do ii = 1, norder
                    tcoefs (j,jj,ii) = coefs (jj,ii)
                 enddo
             enddo
         enddo

         ENDIF

C**********************************************************************C
C
C     READ TRACE, FILTER, WRITE TO OUTPUT FILE
C
C**********************************************************************C

      init = 1

      DO 5001 JJ = IRS, IRE

c-------------------------------------------------
c  skip to start trace of this record
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c-------------------------------------------------

           DO 5002 KK = NS, NE

               nbytes = 0
               CALL RTAPE  ( LUIN, ITR, NBYTES           )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)

               call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     irec   , TRACEHEADER)
               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istatic, TRACEHEADER)

               IF(istatic .ne. 30000) THEN
c------------------
c  detect mute zone
                    if (.not. mute)
     1              call detmut ( tri, im, nsamp)

                    if (orms) then
                       call orms_tv (tri, nsamp, work, lslide, nwin,
     1                              ovlp, dt, first, f1, f2, f3, f4,
     2                              fwt, workc, amp, phz)
                    else
                       call filt_tv (tri, nsamp, work, lslide, nwin,
     1                              zerop, norder,ovlp,tcoefs,tnorm,
     2                              wrk1,wrk2)
                    endif

c------------------
c  reapply zone
                    if (.not. mute)
     1              call resmut (work, im, nsamp)

               ELSE

                    call vclr (work, 1, nsamp)

               ENDIF
               call vmov (work, 1, lhed(ITHWP1), 1, nsamp)

               CALL WRTAPE ( LUOUT, ITR, OBYTES          )
 5002      CONTINUE

c-------------------------------------------------
c  skip to end trace of this record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c-------------------------------------------------
           if( verbos ) write(LERR,*)'Filtered record ',irec

 5001 CONTINUE

  999 continue
      call lbclos ( luin )
      call lbclos ( luout)
      END

c---------------------------------
c  online help section
c---------------------------------
      subroutine  help
#include  <f77/iounit.h>

      write(LER,*)
     :'**************************************************************'
      write(LER,*)
     :'tvfilt:  time varying bandpass filtering'
      write(LER,*)
     :'Run this program by typing tvfilt and the following arguments'
      write(LER,*)
     :' -N[ntap]     (default stdin)  : Input data file'
      write(LER,*)
     :' -O[otap]     (default stdout) : Output data file'
      write(LER,*)
     :' -B[ffile]    (default = none) : file of time(ms) locut hicut'
      write(LER,*)
     :'                                  (3 entries per line)'
      write(LER,*)' '
      write(LER,*)
     :' -ns[ns]      (default = first): start trace number'
      write(LER,*)
     :' -ne[ne]      (default = last) : end trace number'
      write(LER,*)
     :' -rs[irs]     (default = first): start record number'
      write(LER,*)
     :' -re[ire]     (default = last) : end record number'
      write(LER,*)' '
      write(LER,*)
     :' -lw[lwind]    (default = 500) : filter update time'
      write(LER,*)
     :' -nor[norder] (default = 2)    : filter order'
      write(LER,*)
     :' -ormsby                Ormsby filter; else Butterworth'
      write(LER,*)
     :' -C                     For causal filter else zero phase'
      write(LER,*)
     :' -M                     Do not restore early mute'
      write(LER,*)
     :'                                        (time varying option)'
      write(LER,*)
     :' -lw[lside]   (default = 500ms) : length sliding window'
      write(LER,*)' '
      write(LER,*)
     :'Usage:'
      write(LER,*)
     :' tvfilt -N[] -O[] -ns[] -ne[] -rs[] -re[] -B[] -lw[]'
      write(LER,*)
     :'        [ -ormsby -nor[] -M -C -V ]'

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c    tmul   - R      time multiplier
c    fl,h   - R      corner frqs
c     ns    - I      start trace
c     ne    - I      stop end trace
c    irs    - I      start record
c    ire    - I      stop end record
c  norder   - I      butterworth order
c    deci   - I      decimation factor
c   zerop   - L      causal/acausal
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,ns,ne,TV,ttap,fun,lslide,orms,
     &                irs,ire,norder,zerop,verbos,mute)
#include    <f77/iounit.h>
      character  ntap*(*), otap*(*), ttap*(*)
      integer    argis,ns,ne,irs,ire,norder,lslide,fun
      logical    zerop, verbos, mute, TV, orms

      TV    = .false.
      orms  = .false.
      zerop = .false.
      fun = 29

          call argstr( '-N', ntap, ' ', ' ' )
          call argstr( '-O', otap, ' ', ' ' )
          call argstr( '-B', ttap, ' ', ' ' )
          call argi4 ( '-lw', lslide , 500  ,500    )
          call argi4 ( '-ns', ns ,   0  ,  0    )
          call argi4 ( '-ne', ne ,   0  ,  0    )
          call argi4 ( '-rs', irs ,   0  ,  0    )
          call argi4 ( '-re', ire ,   0  ,  0    )
          call argi4 ( '-nor', norder, 2 , 2 )
          orms   = ( argis( '-ormsby' ) .gt. 0   )

          if (.not.orms) then
             if(argis('-C').gt.0)then
                   zerop = .false.
             else
                   zerop = .true.
             endif
          endif

          if (ttap(1:1) .ne. ' ') then
             open (unit=fun,file=ttap,status='old',iostat=ierr)
             if (ierr .ne. 0) then
                write(LERR,*)'Could not open time-freq file ',ttap
                write(LERR,*)'Check existence'
                stop
             endif
             TV = .true.
          else
             write(LERR,*)'Fatal Error in tvfilt:'
             write(LERR,*)'Must supply file of time locut hicut'
             write(LERR,*)'using -B[] on the cmd line'
             write(LER ,*)'Fatal Error in tvfilt:'
             write(LER ,*)'Must supply file of time locut hicut'
             write(LER ,*)'using -B[] on the cmd line'
             stop
          endif

          if (.not.orms) then
             if (norder .gt. 8) then
                write(LERR,*)'Filter order cannot exceed 8: resetting'
                write(LERR,*)'order to 8'
                norder = 8
             elseif (norder .lt. 2) then
                write(LERR,*)'Filter order cannot be less than 2:'
                write(LERR,*)'resetting order to 2'
                norder = 2
             endif
          endif

          mute   = ( argis( '-M' ) .gt. 0   )
          verbos = ( argis( '-V' ) .gt. 0   )

      return
      end
