/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "ufh.h"
#include "x_tab.h"
#include <stdio.h>
#include <stdlib.h>

void incr()
{
    double d = popD();
    pushD(d + 1.0);
}

void decr()
{
    double d = popD();
    pushD(d - 1.0);
}

void mod()
{
	int a = popD();
	int b = popD();
        pushD((double) (b % a));
}

void gt()
{
	double a = popD();
	double b = popD();
	pushD((double)(b > a));
}

void lt()
{
	double a = popD();
	double b = popD();
	pushD((double)(b < a));
}

void ge()
{
	double a = popD();
	double b = popD();
	pushD((double)(b >= a));
}

void le()
{
	double a = popD();
	double b = popD();
	pushD((double)(b <= a));
}

void eq()
{
    TPackage ap, bp;
    ap = pop();
    bp = pop();

    if(isDouble(ap)) {
	pushD((double)(asDouble(ap) == asDouble(bp)));
    } else if(ap.type == Nothing) {
	pushD((double)(bp.type == Nothing));
    } else
    execerror("operator == used for types %s amd %s.",
	      typeName(ap), typeName(bp));
}

void ne()
{
	double a = popD();
	double b = popD();
	pushD((double)(b != a));
}

void and()
{ 
	double a = popD();
	double b = popD();
	pushD((double)(b != 0.0 && a != 0.0));
}

void or()
{
	double a = popD();
	double b = popD();
	pushD((double)(b != 0.0 || a != 0.0));
}
	
void not()
{
    pushD((double)(popD() == 0.0));
}

void power()
{
    push(TPOpPow());
}

void zero()
{
    pushD(0.0);
}

void one()
{
    pushD(1.0);
}

void nothing()
{
    push(newTP());
}


