/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "ufh.h"
#include "x_tab.h"
#include <stdio.h>
#include <stdlib.h>

/*
**	make sure the tpackage is free-standing (FloatP, not OFLoatP)
**	and is at least minlength long (zero-padding if necessary).
*/
static TPackage newFMinSize(oldt, minlength)
TPackage oldt;
int minlength;
{
    int l;
    int i;

    l = oldt.size;
    if(l < minlength)
	l = minlength;
    if((l > oldt.size) || (oldt.type == OFloatP)) {
	TPackage q;
	q = oldt;
	oldt.type = FloatP;
	oldt.size = l;
	oldt.u.series = (float*) malloc(l * sizeof(float));
	memcpy(oldt.u.series, q.u.series, q.size * sizeof(float));
	if(q.size < l)
	    for(i = q.size; i < l; i++)
		oldt.u.series[i] = 0.0;
	deleteTP(q);
    }
    return oldt;
}
/*
**	true if both arguments are packed with numbers.
*/
static int bothNumeric(a, b)
TPackage a, b;
{
    switch(a.type) {
      case Double:
      case FloatP:
      case OFloatP:
	break;
      default:
	return 0;
    }
    switch(b.type) {
      case Double:
      case FloatP:
      case OFloatP:
	break;
      default:
	return 0;
    }
    return 1;
}

void add()
{
    TPackage t, s, r;
    int i;

    t = pop();
    s = pop();
    if((t.type == CharP) && (s.type == CharP)) {
	push(addString(s, asString(t)));
	deleteTP(t);
	deleteTP(s);
	return;
    }
    if((t.type == Double) && (s.type == Double)) {
	pushD(asDouble(t) + asDouble(s));
	return;
    }
    if(t.type == Double) {
	r = s; s = t; t = r;
    }
    if(s.type == Double) { /* one scalar and its in s */
	switch(t.type) {
	  case OFloatP:
	  case FloatP:
	    t = newFMinSize(t, t.size);
	    for(i = 0; i < t.size; i++)
		t.u.series[i] += s.u.val;
	    push(t);
	    return;
	  default:
	    break;
	}
    } else if(bothNumeric(t, s)){
	t = newFMinSize(t, s.size);
	for(i = 0; i < s.size; i++)
	    t.u.series[i] += s.u.series[i];
	deleteTP(s);
	push(t);
	return;
    }
    execerror("add: sum of a %s and a %s is undefined.",
	      typeName(s), typeName(t));
}

void sub()
{
    TPackage t, s, r;
    int swapped;
    int i;

    s = pop();
    t = pop();

    if((t.type == Double) && (s.type == Double)) {
	pushD(asDouble(t) - asDouble(s));
	return;
    }
    swapped = 0;
    if(t.type == Double) {
	r = s; s = t; t = r;
	swapped = 1;
    }
    if(s.type == Double) { /* one scalar and its in s */
	switch(t.type) {
	  case OFloatP:
	  case FloatP:
	    t = newFMinSize(t, t.size);
	    if(swapped) {
		for(i = 0; i < t.size; i++)
		    t.u.series[i] = s.u.val - t.u.series[i];
	    } else {
		for(i = 0; i < t.size; i++)
		    t.u.series[i] = t.u.series[i] - s.u.val;
	    }
	    push(t);
	    return;
	  default:
	    break;
	}
    } else if(bothNumeric(t, s)){
	t = newFMinSize(t, s.size);
	for(i = 0; i < s.size; i++)
	    t.u.series[i] -= s.u.series[i];
	deleteTP(s);
	push(t);
	return;
    }
    execerror("sub:  a %s minus a %s is undefined.",
	      typeName(t), typeName(s));
}

void mul()
{
    TPackage t, s, r;
    int i;

    t = pop();
    s = pop();
    if((t.type == Double) && (s.type == Double)) {
	pushD(asDouble(t) * asDouble(s));
	return;
    }
    if(t.type == Double) {
	r = s; s = t; t = r;
    }
    if(s.type == Double) { /* one scalar and its in s */
	switch(t.type) {
	  case OFloatP:
	  case FloatP:
	    t = newFMinSize(t, t.size);
	    for(i = 0; i < t.size; i++)
		t.u.series[i] *= s.u.val;
	    push(t);
	    return;
	  default:
	    break;
	}
    } else if(bothNumeric(t, s)){
	t = newFMinSize(t, s.size);
	for(i = 0; i < s.size; i++)
	    t.u.series[i] *= s.u.series[i];
	deleteTP(s);
	push(t);
	return;
    }
    execerror("mul: a %s times a %s is undefined.",
	      typeName(s), typeName(t));
}

void divop()
{
	double a = popD();
	double b = popD();
	if (a == 0.0) 
		execerror("can't divide %g by zero", b);
	pushD(b / a);
}

void negate()
{
	pushD(-popD());
}


