/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "ufh.h"
#include <math.h>
#include <errno.h>

static TPackage errcheck(d, s)
TPackage d;
char *s;
{
    if (errno == EDOM) {
	errno = 0;
	execerror("%s: argument out of domain", s);
    } else if (errno == ERANGE) {
	errno = 0;
	execerror("%s: result out of range", s);
    }
    return d;
}

static TPackage arrayApply(f, r, s)
double (*f)();
TPackage r;
char* s;
{
    int i;

    switch(r.type) {
      case Double:
	r.u.val = f(r.u.val);
	break;
      case FloatP:
	for(i = 0; i < r.size; i++)
	    r.u.series[i] = f(r.u.series[i]);
	break;
      case TPackageP:
	for(i = 0; i < r.size; i++)
	    r.u.tpa[i] = arrayApply(f, r.u.tpa[i], s);
	break;
      default:
	execerror("%s: bad argument type (%s)", s, typeName(r));
	break;
    }
    return r;
}

static TPackage scall(f,s)
double (*f)();
char*s;
{
    TPackage r;

    if(nArgs() != 1)
	execerror("%s: bad argument count (%d)", s, nArgs());
    r = nthArg(1);
    if(r.type == Double)
	return errcheck(dTPackage(f(asDouble(nthArg(1)))), s);
    r = deepCopyTP(r);
    return errcheck(arrayApply(f, r, s), s);
}

TPackage TPSin()
{
    return scall(sin, "sin");
}

TPackage TPCos()
{
    return scall(cos, "cos");
}

TPackage TPAtan()
{
    return scall(atan, "atan");
}

TPackage TPLog()
{
    return scall(log, "log");
}

TPackage TPLog10()
{
    return scall(log10, "log10");
}

TPackage TPExp()
{
    return scall(exp, "exp");
}

TPackage TPSqrt()
{
    return scall(sqrt, "sqrt");
}

static double dint(d)
double d;
{
    return (double) ((int) d);
}

TPackage TPInteger()
{
    return scall(dint, "int");
}

static double dnint(d)
double d;
{
    return ((d >= 0) ? (floor((d)+.5)) : (ceil((d)-.5)));
}

TPackage TPNInteger()
{
    return scall(dnint, "nint");
}

static double dblabs(d)
double d;
{
    return (d < 0) ? (- d) : d;
}

TPackage TPAbs()
{
    return scall(dblabs, "abs");
}


TPackage TPOpPow()
{
    TPackage r;
    r = dTPackage(pow(asDouble(nthArg(1)), asDouble(nthArg(2))));
    return errcheck(r, "exponentiation");
}
