/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <signal.h>
#include <setjmp.h>

#include "ufh.h"
#include "functions.h"
#include "support.h"
#include "x_tab.h"

char 	**gargv;                /* global argument list */
int 	gargc;

int 	printSymbols = 0;

extern FILE	*fin;	/* input file pointer */

void fpecatch()    /* catch floating point exceptions */
{
       execerror("floating point exception caught by fpecatch()");
}

int run()   /* execute until EOF */
{
    Symbol*	Begin;
    Symbol*	OnLineHeader;
    Symbol*	OnTrace;
    Symbol*	End;

    Symbol*	LH;
    Symbol*	Tr;
    Symbol*	Argc;
    Symbol*	Argv;
    TPackage	av;
    int		i;

    Symbol*	s;

    long	rlen;

    signal(SIGFPE, fpecatch);

    UfhState = Compiling;

    if((fin=fopen(gargv[0], "r")) == NULL) {
	fprintf(stderr, "%s: can't open %s\n", progname, infile);
	exit(1);
    }

    Argc = install("argc");
    Argc->ttype = VAR;
    Argc->spk = dTPackage((double) gargc);

    Argv = install("argv");
    Argv->ttype = VAR;
    av.type = TPackageP;
    av.size = gargc;
    av.u.tpa = (TPackage*) emalloc(av.size * sizeof(TPackage));
    for(i = 0; i < gargc; i++)
	av.u.tpa[i] = cTPackage(gargv[i]);
    Argv->spk = av;

    LH = install("lh");
    LH->ttype = VAR;
    Tr = install("tr");
    Tr->ttype = VAR;

    initcode();

    s = installlc("SourceText");
    s->ttype = VAR;
    s->spk = cTPackage("");

    yyparse();

    infile = 0;

    s = lookup("sourcetext");
    s->spk = cTPackage(SourceText);

    Begin = lookup("begin");
    if( (Begin != NULL) && (Begin->ttype != FUNCTION) )
	return 1;

    OnLineHeader = lookup("onlineheader");
    if( (OnLineHeader != NULL) && (OnLineHeader->ttype != FUNCTION) )
	return 1;

    OnTrace = lookup("ontrace");
    if( (OnTrace != NULL) && (OnTrace->ttype != FUNCTION) )
	return 1;

    End = lookup("end");
    if( (End != NULL) && (End->ttype != FUNCTION) )
	return 1;

    if(printSymbols)
	dumpSymbols(stderr);

    UfhState = Executing;

    if(Begin != NULL)
	callSymbol(Begin, 0);

    LH->spk = TPGetSISChunk(0);
    if(LH->spk.type != Nothing) {

	if(OnLineHeader != NULL)
	    callSymbol(OnLineHeader, 0);
	
	for(;;) {
	    deleteTP(Tr->spk);
	    Tr->spk = TPGetSISChunk(0);
	    if(Tr->spk.type == Nothing)
		break;
	    if(OnTrace != NULL)
		callSymbol(OnTrace, 0);
	}
    }
    if(End != NULL)
	callSymbol(End, 0);
    exitproconly();
    return 0;
}

