/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "ufh.h" 
#include "x_tab.h"

static Symbol* global		= 0;
static Symbol* constants	= 0;
static Symbol* local		= 0;

static int inLocal = 0;

void beginlocal()
{
    inLocal = 1;
    local = 0;
}

void openlocal()
{
    inLocal = 1;
}

void closelocal()
{
    inLocal = 0;
}

Symbol* endlocal()
{
    Symbol* sp;
    inLocal = 0;
    sp = local;
    local = 0;
    return sp;
}

static Symbol *reallookup(s, b)
char *s;
Symbol *b;
{
    Symbol *sp;
    for (sp = b; sp != (Symbol *) 0; sp = sp->next)
	if (strcmp(sp->name, s) == 0)
	    return sp;
    return 0;      /* 0 ==> not found */
}

Symbol *lookup(s)
char *s;
{
    Symbol *sp;

    if(local != 0) {
	sp = reallookup(s, local);
	if(sp != 0)
	    return sp;
    }
    return reallookup(s, global);
}

static Symbol *realinstall(s, b)
char *s;
Symbol** b;
{
    Symbol *sp;
    char *emalloc();
    
    sp = (Symbol *) emalloc(sizeof(Symbol));
    if(s != 0) {
	sp->name = emalloc(strlen(s)+1);
	strcpy(sp->name, s);
    } else
	sp->name = 0;
    sp->spk = newTP();
    sp->next = *b;
    sp->local = 0;
    *b = sp;
    return sp;
}

Symbol *install(s)  /* install s in symbol table */
char *s;
{
    if(inLocal)
	return realinstall(s, &local);
    return realinstall(s, &global);
}

Symbol* installlc(s)
char*s;
{
    Symbol* sp;
    char *emalloc(), *t;
    int i;
    
    t = emalloc(strlen(s)+1);
    for(i = 0; i <= strlen(s); i++)
	t[i] = tolower(s[i]);
    sp = install(t);
    free(t);
    return sp;
}

Symbol* installcons()
{
    return realinstall(0, &constants);;
}

static void dumpSymbolTable(out, t)
FILE* out;
Symbol* t;
{
    Symbol* q;
    while(t != 0) {
	if((t->ttype != VAR) && (t->ttype != FUNCTION)) {
	    t = t->next;
	    continue;
	}
	fprintf(out, "   %s%s", t->name,
		    (t->ttype == FUNCTION) ? "() " : " = ");
	if(t->ttype == VAR) {
	    if(strlen(stringForm(t->spk)) < 40)
		fprintf(out, "%s", stringForm(t->spk));
	    else
		fprintf(out, "string of length %d",
			strlen(stringForm(t->spk)));
	}
	fprintf(out, "\n");
	if((t->ttype == FUNCTION) && (t->local != 0)) {
	    q = t->local;
	    while(q != 0) {
		fprintf(out, "       %s\n", q->name);
		q = q->next;
	    }
	}
	t = t->next;
    }
}

void dumpSymbols(out)
FILE* out;
{
    fprintf(out, "%s::\n", "Global");
    dumpSymbolTable(out, global);
/*
    fprintf(out, "%s::\n", "Constants");
    dumpSymbolTable(out, constants);
*/
}
